/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.CategoryGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.EntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;

public class AsteroidBeltGenPlugin
implements TerrainGenPlugin {
    @Override
    public StarSystemGenerator.GenResult generate(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        float orbitRadius;
        float orbitDays;
        int count;
        StarSystemAPI system = context.system;
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        float width = 200.0f;
        float countMult = 1.0f;
        float maxPlanets = 1.0f;
        if (context.currentRadius > 2000.0f && StarSystemGenerator.random.nextFloat() > 0.5f) {
            width += 100.0f;
            countMult += 0.1f;
            maxPlanets += 1.0f;
        }
        if (context.currentRadius > 4000.0f && StarSystemGenerator.random.nextFloat() > 0.5f) {
            width += 100.0f;
            countMult += 0.1f;
            maxPlanets += 1.0f;
        }
        if (context.currentRadius > 6000.0f && StarSystemGenerator.random.nextFloat() > 0.5f) {
            width += 100.0f;
            countMult += 0.1f;
            maxPlanets += 1.0f;
        }
        if (maxPlanets > 1.0f) {
            maxPlanets = 1.0f;
        }
        if ((count = (int)((orbitDays = (orbitRadius = context.currentRadius + width / 2.0f) / (15.0f + 5.0f * StarSystemGenerator.random.nextFloat())) * (0.25f + 0.5f * StarSystemGenerator.random.nextFloat()) * countMult)) > 100) {
            count = (int)(100.0f + ((float)count - 100.0f) * 0.25f);
        }
        if (count > 250) {
            count = 250;
        }
        SectorEntityToken belt = system.addAsteroidBelt(parent, count, orbitRadius, width, orbitDays * 0.75f, orbitDays * 1.5f, "asteroid_belt", null);
        WeightedRandomPicker<Integer> indexPicker = new WeightedRandomPicker<Integer>(StarSystemGenerator.random);
        indexPicker.add(0);
        indexPicker.add(1);
        system.addRingBand(parent, "misc", "rings_asteroids0", 256.0f, (Integer)indexPicker.pickAndRemove(), Color.white, 256.0f, orbitRadius - width * 0.25f, orbitDays * 1.05f, null, null);
        indexPicker = new WeightedRandomPicker(StarSystemGenerator.random);
        indexPicker.add(0);
        indexPicker.add(1);
        indexPicker.add(2);
        indexPicker.add(3);
        system.addRingBand(parent, "misc", "rings_asteroids0", 256.0f, (Integer)indexPicker.pickAndRemove(), Color.white, 256.0f, orbitRadius + width * 0.25f, orbitDays, null, null);
        float prevRadius = context.currentRadius;
        int i = 0;
        while ((float)i < maxPlanets) {
            CategoryGenDataSpec cat = context.gen.pickCategory(context, "in_asteroids", true);
            if (cat != null) {
                WeightedRandomPicker<EntityGenDataSpec> picker = context.gen.getPickerForCategory(cat, context, "in_asteroids");
                if (StarSystemGenerator.DEBUG) {
                    picker.print("  Picking from category " + cat.getCategory() + ", orbit index " + (context.parent != null ? context.parentOrbitIndex : context.orbitIndex));
                }
                EntityGenDataSpec pick = picker.pick();
                if (StarSystemGenerator.DEBUG) {
                    if (pick == null) {
                        System.out.println("  Nothing to pick");
                        System.out.println();
                    } else {
                        System.out.println("  Picked: " + pick.getId());
                        System.out.println();
                    }
                }
                if (pick instanceof PlanetGenDataSpec) {
                    PlanetGenDataSpec planetData = (PlanetGenDataSpec)pick;
                    context.currentRadius = prevRadius - width * 0.6f;
                    context.parentRadiusOverride = 200.0f;
                    StarSystemGenerator.GenResult result = context.gen.addPlanet(context, planetData, true, false);
                    if (result != null && !result.entities.isEmpty()) {
                        context.gen.getAllEntitiesAdded().put(result.entities.get(0), result.entities);
                    }
                    if (!context.generatedPlanets.isEmpty()) {
                        StarSystemGenerator.GeneratedPlanet last = context.generatedPlanets.get(context.generatedPlanets.size() - 1);
                        last.planet.setRadius(last.planet.getRadius() * 0.75f);
                    }
                }
            }
            ++i;
        }
        context.parentRadiusOverride = -1.0f;
        context.currentRadius = prevRadius;
        StarSystemGenerator.GenResult result = new StarSystemGenerator.GenResult();
        result.onlyIncrementByWidth = false;
        result.orbitalWidth = width;
        result.entities.add(belt);
        return result;
    }

    @Override
    public boolean wantsToHandle(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        return terrainData != null && terrainData.getId().equals("asteroid_belt");
    }
}

