/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.CategoryGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.EntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;

public class AsteroidFieldGenPlugin
implements TerrainGenPlugin {
    public static final float WIDTH_PLANET = 200.0f;
    public static final float WIDTH_STAR = 400.0f;

    @Override
    public StarSystemGenerator.GenResult generate(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        float area;
        int count;
        float maxRadius;
        if (context.lagrangeParent == null || context.lagrangePointType == null) {
            return null;
        }
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        if (context.lagrangeParent != null) {
            parent = context.center;
        }
        if (parent == null) {
            return null;
        }
        WeightedRandomPicker<Integer> sizePicker = new WeightedRandomPicker<Integer>(StarSystemGenerator.random);
        int i = 5;
        while (i <= 11) {
            sizePicker.add(i, 20 - i);
            ++i;
        }
        int size = (Integer)sizePicker.pick();
        float radius = (float)size * 100.0f;
        if (radius > (maxRadius = (context.currentRadius - parent.getRadius()) * 0.5f)) {
            radius = maxRadius;
        }
        if (radius < 400.0f) {
            radius = 400.0f;
        }
        if ((count = (int)((area = radius * radius * 3.14f) / 80000.0f)) < 10) {
            count = 10;
        }
        if (count > 100) {
            count = 100;
        }
        StarSystemAPI system = context.system;
        float orbitRadius = context.currentRadius + radius;
        float orbitDays = orbitRadius / (20.0f + StarSystemGenerator.random.nextFloat() * 5.0f);
        float angle = StarSystemGenerator.random.nextFloat() * 360.0f;
        if (context.lagrangeParent != null) {
            orbitRadius = context.lagrangeParent.orbitRadius;
            orbitDays = context.lagrangeParent.orbitDays;
            float angleOffset = -60.0f;
            if (context.lagrangePointType == StarSystemGenerator.LagrangePointType.L5) {
                angleOffset = 60.0f;
            }
            angle = context.lagrangeParent.orbitAngle + angleOffset;
        }
        SectorEntityToken field = system.addTerrain("asteroid_field", new AsteroidFieldTerrainPlugin.AsteroidFieldParams(radius, radius + 100.0f, count, count, 4.0f, 16.0f, null));
        field.setCircularOrbit(parent, angle, orbitRadius, orbitDays);
        CategoryGenDataSpec cat = context.gen.pickCategory(context, "in_asteroids", true);
        if (cat != null) {
            float prevRadius = context.currentRadius;
            WeightedRandomPicker<EntityGenDataSpec> picker = context.gen.getPickerForCategory(cat, context, "in_asteroids");
            if (StarSystemGenerator.DEBUG) {
                picker.print("  Picking from category " + cat.getCategory() + ", orbit index " + (context.parent != null ? context.parentOrbitIndex : context.orbitIndex));
            }
            EntityGenDataSpec pick = picker.pick();
            if (StarSystemGenerator.DEBUG) {
                if (pick == null) {
                    System.out.println("  Nothing to pick");
                    System.out.println();
                } else {
                    System.out.println("  Picked: " + pick.getId());
                    System.out.println();
                }
            }
            if (pick instanceof PlanetGenDataSpec) {
                PlanetGenDataSpec planetData = (PlanetGenDataSpec)pick;
                context.currentRadius = orbitRadius;
                context.parentRadiusOverride = 303.0303f;
                StarSystemGenerator.GenResult result = context.gen.addPlanet(context, planetData, true, false);
                if (result != null && !result.entities.isEmpty()) {
                    context.gen.getAllEntitiesAdded().put(result.entities.get(0), result.entities);
                    if (context.lagrangeParent != null && !result.entities.isEmpty()) {
                        context.gen.getLagrangeParentMap().put(result.entities.get(0), context.lagrangeParent.planet);
                    }
                }
            }
            context.parentRadiusOverride = -1.0f;
            context.currentRadius = prevRadius;
        }
        StarSystemGenerator.GenResult result = new StarSystemGenerator.GenResult();
        result.onlyIncrementByWidth = false;
        result.orbitalWidth = radius * 2.0f;
        result.entities.add(field);
        return result;
    }

    @Override
    public boolean wantsToHandle(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        return terrainData != null && terrainData.getId().equals("asteroid_field");
    }
}

