/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.NebulaTerrainPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;

public class NebulaSmallGenPlugin
implements TerrainGenPlugin {
    public static final float WIDTH_PLANET = 200.0f;
    public static final float WIDTH_STAR = 400.0f;

    @Override
    public StarSystemGenerator.GenResult generate(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        if (context.lagrangeParent == null || context.lagrangePointType == null) {
            return null;
        }
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        if (context.lagrangeParent != null) {
            parent = context.center;
        }
        WeightedRandomPicker<Integer> sizePicker = new WeightedRandomPicker<Integer>(StarSystemGenerator.random);
        int i = 5;
        while (i <= 15) {
            sizePicker.add(i, 20 - i);
            ++i;
        }
        int size = (Integer)sizePicker.pick();
        float radius = 400.0f * (float)size / 2.0f;
        StarSystemAPI system = context.system;
        float orbitRadius = context.currentRadius + radius;
        float orbitDays = orbitRadius / (20.0f + StarSystemGenerator.random.nextFloat() * 5.0f);
        float angle = StarSystemGenerator.random.nextFloat() * 360.0f;
        if (context.lagrangeParent != null) {
            orbitRadius = context.lagrangeParent.orbitRadius;
            orbitDays = context.lagrangeParent.orbitDays;
            float angleOffset = -60.0f;
            if (context.lagrangePointType == StarSystemGenerator.LagrangePointType.L5) {
                angleOffset = 60.0f;
            }
            angle = context.lagrangeParent.orbitAngle + angleOffset;
        }
        if (radius > orbitRadius * 0.5f) {
            radius = orbitRadius * 0.5f;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < size * size) {
            sb.append("x");
            ++i2;
        }
        String initStr = sb.toString();
        String nebulaType = StarSystemGenerator.nebulaTypes.get((Object)context.gen.getStarAge());
        SectorEntityToken nebula = system.addTerrain("nebula", new BaseTiledTerrain.TileParams(initStr, size, size, "terrain", nebulaType, 4, 4, null));
        nebula.setCircularOrbit(parent, angle, orbitRadius, orbitDays);
        NebulaTerrainPlugin nebulaPlugin = (NebulaTerrainPlugin)((CampaignTerrainAPI)nebula).getPlugin();
        NebulaEditor editor = new NebulaEditor(nebulaPlugin);
        editor.noisePrune(0.75f);
        editor.clearArc(nebula.getLocation().x, nebula.getLocation().y, radius * 0.8f, radius * 3.0f, 0.0f, 360.0f);
        StarSystemGenerator.GenResult result = new StarSystemGenerator.GenResult();
        result.onlyIncrementByWidth = false;
        result.orbitalWidth = radius * 2.0f;
        result.entities.add(nebula);
        return result;
    }

    @Override
    public boolean wantsToHandle(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        return terrainData != null && terrainData.getId().equals("nebula_small");
    }
}

