/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.DomainSurveyDerelictSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.SurveyDataSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TopographicDataSpecial;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class DerelictThemeGenerator
extends BaseThemeGenerator {
    public static final float BASE_LINK_FRACTION = 0.25f;
    public static final float SALVAGE_SPECIAL_FRACTION = 0.5f;
    public static final float TOPOGRAPHIC_DATA_FRACTION = 0.2f;
    public static final int BRANCHES_PER_MOTHERSHIP_MIN = 3;
    public static final int BRANCHES_PER_MOTHERSHIP_MAX = 4;
    public static final int BRANCHES_PER_SHIP_MIN = 2;
    public static final int BRANCHES_PER_SHIP_MAX = 3;
    public static Set<String> interestingConditions = new HashSet<String>();
    public static Set<String> interestingConditionsWithoutHabitable = new HashSet<String>();
    public static Set<String> interestingConditionsWithRuins = new HashSet<String>();

    static {
        interestingConditions.add("volatiles_plentiful");
        interestingConditions.add("rare_ore_rich");
        interestingConditions.add("rare_ore_ultrarich");
        interestingConditions.add("ore_ultrarich");
        interestingConditions.add("farmland_bountiful");
        interestingConditions.add("farmland_adequate");
        interestingConditions.add("organics_plentiful");
        interestingConditions.add("habitable");
        interestingConditionsWithoutHabitable.addAll(interestingConditions);
        interestingConditionsWithoutHabitable.remove("habitable");
        interestingConditionsWithRuins.addAll(interestingConditions);
        interestingConditionsWithRuins.add("ruins_vast");
        interestingConditionsWithRuins.add("ruins_extensive");
    }

    @Override
    public String getThemeId() {
        return "derelicts";
    }

    @Override
    public void generateForSector(ThemeGenContext context, float allowedUnusedFraction) {
        float total = (float)(context.constellations.size() - context.majorThemes.size()) * allowedUnusedFraction;
        if (total <= 0.0f) {
            return;
        }
        float avg1 = 3.5f;
        float avg2 = 2.5f;
        float perChain = 1.0f + avg1 + avg1 * avg2;
        float num = total / perChain;
        if (num < 1.0f) {
            num = 1.0f;
        }
        if (num > 3.0f) {
            num = 3.0f;
        }
        num = num > 1.0f && num < 2.0f ? 2.0f : (float)Math.round(num);
        ArrayList<BaseThemeGenerator.AddedEntity> mothershipsSoFar = new ArrayList<BaseThemeGenerator.AddedEntity>();
        int i = 0;
        while ((float)i < num) {
            this.addMothershipChain(context, mothershipsSoFar);
            ++i;
        }
        WeightedRandomPicker<StarSystemAPI> cryoSystems = new WeightedRandomPicker<StarSystemAPI>(StarSystemGenerator.random);
        WeightedRandomPicker backup = new WeightedRandomPicker(StarSystemGenerator.random);
        block1: for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float w = 0.0f;
            if (system.hasTag("theme_derelict_probes")) {
                w = 10.0f;
            } else if (system.hasTag("theme_derelict_survey_ship")) {
                w = 10.0f;
            } else if (system.hasTag("theme_derelict_mothership")) {
                w = 10.0f;
            } else {
                if (!system.hasTag("theme_derelict")) continue;
                w = 10.0f;
            }
            int numPlanets = 0;
            boolean hasHab = false;
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.isStar()) continue;
                if (planet.getSpec().isPulsar()) continue block1;
                hasHab |= planet.getMarket() != null && planet.getMarket().hasCondition("habitable");
                ++numPlanets;
            }
            WeightedRandomPicker<StarSystemAPI> use = cryoSystems;
            if (!hasHab || numPlanets < 3) {
                use = backup;
            }
            if (hasHab) {
                w += 5.0f;
            }
            w += (float)numPlanets;
            if (use == backup) {
                w *= 1.0E-4f;
            }
            use.add(system, w);
        }
        int numCryo = 2;
        if (cryoSystems.isEmpty() || cryoSystems.getItems().size() < numCryo + 1) {
            cryoSystems.addAll(backup);
        }
        int added = 0;
        WeightedRandomPicker<String> cryosleeperNames = new WeightedRandomPicker<String>(this.random);
        cryosleeperNames.add("Calypso");
        cryosleeperNames.add("Tantalus");
        while (added < numCryo && !cryoSystems.isEmpty()) {
            String name;
            StarSystemAPI pick = (StarSystemAPI)cryoSystems.pickAndRemove();
            BaseThemeGenerator.AddedEntity cryo = this.addCryosleeper(pick, name = (String)cryosleeperNames.pickAndRemove());
            if (cryo == null) continue;
            ++added;
        }
    }

    protected void addMothershipChain(ThemeGenContext context, List<BaseThemeGenerator.AddedEntity> mothershipsSoFar) {
        ArrayList<BaseThemeGenerator.AddedEntity> all = new ArrayList<BaseThemeGenerator.AddedEntity>();
        Vector2f center = new Vector2f();
        for (BaseThemeGenerator.AddedEntity e : mothershipsSoFar) {
            Vector2f.add((Vector2f)center, (Vector2f)e.entity.getLocationInHyperspace(), (Vector2f)center);
        }
        center.scale(1.0f / ((float)mothershipsSoFar.size() + 1.0f));
        List<Constellation> constellations = this.getSortedAvailableConstellations(context, false, center, null);
        WeightedRandomPicker<Constellation> picker = new WeightedRandomPicker<Constellation>(StarSystemGenerator.random);
        int i = 0;
        while (i < constellations.size() / 3) {
            picker.add(constellations.get(i));
            ++i;
        }
        Constellation main = (Constellation)picker.pick();
        if (main == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("Picked for mothership chain start: [" + main.getNameWithType() + "] (" + (int)main.getLocation().x + ", " + (int)main.getLocation().y + ")");
        }
        constellations.remove(main);
        context.majorThemes.put(main, "derelicts");
        StarSystemAPI mainSystem = main.getSystemWithMostPlanets();
        if (mainSystem == null) {
            return;
        }
        for (StarSystemAPI system : main.getSystems()) {
            system.addTag("theme_derelict");
        }
        BaseThemeGenerator.AddedEntity mothership = this.addMothership(mainSystem);
        if (mothership == null) {
            return;
        }
        all.add(mothership);
        if (DEBUG) {
            System.out.println("  Added mothership to [" + mainSystem.getNameWithLowercaseType() + "]");
        }
        int probesNearMothership = this.getNumProbesForSystem(mothership.entity.getContainingLocation());
        List<BaseThemeGenerator.AddedEntity> added = this.addToSystem(mainSystem, "derelict_probe", probesNearMothership);
        all.addAll(added);
        this.linkFractionToParent(mothership, added, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_MOTHERSHIP);
        int surveyShipsNearMothership = Math.round(StarSystemGenerator.getRandom(0.0f, 3.0f));
        if (surveyShipsNearMothership > main.getSystems().size()) {
            surveyShipsNearMothership = main.getSystems().size();
        }
        if (DEBUG) {
            System.out.println(String.format("Adding %d survey ships near mothership", surveyShipsNearMothership));
        }
        List<BaseThemeGenerator.AddedEntity> addedShips = this.addToConstellation(main, "derelict_survey_ship", surveyShipsNearMothership, false);
        all.addAll(addedShips);
        for (BaseThemeGenerator.AddedEntity e : addedShips) {
            int probesNearSurveyShip = Math.round(StarSystemGenerator.getRandom(1.0f, 3.0f));
            added = this.addProbes((StarSystemAPI)e.entity.getContainingLocation(), probesNearSurveyShip);
            all.addAll(added);
            this.linkFractionToParent(e, added, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_SURVEY_SHIP);
        }
        this.linkFractionToParent(mothership, addedShips, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_MOTHERSHIP);
        constellations = this.getSortedAvailableConstellations(context, false, mothership.entity.getLocationInHyperspace(), null);
        picker = new WeightedRandomPicker(StarSystemGenerator.random);
        int i2 = constellations.size() - 7;
        while (i2 < constellations.size()) {
            if (i2 >= 0) {
                picker.add(constellations.get(i2));
            }
            ++i2;
        }
        int numSurveyShipsInNearConstellations = Math.round(StarSystemGenerator.getRandom(3.0f, 4.0f));
        if (DEBUG) {
            System.out.println(String.format("Adding up to %d survey ships", numSurveyShipsInNearConstellations));
        }
        ArrayList<Constellation> constellationsForSurveyShips = new ArrayList<Constellation>();
        int i3 = 0;
        while (i3 < numSurveyShipsInNearConstellations && !picker.isEmpty()) {
            constellationsForSurveyShips.add((Constellation)picker.pickAndRemove());
            ++i3;
        }
        ArrayList<BaseThemeGenerator.AddedEntity> outerShips = new ArrayList<BaseThemeGenerator.AddedEntity>();
        for (Constellation c : constellationsForSurveyShips) {
            context.majorThemes.put(c, "derelicts");
            if (DEBUG) {
                System.out.println("  Picked for survey ship: [" + c.getNameWithType() + "]");
            }
            if ((addedShips = this.addToConstellation(c, "derelict_survey_ship", 1, true)).isEmpty()) continue;
            all.addAll(addedShips);
            BaseThemeGenerator.AddedEntity ship = addedShips.get(0);
            outerShips.addAll(addedShips);
            int probesNearSurveyShip = this.getNumProbesForSystem(ship.entity.getContainingLocation());
            added = this.addProbes((StarSystemAPI)ship.entity.getContainingLocation(), probesNearSurveyShip);
            all.addAll(added);
            this.linkFractionToParent(ship, added, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_SURVEY_SHIP);
            int probesInSameConstellation = Math.round(StarSystemGenerator.getRandom(2.0f, 5.0f));
            int max = c.getSystems().size() + 2;
            if (probesInSameConstellation > max) {
                probesInSameConstellation = max;
            }
            added = this.addToConstellation(c, "derelict_probe", probesInSameConstellation, false);
            all.addAll(added);
            this.linkFractionToParent(ship, added, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_SURVEY_SHIP);
            List<Constellation> c2 = this.getSortedAvailableConstellations(context, false, c.getLocation(), constellationsForSurveyShips);
            WeightedRandomPicker<Constellation> p2 = new WeightedRandomPicker<Constellation>(StarSystemGenerator.random);
            int i4 = c2.size() - 3;
            while (i4 < c2.size()) {
                if (i4 >= 0) {
                    p2.add(constellations.get(i4));
                }
                ++i4;
            }
            int probeSystemsNearShip = Math.round(StarSystemGenerator.getRandom(2.0f, 3.0f));
            int k = 0;
            if (DEBUG) {
                System.out.println(String.format("Adding probes to %d constellations near survey ship", probeSystemsNearShip));
            }
            ArrayList<BaseThemeGenerator.AddedEntity> probes3 = new ArrayList<BaseThemeGenerator.AddedEntity>();
            while (k < probeSystemsNearShip && !p2.isEmpty()) {
                Constellation pick = (Constellation)p2.pickAndRemove();
                ++k;
                context.majorThemes.put(pick, "no_theme");
                int probesInConstellation = Math.round(StarSystemGenerator.getRandom(1.0f, 3.0f));
                probes3.addAll(this.addToConstellation(pick, "derelict_probe", probesInConstellation, false));
            }
            all.addAll(probes3);
            this.linkFractionToParent(ship, probes3, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_MOTHERSHIP);
        }
        this.linkFractionToParent(mothership, outerShips, 0.25f, DomainSurveyDerelictSpecial.SpecialType.LOCATION_MOTHERSHIP);
        this.assignRandomSpecials(all);
    }

    protected void assignRandomSpecials(List<BaseThemeGenerator.AddedEntity> entities) {
        HashSet<PlanetAPI> usedPlanets = new HashSet<PlanetAPI>();
        HashSet usedSystems = new HashSet();
        for (BaseThemeGenerator.AddedEntity e : entities) {
            PlanetAPI planet;
            if (DerelictThemeGenerator.hasSpecial(e.entity)) continue;
            SurveyDataSpecial.SurveyDataSpecialType type = null;
            if (StarSystemGenerator.random.nextFloat() < 0.2f) {
                int min = 0;
                int max = 0;
                if ("derelict_probe".equals(e.entityType)) {
                    min = HTPoints.LOW_MIN;
                    max = HTPoints.LOW_MAX;
                } else if ("derelict_survey_ship".equals(e.entityType)) {
                    min = HTPoints.MEDIUM_MIN;
                    max = HTPoints.MEDIUM_MAX;
                } else if ("derelict_mothership".equals(e.entityType)) {
                    min = HTPoints.HIGH_MIN;
                    max = HTPoints.HIGH_MAX;
                }
                int points = min + StarSystemGenerator.random.nextInt(max - min + 1);
                if (points > 0) {
                    TopographicDataSpecial.TopographicDataSpecialData data = new TopographicDataSpecial.TopographicDataSpecialData(points);
                    Misc.setSalvageSpecial(e.entity, data);
                    continue;
                }
            }
            if (StarSystemGenerator.random.nextFloat() < 0.5f) {
                float pNothing = 0.1f;
                if ("derelict_probe".equals(e.entityType)) {
                    pNothing = 0.5f;
                } else if ("derelict_survey_ship".equals(e.entityType)) {
                    pNothing = 0.25f;
                } else if ("derelict_mothership".equals(e.entityType)) {
                    pNothing = 0.0f;
                }
                float r = StarSystemGenerator.random.nextFloat();
                if (r >= pNothing) {
                    type = SurveyDataSpecial.SurveyDataSpecialType.PLANET_SURVEY_DATA;
                }
            }
            if (type != SurveyDataSpecial.SurveyDataSpecialType.PLANET_SURVEY_DATA || (planet = DerelictThemeGenerator.findInterestingPlanet(e.entity.getConstellation().getSystems(), usedPlanets)) == null) continue;
            SurveyDataSpecial.SurveyDataSpecialData data = new SurveyDataSpecial.SurveyDataSpecialData(SurveyDataSpecial.SurveyDataSpecialType.PLANET_SURVEY_DATA);
            data.entityId = planet.getId();
            data.includeRuins = false;
            Misc.setSalvageSpecial(e.entity, data);
            usedPlanets.add(planet);
        }
    }

    public static StarSystemAPI findNearbySystem(SectorEntityToken from, Set<StarSystemAPI> exclude) {
        return DerelictThemeGenerator.findNearbySystem(from, exclude, null, 10000.0f);
    }

    public static StarSystemAPI findNearbySystem(SectorEntityToken from, Set<StarSystemAPI> exclude, Random random, float maxRange) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(random);
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist;
            if (exclude != null && exclude.contains(system) || (dist = Misc.getDistance(from.getLocationInHyperspace(), system.getLocation())) > maxRange || DerelictThemeGenerator.systemIsEmpty(system)) continue;
            picker.add(system);
        }
        return (StarSystemAPI)picker.pick();
    }

    public static String getInterestingCondition(PlanetAPI planet, boolean includeRuins) {
        if (planet == null) {
            return null;
        }
        Set<String> conditions = interestingConditions;
        if (includeRuins) {
            conditions = interestingConditionsWithRuins;
        }
        for (MarketConditionAPI mc : planet.getMarket().getConditions()) {
            if (!conditions.contains(mc.getId())) continue;
            return mc.getId();
        }
        return null;
    }

    public static PlanetAPI findInterestingPlanet(List<StarSystemAPI> systems, Set<PlanetAPI> exclude) {
        return DerelictThemeGenerator.findInterestingPlanet(systems, exclude, true, false, null);
    }

    public static PlanetAPI findInterestingPlanet(List<StarSystemAPI> systems, Set<PlanetAPI> exclude, boolean includeKnown, boolean includeRuins, Random random) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        WeightedRandomPicker<PlanetAPI> planets = new WeightedRandomPicker<PlanetAPI>(random);
        Set<String> conditions = interestingConditions;
        if (includeRuins) {
            conditions = interestingConditionsWithRuins;
        }
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        for (StarSystemAPI system : systems) {
            if (system.hasTag("theme_hidden")) continue;
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.isStar() || exclude != null && exclude.contains(planet) || planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly() || !includeKnown && planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) continue;
                String type = plugin.getSurveyDataType(planet);
                boolean classIV = "survey_data_4".equals(type);
                boolean classV = "survey_data_5".equals(type);
                if (!classIV && !classV && !(planet.getMarket().getHazardValue() <= 1.0f)) continue;
                float w = 1.0f;
                for (MarketConditionAPI mc : planet.getMarket().getConditions()) {
                    if (!conditions.contains(mc.getId())) continue;
                    w += 1.0f;
                }
                if (classIV) {
                    w *= 0.5f;
                }
                if (classV) {
                    w *= 4.0f;
                }
                planets.add(planet, w);
            }
        }
        return (PlanetAPI)planets.pick();
    }

    protected int getNumProbesForSystem(LocationAPI system) {
        int base = 1;
        int planets = system.getPlanets().size();
        if (planets > 3) {
            base = planets <= 5 ? ++base : (planets <= 8 ? (base += 2) : (base += 3));
        }
        return base += StarSystemGenerator.random.nextInt(2);
    }

    protected void linkFractionToParent(BaseThemeGenerator.AddedEntity parent, List<BaseThemeGenerator.AddedEntity> children, float p, DomainSurveyDerelictSpecial.SpecialType type) {
        WeightedRandomPicker<BaseThemeGenerator.AddedEntity> picker = new WeightedRandomPicker<BaseThemeGenerator.AddedEntity>(StarSystemGenerator.random);
        for (BaseThemeGenerator.AddedEntity c : children) {
            if (DerelictThemeGenerator.hasSpecial(c.entity)) continue;
            picker.add(c);
        }
        int extraLinks = Math.max(1, Math.round((float)children.size() * p * (1.0f + StarSystemGenerator.random.nextFloat() * 0.5f)));
        int i = 0;
        while (i < extraLinks && !picker.isEmpty()) {
            BaseThemeGenerator.AddedEntity e = (BaseThemeGenerator.AddedEntity)picker.pickAndRemove();
            this.linkToParent(e.entity, parent.entity, type);
            ++i;
        }
    }

    protected void linkToParent(SectorEntityToken from, SectorEntityToken parent, DomainSurveyDerelictSpecial.SpecialType type) {
        if (DerelictThemeGenerator.hasSpecial(from)) {
            return;
        }
        DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData special = new DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData(type);
        special.entityId = parent.getId();
        from.getMemoryWithoutUpdate().set("$salvageSpecialData", special);
    }

    protected void linkToMothership(SectorEntityToken from, SectorEntityToken mothership) {
        if (DerelictThemeGenerator.hasSpecial(from)) {
            return;
        }
        DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData special = new DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData(DomainSurveyDerelictSpecial.SpecialType.LOCATION_MOTHERSHIP);
        special.entityId = mothership.getId();
        from.getMemoryWithoutUpdate().set("$salvageSpecialData", special);
    }

    public static boolean hasSpecial(SectorEntityToken entity) {
        return entity.getMemoryWithoutUpdate().contains("$salvageSpecialData");
    }

    protected List<BaseThemeGenerator.AddedEntity> addToConstellation(Constellation c, String type, int num, boolean biggestFirst) {
        ArrayList<BaseThemeGenerator.AddedEntity> result = new ArrayList<BaseThemeGenerator.AddedEntity>();
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(StarSystemGenerator.random);
        picker.addAll(c.getSystems());
        boolean first = true;
        int i = 0;
        while (i < num) {
            StarSystemAPI system = (StarSystemAPI)picker.pick();
            if (biggestFirst && first) {
                system = c.getSystemWithMostPlanets();
            }
            first = false;
            if (system != null) {
                result.addAll(this.addToSystem(system, type, 1));
            }
            ++i;
        }
        return result;
    }

    protected List<BaseThemeGenerator.AddedEntity> addToSystem(StarSystemAPI system, String type, int num) {
        ArrayList<BaseThemeGenerator.AddedEntity> result = new ArrayList<BaseThemeGenerator.AddedEntity>();
        if (system == null) {
            return result;
        }
        int i = 0;
        while (i < num) {
            BaseThemeGenerator.AddedEntity e = null;
            if ("derelict_mothership".equals(type)) {
                e = this.addMothership(system);
            } else if ("derelict_survey_ship".equals(type)) {
                e = this.addSurveyShip(system);
            } else if ("derelict_probe".equals(type)) {
                result.addAll(this.addProbes(system, 1));
            }
            if (e != null) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    protected BaseThemeGenerator.AddedEntity addMothership(StarSystemAPI system) {
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.JUMP_ORBIT, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.NEAR_STAR, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.STAR_ORBIT, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.L_POINT, Float.valueOf(1.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = DerelictThemeGenerator.getLocations(this.random, system, 100.0f, weights);
        BaseThemeGenerator.AddedEntity entity = DerelictThemeGenerator.addEntity(this.random, system, locs, "derelict_mothership", "derelict");
        if (entity != null) {
            system.addTag("theme_interesting");
            system.addTag("theme_derelict");
            system.addTag("theme_derelict_mothership");
        }
        if (DEBUG) {
            if (entity != null) {
                System.out.println(String.format("  Added mothership to %s", system.getNameWithLowercaseType()));
            } else {
                System.out.println(String.format("  Failed to add mothership to %s", system.getNameWithLowercaseType()));
            }
        }
        return entity;
    }

    protected BaseThemeGenerator.AddedEntity addCryosleeper(StarSystemAPI system, String name) {
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.JUMP_ORBIT, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.NEAR_STAR, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.STAR_ORBIT, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.L_POINT, Float.valueOf(10.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = DerelictThemeGenerator.getLocations(this.random, system, 100.0f, weights);
        BaseThemeGenerator.AddedEntity entity = DerelictThemeGenerator.addEntity(this.random, system, locs, "derelict_cryosleeper", "derelict");
        if (entity != null) {
            system.addTag("theme_interesting");
            system.addTag("theme_derelict");
            system.addTag("theme_derelict_cryosleeper");
            if (name != null) {
                entity.entity.setName(String.valueOf(entity.entity.getName()) + " \"" + name + "\"");
            }
        }
        if (DEBUG) {
            if (entity != null) {
                System.out.println(String.format("  Added cryosleeper to %s", system.getNameWithLowercaseType()));
            } else {
                System.out.println(String.format("  Failed to add cryosleeper to %s", system.getNameWithLowercaseType()));
            }
        }
        return entity;
    }

    protected BaseThemeGenerator.AddedEntity addSurveyShip(StarSystemAPI system) {
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.JUMP_ORBIT, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.NEAR_STAR, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.STAR_ORBIT, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.L_POINT, Float.valueOf(1.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = DerelictThemeGenerator.getLocations(this.random, system, 100.0f, weights);
        BaseThemeGenerator.AddedEntity entity = DerelictThemeGenerator.addEntity(this.random, system, locs, "derelict_survey_ship", "derelict");
        if (entity != null) {
            system.addTag("theme_interesting");
            system.addTag("theme_derelict");
            system.addTag("theme_derelict_survey_ship");
        }
        if (DEBUG) {
            if (entity != null) {
                System.out.println(String.format("  Added survey ship to %s", system.getNameWithLowercaseType()));
            } else {
                System.out.println(String.format("  Failed to add survey ship to %s", system.getNameWithLowercaseType()));
            }
        }
        return entity;
    }

    protected List<BaseThemeGenerator.AddedEntity> addProbes(StarSystemAPI system, int num) {
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(20.0f));
        weights.put(BaseThemeGenerator.LocationType.JUMP_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.NEAR_STAR, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(5.0f));
        weights.put(BaseThemeGenerator.LocationType.STAR_ORBIT, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(1.0f));
        weights.put(BaseThemeGenerator.LocationType.L_POINT, Float.valueOf(1.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = DerelictThemeGenerator.getLocations(this.random, system, 100.0f, weights);
        ArrayList<BaseThemeGenerator.AddedEntity> result = new ArrayList<BaseThemeGenerator.AddedEntity>();
        int i = 0;
        while (i < num) {
            BaseThemeGenerator.AddedEntity probe = DerelictThemeGenerator.addEntity(this.random, system, locs, "derelict_probe", "derelict");
            if (probe != null) {
                result.add(probe);
                system.addTag("theme_interesting_minor");
                system.addTag("theme_derelict");
                system.addTag("theme_derelict_probes");
            }
            if (DEBUG) {
                if (probe != null) {
                    System.out.println(String.format("  Added probe to %s", system.getNameWithLowercaseType()));
                } else {
                    System.out.println(String.format("  Failed to add probe to %s", system.getNameWithLowercaseType()));
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    protected List<Constellation> getSortedAvailableConstellations(ThemeGenContext context, boolean emptyOk, final Vector2f sortFrom, List<Constellation> exclude) {
        ArrayList<Constellation> constellations = new ArrayList<Constellation>();
        for (Constellation c : context.constellations) {
            if (context.majorThemes.containsKey(c) || !emptyOk && DerelictThemeGenerator.constellationIsEmpty(c)) continue;
            constellations.add(c);
        }
        if (exclude != null) {
            constellations.removeAll(exclude);
        }
        Collections.sort(constellations, new Comparator<Constellation>(){

            @Override
            public int compare(Constellation o1, Constellation o2) {
                float d1 = Misc.getDistance(o1.getLocation(), sortFrom);
                float d2 = Misc.getDistance(o2.getLocation(), sortFrom);
                return (int)Math.signum(d2 - d1);
            }
        });
        return constellations;
    }

    public static boolean constellationIsEmpty(Constellation c) {
        for (StarSystemAPI s : c.getSystems()) {
            if (DerelictThemeGenerator.systemIsEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean systemIsEmpty(StarSystemAPI system) {
        for (PlanetAPI p : system.getPlanets()) {
            if (p.isStar()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    public static class SystemGenData {
        public int numMotherships;
        public int numSurveyShips;
        public int numProbes;
    }
}

