/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.NameAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RuinsFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class RuinsThemeGenerator
extends BaseThemeGenerator {
    public static final int MIN_CONSTELLATIONS_WITH_RUINS = 15;
    public static final int MAX_CONSTELLATIONS_WITH_RUINS = 25;
    public static float CONSTELLATION_SKIP_PROB = 0.0f;

    @Override
    public String getThemeId() {
        return "ruins";
    }

    @Override
    public void generateForSector(ThemeGenContext context, float allowedUnusedFraction) {
        float total = (float)(context.constellations.size() - context.majorThemes.size()) * allowedUnusedFraction;
        if (total <= 0.0f) {
            return;
        }
        int num = (int)StarSystemGenerator.getNormalRandom(15.0f, 25.0f);
        if ((float)num > total) {
            num = (int)total;
        }
        List<Constellation> constellations = this.getSortedAvailableConstellations(context, false, new Vector2f(), null);
        Collections.reverse(constellations);
        float skipProb = CONSTELLATION_SKIP_PROB;
        if (total < (float)num / (1.0f - skipProb)) {
            skipProb = 1.0f - (float)num / total;
        }
        skipProb = 0.0f;
        ArrayList<BaseThemeGenerator.StarSystemData> ruinSystems = new ArrayList<BaseThemeGenerator.StarSystemData>();
        if (DEBUG) {
            System.out.println("\n\n\n");
        }
        if (DEBUG) {
            System.out.println("Generating systems with ruins");
        }
        int count = 0;
        int numUsed = 0;
        int i = 0;
        while (i < num && i < constellations.size()) {
            Constellation c = constellations.get(i);
            if (this.random.nextFloat() < skipProb) {
                if (DEBUG) {
                    System.out.println("Skipping constellation " + c.getName());
                }
            } else {
                ArrayList<BaseThemeGenerator.StarSystemData> systems = new ArrayList<BaseThemeGenerator.StarSystemData>();
                for (StarSystemAPI system : c.getSystems()) {
                    BaseThemeGenerator.StarSystemData data = RuinsThemeGenerator.computeSystemData(system);
                    systems.add(data);
                }
                List<BaseThemeGenerator.StarSystemData> mainCandidates = this.getSortedSystemsSuitedToBePopulated(systems);
                int numMain = 1 + this.random.nextInt(3);
                if (numMain > mainCandidates.size()) {
                    numMain = mainCandidates.size();
                }
                if (numMain <= 0) {
                    if (DEBUG) {
                        System.out.println("Skipping constellation " + c.getName() + ", no suitable main candidates");
                    }
                } else {
                    context.majorThemes.put(c, "ruins");
                    ++numUsed;
                    if (DEBUG) {
                        System.out.println("Generating " + numMain + " main systems in " + c.getName());
                    }
                    int j = 0;
                    while (j < numMain) {
                        BaseThemeGenerator.StarSystemData data = mainCandidates.get(j);
                        this.populateMain(data);
                        data.system.addTag("theme_interesting");
                        data.system.addTag("theme_ruins");
                        data.system.addTag("theme_ruins_main");
                        ruinSystems.add(data);
                        RuinsFleetRouteManager fleets = new RuinsFleetRouteManager(data.system);
                        data.system.addScript(fleets);
                        if (!NameAssigner.isNameSpecial(data.system)) {
                            NameAssigner.assignSpecialNames(data.system);
                        }
                        ++j;
                    }
                    for (BaseThemeGenerator.StarSystemData data : systems) {
                        int index = mainCandidates.indexOf(data);
                        if (index >= 0 && index < numMain) continue;
                        this.populateNonMain(data);
                        data.system.addTag("theme_interesting");
                        data.system.addTag("theme_ruins");
                        data.system.addTag("theme_ruins_secondary");
                        ruinSystems.add(data);
                    }
                    ++count;
                }
            }
            ++i;
        }
        SalvageSpecialAssigner.SpecialCreationContext specialContext = new SalvageSpecialAssigner.SpecialCreationContext();
        specialContext.themeId = this.getThemeId();
        SalvageSpecialAssigner.assignSpecials(ruinSystems, specialContext);
        if (DEBUG) {
            System.out.println("Finished generating systems with ruins\n\n\n\n\n");
        }
    }

    public void populateNonMain(BaseThemeGenerator.StarSystemData data) {
        boolean special;
        if (DEBUG) {
            System.out.println(" Generating secondary ruins in " + data.system.getName());
        }
        boolean bl = special = data.isBlackHole() || data.isNebula() || data.isPulsar();
        if (special) {
            this.addResearchStations(data, 0.75f, 1, 1, this.createStringPicker("station_research_remnant", Float.valueOf(10.0f)));
        }
        if (this.random.nextFloat() < 0.5f) {
            return;
        }
        if (!data.resourceRich.isEmpty()) {
            this.addMiningStations(data, 0.5f, 1, 1, this.createStringPicker("station_mining_remnant", Float.valueOf(10.0f)));
        }
        if (!special && !data.habitable.isEmpty()) {
            this.addHabCenters(data, 0.25f, 1, 1, this.createStringPicker("orbital_habitat_remnant", Float.valueOf(10.0f)));
        }
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(this.random, data.system.getCenter(), 15.0f, 10.0f, 10.0f);
        this.addShipGraveyard(data, 0.05f, 1, 1, factions);
        this.addDebrisFields(data, 0.25f, 1, 2);
        this.addDerelictShips(data, 0.5f, 0, 3, factions);
        this.addCaches(data, 0.25f, 0, 2, this.createStringPicker("weapons_cache", Float.valueOf(4.0f), "weapons_cache_small", Float.valueOf(10.0f), "weapons_cache_high", Float.valueOf(4.0f), "weapons_cache_small_high", Float.valueOf(10.0f), "weapons_cache_low", Float.valueOf(4.0f), "weapons_cache_small_low", Float.valueOf(10.0f), "supply_cache", Float.valueOf(4.0f), "supply_cache_small", Float.valueOf(10.0f), "equipment_cache", Float.valueOf(4.0f), "equipment_cache_small", Float.valueOf(10.0f)));
    }

    public void populateMain(BaseThemeGenerator.StarSystemData data) {
        if (DEBUG) {
            System.out.println(" Generating ruins in " + data.system.getName());
        }
        StarSystemAPI system = data.system;
        int maxHabCenters = 1 + this.random.nextInt(3);
        BaseThemeGenerator.HabitationLevel level = BaseThemeGenerator.HabitationLevel.LOW;
        if (maxHabCenters == 2) {
            level = BaseThemeGenerator.HabitationLevel.MEDIUM;
        }
        if (maxHabCenters >= 3) {
            level = BaseThemeGenerator.HabitationLevel.HIGH;
        }
        this.addHabCenters(data, 1.0f, maxHabCenters, maxHabCenters, this.createStringPicker("orbital_habitat_remnant", Float.valueOf(10.0f)));
        float probGate = 1.0f;
        float probRelay = 1.0f;
        float probMining = 0.5f;
        float probResearch = 0.25f;
        switch (level) {
            case HIGH: {
                probGate = 0.5f;
                probRelay = 1.0f;
                break;
            }
            case MEDIUM: {
                probGate = 0.3f;
                probRelay = 0.75f;
                break;
            }
            case LOW: {
                probGate = 0.2f;
                probRelay = 0.5f;
            }
        }
        this.addObjectives(data, probRelay);
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(this.random, system.getCenter(), 15.0f, 5.0f, 5.0f);
        this.addInactiveGate(data, probGate, 0.75f, 0.75f, factions);
        this.addShipGraveyard(data, 0.25f, 1, 1, factions);
        this.addMiningStations(data, probMining, 1, 1, this.createStringPicker("station_mining_remnant", Float.valueOf(10.0f)));
        this.addResearchStations(data, probResearch, 1, 1, this.createStringPicker("station_research_remnant", Float.valueOf(10.0f)));
        this.addDebrisFields(data, 0.75f, 1, 5);
        this.addDerelictShips(data, 0.75f, 0, 7, factions);
        WeightedRandomPicker<String> caches = this.createStringPicker("supply_cache", Float.valueOf(10.0f), "supply_cache_small", Float.valueOf(10.0f), "equipment_cache", Float.valueOf(10.0f), "equipment_cache_small", Float.valueOf(10.0f));
        float r = this.random.nextFloat();
        if (r < 0.33f) {
            caches.add("weapons_cache", 10.0f);
            caches.add("weapons_cache_small", 10.0f);
        } else if (r < 0.67f) {
            caches.add("weapons_cache_low", 10.0f);
            caches.add("weapons_cache_small_low", 10.0f);
        } else {
            caches.add("weapons_cache_high", 10.0f);
            caches.add("weapons_cache_small_high", 10.0f);
        }
        this.addCaches(data, 0.75f, 0, 3, caches);
    }

    public List<BaseThemeGenerator.StarSystemData> getSortedSystemsSuitedToBePopulated(List<BaseThemeGenerator.StarSystemData> systems) {
        ArrayList<BaseThemeGenerator.StarSystemData> result = new ArrayList<BaseThemeGenerator.StarSystemData>();
        for (BaseThemeGenerator.StarSystemData data : systems) {
            if (data.isBlackHole() || data.isNebula() || data.isPulsar() || data.planets.size() < 4 && data.habitable.size() < 1) continue;
            result.add(data);
        }
        Collections.sort(systems, new Comparator<BaseThemeGenerator.StarSystemData>(){

            @Override
            public int compare(BaseThemeGenerator.StarSystemData o1, BaseThemeGenerator.StarSystemData o2) {
                float s1 = RuinsThemeGenerator.this.getMainCenterScore(o1);
                float s2 = RuinsThemeGenerator.this.getMainCenterScore(o2);
                return (int)Math.signum(s2 - s1);
            }
        });
        return result;
    }

    public float getMainCenterScore(BaseThemeGenerator.StarSystemData data) {
        float total = 0.0f;
        total += (float)data.planets.size() * 1.0f;
        total += (float)data.habitable.size() * 2.0f;
        return total += (float)data.resourceRich.size() * 0.25f;
    }

    @Override
    protected List<Constellation> getSortedAvailableConstellations(ThemeGenContext context, boolean emptyOk, final Vector2f sortFrom, List<Constellation> exclude) {
        ArrayList<Constellation> constellations = new ArrayList<Constellation>();
        for (Constellation c : context.constellations) {
            if (context.majorThemes.containsKey(c) || !emptyOk && RuinsThemeGenerator.constellationIsEmpty(c)) continue;
            constellations.add(c);
        }
        if (exclude != null) {
            constellations.removeAll(exclude);
        }
        Collections.sort(constellations, new Comparator<Constellation>(){

            @Override
            public int compare(Constellation o1, Constellation o2) {
                float d1 = Misc.getDistance(o1.getLocation(), sortFrom);
                float d2 = Misc.getDistance(o2.getLocation(), sortFrom);
                return (int)Math.signum(d2 - d1);
            }
        });
        return constellations;
    }

    public static boolean constellationIsEmpty(Constellation c) {
        for (StarSystemAPI s : c.getSystems()) {
            if (RuinsThemeGenerator.systemIsEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean systemIsEmpty(StarSystemAPI system) {
        for (PlanetAPI p : system.getPlanets()) {
            if (p.isStar()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 2000;
    }
}

