/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ScavengerFleetAssignmentAI
extends RouteFleetAssignmentAI {
    protected boolean pirate;
    protected IntervalUtil piracyCheck = new IntervalUtil(0.2f, 0.4f);

    public ScavengerFleetAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route, boolean pirate) {
        super(fleet, route);
        this.pirate = pirate;
    }

    @Override
    protected String getTravelActionText(RouteManager.RouteSegment segment) {
        if (segment.to == this.route.getMarket().getPrimaryEntity()) {
            return "returning to " + this.route.getMarket().getName();
        }
        return "on a salvage expedition";
    }

    @Override
    protected String getInSystemActionText(RouteManager.RouteSegment segment) {
        return "exploring";
    }

    @Override
    protected void addLocalAssignment(RouteManager.RouteSegment segment, boolean justSpawned) {
        boolean pickSpecificEntity;
        boolean bl = pickSpecificEntity = (float)Math.random() > 0.2f && !segment.from.getContainingLocation().isHyperspace();
        if (pickSpecificEntity) {
            SectorEntityToken target = RemnantSeededFleetManager.pickEntityToGuard(new Random(), (StarSystemAPI)segment.from.getContainingLocation(), this.fleet);
            if (target != null) {
                if (justSpawned) {
                    Vector2f loc = Misc.getPointAtRadius(new Vector2f((ReadableVector2f)target.getLocation()), 500.0f);
                    this.fleet.setLocation(loc.x, loc.y);
                }
                float speed = Misc.getSpeedForBurnLevel(8.0f);
                float dist = Misc.getDistance(this.fleet.getLocation(), target.getLocation());
                float seconds = dist / speed;
                float days = seconds / Global.getSector().getClock().getSecondsPerDay();
                this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, target, days += 5.0f + 5.0f * (float)Math.random(), "investigating");
                return;
            }
            if (justSpawned) {
                Vector2f loc = Misc.getPointAtRadius(new Vector2f(), 8000.0f);
                this.fleet.setLocation(loc.x, loc.y);
            }
            float days = 5.0f + 5.0f * (float)Math.random();
            this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, null, days, "exploring");
        } else {
            super.addLocalAssignment(segment, justSpawned);
        }
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.pirate) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.piracyCheck.advance(days);
            if (this.piracyCheck.intervalElapsed()) {
                this.doPiracyCheck();
            }
        }
    }

    protected void doPiracyCheck() {
        if (this.fleet.getBattle() != null) {
            return;
        }
        boolean isCurrentlyPirate = this.fleet.getFaction().getId().equals("pirates");
        if (this.fleet.isTransponderOn() && !isCurrentlyPirate) {
            return;
        }
        if (isCurrentlyPirate) {
            List<CampaignFleetAPI> visible = Misc.getVisibleFleets(this.fleet, false);
            if (visible.isEmpty()) {
                this.fleet.setFaction("independent", true);
                Misc.clearTarget(this.fleet, true);
            }
            return;
        }
        List<CampaignFleetAPI> visible = Misc.getVisibleFleets(this.fleet, false);
        if (visible.size() == 1) {
            int weakerCount = 0;
            for (CampaignFleetAPI other : visible) {
                boolean seesComp;
                CampaignFleetAIAPI.EncounterOption option;
                if (this.fleet.getAI() == null || !Global.getSector().getFaction("pirates").isHostileTo(other.getFaction()) || (option = this.fleet.getAI().pickEncounterOption(null, other, true)) != CampaignFleetAIAPI.EncounterOption.ENGAGE && option != CampaignFleetAIAPI.EncounterOption.HOLD) continue;
                float dist = Misc.getDistance(this.fleet.getLocation(), other.getLocation());
                SectorEntityToken.VisibilityLevel level = other.getVisibilityLevelTo(this.fleet);
                boolean bl = seesComp = level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
                if (!(dist < 800.0f) || !seesComp) continue;
                ++weakerCount;
            }
            if (weakerCount == 1) {
                this.fleet.getMemoryWithoutUpdate().set("$isPirate", true);
                this.fleet.setNoFactionInName(true);
                this.fleet.setFaction("pirates", true);
            }
        }
    }
}

