/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RuinsThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SectorThemeGenerator {
    public static List<ThemeGenerator> generators = new ArrayList<ThemeGenerator>();

    static {
        generators.add(new DerelictThemeGenerator());
        generators.add(new RemnantThemeGenerator());
        generators.add(new RuinsThemeGenerator());
        generators.add(new MiscellaneousThemeGenerator());
    }

    public static void generate(ThemeGenContext context) {
        Collections.sort(generators, new Comparator<ThemeGenerator>(){

            @Override
            public int compare(ThemeGenerator o1, ThemeGenerator o2) {
                int result = o1.getOrder() - o2.getOrder();
                if (result == 0) {
                    return o1.getThemeId().compareTo(o2.getThemeId());
                }
                return result;
            }
        });
        float totalWeight = 0.0f;
        for (ThemeGenerator g : generators) {
            totalWeight += g.getWeight();
            g.setRandom(StarSystemGenerator.random);
        }
        for (ThemeGenerator g : generators) {
            float w = g.getWeight();
            float f = 0.0f;
            if (totalWeight > 0.0f) {
                f = w / totalWeight;
            } else if (w > 0.0f) {
                f = 1.0f;
            }
            g.generateForSector(context, f);
            totalWeight -= w;
        }
    }
}

