/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.loading.PersonMissionSpec;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BeginMission
extends BaseCommandPlugin {
    public static String TEMP_MISSION_KEY = "$tempMissionKey";

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        PersonMissionSpec spec;
        if (dialog == null) {
            return false;
        }
        String missionId = params.get(0).getString(memoryMap);
        Boolean accept = null;
        if (params.size() > 1) {
            accept = params.get(1).getBoolean(memoryMap);
        }
        if (accept == null) {
            accept = true;
        }
        if ((spec = Global.getSettings().getMissionSpec(missionId)) == null) {
            throw new RuntimeException("Mission with spec [" + missionId + "] not found");
        }
        HubMission mission = spec.createMission();
        SectorEntityToken entity = dialog.getInteractionTarget();
        PersonAPI person = entity.getActivePerson();
        if (person == null) {
            String extra = "";
            long seed = BarEventManager.getInstance().getSeed(null, person, extra);
            mission.setGenRandom(new Random(seed));
        } else {
            mission.setPersonOverride(person);
            String key = "$beginMission_seedExtra";
            String extra = person.getMemoryWithoutUpdate().getString(key);
            long seed = BarEventManager.getInstance().getSeed(null, person, extra);
            person.getMemoryWithoutUpdate().set(key, "" + seed);
            mission.setGenRandom(new Random(seed));
        }
        mission.createAndAbortIfFailed(entity.getMarket(), false);
        if (mission.isMissionCreationAborted()) {
            MemoryAPI memory = memoryMap.get("local");
            if (memory == null && dialog.getInteractionTarget() != null && (memory = dialog.getInteractionTarget().getActivePerson() != null ? dialog.getInteractionTarget().getActivePerson().getMemoryWithoutUpdate() : dialog.getInteractionTarget().getMemoryWithoutUpdate()) != null) {
                memory.set("$missionCreationFailed", mission.getMissionId());
            }
            return false;
        }
        if (accept.booleanValue()) {
            mission.accept(dialog, memoryMap);
        } else {
            Global.getSector().getMemoryWithoutUpdate().set(TEMP_MISSION_KEY, mission, 0.0f);
        }
        return true;
    }
}

