/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DumpMemory
extends BaseCommandPlugin {
    public static final String OPTION_ID = "DumpMemory.option_dump_memory";

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        ArrayList<String> memKeys = new ArrayList<String>(memoryMap.keySet());
        Collections.sort(memKeys);
        memKeys.remove("local");
        memKeys.add("local");
        Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
        Color GRAY_COLOR = new Color(100, 100, 100);
        for (String memKey : memKeys) {
            String text = "";
            MemoryAPI memory = memoryMap.get(memKey);
            ArrayList<String> keys = new ArrayList<String>(memory.getKeys());
            Collections.sort(keys);
            ArrayList<Color> highlightColors = new ArrayList<Color>();
            ArrayList<String> highlightList = new ArrayList<String>();
            for (String key : keys) {
                Object value = memory.get(key);
                String varName = "$" + memKey + ".";
                if (memKey.equals("local")) {
                    varName = "$";
                }
                if ((varName = key.startsWith("$") ? String.valueOf(varName) + key.substring(1) : String.valueOf(varName) + key).length() > 35) {
                    varName = String.valueOf(varName.substring(0, 35)) + "...";
                }
                highlightColors.add(HIGHLIGHT_COLOR);
                highlightList.add(varName);
                text = String.valueOf(text) + varName;
                text = value instanceof Boolean || value instanceof String || value instanceof Float || value instanceof Integer || value instanceof Long ? String.valueOf(text) + " = " + value.toString() : (value != null ? String.valueOf(text) + " = " + value.getClass().getSimpleName() + "@" + value.hashCode() : String.valueOf(text) + " = null");
                float expire2 = memory.getExpire(key);
                if (expire2 >= 0.0f) {
                    String eText = "(e=" + (float)((int)(expire2 * 10.0f)) / 10.0f + ")";
                    if (expire2 == 0.0f) {
                        eText = "(e=0)";
                    }
                    highlightColors.add(GRAY_COLOR);
                    highlightList.add(eText);
                    text = String.valueOf(text) + " " + eText;
                }
                text = String.valueOf(text) + "\n";
            }
            if (dialog != null) {
                dialog.getTextPanel().addParagraph(text);
                dialog.getTextPanel().setHighlightColorsInLastPara(highlightColors.toArray(new Color[0]));
                dialog.getTextPanel().highlightInLastPara(highlightList.toArray(new String[0]));
                continue;
            }
            if (!DebugFlags.PRINT_RULES_DEBUG_INFO) continue;
            System.out.println(text);
        }
        return true;
    }

    public static void addOption(InteractionDialogAPI dialog) {
        dialog.getOptionPanel().addOption(">> (dev) dump memory", OPTION_ID, Misc.getGrayColor(), null);
    }
}

