/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.ExpressionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.Option;
import com.fs.starfarer.api.campaign.rules.RuleAPI;
import com.fs.starfarer.api.campaign.rules.RulesAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class FireBest
extends BaseCommandPlugin {
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected List<Misc.Token> params;
    protected String ruleId;
    protected boolean keepOptions = false;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        RulesAPI rules;
        RuleAPI rule;
        this.ruleId = ruleId;
        this.dialog = dialog;
        this.params = params;
        this.memoryMap = memoryMap;
        String trigger = params.get((int)0).string;
        if (params.get(0).isVariable()) {
            Misc.VarAndMemory var = params.get(0).getVarNameAndMemory(memoryMap);
            trigger = var.memory.getString(var.name);
        }
        if (params.size() > 1) {
            this.keepOptions = params.get(1).getBoolean(memoryMap);
        }
        if ((rule = (rules = Global.getSector().getRules()).getBestMatching(ruleId, trigger, dialog, memoryMap)) == null) {
            return false;
        }
        this.applyRule(rule);
        return true;
    }

    public static boolean fire(String ruleId, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, String params) {
        return new FireBest().execute(ruleId, dialog, Misc.tokenize(params), memoryMap);
    }

    private void applyRule(RuleAPI rule) {
        ArrayList<FireAll.OptionAdder> options = new ArrayList<FireAll.OptionAdder>();
        for (Option option : rule.getOptions()) {
            if (option.id.startsWith("(dev)") && !Global.getSettings().isDevMode()) continue;
            options.add(new FireAll.OptionAdder(option));
        }
        for (ExpressionAPI expressionAPI : rule.getScriptCopy()) {
            if (!expressionAPI.doesCommandAddOptions()) continue;
            options.add(new FireAll.OptionAdder(expressionAPI));
        }
        if (!options.isEmpty()) {
            Collections.sort(options, new Comparator<FireAll.OptionAdder>(){

                @Override
                public int compare(FireAll.OptionAdder o1, FireAll.OptionAdder o2) {
                    float diff = o1.getOrder(FireBest.this.memoryMap) - o2.getOrder(FireBest.this.memoryMap);
                    if (diff < 0.0f) {
                        return -1;
                    }
                    if (diff > 0.0f) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (!this.keepOptions) {
                this.dialog.getOptionPanel().clearOptions();
            }
            for (FireAll.OptionAdder optionAdder : options) {
                optionAdder.add(this.ruleId, this.dialog, this.params, this.memoryMap);
            }
            if (!this.keepOptions && Global.getSettings().isDevMode()) {
                DevMenuOptions.addOptions(this.dialog);
            }
        }
        this.addText(rule.getId(), rule.pickText());
        rule.runScript(this.dialog, this.memoryMap);
    }

    private void addText(String ruleId, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        text = Global.getSector().getRules().performTokenReplacement(ruleId, text, this.dialog.getInteractionTarget(), this.memoryMap);
        this.dialog.getTextPanel().addParagraph(text);
    }
}

