/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.CharacterCreationData;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.CampaignTutorialScript;
import com.fs.starfarer.api.impl.campaign.tutorial.SpacerObligation;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class NGCAddStandardStartingScript
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        CharacterCreationData data = (CharacterCreationData)memoryMap.get("local").get("$characterData");
        final MemoryAPI memory = memoryMap.get("local");
        data.addScriptBeforeTimePass(new Script(){

            @Override
            public void run() {
                boolean skipTutorial;
                boolean explorer = memory.getBoolean("$ngcExplorerSelected");
                boolean merc = memory.getBoolean("$ngcMercSelected");
                boolean random = memory.getBoolean("$ngcRandomSelected");
                boolean spacer = memory.getBoolean("$ngcSpacerSelected");
                if (explorer || merc || random) {
                    Global.getSector().getMemoryWithoutUpdate().set("$fastStart", true);
                    if (explorer) {
                        Global.getSector().getMemoryWithoutUpdate().set("$fastStartExplorer", true);
                    }
                    if (merc) {
                        Global.getSector().getMemoryWithoutUpdate().set("$fastStartMerc", true);
                    }
                    if (random) {
                        Global.getSector().getMemoryWithoutUpdate().set("$fastStartRandom", true);
                    }
                }
                if (spacer) {
                    Global.getSector().getMemoryWithoutUpdate().set("$spacerStart", true);
                }
                if (!(skipTutorial = memory.getBoolean("$ngcSkipTutorial"))) {
                    Global.getSector().getMemoryWithoutUpdate().set("$tutorialRespawn", true);
                }
            }
        });
        data.addScript(new Script(){

            @Override
            public void run() {
                CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
                int crew = 0;
                int supplies = 0;
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    crew = (int)((double)crew + Math.ceil(member.getMinCrew() + (member.getMaxCrew() - member.getMinCrew()) * 0.5f));
                    supplies = (int)((float)supplies + member.getDeploymentCostSupplies() * 4.0f);
                }
                CargoAPI cargo = fleet.getCargo();
                cargo.initPartialsIfNeeded();
                cargo.addCrew(crew);
                cargo.addSupplies(10.0f);
                cargo.addCommodity("heavy_machinery", 10.0f);
                cargo.addFuel(cargo.getMaxFuel() * 0.5f);
                boolean addOfficer = memory.getBoolean("$ngcAddOfficer");
                boolean skipTutorial = memory.getBoolean("$ngcSkipTutorial");
                boolean explorer = memory.getBoolean("$ngcExplorerSelected");
                boolean merc = memory.getBoolean("$ngcMercSelected");
                boolean random = memory.getBoolean("$ngcRandomSelected");
                boolean spacer = memory.getBoolean("$ngcSpacerSelected");
                if (explorer) {
                    cargo.addCommodity("heavy_machinery", 50.0f);
                    cargo.addSupplies(150.0f);
                    cargo.removeFuel(cargo.getMaxFuel() * 0.2f);
                    NGCAddStandardStartingScript.adjustStartingHulls(fleet);
                } else if (merc) {
                    cargo.addSupplies(100.0f);
                    cargo.removeFuel(cargo.getMaxFuel() * 0.2f);
                    NGCAddStandardStartingScript.adjustStartingHulls(fleet);
                } else if (spacer) {
                    NGCAddStandardStartingScript.adjustStartingHulls(fleet);
                } else if (random) {
                    addOfficer = NGCAddStandardStartingScript.genRandomStart(fleet);
                }
                fleet.getFleetData().ensureHasFlagship();
                if (addOfficer) {
                    for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                        if (member.isFlagship()) continue;
                        PersonAPI officer = Global.getSector().getPlayerFaction().createRandomPerson(new Random());
                        officer.getStats().setSkillLevel("helmsmanship", 1.0f);
                        officer.setRankId(Ranks.SPACE_LIEUTENANT);
                        officer.setPostId(Ranks.POST_OFFICER);
                        officer.setPersonality("steady");
                        officer.getStats().refreshCharacterStatsEffects();
                        member.setCaptain(officer);
                        fleet.getFleetData().addOfficer(officer);
                        break;
                    }
                }
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    float max = member.getRepairTracker().getMaxCR();
                    member.getRepairTracker().setCR(max);
                }
                fleet.getFleetData().setSyncNeeded();
                if (skipTutorial) {
                    StarSystemAPI system = Global.getSector().getStarSystem("galatia");
                    PlanetAPI ancyra = (PlanetAPI)system.getEntityById("ancyra");
                    PersonAPI mainContact = TutorialMissionIntel.createMainContact(ancyra);
                    PersonAPI jangalaContact = TutorialMissionIntel.getJangalaContact();
                    TutorialMissionIntel.endGalatiaPortionOfMission(!spacer, false);
                    if (spacer) {
                        new SpacerObligation();
                    }
                    mainContact.getRelToPlayer().setRel(0.2f);
                    jangalaContact.getRelToPlayer().setRel(0.1f);
                    Global.getSector().getFaction("hegemony").getRelToPlayer().setRel(0.15f);
                    if (spacer) {
                        cargo.clear();
                        cargo.addCrew(2);
                        cargo.addSupplies(15.0f);
                        cargo.addFuel(cargo.getMaxFuel() * 1.0f);
                    } else {
                        float addCrew;
                        float freeCargo = cargo.getSpaceLeft();
                        float addMachinery = Math.min(freeCargo, 15.0f);
                        if (random) {
                            float r = (float)Math.random();
                            addMachinery = Math.min(freeCargo, 5.0f + 20.0f * r);
                        }
                        if (addMachinery > 0.0f) {
                            cargo.addCommodity("heavy_machinery", addMachinery);
                            freeCargo -= addMachinery;
                        }
                        float addSupplies = Math.min(freeCargo, 70.0f);
                        if (random) {
                            supplies = 0;
                            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                                crew = (int)((double)crew + Math.ceil(member.getMinCrew() + (member.getMaxCrew() - member.getMinCrew()) * 0.5f));
                                supplies = (int)((float)supplies + member.getDeploymentCostSupplies() * 4.0f);
                            }
                            float r = (float)Math.random();
                            cargo.removeSupplies(cargo.getSupplies());
                            freeCargo = cargo.getSpaceLeft();
                            addSupplies = Math.min(freeCargo, (float)supplies + 20.0f + 20.0f * r);
                        }
                        if (addSupplies > 0.0f) {
                            cargo.addSupplies(addSupplies);
                            freeCargo -= addSupplies;
                        }
                        float addFuel = Math.min((float)cargo.getFreeFuelSpace() - 10.0f, 70.0f);
                        if (random) {
                            float r = (float)Math.random();
                            cargo.removeFuel(cargo.getFuel());
                            addFuel = Math.min((float)cargo.getFreeFuelSpace(), cargo.getMaxFuel() * (0.25f + 0.25f * r));
                        }
                        if (addFuel > 0.0f) {
                            cargo.addFuel(addFuel);
                        }
                        if ((addCrew = Math.min((float)cargo.getFreeCrewSpace() - 10.0f, 100.0f)) > 0.0f) {
                            cargo.addCrew((int)addCrew);
                        }
                        if (!random) {
                            cargo.getCredits().add(30000.0f);
                        }
                    }
                } else {
                    float addCrew;
                    if (random && (addCrew = Math.min((float)cargo.getFreeCrewSpace() - 10.0f, 10.0f)) > 0.0f) {
                        cargo.addCrew((int)addCrew);
                    }
                    fleet.clearAbilities();
                    PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
                    int i = 0;
                    while (i < 5) {
                        slots.setCurrBarIndex(i);
                        int j = 0;
                        while (j < 10) {
                            PersistentUIDataAPI.AbilitySlotAPI slot = slots.getCurrSlotsCopy().get(j);
                            slot.setAbilityId(null);
                            ++j;
                        }
                        ++i;
                    }
                    fleet.clearFloatingText();
                    fleet.setTransponderOn(false);
                    StarSystemAPI system = Global.getSector().getStarSystem("galatia");
                    system.addScript(new CampaignTutorialScript(system));
                }
            }
        });
        return true;
    }

    public static boolean genRandomStart(CampaignFleetAPI fleet) {
        Random random = new Random();
        fleet.getFleetData().clear();
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        picker.add("shrike_Attack");
        picker.add("mule_Standard");
        picker.add("hammerhead_Balanced");
        picker.add("enforcer_Balanced", 0.5f);
        picker.add("enforcer_Assault", 0.5f);
        picker.add("drover_Starting", 1.0f);
        float qMod = 0.0f;
        float r = random.nextFloat();
        int num = 1;
        boolean addedLarge = false;
        if (r > 0.5f) {
            num = 2;
            qMod -= 0.1f;
            addedLarge = true;
        }
        int i = 0;
        while (i < num) {
            fleet.getFleetData().addFleetMember((String)picker.pickAndRemove());
            ++i;
        }
        picker.clear();
        picker.add("lasher_Standard");
        picker.add("centurion_Assault");
        picker.add("wolf_Assault", 0.5f);
        picker.add("wolf_CS", 0.5f);
        picker.add("wayfarer_Standard");
        picker.add("hound_hegemony_Standard", 0.5f);
        picker.add("hound_Standard", 0.5f);
        picker.add("cerberus_Standard");
        picker.add("kite_hegemony_Interceptor", 0.5f);
        picker.add("kite_pirates_Raider", 0.5f);
        picker.add("gremlin_Strike");
        picker.add("condor_Attack");
        num = 1;
        r = random.nextFloat();
        int extra = (int)(r / 0.34f);
        if (addedLarge) {
            extra = Math.min(extra, 1);
        }
        num += extra;
        qMod -= 0.07f * (float)extra;
        int i2 = 0;
        while (i2 < num) {
            fleet.getFleetData().addFleetMember((String)picker.pickAndRemove());
            ++i2;
        }
        picker.clear();
        picker.add("tarsus_Standard");
        picker.add("buffalo_Standard");
        picker.add("crig_Standard");
        picker.add("mudskipper_Standard");
        fleet.getFleetData().addFleetMember((String)picker.pickAndRemove());
        r = random.nextFloat();
        if (r > 0.75f) {
            fleet.getFleetData().addFleetMember("phaeton_Standard");
        } else if (r > 0.33f) {
            fleet.getFleetData().addFleetMember("dram_Light");
        }
        DefaultFleetInflaterParams p = new DefaultFleetInflaterParams();
        p.quality = 0.8f + qMod;
        p.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        p.persistent = false;
        p.seed = random.nextLong();
        p.timestamp = null;
        FleetInflater inflater = Misc.getInflater(fleet, p);
        fleet.setFaction("independent");
        inflater.inflate(fleet);
        fleet.setInflater(null);
        fleet.setFaction("player");
        fleet.getCargo().addCrew((int)fleet.getFleetData().getMinCrew() - fleet.getCargo().getCrew());
        fleet.getCargo().getCredits().set((int)(5000.0f + 20000.0f * random.nextFloat()));
        fleet.getFleetData().syncIfNeeded();
        fleet.getCargo().sort();
        fleet.getFlagship().setCaptain(Global.getSector().getCharacterData().getPerson());
        fleet.getFlagship().updateStats();
        return random.nextFloat() > 0.5f;
    }

    public static void adjustStartingHulls(CampaignFleetAPI fleet) {
        boolean addDmods = true;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            ShipVariantAPI v = member.getVariant().clone();
            v.setSource(VariantSource.REFIT);
            v.setHullVariantId(Misc.genUID());
            member.setVariant(v, false, false);
            String h = member.getHullId();
            if (!addDmods) continue;
            if (h.equals("hammerhead")) {
                v.addPermaMod("comp_hull");
                continue;
            }
            if (h.equals("drover")) {
                v.addPermaMod("faulty_grid");
                continue;
            }
            if (h.equals("centurion")) {
                v.addPermaMod("comp_armor");
                continue;
            }
            if (h.equals("lasher")) {
                v.addPermaMod("fragile_subsystems");
                continue;
            }
            if (h.equals("dram")) {
                v.addPermaMod("fragile_subsystems");
                continue;
            }
            if (h.equals("apogee")) continue;
            if (h.equals("condor")) {
                v.addPermaMod("comp_armor");
                continue;
            }
            if (h.equals("wayfarer")) {
                v.addPermaMod("fragile_subsystems");
                continue;
            }
            if (h.equals("shepherd")) {
                v.addPermaMod("faulty_grid");
                continue;
            }
            if (!h.equals("kite_original")) continue;
            v.addPermaMod("comp_armor");
            v.addPermaMod("faulty_grid");
        }
        fleet.getFleetData().setSyncNeeded();
    }
}

