/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddShip;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class TT_CMD
extends BaseCommandPlugin {
    protected String ARROYO = "arroyo";
    protected String SUN = "sun";
    protected String GLAMOR_ROTANEV = "glamor_rotanev";

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        CargoAPI cargo = pf.getCargo();
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        if ("isArroyoContact".equals(action)) {
            return this.isArroyoContact();
        }
        if ("giveColossus".equals(action)) {
            this.giveColossus(dialog, params, memoryMap);
            return true;
        }
        if ("givePhaeton".equals(action)) {
            this.givePhaeton(dialog, params, memoryMap);
            return true;
        }
        return false;
    }

    protected void giveColossus(InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        ShipVariantAPI v = Global.getSettings().getVariant("colossus_Standard").clone();
        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, v);
        Global.getSector().getPlayerFleet().getFleetData().addFleetMember(member);
        AddShip.addShipGainText(member, dialog.getTextPanel());
    }

    protected void givePhaeton(InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        ShipVariantAPI v = Global.getSettings().getVariant("phaeton_Standard").clone();
        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, v);
        Global.getSector().getPlayerFleet().getFleetData().addFleetMember(member);
        AddShip.addShipGainText(member, dialog.getTextPanel());
    }

    protected boolean isArroyoContact() {
        PersonAPI person = People.getPerson(this.ARROYO);
        boolean isContact = ContactIntel.playerHasContact(person, true);
        return isContact;
    }
}

