/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseCampaignEventListenerAndScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignProgressIndicatorAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.LeashScript;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.RuleException;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class Wait
extends BaseCommandPlugin {
    private EveryFrameScript waitScript;
    private LeashScript leash;
    private CampaignProgressIndicatorAPI indicator;
    private Misc.VarAndMemory handle;
    private Misc.VarAndMemory finished;
    private Misc.VarAndMemory interrupted;
    private Misc.VarAndMemory inProgress;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (params.size() != 6) {
            throw new RuleException("Wait usage: Wait $handle duration $finished $interrupted $inProgress <text>");
        }
        this.handle = params.get(0).getVarNameAndMemory(memoryMap);
        final float durationDays = Float.parseFloat(params.get((int)1).string);
        this.finished = params.get(2).getVarNameAndMemory(memoryMap);
        this.interrupted = params.get(3).getVarNameAndMemory(memoryMap);
        this.inProgress = params.get(4).getVarNameAndMemory(memoryMap);
        String text = "Waiting";
        if (params.size() >= 5) {
            text = params.get(5).getString(memoryMap);
        }
        final SectorEntityToken target = dialog.getInteractionTarget();
        final CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        playerFleet.setInteractionTarget(null);
        Vector2f offset = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)target.getLocation(), (Vector2f)new Vector2f());
        float len = offset.length();
        float radSum = playerFleet.getRadius() + target.getRadius() - 1.0f;
        if (len > 0.0f) {
            offset.scale(radSum / len);
        } else {
            offset.set(radSum, 0.0f);
        }
        this.indicator = Global.getFactory().createProgressIndicator(text, target, durationDays);
        target.getContainingLocation().addEntity(this.indicator);
        this.waitScript = new BaseCampaignEventListenerAndScript(durationDays + 0.1f){
            private float elapsedDays;
            private boolean done;
            private boolean battleOccured;
            private boolean interactedWithSomethingElse;
            {
                super($anonymous0);
                this.elapsedDays = 0.0f;
                this.done = false;
                this.battleOccured = false;
                this.interactedWithSomethingElse = false;
            }

            @Override
            public boolean runWhilePaused() {
                return false;
            }

            @Override
            public boolean isDone() {
                return this.done;
            }

            @Override
            public void advance(float amount) {
                CampaignClockAPI clock = Global.getSector().getClock();
                Global.getSector().getCampaignUI().setDisallowPlayerInteractionsForOneFrame();
                float days = clock.convertToDays(amount);
                this.elapsedDays += days;
                Wait.this.inProgress.memory.set(Wait.this.inProgress.name, true);
                Wait.this.inProgress.memory.expire(Wait.this.inProgress.name, 0.1f);
                if (this.battleOccured || this.interactedWithSomethingElse) {
                    this.done = true;
                    Wait.this.interrupted.memory.set(Wait.this.interrupted.name, true);
                    Wait.this.interrupted.memory.expire(Wait.this.interrupted.name, 2.0f);
                    Wait.this.handle.memory.unset(Wait.this.handle.name);
                    Wait.this.indicator.interrupt();
                    Global.getSector().removeScript(Wait.this.leash);
                    Global.getSoundPlayer().playUISound("ui_wait_interrupt", 1.0f, 1.0f);
                } else if (this.elapsedDays >= durationDays && !Global.getSector().getCampaignUI().isShowingDialog()) {
                    this.done = true;
                    Wait.this.finished.memory.set(Wait.this.finished.name, true);
                    Wait.this.finished.memory.expire(Wait.this.finished.name, 0.0f);
                    Wait.this.inProgress.memory.unset(Wait.this.inProgress.name);
                    Wait.this.handle.memory.unset(Wait.this.handle.name);
                    Global.getSector().removeScript(Wait.this.leash);
                    Wait.this.indicator.getContainingLocation().removeEntity(Wait.this.indicator);
                    Global.getSector().getCampaignUI().showInteractionDialog(target);
                    Global.getSoundPlayer().playUISound("ui_wait_finish", 1.0f, 1.0f);
                }
            }

            @Override
            public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
                if (battle.getSnapshotSideFor(playerFleet) != null || target instanceof CampaignFleetAPI && battle.getSnapshotSideFor((CampaignFleetAPI)target) != null) {
                    this.battleOccured = true;
                }
            }

            @Override
            public void reportShownInteractionDialog(InteractionDialogAPI dialog) {
                this.interactedWithSomethingElse |= dialog.getInteractionTarget() != target;
            }

            @Override
            public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
                if (fleet == playerFleet || fleet == target) {
                    this.battleOccured = true;
                }
            }
        };
        this.leash = new LeashScript(playerFleet, 50.0f, target, offset, new Script(){

            @Override
            public void run() {
                Wait.this.interrupted.memory.set(Wait.this.interrupted.name, true);
                Wait.this.interrupted.memory.expire(Wait.this.interrupted.name, 2.0f);
                Wait.this.handle.memory.unset(Wait.this.handle.name);
                Wait.this.indicator.interrupt();
                Global.getSector().removeScript(Wait.this.waitScript);
                Global.getSoundPlayer().playUISound("ui_wait_interrupt", 1.0f, 1.0f);
            }
        });
        Global.getSector().addScript(this.leash);
        this.handle.memory.set(this.handle.name, this);
        Global.getSector().addScript(this.waitScript);
        Global.getSector().setPaused(false);
        dialog.dismiss();
        return true;
    }

    public EveryFrameScript getWaitScript() {
        return this.waitScript;
    }

    public LeashScript getLeashScript() {
        return this.leash;
    }

    public CampaignProgressIndicatorAPI getIndicator() {
        return this.indicator;
    }

    public Misc.VarAndMemory getHandle() {
        return this.handle;
    }

    public Misc.VarAndMemory getFinished() {
        return this.finished;
    }

    public Misc.VarAndMemory getInProgress() {
        return this.inProgress;
    }

    public Misc.VarAndMemory getInterrupted() {
        return this.interrupted;
    }
}

