/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEntityPickerListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.misc.GateHaulerIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GateHaulerCMD
extends BaseCommandPlugin {
    public static int ACTIVATION_COST = 1000;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected SectorEntityToken stableLocation;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = GateHaulerCMD.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.stableLocation = this.findNearestStableLocation();
        if (command.equals("addIntel")) {
            Global.getSector().getIntelManager().addIntel(new GateHaulerIntel(this.entity), false, this.text);
        } else if (command.equals("printCost")) {
            this.printCost();
        } else if (command.equals("removeActivationCosts")) {
            this.removeActivationCosts();
        } else {
            if (command.equals("canActivate")) {
                return this.canActivate();
            }
            if (command.equals("selectDestination")) {
                this.selectDestination();
            } else if (command.equals("activate")) {
                this.activate();
            } else {
                if (command.equals("canDeploy")) {
                    return this.canDeploy();
                }
                if (command.equals("deploy")) {
                    this.deploy();
                } else {
                    if (command.equals("isInCurrentSystem")) {
                        return this.isInCurrentSystem();
                    }
                    if (command.equals("wasDeployedToCurrentSystem")) {
                        return this.wasDeployedToCurrentSystem();
                    }
                }
            }
        }
        return true;
    }

    public boolean wasDeployedToCurrentSystem() {
        LocationAPI loc = Global.getSector().getCurrentLocation();
        if (loc == null) {
            return false;
        }
        return loc.getMemoryWithoutUpdate().getBoolean("$deployedGateHaulerHere");
    }

    public boolean isInCurrentSystem() {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null && intel.getAction() == null) {
            return intel.getGateHauler().getContainingLocation() == Global.getSector().getCurrentLocation();
        }
        return false;
    }

    public void deploy() {
        if (this.stableLocation == null) {
            return;
        }
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null) {
            intel.initiateDeployment(this.stableLocation);
        }
    }

    public boolean canDeploy() {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel == null) {
            return false;
        }
        return this.stableLocation != null;
    }

    public SectorEntityToken findNearestStableLocation() {
        if (this.entity.getContainingLocation() == null) {
            return null;
        }
        float minDist = Float.MAX_VALUE;
        SectorEntityToken nearest = null;
        for (SectorEntityToken curr : this.entity.getContainingLocation().getEntitiesWithTag("stable_location")) {
            float dist = Misc.getDistance(curr, this.entity);
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = curr;
        }
        return nearest;
    }

    public void activate() {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null) {
            intel.activate();
        }
    }

    public void printCost() {
        Misc.showCost(this.text, null, null, this.getResources(), this.getQuantities());
        if (this.canActivate()) {
            this.text.addPara("Proceed with reactivation?");
        } else {
            this.text.addPara("You do not have the necessary resources to reactivate the Gate Hauler.");
        }
    }

    public void removeActivationCosts() {
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getResources();
        int[] quantities = this.getQuantities();
        int i = 0;
        while (i < res.length) {
            String commodityId = res[i];
            int quantity = quantities[i];
            cargo.removeCommodity(commodityId, quantity);
            ++i;
        }
    }

    public boolean canActivate() {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return true;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getResources();
        int[] quantities = this.getQuantities();
        int i = 0;
        while (i < res.length) {
            int quantity = quantities[i];
            String commodityId = res[i];
            if ((float)quantity > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getResources() {
        return new String[]{"rare_metals"};
    }

    public int[] getQuantities() {
        return new int[]{ACTIVATION_COST};
    }

    public int getTravelDays(SectorEntityToken entity) {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null) {
            StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
            return intel.computeTransitDays(system);
        }
        return 365;
    }

    public void selectDestination() {
        ArrayList<SectorEntityToken> systems = new ArrayList<SectorEntityToken>();
        for (StarSystemAPI curr : Global.getSector().getStarSystems()) {
            if (curr == this.entity.getContainingLocation() || curr.hasTag("theme_hidden") && !"Limbo".equals(curr.getBaseName()) || curr.isDeepSpace() || curr.getHyperspaceAnchor() == null || Misc.getStarSystemForAnchor(curr.getHyperspaceAnchor()) == null) continue;
            systems.add(curr.getHyperspaceAnchor());
        }
        this.dialog.showCampaignEntityPicker("Select destination for gate hauler", "Destination:", "Execute", Global.getSector().getPlayerFaction(), systems, new BaseCampaignEntityPickerListener(){

            @Override
            public void pickedEntity(SectorEntityToken entity) {
                GateHaulerCMD.this.dialog.dismiss();
                Global.getSector().setPaused(false);
                GateHaulerIntel intel = GateHaulerIntel.get(GateHaulerCMD.this.entity);
                if (intel != null) {
                    StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
                    intel.initiateDeparture(system);
                }
            }

            @Override
            public void cancelledEntityPicking() {
            }

            @Override
            public String getMenuItemNameOverrideFor(SectorEntityToken entity) {
                StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
                if (system != null) {
                    return system.getNameWithLowercaseTypeShort();
                }
                return null;
            }

            @Override
            public String getSelectedTextOverrideFor(SectorEntityToken entity) {
                StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
                if (system != null) {
                    return system.getNameWithLowercaseType();
                }
                return null;
            }

            @Override
            public void createInfoText(TooltipMakerAPI info, SectorEntityToken entity) {
                int days = GateHaulerCMD.this.getTravelDays(entity);
                info.setParaSmallInsignia();
                String daysStr = "days";
                if (days == 1) {
                    daysStr = "day";
                }
                info.addPara("    Estimated gate hauler travel time: %s " + daysStr, 0.0f, Misc.getHighlightColor(), "" + days);
            }

            @Override
            public boolean canConfirmSelection(SectorEntityToken entity) {
                return true;
            }

            @Override
            public float getFuelColorAlphaMult() {
                return 0.0f;
            }

            @Override
            public float getFuelRangeMult() {
                return 0.0f;
            }
        });
    }
}

