/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DemandCargo
extends BaseCommandPlugin {
    protected CampaignFleetAPI playerFleet;
    protected CampaignFleetAPI otherFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected PersonAPI person;
    protected FactionAPI faction;
    protected boolean buysAICores;
    protected float valueMult;
    protected float repMult;
    protected DemandData data = new DemandData();

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = DemandCargo.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.otherFleet = (CampaignFleetAPI)this.entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.person = dialog.getInteractionTarget().getActivePerson();
        this.faction = this.person != null ? this.person.getFaction() : this.entityFaction;
        String key = "$DemandCargo_temp";
        MemoryAPI mem = this.otherFleet.getMemoryWithoutUpdate();
        if (mem.contains(key)) {
            this.data = (DemandData)mem.get(key);
        } else {
            this.data = new DemandData();
            this.data.cargo = Global.getFactory().createCargo(true);
            mem.set(key, this.data, 0.0f);
        }
        if (command.equals("selectCargo")) {
            this.selectCores();
        } else {
            command.equals("playerHasValuableCargo");
        }
        return true;
    }

    protected Random getRandom() {
        String key = "$DemandCargo_random";
        MemoryAPI mem = this.otherFleet.getMemoryWithoutUpdate();
        Random random = null;
        if (mem.contains(key)) {
            random = (Random)mem.get(key);
        } else {
            long seed = Misc.getSalvageSeed(this.otherFleet);
            seed /= 321L;
            random = new Random(seed *= (long)(Global.getSector().getClock().getMonth() + 10));
        }
        mem.set(key, random, 30.0f);
        return random;
    }

    protected void computeAndPrintDemands() {
        int fleetValue = 0;
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            fleetValue = (int)((float)fleetValue + member.getHullSpec().getBaseValue());
        }
        for (CargoStackAPI stack : this.playerCargo.getStacksCopy()) {
            fleetValue = (int)((float)fleetValue + (float)stack.getBaseValuePerUnit() * stack.getSize());
        }
        float demandFraction = 0.2f;
        float rel = this.otherFleet.getFaction().getRelToPlayer().getRel();
        if (rel > 0.0f) {
            demandFraction *= 0.2f + 0.8f * rel;
        }
        int demandValue = (int)((float)fleetValue * demandFraction);
        Random random = this.getRandom();
    }

    protected void selectCores() {
        CargoAPI copy = Global.getFactory().createCargo(false);
        for (CargoStackAPI stack : this.playerCargo.getStacksCopy()) {
            CommoditySpecAPI spec = stack.getResourceIfResource();
            if (spec == null || !spec.getDemandClass().equals("ai_cores")) continue;
            copy.addFromStack(stack);
        }
        copy.sort();
    }

    public static class DemandData {
        public CargoAPI cargo;
        public List<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
        public int credits = 0;
        public boolean hasAnythingWorthwhile = true;
    }
}

