/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.abilities.DistressCallAbility;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class DistressResponse
extends BaseCommandPlugin {
    public static float REP_PER_USE = -0.02f;
    public static float REP_SCAM = -0.15f;
    protected CampaignFleetAPI playerFleet;
    protected CampaignFleetAPI fleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected PersonAPI person;
    protected FactionAPI faction;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = DistressResponse.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.person = dialog.getInteractionTarget().getActivePerson();
        this.faction = this.person.getFaction();
        this.fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        if (command.equals("playerNeedsHelp")) {
            return this.playerNeedsHelp();
        }
        if (command.equals("didNotNeedHelp")) {
            this.didNotNeedHelp();
        } else if (command.equals("acceptHelp")) {
            this.acceptAid();
        } else if (command.equals("neverMind")) {
            this.neverMind();
        } else {
            if (command.equals("isCargoPodsScam")) {
                return this.isCargoPodsScam();
            }
            if (command.equals("cargoPodsScam")) {
                this.cargoPodsScam();
            } else if (command.equals("unrespond")) {
                this.unrespond();
            } else if (command.equals("init")) {
                this.init();
            } else if (command.equals("pay")) {
                this.pay();
            } else if (command.equals("thank")) {
                this.thank();
            }
        }
        return true;
    }

    protected void init() {
        this.person.getMemoryWithoutUpdate().set("$distressUsesLastCycle", this.getNumUses(), 0.0f);
        int fuel = this.getNeededFuel();
        int supplies = this.getNeededSupplies();
        int maxFuel = this.getMaxFuel();
        int maxSupplies = this.getMaxSupplies();
        boolean adequate = (float)fuel <= (float)maxFuel * 1.5f && (float)supplies <= (float)maxSupplies * 1.5f;
        this.person.getMemoryWithoutUpdate().set("$distressHelpAdequate", adequate, 0.0f);
        int distressPayment = this.getPayment();
        this.person.getMemoryWithoutUpdate().set("$distressPayment", Misc.getWithDGS(distressPayment), 0.0f);
        this.person.getMemoryWithoutUpdate().set("$distressPaymentC", String.valueOf(Misc.getWithDGS(distressPayment)) + "\u00a2", 0.0f);
        this.person.getMemoryWithoutUpdate().set("$distressCanAfford", (float)distressPayment <= this.playerCargo.getCredits().get(), 0.0f);
    }

    protected int getPayment() {
        int fuel = this.getNeededFuel();
        int supplies = this.getNeededSupplies();
        int maxFuel = this.getMaxFuel();
        int maxSupplies = this.getMaxSupplies();
        if (fuel > maxFuel) {
            fuel = maxFuel;
        }
        if (supplies > maxSupplies) {
            supplies = maxSupplies;
        }
        CommoditySpecAPI fuelComm = Global.getSettings().getCommoditySpec("fuel");
        CommoditySpecAPI suppliesComm = Global.getSettings().getCommoditySpec("fuel");
        float distressPayment = (float)fuel * fuelComm.getBasePrice() + (float)supplies * suppliesComm.getBasePrice();
        distressPayment = (float)Math.ceil(distressPayment / 10000.0f) * 10000.0f;
        return (int)(distressPayment *= 2.0f);
    }

    protected int getNumUses() {
        AbilityPlugin plugin = this.playerFleet.getAbility("distress_call");
        if (plugin != null) {
            int uses = ((DistressCallAbility)plugin).getNumUsesInLastPeriod();
            return uses;
        }
        return 0;
    }

    protected boolean playerNeedsHelp() {
        return this.getNeededFuel() > 0 || this.getNeededSupplies() > 0;
    }

    protected void cargoPodsScam() {
        Misc.adjustRep(REP_SCAM, RepLevel.INHOSPITABLE, this.fleet.getFaction().getId(), REP_SCAM, RepLevel.INHOSPITABLE, this.person, this.text);
        this.unrespond();
    }

    protected boolean isCargoPodsScam() {
        for (SectorEntityToken entity : this.fleet.getContainingLocation().getAllEntities()) {
            SectorEntityToken.VisibilityLevel level;
            if (!"cargo_pods".equals(entity.getCustomEntityType()) || (level = entity.getVisibilityLevelTo(this.fleet)) != SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS && level != SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || !(entity.getCargo().getFuel() >= 10.0f) && !(entity.getCargo().getSupplies() >= 10.0f)) continue;
            return true;
        }
        return false;
    }

    protected int getNeededFuel() {
        return DistressResponse.getNeededFuel(this.playerFleet);
    }

    public static int getNeededFuel(CampaignFleetAPI playerFleet) {
        float returnDistLY = Misc.getDistanceLY(new Vector2f(), playerFleet.getLocationInHyperspace());
        int fuel = (int)(returnDistLY * Math.max(1.0f, playerFleet.getLogistics().getFuelCostPerLightYear()));
        if ((fuel = (int)((float)fuel * 0.75f)) < 10) {
            fuel = 10;
        }
        if ((fuel = (int)((float)fuel - playerFleet.getCargo().getFuel())) < 0) {
            fuel = 0;
        }
        return fuel;
    }

    protected int getNeededSupplies() {
        float supplies = 0.0f;
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            supplies += member.getStats().getSuppliesPerMonth().getModifiedValue();
        }
        if (supplies < 5.0f) {
            supplies = 5.0f;
        }
        if ((supplies -= this.playerCargo.getSupplies()) < 0.0f) {
            supplies = 0.0f;
        }
        return (int)supplies;
    }

    protected float getRepPenalty() {
        float uses = this.getNumUses();
        return REP_PER_USE * (uses + 1.0f);
    }

    protected void didNotNeedHelp() {
        float penalty = this.getRepPenalty();
        Misc.adjustRep(penalty, RepLevel.INHOSPITABLE, this.fleet.getFaction().getId(), penalty * 2.0f, RepLevel.INHOSPITABLE, this.person, this.text);
        this.unrespond();
    }

    protected void neverMind() {
        float penalty = this.getRepPenalty();
        Misc.adjustRep(penalty * 0.5f, RepLevel.INHOSPITABLE, this.fleet.getFaction().getId(), penalty, RepLevel.INHOSPITABLE, this.person, this.text);
    }

    protected int getMaxFuel() {
        return (int)Math.max(10.0f, this.fleet.getCargo().getMaxFuel() * 0.25f);
    }

    protected int getMaxSupplies() {
        return (int)Math.max(10.0f, this.fleet.getCargo().getMaxCapacity() * 0.1f);
    }

    protected void pay() {
        int credits = (int)this.person.getMemoryWithoutUpdate().getFloat("$distressPayment");
        this.playerCargo.getCredits().subtract(credits);
        AddRemoveCommodity.addCreditsLossText(credits, this.text);
        float uses = this.getNumUses();
        if (uses <= 4.0f) {
            Misc.adjustRep(0.01f, RepLevel.WELCOMING, this.fleet.getFaction().getId(), 0.02f, RepLevel.WELCOMING, this.person, this.text);
        }
    }

    protected void thank() {
        float penalty = this.getRepPenalty();
        Misc.adjustRep(penalty, RepLevel.INHOSPITABLE, this.fleet.getFaction().getId(), penalty * 2.0f, RepLevel.INHOSPITABLE, this.person, this.text);
    }

    protected void acceptAid() {
        int fuel = this.getNeededFuel();
        int supplies = this.getNeededSupplies();
        int maxFuel = this.getMaxFuel();
        int maxSupplies = this.getMaxSupplies();
        if (fuel > maxFuel) {
            fuel = maxFuel;
        }
        if (supplies > maxSupplies) {
            supplies = maxSupplies;
        }
        if (fuel > 0) {
            this.playerCargo.addFuel(fuel);
            AddRemoveCommodity.addCommodityGainText("fuel", fuel, this.text);
        }
        if (supplies > 0) {
            this.playerCargo.addSupplies(supplies);
            AddRemoveCommodity.addCommodityGainText("supplies", supplies, this.text);
        }
        this.unrespond();
    }

    protected void unrespond() {
        Misc.clearTarget(this.fleet, true);
        Misc.makeUnimportant(this.fleet, "distressResponse");
        this.fleet.getMemoryWithoutUpdate().unset("$distressResponse");
        Misc.giveStandardReturnToSourceAssignments(this.fleet);
    }
}

