/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.GroundRaidTargetPickerDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.GroundRaidObjectivesListener;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.impl.campaign.graid.DisruptIndustryRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivTracker;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class MarketCMD
extends BaseCommandPlugin {
    public static int HOSTILE_ACTIONS_TIMEOUT_DAYS = 60;
    public static int TACTICAL_BOMBARD_TIMEOUT_DAYS = 120;
    public static int SATURATION_BOMBARD_TIMEOUT_DAYS = 365;
    public static int MIN_MARINE_TOKENS = 1;
    public static float RE_PER_MARINE_TOKEN = 0.1f;
    public static int MAX_MARINE_TOKENS = 10;
    public static float LOSS_REDUCTION_PER_RESERVE_TOKEN = 0.05f;
    public static float LOSS_INCREASE_PER_RAID = 0.5f;
    public static float MAX_MARINE_LOSSES = 0.8f;
    public static float MIN_RE_TO_REDUCE_MARINE_LOSSES = 0.5f;
    public static float MAX_MARINE_LOSS_REDUCTION_MULT = 0.05f;
    public static float ECON_IMPACT_MULT = 1.0f;
    public static float QUANTITY_MULT_NORMAL = 1.0f;
    public static float QUANTITY_MULT_EXCESS = 2.0f;
    public static float QUANTITY_MULT_DEFICIT = -0.5f;
    public static float QUANTITY_MULT_OVERALL = 0.1f;
    public static String ENGAGE = "mktEngage";
    public static String RAID = "mktRaid";
    public static String RAID_NON_MARKET = "mktRaidNonMarket";
    public static String RAID_VALUABLE = "mktRaidValuable";
    public static String RAID_DISRUPT = "mktRaidDisrupt";
    public static String RAID_GO_BACK = "mktRaidGoBack";
    public static String RAID_CONFIRM_CONTINUE = "mktRaidConfirmContinue";
    public static String RAID_CONFIRM = "mktRaidConfirm";
    public static String RAID_CONFIRM_STORY = "mktRaidConfirmStory";
    public static String RAID_NEVER_MIND = "mktRaidNeverMind";
    public static String RAID_RESULT = "mktRaidResult";
    public static String INVADE = "mktInvade";
    public static String GO_BACK = "mktGoBack";
    public static String BOMBARD = "mktBombard";
    public static String BOMBARD_TACTICAL = "mktBombardTactical";
    public static String BOMBARD_SATURATION = "mktBombardSaturation";
    public static String BOMBARD_CONFIRM = "mktBombardConfirm";
    public static String BOMBARD_NEVERMIND = "mktBombardNeverMind";
    public static String BOMBARD_RESULT = "mktBombardResult";
    public static String DEBT_RESULT_CONTINUE = "marketCmd_checkDebtContinue";
    public static float DISRUPTION_THRESHOLD = 0.25f;
    public static float VALUABLES_THRESHOLD = 0.05f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected MarketAPI market;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected FactionAPI faction;
    protected TempData temp = new TempData();
    public static float MARINES_IN_MARKET_CARGO_DEFENSE_BONUS = 1.0f;
    public static final String DEFENDER_INCREASE_KEY = "$core_defenderIncrease";

    public MarketCMD() {
    }

    protected void clearTemp() {
        if (this.temp != null) {
            this.temp.raidType = null;
            this.temp.bombardType = null;
            this.temp.raidLoot = null;
            this.temp.target = null;
            this.temp.willBecomeHostile.clear();
            this.temp.bombardmentTargets.clear();
            this.temp.objectives.clear();
            this.temp.contText = null;
            this.temp.raidGoBackTrigger = null;
            this.temp.raidContinueTrigger = null;
        }
    }

    public MarketCMD(SectorEntityToken entity) {
        this.init(entity);
    }

    protected void init(SectorEntityToken entity) {
        this.memory = entity.getMemoryWithoutUpdate();
        this.entity = entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = entity.getFaction();
        this.faction = entity.getFaction();
        this.market = entity.getMarket();
        String key = "$MarketCMD_temp";
        MemoryAPI mem = null;
        mem = this.market != null ? this.market.getMemoryWithoutUpdate() : entity.getMemoryWithoutUpdate();
        if (mem.contains(key)) {
            this.temp = (TempData)mem.get(key);
        } else {
            mem.set(key, this.temp, 0.0f);
        }
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.entity = dialog.getInteractionTarget();
        this.init(this.entity);
        this.memory = MarketCMD.getEntityMemory(memoryMap);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        if (command.equals("showDefenses")) {
            this.clearTemp();
            this.showDefenses(true);
        } else if (command.equals("goBackToDefenses")) {
            if (this.temp.nonMarket) {
                String trigger = this.temp.raidGoBackTrigger;
                if (trigger == null || trigger.isEmpty()) {
                    trigger = "PopulateOptions";
                }
                this.clearTemp();
                FireAll.fire(null, dialog, memoryMap, trigger);
                return true;
            }
            this.clearTemp();
            this.showDefenses(true);
        } else if (command.equals("engage")) {
            this.engage();
        } else if (command.equals("raidMenu")) {
            this.raidMenu();
        } else if (command.equals("raidNonMarket")) {
            this.raidNonMarket();
        } else if (command.equals("raidValuable")) {
            this.raidValuable();
        } else if (command.equals("raidDisrupt")) {
            this.raidDisrupt();
        } else if (command.equals("raidConfirm")) {
            this.raidConfirm(false);
        } else if (command.equals("raidConfirmContinue")) {
            this.raidConfirmContinue();
        } else if (command.equals("raidNeverMind")) {
            this.raidNeverMind();
        } else if (command.equals("addContinueToRaidResultOption")) {
            this.addContinueOption(this.temp.contText);
        } else if (command.equals("raidResult")) {
            this.raidResult();
        } else if (command.equals("bombardMenu")) {
            this.bombardMenu();
        } else if (command.equals("bombardTactical")) {
            this.bombardTactical();
        } else if (command.equals("bombardSaturation")) {
            this.bombardSaturation();
        } else if (command.equals("bombardConfirm")) {
            this.bombardConfirm();
        } else if (command.equals("bombardNeverMind")) {
            this.bombardNeverMind();
        } else if (command.equals("bombardResult")) {
            this.bombardResult();
        } else {
            if (command.equals("checkDebtEffect")) {
                return this.checkDebtEffect();
            }
            if (command.equals("applyDebtEffect")) {
                this.applyDebtEffect();
            } else {
                if (command.equals("checkMercsLeaving")) {
                    return this.checkMercsLeaving();
                }
                if (command.equals("convinceMercToStay")) {
                    this.convinceMercToStay();
                } else if (command.equals("mercLeaves")) {
                    this.mercLeaves();
                } else if (command.equals("assistVolturnInsurgents")) {
                    MarketAPI volturn = Global.getSector().getEconomy().getMarket("volturn");
                    RecentUnrest.get(volturn).add(2, "The Luddic insurgency acquired unusually heavy weaponry somehow");
                }
            }
        }
        return true;
    }

    protected void showDefenses(boolean withText) {
        FleetMemberAPI flagship;
        CampaignFleetAPI primary = this.getInteractionTargetForFIDPI();
        CampaignFleetAPI station = this.getStationFleet();
        boolean hasNonStation = false;
        boolean hasOtherButInsignificant = true;
        boolean hasStation = station != null;
        boolean otherWantsToFight = false;
        BattleAPI b = null;
        FleetEncounterContext context = null;
        FleetInteractionDialogPluginImpl plugin = null;
        boolean ongoingBattle = false;
        boolean playerOnDefenderSide = false;
        boolean playerCanNotJoin = false;
        String stationType = "station";
        if (station != null && (flagship = station.getFlagship()) != null && flagship.getVariant() != null) {
            String name;
            stationType = name = flagship.getVariant().getDesignation().toLowerCase();
        }
        StationState state = this.getStationState();
        if (this.market != null) {
            Global.getSector().getEconomy().tripleStep();
        }
        if (primary == null) {
            if (state == StationState.NONE) {
                this.text.addPara("The colony has no orbital station or nearby fleets to defend it.");
            } else {
                this.printStationState();
                this.text.addPara("There are no nearby fleets to defend the colony.");
            }
        } else {
            ongoingBattle = primary.getBattle() != null;
            CampaignFleetAPI pluginFleet = primary;
            if (ongoingBattle) {
                BattleAPI.BattleSide playerSide = primary.getBattle().pickSide(this.playerFleet);
                CampaignFleetAPI other = primary.getBattle().getPrimary(primary.getBattle().getOtherSide(playerSide));
                if (other != null) {
                    pluginFleet = other;
                }
            }
            FleetInteractionDialogPluginImpl.FIDConfig params = new FleetInteractionDialogPluginImpl.FIDConfig();
            params.justShowFleets = true;
            params.showPullInText = withText;
            plugin = new FleetInteractionDialogPluginImpl(params);
            this.dialog.setInteractionTarget(pluginFleet);
            plugin.init(this.dialog);
            this.dialog.setInteractionTarget(this.entity);
            context = (FleetEncounterContext)plugin.getContext();
            b = context.getBattle();
            BattleAPI.BattleSide playerSide = b.pickSide(this.playerFleet);
            if (playerSide != BattleAPI.BattleSide.NO_JOIN && b.getOtherSideCombined(playerSide).isEmpty()) {
                playerSide = BattleAPI.BattleSide.NO_JOIN;
            }
            boolean bl = playerCanNotJoin = playerSide == BattleAPI.BattleSide.NO_JOIN;
            if (!playerCanNotJoin) {
                boolean bl2 = playerOnDefenderSide = b.getSide(playerSide) == b.getSideFor(primary);
            }
            if (!ongoingBattle) {
                playerOnDefenderSide = false;
            }
            boolean otherHasStation = false;
            if (playerSide != BattleAPI.BattleSide.NO_JOIN) {
                if (station != null) {
                    for (CampaignFleetAPI fleet : b.getSideFor(station)) {
                        if (fleet.isStationMode()) continue;
                        hasNonStation = true;
                        hasOtherButInsignificant &= Misc.isInsignificant(fleet);
                    }
                } else if (b.getNonPlayerSide() != null) {
                    for (CampaignFleetAPI fleet : b.getNonPlayerSide()) {
                        if (fleet.isStationMode()) continue;
                        hasNonStation = true;
                        hasOtherButInsignificant &= Misc.isInsignificant(fleet);
                    }
                } else {
                    hasNonStation = true;
                }
                for (CampaignFleetAPI fleet : b.getOtherSide(playerSide)) {
                    if (!fleet.isStationMode()) continue;
                    otherHasStation = true;
                }
            }
            if (!hasNonStation) {
                hasOtherButInsignificant = false;
            }
            boolean bl3 = otherWantsToFight = otherHasStation || plugin.otherFleetWantsToFight(true);
            if (withText) {
                if (hasStation) {
                    FleetMemberAPI flagship2;
                    String name = "An orbital station";
                    if (station != null && (flagship2 = station.getFlagship()) != null) {
                        stationType = name = flagship2.getVariant().getDesignation().toLowerCase();
                        name = String.valueOf(Misc.ucFirst(station.getFaction().getPersonNamePrefixAOrAn())) + " " + station.getFaction().getPersonNamePrefix() + " " + name;
                    }
                    this.text.addPara(String.valueOf(name) + " dominates the orbit and prevents any " + "hostile action, aside from a quick raid, unless it is dealt with.");
                    if (hasNonStation) {
                        if (ongoingBattle) {
                            this.text.addPara("There are defending ships present, but they are currently involved in a battle, and you could take advantage of the distraction to launch a raid.");
                        } else if (hasOtherButInsignificant) {
                            this.text.addPara("Defending ships are present, but not in sufficient strength to want to give battle or prevent any hostile action you might take.");
                        } else {
                            this.text.addPara("The defending ships present are, with the support of the station, sufficient to prevent raiding as well.");
                        }
                    }
                } else if (hasNonStation && otherWantsToFight) {
                    this.printStationState();
                    this.text.addPara("Defending ships are present in sufficient strength to prevent any hostile action until they are dealt with.");
                } else if (hasNonStation && !otherWantsToFight) {
                    this.printStationState();
                    this.text.addPara("Defending ships are present, but not in sufficient strength to want to give battle or prevent any hostile action you might take.");
                }
                plugin.printOngoingBattleInfo();
            }
        }
        if (!hasNonStation) {
            hasOtherButInsignificant = false;
        }
        this.options.clearOptions();
        String engageText = "Engage the defenders";
        engageText = playerCanNotJoin ? "Engage the defenders" : (playerOnDefenderSide ? (hasStation && hasNonStation ? "Aid the " + stationType + " and its defenders" : (hasStation ? "Aid the " + stationType : "Aid the defenders")) : (ongoingBattle ? "Aid the attacking forces" : (hasStation && hasNonStation ? "Engage the " + stationType + " and its defenders" : (hasStation ? "Engage the " + stationType : "Engage the defenders"))));
        this.options.addOption(engageText, ENGAGE);
        this.temp.secret = false;
        this.temp.canRaid = ongoingBattle || hasOtherButInsignificant || hasNonStation && !otherWantsToFight || !hasNonStation;
        this.temp.canBombard = (hasOtherButInsignificant || hasNonStation && !otherWantsToFight || !hasNonStation) && !hasStation;
        boolean couldRaidIfNotDebug = this.temp.canRaid;
        if (DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            if (!this.temp.canRaid || !this.temp.canBombard) {
                this.text.addPara("(DEBUG mode: can raid and bombard anyway)");
            }
            this.temp.canRaid = true;
            this.temp.canBombard = true;
        }
        this.options.addOption("Launch a raid against " + this.market.getName(), RAID);
        this.options.addOption("Consider an orbital bombardment of " + this.market.getName(), BOMBARD);
        if (!this.temp.canRaid) {
            this.options.setEnabled(RAID, false);
            this.options.setTooltip(RAID, "The presence of enemy fleets that are willing to offer battle makes a raid impossible.");
        }
        if (!this.temp.canBombard) {
            this.options.setEnabled(BOMBARD, false);
            this.options.setTooltip(BOMBARD, "All defenses must be defeated to make a bombardment possible.");
        }
        if (this.temp.canRaid && this.getRaidCooldown() > 0.0f) {
            if (!DebugFlags.MARKET_HOSTILITIES_DEBUG) {
                this.options.setEnabled(RAID, false);
                this.text.addPara("Your forces will be able to organize another raid within a day or so.");
                this.temp.canRaid = false;
            } else {
                this.text.addPara("Your forces will be able to organize another raid within a day or so.");
                this.text.addPara("(DEBUG mode: can do it anyway)");
            }
        }
        if (context != null && otherWantsToFight && !playerCanNotJoin) {
            boolean knows = context.getBattle() != null && context.getBattle().getNonPlayerSide() != null && context.getBattle().knowsWhoPlayerIs(context.getBattle().getNonPlayerSide());
            boolean lowImpact = context.isLowRepImpact();
            FactionAPI nonHostile = plugin.getNonHostileOtherFaction();
            if (nonHostile != null && knows && !lowImpact && !context.isEngagedInHostilities()) {
                this.options.addOptionConfirmation(ENGAGE, "The " + nonHostile.getDisplayNameLong() + " " + nonHostile.getDisplayNameIsOrAre() + " not currently hostile, and you have been positively identified. " + "Are you sure you want to engage in open hostilities?", "Yes", "Never mind");
            }
        } else if (context == null || playerCanNotJoin || !otherWantsToFight) {
            this.options.setEnabled(ENGAGE, false);
            if (!otherWantsToFight) {
                if (ongoingBattle && playerOnDefenderSide && !otherWantsToFight) {
                    this.options.setTooltip(ENGAGE, "The attackers are in disarray and not currently attempting to engage the station.");
                } else if (playerCanNotJoin) {
                    this.options.setTooltip(ENGAGE, "You're unable to join this battle.");
                } else if (primary == null) {
                    this.options.setTooltip(ENGAGE, "There are no defenders to engage.");
                } else {
                    this.options.setTooltip(ENGAGE, "The defenders are refusing to give battle to defend the colony.");
                }
            }
        }
        this.options.addOption("Go back", GO_BACK);
        this.options.setShortcut(GO_BACK, 1, false, false, false, true);
        if (plugin != null) {
            plugin.cleanUpBattle();
        }
    }

    public static float getRaidStr(CampaignFleetAPI fleet) {
        float attackerStr = fleet.getCargo().getMaxPersonnel() * 0.25f;
        float support = Misc.getFleetwideTotalMod(fleet, "ground_support", 0.0f);
        attackerStr += Math.min(support, attackerStr);
        StatBonus stat = fleet.getStats().getDynamic().getMod("ground_attack_mod");
        attackerStr = stat.computeEffective(attackerStr);
        return attackerStr;
    }

    public static float getDefenderStr(MarketAPI market) {
        return MarketCMD.getDefenderStr(market, false);
    }

    public static float getDefenderStr(MarketAPI market, boolean forBombard) {
        StatBonus stat = market.getStats().getDynamic().getMod("ground_defenses_mod");
        float defenderStr = Math.round(stat.computeEffective(0.0f));
        float added = MarketCMD.getDefenderIncreaseValue(market);
        defenderStr += added;
        if (market.isPlayerOwned() && !forBombard) {
            float marineDefenseValueMult = MARINES_IN_MARKET_CARGO_DEFENSE_BONUS;
            CargoAPI cargo = Misc.getStorageCargo(market);
            if (cargo != null) {
                defenderStr += (float)cargo.getMarines() * marineDefenseValueMult;
            }
            if ((cargo = Misc.getLocalResourcesCargo(market)) != null) {
                defenderStr += (float)cargo.getMarines() * marineDefenseValueMult;
            }
        }
        return defenderStr;
    }

    public static float getRaidEffectiveness(MarketAPI market, CampaignFleetAPI fleet) {
        return MarketCMD.getRaidEffectiveness(market, MarketCMD.getRaidStr(fleet));
    }

    public static float getRaidEffectiveness(MarketAPI market, float attackerStr) {
        float defenderStr = MarketCMD.getDefenderStr(market);
        return attackerStr / Math.max(1.0f, attackerStr + defenderStr);
    }

    public static int getMarinesFor(MarketAPI market, int tokens) {
        float defenderStr = MarketCMD.getDefenderStr(market);
        return MarketCMD.getMarinesFor((int)defenderStr, tokens);
    }

    public static int getMarinesFor(int defenderStrength, int tokens) {
        int marines = Math.round((float)tokens * RE_PER_MARINE_TOKEN * (float)defenderStrength / (1.0f - (float)tokens * RE_PER_MARINE_TOKEN));
        return marines;
    }

    public static int getDisruptDaysPerToken(MarketAPI market, Industry industry) {
        DisruptIndustryRaidObjectivePluginImpl obj = new DisruptIndustryRaidObjectivePluginImpl(market, industry);
        return Math.round(obj.getBaseDisruptDuration(1));
    }

    protected void raidNonMarket() {
        float width = 350.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        this.temp.nonMarket = true;
        float difficulty = this.memory.getFloat("$raidDifficulty");
        this.temp.raidGoBackTrigger = this.memory.getString("$raidGoBackTrigger");
        this.temp.raidContinueTrigger = this.memory.getString("$raidContinueTrigger");
        this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_prepare", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        float marines = this.playerFleet.getCargo().getMarines();
        float support = Misc.getFleetwideTotalMod(this.playerFleet, "ground_support", 0.0f);
        if (support > marines) {
            support = marines;
        }
        StatBonus attackerBase = new StatBonus();
        StatBonus defenderBase = new StatBonus();
        attackerBase.modifyFlatAlways("core_marines", marines, "Marines on board");
        attackerBase.modifyFlatAlways("core_support", support, "Fleet capability for ground support");
        StatBonus attacker = this.playerFleet.getStats().getDynamic().getMod("ground_attack_mod");
        StatBonus defender = new StatBonus();
        if (this.market != null && difficulty <= 0.0f) {
            defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        }
        defender.modifyFlat("difficulty", difficulty, "Expected resistance");
        String surpriseKey = "core_surprise";
        String increasedDefensesKey = "core_addedDefStr";
        float added = 0.0f;
        if (this.market != null) {
            added = MarketCMD.getDefenderIncreaseValue(this.market);
        }
        if (added > 0.0f) {
            defender.modifyFlat(increasedDefensesKey, added, "Increased defender preparedness");
        }
        float attackerStr = Math.round(attacker.computeEffective(attackerBase.computeEffective(0.0f)));
        float defenderStr = Math.round(defender.computeEffective(defenderBase.computeEffective(0.0f)));
        this.temp.attackerStr = attackerStr;
        this.temp.defenderStr = defenderStr;
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        String has = this.faction.getDisplayNameHasOrHave();
        String is = this.faction.getDisplayNameIsOrAre();
        boolean hostile = this.faction.isHostileTo("player");
        boolean tOn = this.playerFleet.isTransponderOn();
        float initPad = 0.0f;
        if (!hostile && !this.faction.isNeutralFaction()) {
            if (tOn) {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + " not currently hostile. Your fleet's transponder is on, and carrying out a raid " + "will result in open hostilities.", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + " not currently hostile. Your fleet's transponder is off, and carrying out a raid " + "will only result in a minor penalty to your standing.", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            }
            initPad = opad;
        }
        float sep = small;
        sep = 3.0f;
        info.addPara("Raid strength: %s", initPad, h, "" + (int)attackerStr);
        info.addStatModGrid(width, 50.0f, opad, small, attackerBase, true, MarketCMD.statPrinter(false));
        if (!attacker.isUnmodified()) {
            info.addStatModGrid(width, 50.0f, opad, sep, attacker, true, MarketCMD.statPrinter(true));
        }
        info.addPara("Operation difficulty: %s", opad, h, "" + (int)defenderStr);
        info.addStatModGrid(width, 50.0f, opad, small, defender, true, MarketCMD.statPrinter(true));
        defender.unmodifyFlat(increasedDefensesKey);
        defender.unmodifyMult(surpriseKey);
        attacker.unmodifyMult(surpriseKey);
        this.text.addTooltip();
        boolean hasForces = true;
        this.temp.raidMult = attackerStr / Math.max(1.0f, attackerStr + defenderStr);
        this.temp.raidMult = (float)Math.round(this.temp.raidMult * 100.0f) / 100.0f;
        Color eColor = h;
        if (this.temp.raidMult < DISRUPTION_THRESHOLD && this.temp.raidMult < VALUABLES_THRESHOLD) {
            eColor = Misc.getNegativeHighlightColor();
        }
        this.text.addPara("Projected raid effectiveness: %s", eColor, (int)(this.temp.raidMult * 100.0f) + "%");
        if (this.temp.raidMult < VALUABLES_THRESHOLD) {
            this.text.addPara("You do not have the forces to carry out an effective raid.");
            hasForces = false;
        }
        this.options.clearOptions();
        this.options.addOption("Designate raid objectives", RAID_VALUABLE);
        if (!hasForces) {
            this.options.setEnabled(RAID_VALUABLE, false);
        }
        this.options.addOption("Go back", RAID_GO_BACK);
        this.options.setShortcut(RAID_GO_BACK, 1, false, false, false, true);
    }

    protected void raidMenu() {
        float width = 350.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        this.temp.nonMarket = false;
        this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_prepare", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        float marines = this.playerFleet.getCargo().getMarines();
        float support = Misc.getFleetwideTotalMod(this.playerFleet, "ground_support", 0.0f);
        if (support > marines) {
            support = marines;
        }
        StatBonus attackerBase = new StatBonus();
        StatBonus defenderBase = new StatBonus();
        attackerBase.modifyFlatAlways("core_marines", marines, "Marines on board");
        attackerBase.modifyFlatAlways("core_support", support, "Fleet capability for ground support");
        StatBonus attacker = this.playerFleet.getStats().getDynamic().getMod("ground_attack_mod");
        StatBonus defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        String surpriseKey = "core_surprise";
        String increasedDefensesKey = "core_addedDefStr";
        float added = MarketCMD.getDefenderIncreaseValue(this.market);
        if (added > 0.0f) {
            defender.modifyFlat(increasedDefensesKey, added, "Increased defender preparedness");
        }
        float attackerStr = Math.round(attacker.computeEffective(attackerBase.computeEffective(0.0f)));
        float defenderStr = Math.round(defender.computeEffective(defenderBase.computeEffective(0.0f)));
        this.temp.attackerStr = attackerStr;
        this.temp.defenderStr = defenderStr;
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        String has = this.faction.getDisplayNameHasOrHave();
        String is = this.faction.getDisplayNameIsOrAre();
        boolean hostile = this.faction.isHostileTo("player");
        boolean tOn = this.playerFleet.isTransponderOn();
        float initPad = 0.0f;
        if (!hostile) {
            if (tOn) {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + " not currently hostile. Your fleet's transponder is on, and carrying out a raid " + "will result in open hostilities.", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + " not currently hostile. Your fleet's transponder is off, and carrying out a raid " + "will only result in a minor penalty to your standing.", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            }
            initPad = opad;
        }
        float sep = small;
        sep = 3.0f;
        info.addPara("Raid strength: %s", initPad, h, "" + (int)attackerStr);
        info.addStatModGrid(width, 50.0f, opad, small, attackerBase, true, MarketCMD.statPrinter(false));
        if (!attacker.isUnmodified()) {
            info.addStatModGrid(width, 50.0f, opad, sep, attacker, true, MarketCMD.statPrinter(true));
        }
        info.addPara("Ground defense strength: %s", opad, h, "" + (int)defenderStr);
        info.addStatModGrid(width, 50.0f, opad, small, defender, true, MarketCMD.statPrinter(true));
        defender.unmodifyFlat(increasedDefensesKey);
        defender.unmodifyMult(surpriseKey);
        attacker.unmodifyMult(surpriseKey);
        this.text.addTooltip();
        boolean hasForces = true;
        boolean canDisrupt = true;
        this.temp.raidMult = attackerStr / Math.max(1.0f, attackerStr + defenderStr);
        this.temp.raidMult = (float)Math.round(this.temp.raidMult * 100.0f) / 100.0f;
        Color eColor = h;
        if (this.temp.raidMult < DISRUPTION_THRESHOLD && this.temp.raidMult < VALUABLES_THRESHOLD) {
            eColor = Misc.getNegativeHighlightColor();
        }
        if (this.temp.raidMult < DISRUPTION_THRESHOLD) {
            canDisrupt = false;
        } else {
            float cfr_ignored_0 = this.temp.raidMult;
        }
        this.text.addPara("Projected raid effectiveness: %s", eColor, (int)(this.temp.raidMult * 100.0f) + "%");
        if (!canDisrupt) {
            this.text.addPara("The ground defenses are too strong for your forces to be able to cause long-term disruption.");
        }
        if (this.temp.raidMult < VALUABLES_THRESHOLD) {
            this.text.addPara("You do not have the forces to carry out an effective raid to acquire valuables or achieve other objectives.");
            hasForces = false;
        }
        if (DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            canDisrupt = true;
        }
        this.options.clearOptions();
        this.options.addOption("Try to acquire valuables, such as commodities or blueprints, or achieve other objectives", RAID_VALUABLE);
        this.options.addOption("Disrupt the operations of a specific industry or facility", RAID_DISRUPT);
        if (!hasForces) {
            this.options.setEnabled(RAID_VALUABLE, false);
        }
        if (!hasForces || !canDisrupt) {
            this.options.setEnabled(RAID_DISRUPT, false);
            if (!canDisrupt) {
                String pct = Math.round(DISRUPTION_THRESHOLD * 100.0f) + "%";
                this.options.setTooltip(RAID_DISRUPT, "Requires at least " + pct + " raid effectiveness.");
                this.options.setTooltipHighlights(RAID_DISRUPT, pct);
                this.options.setTooltipHighlightColors(RAID_DISRUPT, h);
            }
        }
        this.options.addOption("Go back", RAID_GO_BACK);
        this.options.setShortcut(RAID_GO_BACK, 1, false, false, false, true);
    }

    protected void raidValuable() {
        this.temp.raidType = RaidType.VALUABLE;
        ArrayList<GroundRaidObjectivePlugin> obj = new ArrayList<GroundRaidObjectivePlugin>();
        final RaidType useType = !this.temp.nonMarket ? this.temp.raidType : RaidType.CUSTOM_ONLY;
        int i = 0;
        while (i < 10) {
            ListenerUtil.modifyRaidObjectives(this.market, this.entity, obj, useType, this.getNumMarineTokens(), i);
            ++i;
        }
        if (obj.isEmpty()) {
            this.text.addPara("After careful consideration, there do not appear to be any targets likely to yield anything of value.");
            this.addNeverMindOption();
            return;
        }
        this.dialog.showGroundRaidTargetPicker("Select raid objectives", "Select", this.market, obj, new GroundRaidTargetPickerDelegate(){

            @Override
            public void pickedGroundRaidTargets(List<GroundRaidObjectivePlugin> data) {
                float value = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    value += (float)curr.getProjectedCreditsValue();
                }
                Color h = Misc.getHighlightColor();
                ArrayList<String> names = new ArrayList<String>();
                for (GroundRaidObjectivePlugin curr : data) {
                    names.add(curr.getNameOverride() != null ? curr.getNameOverride() : curr.getName());
                }
                String list = Misc.getAndJoined(names);
                String item = "objective";
                if (names.size() > 1) {
                    item = "objectives";
                }
                String isOrAre = "are";
                String marinesStr = "marines";
                if (MarketCMD.this.playerCargo.getMarines() == 1) {
                    isOrAre = "is";
                    marinesStr = "marine";
                }
                LabelAPI label = MarketCMD.this.text.addPara("Your marine commander submits a plan for your approval. Losses during this operation are projected to be %s. There " + isOrAre + " a total of %s " + marinesStr + " in your fleet.", this.getMarineLossesColor(data), this.getProjectedMarineLosses(data).toLowerCase(), Misc.getWithDGS(MarketCMD.this.playerCargo.getMarines()));
                label.setHighlightColors(this.getMarineLossesColor(data), Misc.getHighlightColor());
                MarketCMD.this.text.addPara(String.valueOf(Misc.ucFirst(item)) + " targeted: " + list + ".", h, names.toArray(new String[0]));
                if (value > 0.0f) {
                    MarketCMD.this.text.addPara("The estimated value of the items obtained is projected to be around %s.", h, Misc.getDGSCredits(value));
                }
                MarketCMD.this.text.addPara("The marines are ready to go, awaiting your final confirmation.");
                MarketCMD.this.temp.objectives = data;
                MarketCMD.this.addConfirmOptions();
            }

            @Override
            public boolean isDisruptIndustryMode() {
                return false;
            }

            @Override
            public boolean isCustomOnlyMode() {
                return useType == RaidType.CUSTOM_ONLY;
            }

            @Override
            public void cancelledGroundRaidTargetPicking() {
            }

            @Override
            public int getCargoSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getCargoSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getFuelSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getFuelSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getProjectedCreditsValue(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getProjectedCreditsValue();
                }
                return (int)total;
            }

            @Override
            public int getNumMarineTokens() {
                return MarketCMD.this.getNumMarineTokens();
            }

            @Override
            public MutableStat getMarineLossesStat(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getMarineLossesStat(data);
            }

            @Override
            public String getProjectedMarineLosses(List<GroundRaidObjectivePlugin> data) {
                float marines = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, marines);
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (level == RaidDangerLevel.NONE) {
                        test = RaidDangerLevel.NONE.marineLossesMult;
                    }
                    if (test >= f) {
                        return level.lossesName;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.lossesName;
            }

            @Override
            public float getAverageMarineLosses(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getAverageMarineLosses(data);
            }

            @Override
            public Color getMarineLossesColor(List<GroundRaidObjectivePlugin> data) {
                float marines = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, marines);
                if (f <= 0.0f && data.isEmpty()) {
                    return Misc.getGrayColor();
                }
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (test >= f) {
                        return level.color;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.color;
            }

            @Override
            public String getRaidEffectiveness() {
                return (int)(MarketCMD.this.temp.raidMult * 100.0f) + "%";
            }
        });
    }

    protected void addBombardConfirmOptions() {
        this.options.clearOptions();
        this.options.addOption("Launch bombardment", BOMBARD_CONFIRM);
        this.options.addOption("Never mind", BOMBARD_NEVERMIND);
        this.options.setShortcut(BOMBARD_NEVERMIND, 1, false, false, false, true);
        ArrayList<FactionAPI> nonHostile = new ArrayList<FactionAPI>();
        for (FactionAPI faction : this.temp.willBecomeHostile) {
            boolean hostile = faction.isHostileTo("player");
            if (hostile) continue;
            nonHostile.add(faction);
        }
        if (nonHostile.size() == 1) {
            FactionAPI faction;
            faction = (FactionAPI)nonHostile.get(0);
            this.options.addOptionConfirmation(BOMBARD_CONFIRM, "The " + faction.getDisplayNameLong() + " " + faction.getDisplayNameIsOrAre() + " not currently hostile, and will become hostile if you carry out the bombardment. " + "Are you sure?", "Yes", "Never mind");
        } else if (nonHostile.size() > 1) {
            this.options.addOptionConfirmation(BOMBARD_CONFIRM, "Multiple factions that are not currently hostile will become hostile if you carry out the bombardment. Are you sure?", "Yes", "Never mind");
        }
    }

    protected void raidDisrupt() {
        this.temp.raidType = RaidType.DISRUPT;
        ArrayList<GroundRaidObjectivePlugin> obj = new ArrayList<GroundRaidObjectivePlugin>();
        int i = 0;
        while (i < 10) {
            ListenerUtil.modifyRaidObjectives(this.market, this.entity, obj, this.temp.raidType, this.getNumMarineTokens(), i);
            ++i;
        }
        if (obj.isEmpty()) {
            this.text.addPara("There are no industries or facilities present that could be disrupted by a raid.");
            this.addNeverMindOption();
            return;
        }
        this.dialog.showGroundRaidTargetPicker("Select raid objectives", "Select", this.market, obj, new GroundRaidTargetPickerDelegate(){

            @Override
            public void pickedGroundRaidTargets(List<GroundRaidObjectivePlugin> data) {
                float value = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    value += (float)curr.getProjectedCreditsValue();
                }
                Color h = Misc.getHighlightColor();
                ArrayList<String> names = new ArrayList<String>();
                for (GroundRaidObjectivePlugin curr : data) {
                    names.add(curr.getNameOverride() != null ? curr.getNameOverride() : curr.getName());
                }
                String list = Misc.getAndJoined(names);
                String item = "objective";
                if (names.size() > 1) {
                    item = "objectives";
                }
                MarketCMD.this.text.addPara("Your marine commander submits a plan for your approval. Losses during this operation are projected to be %s.", this.getMarineLossesColor(data), this.getProjectedMarineLosses(data).toLowerCase());
                MarketCMD.this.text.addPara(String.valueOf(Misc.ucFirst(item)) + " targeted: " + list + ".", h, names.toArray(new String[0]));
                if (value > 0.0f) {
                    MarketCMD.this.text.addPara("The estimated value of the items obtained is projected to be around %s.", h, Misc.getDGSCredits(value));
                }
                MarketCMD.this.text.addPara("The marines are ready to go, awaiting your final confirmation. There are a total of %s marines in your fleet.", Misc.getHighlightColor(), Misc.getWithDGS(MarketCMD.this.playerCargo.getMarines()));
                MarketCMD.this.temp.objectives = data;
                MarketCMD.this.addConfirmOptions();
            }

            @Override
            public boolean isDisruptIndustryMode() {
                return true;
            }

            @Override
            public void cancelledGroundRaidTargetPicking() {
            }

            @Override
            public int getCargoSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getCargoSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getFuelSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getFuelSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getProjectedCreditsValue(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getProjectedCreditsValue();
                }
                return (int)total;
            }

            @Override
            public int getNumMarineTokens() {
                return MarketCMD.this.getNumMarineTokens();
            }

            @Override
            public MutableStat getMarineLossesStat(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getMarineLossesStat(data);
            }

            @Override
            public String getProjectedMarineLosses(List<GroundRaidObjectivePlugin> data) {
                float marines = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, marines);
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (level == RaidDangerLevel.NONE) {
                        test = RaidDangerLevel.NONE.marineLossesMult;
                    }
                    if (test >= f) {
                        return level.lossesName;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.lossesName;
            }

            @Override
            public float getAverageMarineLosses(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getAverageMarineLosses(data);
            }

            @Override
            public Color getMarineLossesColor(List<GroundRaidObjectivePlugin> data) {
                float marines = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, marines);
                if (f <= 0.0f) {
                    return Misc.getGrayColor();
                }
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (test >= f) {
                        return level.color;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.color;
            }

            @Override
            public String getRaidEffectiveness() {
                return (int)(MarketCMD.this.temp.raidMult * 100.0f) + "%";
            }

            @Override
            public boolean isCustomOnlyMode() {
                return false;
            }
        });
    }

    protected float computeBaseDisruptDuration(Industry ind) {
        float dur = (float)this.getNumMarineTokens() * ind.getSpec().getDisruptDanger().disruptionDays - ind.getDisruptedDays();
        return (int)dur;
    }

    public static int getBombardDestroyThreshold() {
        return Global.getSettings().getInt("bombardSaturationDestroySize");
    }

    public static int getBombardDisruptDuration() {
        float dur = Global.getSettings().getFloat("bombardDisruptDuration");
        return (int)dur;
    }

    protected void raidDisruptIndustryPicked(Industry target) {
        this.temp.target = target;
        this.text.addParagraph("Target: " + target.getCurrentName(), Global.getSettings().getColor("buttonText"));
        float dur = this.computeBaseDisruptDuration(target);
        Color h = Misc.getHighlightColor();
        float already = target.getDisruptedDays();
        if (already > 0.0f) {
            this.text.addPara(String.valueOf(target.getNameForModifier()) + " operations are already disrupted, and a raid will have " + "reduced effect.");
        }
        this.text.addPara("Your ground forces commander estimates that given the relative force strengths,  the raid should disrupt all " + target.getCurrentName() + " operations for at least %s days.", h, "" + (int)Misc.getRounded(dur));
        this.text.addPara("Your forces are ready to go, awaiting your final confirmation.");
        this.options.clearOptions();
        this.addConfirmOptions();
    }

    protected void addNeverMindOption() {
        this.options.clearOptions();
        this.options.addOption("Never mind", RAID_NEVER_MIND);
        this.options.setShortcut(RAID_NEVER_MIND, 1, false, false, false, true);
    }

    protected void addBombardNeverMindOption() {
        this.options.clearOptions();
        this.options.addOption("Never mind", BOMBARD_NEVERMIND);
        this.options.setShortcut(BOMBARD_NEVERMIND, 1, false, false, false, true);
    }

    protected void addContinueOption() {
        this.addContinueOption(null);
    }

    protected void addContinueOption(String text) {
        if (text == null) {
            text = "Continue";
        }
        this.options.clearOptions();
        this.options.addOption(text, RAID_RESULT);
    }

    public static float getDefenderIncreaseRaw(MarketAPI market) {
        if (market == null) {
            return 0.0f;
        }
        float e = market.getMemoryWithoutUpdate().getExpire(DEFENDER_INCREASE_KEY);
        if (e < 0.0f) {
            e = 0.0f;
        }
        return e;
    }

    public static void applyDefenderIncreaseFromRaid(MarketAPI market) {
        float max;
        float e = market.getMemoryWithoutUpdate().getExpire(DEFENDER_INCREASE_KEY);
        if (e < 0.0f) {
            e = 0.0f;
        }
        if ((e += MarketCMD.getRaidDefenderIncreasePerRaid()) > (max = MarketCMD.getRaidDefenderIncreaseMax())) {
            e = max;
        }
        market.getMemoryWithoutUpdate().set(DEFENDER_INCREASE_KEY, true);
        market.getMemoryWithoutUpdate().expire(DEFENDER_INCREASE_KEY, e);
    }

    public static float getDefenderIncreaseValue(MarketAPI market) {
        float e = MarketCMD.getDefenderIncreaseRaw(market);
        float f = MarketCMD.getRaidDefenderIncreaseFraction();
        float min = MarketCMD.getRaidDefenderIncreaseMin();
        float base = PopulationAndInfrastructure.getBaseGroundDefenses(market.getSize());
        float incr = Math.max(base * f, min);
        float per = MarketCMD.getRaidDefenderIncreasePerRaid();
        return (int)(incr * e / per);
    }

    protected static float getRaidDefenderIncreasePerRaid() {
        return Global.getSettings().getFloat("raidDefenderIncreasePerRaid");
    }

    protected static float getRaidDefenderIncreaseMax() {
        return Global.getSettings().getFloat("raidDefenderIncreaseMax");
    }

    protected static float getRaidDefenderIncreaseFraction() {
        return Global.getSettings().getFloat("raidDefenderIncreaseFraction");
    }

    protected static float getRaidDefenderIncreaseMin() {
        return Global.getSettings().getFloat("raidDefenderIncreaseMin");
    }

    protected float getRaidCooldownMax() {
        return Global.getSettings().getFloat("raidCooldownDays");
    }

    protected void setRaidCooldown(float cooldown) {
        String key = "$raid_cooldown";
        Global.getSector().getMemoryWithoutUpdate().set(key, true, cooldown);
    }

    protected float getRaidCooldown() {
        String key = "$raid_cooldown";
        return Global.getSector().getMemoryWithoutUpdate().getExpire(key);
    }

    protected Random getRandom() {
        String key = "$raid_random";
        MemoryAPI mem = null;
        SectorEntityToken entity = null;
        if (this.market != null) {
            mem = this.market.getMemoryWithoutUpdate();
            entity = this.market.getPrimaryEntity();
        } else {
            entity = this.entity;
            mem = entity.getMemoryWithoutUpdate();
        }
        Random random = null;
        if (mem.contains(key)) {
            random = (Random)mem.get(key);
        } else if (entity != null) {
            long seed = Misc.getSalvageSeed(entity);
            seed /= 321L;
            random = new Random(seed *= (long)(Global.getSector().getClock().getMonth() + 10));
        } else {
            random = new Random();
        }
        mem.set(key, random, 30.0f);
        return random;
    }

    public int getNumMarineTokens() {
        int num = Math.round(this.temp.raidMult / RE_PER_MARINE_TOKEN);
        if (num < MIN_MARINE_TOKENS) {
            num = MIN_MARINE_TOKENS;
        }
        if (num > MAX_MARINE_TOKENS) {
            num = MAX_MARINE_TOKENS;
        }
        return num;
    }

    protected MutableStat getMarineLossesStat(List<GroundRaidObjectivePlugin> data) {
        MutableStat stat = new MutableStat(1.0f);
        float total = 0.0f;
        float assignedTokens = 0.0f;
        for (GroundRaidObjectivePlugin curr : data) {
            RaidDangerLevel danger = curr.getDangerLevel();
            total += danger.marineLossesMult * (float)curr.getMarinesAssigned();
            assignedTokens += (float)curr.getMarinesAssigned();
        }
        float danger = total / Math.max(1.0f, assignedTokens);
        float hazard = 1.0f;
        if (this.market != null) {
            hazard = this.market.getHazardValue();
        }
        float reMult = 1.0f;
        if (this.temp.raidMult > MIN_RE_TO_REDUCE_MARINE_LOSSES) {
            extra = (this.temp.raidMult - MIN_RE_TO_REDUCE_MARINE_LOSSES) / (1.0f - MIN_RE_TO_REDUCE_MARINE_LOSSES);
            reMult = extra = MAX_MARINE_LOSS_REDUCTION_MULT + (1.0f - MAX_MARINE_LOSS_REDUCTION_MULT) * (1.0f - extra);
        } else if (this.temp.raidMult < RE_PER_MARINE_TOKEN) {
            reMult = extra = 1.0f + (RE_PER_MARINE_TOKEN - this.temp.raidMult) / RE_PER_MARINE_TOKEN;
        }
        if (this.market != null && reMult < 1.0f) {
            float minMarinesForAssignedTokens = MarketCMD.getMarinesFor(this.market, Math.round(assignedTokens));
            float actualMarines = Global.getSector().getPlayerFleet().getCargo().getMarines();
            if (actualMarines > minMarinesForAssignedTokens && actualMarines > 0.0f) {
                reMult *= 0.5f + 0.5f * minMarinesForAssignedTokens / actualMarines;
            }
        }
        float reservesMult = 1.0f;
        float maxTokens = this.getNumMarineTokens();
        if (maxTokens > assignedTokens) {
            reservesMult = 1.0f - (maxTokens - assignedTokens) * LOSS_REDUCTION_PER_RESERVE_TOKEN;
            reservesMult = Math.max(0.5f, reservesMult);
        }
        float e = MarketCMD.getDefenderIncreaseRaw(this.market);
        float per = MarketCMD.getRaidDefenderIncreasePerRaid();
        float prep = e / per * LOSS_INCREASE_PER_RAID;
        stat.modifyMultAlways("danger", danger, "Danger level of objectives");
        stat.modifyMult("hazard", hazard, "Colony hazard rating");
        if (reMult < 1.0f) {
            stat.modifyMultAlways("reMult", reMult, "High raid effectiveness");
        } else if (reMult > 1.0f) {
            stat.modifyMultAlways("reMult", reMult, "Low raid effectiveness");
        }
        if (reservesMult < 1.0f && assignedTokens > 0.0f) {
            stat.modifyMultAlways("reservesMult", reservesMult, "Forces held in reserve");
        }
        stat.modifyMult("prep", 1.0f + prep, "Increased defender preparedness");
        stat.applyMods(this.playerFleet.getStats().getDynamic().getStat("ground_attack_casualties_mult"));
        ListenerUtil.modifyMarineLossesStatPreRaid(this.market, data, stat);
        return stat;
    }

    protected float getAverageMarineLosses(List<GroundRaidObjectivePlugin> data) {
        MutableStat stat = this.getMarineLossesStat(data);
        float mult = stat.getModifiedValue();
        if (mult > MAX_MARINE_LOSSES) {
            mult = MAX_MARINE_LOSSES;
        }
        float marines = this.playerFleet.getCargo().getMarines();
        return marines * mult;
    }

    protected void addMilitaryResponse() {
        if (this.market == null) {
            return;
        }
        if (!this.market.getFaction().getCustomBoolean("noWarSim")) {
            MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "player_ground_raid_" + this.market.getId(), this.market.getFaction(), this.market.getPrimaryEntity(), 0.75f, 30.0f);
            this.market.getContainingLocation().addScript(new MilitaryResponseScript(params));
        }
        List<CampaignFleetAPI> fleets = this.market.getContainingLocation().getFleets();
        for (CampaignFleetAPI other : fleets) {
            if (other.getFaction() != this.market.getFaction()) continue;
            MemoryAPI mem = other.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$cfai_makeHostileWhileTOff", "raidAlarm", true, 1.0f);
        }
    }

    protected void raidConfirm(boolean secret) {
        if (this.temp.raidType == null) {
            this.raidNeverMind();
            return;
        }
        this.temp.secret = secret;
        Random random = this.getRandom();
        if (!DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            Misc.increaseMarketHostileTimeout(this.market, HOSTILE_ACTIONS_TIMEOUT_DAYS);
        }
        this.addMilitaryResponse();
        this.setRaidCooldown(this.getRaidCooldownMax());
        int stabilityPenalty = 0;
        if (!this.temp.nonMarket) {
            String reason = "Recently raided";
            if (Misc.isPlayerFactionSetUp()) {
                reason = String.valueOf(this.playerFaction.getDisplayName()) + " raid";
            }
            float raidMultForStabilityPenalty = this.temp.raidMult;
            if (this.temp.objectives != null) {
                float assignedTokens = 0.0f;
                for (GroundRaidObjectivePlugin curr : this.temp.objectives) {
                    assignedTokens += (float)curr.getMarinesAssigned();
                }
                raidMultForStabilityPenalty = assignedTokens * 0.1f;
            }
            stabilityPenalty = MarketCMD.applyRaidStabiltyPenalty(this.market, reason, raidMultForStabilityPenalty);
            Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", "player", true, 30.0f);
            Misc.setRaidedTimestamp(this.market);
        }
        int marines = this.playerFleet.getCargo().getMarines();
        float probOfLosses = 1.0f;
        int losses = 0;
        if (random.nextFloat() < probOfLosses) {
            float variance;
            float averageLosses = this.getAverageMarineLosses(this.temp.objectives);
            float randomizedLosses = StarSystemGenerator.getNormalRandom(random, averageLosses - (variance = averageLosses / 4.0f), averageLosses + variance);
            if (randomizedLosses < 1.0f) {
                float f = randomizedLosses = random.nextFloat() < randomizedLosses ? 1.0f : 0.0f;
            }
            if ((losses = (int)(randomizedLosses = (float)Math.round(randomizedLosses))) < 0) {
                losses = 0;
            }
            if (losses > marines) {
                losses = marines;
            }
        }
        if (losses <= 0) {
            this.text.addPara("Your forces have not suffered any casualties.");
            this.temp.marinesLost = 0;
        } else {
            this.text.addPara("You forces have suffered casualties during the raid.", Misc.getHighlightColor(), "" + losses);
            this.playerFleet.getCargo().removeMarines(losses);
            this.temp.marinesLost = losses;
            AddRemoveCommodity.addCommodityLossText("marines", losses, this.text);
        }
        if (!secret) {
            boolean tOn = this.playerFleet.isTransponderOn();
            boolean hostile = this.faction.isHostileTo("player");
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = this.market != null ? (float)this.market.getSize() * -0.01f * 1.0f : -0.01f;
            if (!hostile && tOn) {
                impact.ensureAtBest = RepLevel.HOSTILE;
            }
            if (impact.delta != 0.0f && !this.faction.isNeutralFaction()) {
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.text, true, true), this.faction.getId());
            }
        }
        if (stabilityPenalty > 0) {
            this.text.addPara("Stability of " + this.market.getName() + " reduced by %s.", Misc.getHighlightColor(), "" + stabilityPenalty);
        }
        CargoAPI result = this.performRaid(random, this.temp.raidMult);
        if (this.market != null) {
            this.market.reapplyIndustries();
        }
        result.sort();
        result.updateSpaceUsed();
        this.temp.raidLoot = result;
        if (this.temp.xpGained > 0) {
            Global.getSector().getPlayerStats().addXP(this.temp.xpGained, this.dialog.getTextPanel());
        }
        if (this.temp.raidType == RaidType.VALUABLE) {
            if ((float)result.getTotalCrew() + result.getSpaceUsed() + result.getFuel() < 10.0f) {
                this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_covert_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
            } else {
                this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_valuables_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
            }
        } else if (this.temp.raidType == RaidType.DISRUPT) {
            this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_disrupt_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        }
        boolean withContinue = false;
        for (GroundRaidObjectivePlugin curr : this.temp.objectives) {
            if (!curr.withContinueBeforeResult()) continue;
            withContinue = true;
            break;
        }
        if (this.market != null) {
            MarketCMD.applyDefenderIncreaseFromRaid(this.market);
        }
        if (withContinue) {
            this.options.clearOptions();
            this.options.addOption("Continue", RAID_CONFIRM_CONTINUE);
        } else {
            this.raidConfirmContinue();
        }
    }

    public void raidConfirmContinue() {
        int raidCredits;
        String contText = null;
        RaidType cfr_ignored_0 = this.temp.raidType;
        if (!this.temp.nonMarket) {
            RaidType cfr_ignored_1 = this.temp.raidType;
        }
        if ((raidCredits = (int)this.temp.raidLoot.getCredits().get()) < 0) {
            raidCredits = 0;
        }
        if (raidCredits > 0) {
            AddRemoveCommodity.addCreditsGainText(raidCredits, this.text);
            this.playerFleet.getCargo().getCredits().add(raidCredits);
        }
        if (!this.temp.raidLoot.isEmpty()) {
            contText = "Pick through the spoils";
        }
        this.temp.contText = contText;
        float assignedTokens = 0.0f;
        ArrayList<Industry> disrupted = new ArrayList<Industry>();
        for (GroundRaidObjectivePlugin curr : this.temp.objectives) {
            assignedTokens += (float)curr.getMarinesAssigned();
            if (!(curr instanceof DisruptIndustryRaidObjectivePluginImpl) || curr.getSource() == null) continue;
            disrupted.add(curr.getSource());
        }
        GroundRaidObjectivesListener.RaidResultData data = new GroundRaidObjectivesListener.RaidResultData();
        data.market = this.market;
        data.entity = this.entity;
        data.objectives = this.temp.objectives;
        data.type = this.temp.raidType;
        data.raidEffectiveness = this.temp.raidMult;
        data.xpGained = this.temp.xpGained;
        data.marinesTokensInReserve = Math.round((float)this.getNumMarineTokens() - assignedTokens);
        data.marinesTokens = this.getNumMarineTokens();
        data.marinesLost = this.temp.marinesLost;
        ListenerUtil.reportRaidObjectivesAchieved(data, this.dialog, this.memoryMap);
        if (this.temp.raidType == RaidType.VALUABLE) {
            ListenerUtil.reportRaidForValuablesFinishedBeforeCargoShown(this.dialog, this.market, this.temp, this.temp.raidLoot);
        } else if (this.temp.raidType == RaidType.DISRUPT) {
            for (Industry curr : disrupted) {
                ListenerUtil.reportRaidToDisruptFinished(this.dialog, this.market, this.temp, curr);
            }
        }
        Global.getSoundPlayer().playUISound("ui_raid_finished", 1.0f, 1.0f);
        FireBest.fire(null, this.dialog, this.memoryMap, "PostGroundRaid");
    }

    protected CargoAPI performRaid(Random random, float raidEffectiveness) {
        CargoAPI result = Global.getFactory().createCargo(true);
        float leftoverRE = Math.round(raidEffectiveness * 100.0f) % Math.round(RE_PER_MARINE_TOKEN * 100.0f);
        leftoverRE /= 100.0f;
        if (raidEffectiveness < RE_PER_MARINE_TOKEN) {
            leftoverRE = 0.0f;
        }
        long baseSeed = random.nextLong();
        int xp = 0;
        for (GroundRaidObjectivePlugin plugin : this.temp.objectives) {
            float lootMult = 1.0f + leftoverRE / Math.max(RE_PER_MARINE_TOKEN, raidEffectiveness);
            Random curr = new Random(Misc.seedUniquifier() ^ baseSeed * (long)plugin.getClass().getName().hashCode());
            xp += plugin.performRaid(result, curr, lootMult, this.dialog.getTextPanel());
        }
        this.temp.xpGained = xp;
        return result;
    }

    protected void raidNeverMind() {
        if (this.temp.nonMarket) {
            this.raidNonMarket();
        } else {
            this.raidMenu();
        }
    }

    protected void raidShowLoot() {
        this.dialog.getVisualPanel().showLoot("Spoils", this.temp.raidLoot, false, true, true, new CoreInteractionListener(){

            @Override
            public void coreUIDismissed() {
                MarketCMD.this.finishedRaidOrBombard();
            }
        });
    }

    protected void printStationState() {
        StationState state = this.getStationState();
        if (state == StationState.REPAIRS || state == StationState.UNDER_CONSTRUCTION) {
            FleetMemberAPI flagship;
            CampaignFleetAPI fleet = Misc.getStationBaseFleet(this.market);
            String name = "orbital station";
            if (fleet != null && (flagship = fleet.getFlagship()) != null) {
                name = flagship.getVariant().getDesignation().toLowerCase();
            }
            if (state == StationState.REPAIRS) {
                this.text.addPara("The " + name + " has suffered extensive damage and is not currently combat-capable.");
            } else {
                this.text.addPara("The " + name + " is under construction and is not currently combat-capable.");
            }
        }
    }

    protected void engage() {
        final SectorEntityToken entity = this.dialog.getInteractionTarget();
        MemoryAPI memory = MarketCMD.getEntityMemory(this.memoryMap);
        final CampaignFleetAPI primary = this.getInteractionTargetForFIDPI();
        this.dialog.setInteractionTarget(primary);
        FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
        config.leaveAlwaysAvailable = true;
        config.showCommLinkOption = false;
        config.showEngageText = false;
        config.showFleetAttitude = false;
        config.showTransponderStatus = false;
        config.alwaysAttackVsAttack = true;
        config.impactsAllyReputation = true;
        config.noSalvageLeaveOptionText = "Continue";
        config.dismissOnLeave = false;
        config.printXPToDialog = true;
        config.straightToEngage = true;
        CampaignFleetAPI station = this.getStationFleet();
        config.playerAttackingStation = station != null;
        final FleetInteractionDialogPluginImpl plugin = new FleetInteractionDialogPluginImpl(config);
        final InteractionDialogPlugin originalPlugin = this.dialog.getPlugin();
        config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

            @Override
            public void notifyLeave(InteractionDialogAPI dialog) {
                if (primary.isStationMode()) {
                    primary.getMemoryWithoutUpdate().clear();
                    primary.clearAssignments();
                }
                dialog.setPlugin(originalPlugin);
                dialog.setInteractionTarget(entity);
                boolean quickExit = entity.hasTag("non_clickable");
                if (!Global.getSector().getPlayerFleet().isValidPlayerFleet() || quickExit) {
                    dialog.getOptionPanel().clearOptions();
                    dialog.getOptionPanel().addOption("Leave", "marketLeave");
                    dialog.getOptionPanel().setShortcut("marketLeave", 1, false, false, false, true);
                    dialog.showTextPanel();
                    dialog.setPromptText("You decide to...");
                    dialog.getVisualPanel().finishFadeFast();
                    MarketCMD.this.text.updateSize();
                    return;
                }
                if (plugin.getContext() instanceof FleetEncounterContext) {
                    FleetEncounterContext context = (FleetEncounterContext)plugin.getContext();
                    context.didPlayerWinMostRecentBattleOfEncounter();
                    if (context.isEngagedInHostilities()) {
                        dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "NONE", 0.0f);
                    }
                    MarketCMD.this.showDefenses(context.isEngagedInHostilities());
                } else {
                    MarketCMD.this.showDefenses(false);
                }
                dialog.getVisualPanel().finishFadeFast();
            }

            @Override
            public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                bcc.objectivesAllowed = false;
            }

            @Override
            public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
            }
        };
        this.dialog.setPlugin(plugin);
        plugin.init(this.dialog);
    }

    protected CampaignFleetAPI getStationFleet() {
        CampaignFleetAPI station = Misc.getStationFleet(this.market);
        if (station == null) {
            return null;
        }
        if (station.getFleetData().getMembersListCopy().isEmpty()) {
            return null;
        }
        return station;
    }

    protected CampaignFleetAPI getInteractionTargetForFIDPI() {
        CampaignFleetAPI primary = this.getStationFleet();
        if (primary == null) {
            CampaignFleetAPI best = null;
            float minDist = Float.MAX_VALUE;
            for (CampaignFleetAPI fleet : Misc.getNearbyFleets(this.entity, 2000.0f)) {
                if (fleet.getBattle() != null || fleet.getFaction() != this.market.getFaction() || fleet.getFleetData().getNumMembers() <= 0) continue;
                float dist = Misc.getDistance(this.entity.getLocation(), fleet.getLocation());
                dist -= this.entity.getRadius();
                if (!((dist -= fleet.getRadius()) < Misc.getBattleJoinRange()) || !(dist < minDist)) continue;
                best = fleet;
                minDist = dist;
            }
            primary = best;
        }
        return primary;
    }

    protected StationState getStationState() {
        CampaignFleetAPI fleet = Misc.getStationFleet(this.market);
        boolean destroyed = false;
        if (fleet == null && (fleet = Misc.getStationBaseFleet(this.market)) != null) {
            destroyed = true;
        }
        if (fleet == null) {
            return StationState.NONE;
        }
        MarketAPI market = Misc.getStationMarket(fleet);
        if (market != null) {
            for (Industry ind : market.getIndustries()) {
                if (!ind.getSpec().hasTag("station") || !ind.isBuilding() || ind.isDisrupted() || ind.isUpgrading()) continue;
                return StationState.UNDER_CONSTRUCTION;
            }
        }
        if (destroyed) {
            return StationState.REPAIRS;
        }
        return StationState.OPERATIONAL;
    }

    public static int applyRaidStabiltyPenalty(MarketAPI target, String desc, float re) {
        int penalty = 0;
        if (re >= 0.79f) {
            penalty = 3;
        } else if (re >= 0.59f) {
            penalty = 2;
        } else if (re >= 0.29f) {
            penalty = 1;
        }
        if (penalty > 0) {
            RecentUnrest.get(target).add(penalty, desc);
        }
        return penalty;
    }

    public static int applyRaidStabiltyPenalty(MarketAPI target, String desc, float re, float maxPenalty) {
        int penalty = Math.round((0.45f + maxPenalty) * re);
        if (penalty > 0) {
            RecentUnrest.get(target).add(penalty, desc);
        }
        return penalty;
    }

    public static TooltipMakerAPI.StatModValueGetter statPrinter(final boolean withNegative) {
        return new TooltipMakerAPI.StatModValueGetter(){

            @Override
            public String getPercentValue(MutableStat.StatMod mod) {
                String prefix = mod.getValue() > 0.0f ? "+" : "";
                return String.valueOf(prefix) + (int)mod.getValue() + "%";
            }

            @Override
            public String getMultValue(MutableStat.StatMod mod) {
                return "\u00d7" + Misc.getRoundedValue(mod.getValue());
            }

            @Override
            public String getFlatValue(MutableStat.StatMod mod) {
                String prefix = mod.getValue() > 0.0f ? "+" : "";
                return String.valueOf(prefix) + (int)mod.getValue();
            }

            @Override
            public Color getModColor(MutableStat.StatMod mod) {
                if (withNegative && mod.getValue() < 1.0f) {
                    return Misc.getNegativeHighlightColor();
                }
                return null;
            }
        };
    }

    public static int getBombardmentCost(MarketAPI market, CampaignFleetAPI fleet) {
        float bomardBonus;
        float str = MarketCMD.getDefenderStr(market, true);
        int result = (int)(str * Global.getSettings().getFloat("bombardFuelFraction"));
        if (result < 2) {
            result = 2;
        }
        if (fleet != null && (result = (int)((float)result - (bomardBonus = Misc.getFleetwideTotalMod(fleet, "fleet_bombard_cost_reduction", 0.0f)))) < 0) {
            result = 0;
        }
        return result;
    }

    public static int getTacticalBombardmentStabilityPenalty() {
        return (int)Global.getSettings().getFloat("bombardTacticalStability");
    }

    public static int getSaturationBombardmentStabilityPenalty() {
        return (int)Global.getSettings().getFloat("bombardSaturationStability");
    }

    protected void bombardMenu() {
        float width = 350.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color b = Misc.getNegativeHighlightColor();
        this.dialog.getVisualPanel().showImagePortion("illustrations", "bombard_prepare", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        StatBonus defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        float bomardBonus = Misc.getFleetwideTotalMod(this.playerFleet, "fleet_bombard_cost_reduction", 0.0f);
        String increasedBombardKey = "core_addedBombard";
        StatBonus bombardBonusStat = new StatBonus();
        if (bomardBonus > 0.0f) {
            bombardBonusStat.modifyFlat(increasedBombardKey, -bomardBonus, "Specialized fleet bombardment capability");
        }
        float defenderStr = Math.round(defender.computeEffective(0.0f));
        if ((defenderStr -= bomardBonus) < 0.0f) {
            defenderStr = 0.0f;
        }
        this.temp.defenderStr = defenderStr;
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        String has = this.faction.getDisplayNameHasOrHave();
        String is = this.faction.getDisplayNameIsOrAre();
        boolean hostile = this.faction.isHostileTo("player");
        boolean tOn = this.playerFleet.isTransponderOn();
        float initPad = 0.0f;
        if (!hostile) {
            info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + " not currently hostile. A bombardment is a major enough hostile action that it can't be concealed, " + "regardless of transponder status.", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            initPad = opad;
        }
        info.addPara("Starship fuel can be easily destabilized, unlocking the destructive potential of the antimatter it contains. Ground defenses can counter a bombardment, though in practice it only means that more fuel is required to achieve the same result.", initPad);
        if (bomardBonus > 0.0f) {
            info.addPara("Effective ground defense strength: %s", opad, h, "" + (int)defenderStr);
        } else {
            info.addPara("Ground defense strength: %s", opad, h, "" + (int)defenderStr);
        }
        info.addStatModGrid(width, 50.0f, opad, small, defender, true, MarketCMD.statPrinter(true));
        if (!bombardBonusStat.isUnmodified()) {
            info.addStatModGrid(width, 50.0f, opad, 3.0f, bombardBonusStat, true, MarketCMD.statPrinter(false));
        }
        this.text.addTooltip();
        this.temp.bombardCost = MarketCMD.getBombardmentCost(this.market, this.playerFleet);
        int fuel = (int)this.playerFleet.getCargo().getFuel();
        boolean canBombard = fuel >= this.temp.bombardCost;
        LabelAPI label = this.text.addPara("A bombardment requires %s fuel. You have %s fuel.", h, "" + this.temp.bombardCost, "" + fuel);
        label.setHighlight("" + this.temp.bombardCost, "" + fuel);
        label.setHighlightColors(canBombard ? h : b, h);
        this.options.clearOptions();
        this.options.addOption("Prepare a tactical bombardment", BOMBARD_TACTICAL);
        this.options.addOption("Prepare a saturation bombardment", BOMBARD_SATURATION);
        if (DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            canBombard = true;
        }
        if (!canBombard) {
            this.options.setEnabled(BOMBARD_TACTICAL, false);
            this.options.setTooltip(BOMBARD_TACTICAL, "Not enough fuel.");
            this.options.setEnabled(BOMBARD_SATURATION, false);
            this.options.setTooltip(BOMBARD_SATURATION, "Not enough fuel.");
        }
        this.options.addOption("Go back", RAID_GO_BACK);
        this.options.setShortcut(RAID_GO_BACK, 1, false, false, false, true);
    }

    protected void addConfirmOptions() {
        this.options.clearOptions();
        this.options.addOption("Launch raid", RAID_CONFIRM);
        boolean tOn = this.playerFleet.isTransponderOn();
        if (this.market != null && !this.market.isPlanetConditionMarketOnly()) {
            this.options.addOption("Make special efforts to keep your preparations secret, then proceed", RAID_CONFIRM_STORY);
            String req = "";
            if (tOn) {
                req = "\n\nRequires transponder to be turned off";
                this.options.setEnabled(RAID_CONFIRM_STORY, false);
            }
            this.options.setTooltip(RAID_CONFIRM_STORY, "Suffer no penalty to your standing with " + this.market.getFaction().getDisplayNameWithArticle() + ". " + "Will not help if forced to turn your transponder on by patrols arriving to investigate the raid." + req);
            this.options.setTooltipHighlightColors(RAID_CONFIRM_STORY, this.market.getFaction().getBaseUIColor(), Misc.getNegativeHighlightColor());
            this.options.setTooltipHighlights(RAID_CONFIRM_STORY, this.market.getFaction().getDisplayNameWithArticleWithoutArticle(), req.isEmpty() ? req : req.substring(2));
            SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(RAID_CONFIRM_STORY, 1, "noRepPenaltyRaid", Sounds.STORY_POINT_SPEND_LEADERSHIP, "Secretly raided " + this.market.getName());
            SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

                @Override
                public void confirm() {
                    super.confirm();
                    MarketCMD.this.raidConfirm(true);
                }
            });
        }
        this.options.addOption("Never mind", RAID_NEVER_MIND);
        this.options.setShortcut(RAID_NEVER_MIND, 1, false, false, false, true);
        boolean hostile = this.faction.isHostileTo("player");
        if (tOn && !hostile && !this.faction.isNeutralFaction()) {
            this.options.addOptionConfirmation(RAID_CONFIRM, "The " + this.faction.getDisplayNameLong() + " " + this.faction.getDisplayNameIsOrAre() + " not currently hostile, and you have been positively identified. " + "Are you sure you want to engage in open hostilities?", "Yes", "Never mind");
        }
    }

    public static List<Industry> getTacticalBombardmentTargets(MarketAPI market) {
        int dur = MarketCMD.getBombardDisruptDuration();
        ArrayList<Industry> targets = new ArrayList<Industry>();
        for (Industry ind : market.getIndustries()) {
            if (!ind.getSpec().hasTag("tactical_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
            targets.add(ind);
        }
        return targets;
    }

    protected void bombardTactical() {
        this.temp.bombardType = BombardType.TACTICAL;
        boolean hostile = this.faction.isHostileTo("player");
        this.temp.willBecomeHostile.clear();
        this.temp.willBecomeHostile.add(this.faction);
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color b = Misc.getNegativeHighlightColor();
        int dur = MarketCMD.getBombardDisruptDuration();
        List<Industry> targets = MarketCMD.getTacticalBombardmentTargets(this.market);
        this.temp.bombardmentTargets.clear();
        this.temp.bombardmentTargets.addAll(targets);
        if (targets.isEmpty()) {
            this.text.addPara(String.valueOf(this.market.getName()) + " does not have any undisrupted military targets that would be affected by a tactical bombardment.");
            this.addBombardNeverMindOption();
            return;
        }
        int fuel = (int)this.playerFleet.getCargo().getFuel();
        this.text.addPara("A tactical bombardment will destabilize the colony, and will also disrupt the following military targets for approximately %s days:", h, "" + dur);
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        info.setParaFontDefault();
        info.setBulletedListMode("      ");
        float initPad = 0.0f;
        for (Industry ind : targets) {
            info.addPara(ind.getCurrentName(), initPad);
            initPad = 3.0f;
        }
        info.setBulletedListMode(null);
        this.text.addTooltip();
        this.text.addPara("The bombardment requires %s fuel. You have %s fuel.", h, "" + this.temp.bombardCost, "" + fuel);
        this.addBombardConfirmOptions();
    }

    protected void bombardSaturation() {
        boolean destroy;
        this.temp.bombardType = BombardType.SATURATION;
        this.temp.willBecomeHostile.clear();
        this.temp.willBecomeHostile.add(this.faction);
        ArrayList<FactionAPI> nonHostile = new ArrayList<FactionAPI>();
        nonHostile.add(this.faction);
        for (FactionAPI faction : Global.getSector().getAllFactions()) {
            if (this.temp.willBecomeHostile.contains(faction) || !faction.getCustomBoolean("caresAboutAtrocities")) continue;
            boolean hostile = faction.isHostileTo("player");
            this.temp.willBecomeHostile.add(faction);
            if (hostile) continue;
            nonHostile.add(faction);
        }
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color b = Misc.getNegativeHighlightColor();
        int dur = MarketCMD.getBombardDisruptDuration();
        ArrayList<Industry> targets = new ArrayList<Industry>();
        for (Industry ind : this.market.getIndustries()) {
            if (ind.getSpec().hasTag("no_saturation_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
            targets.add(ind);
        }
        this.temp.bombardmentTargets.clear();
        this.temp.bombardmentTargets.addAll(targets);
        boolean bl = destroy = this.market.getSize() <= MarketCMD.getBombardDestroyThreshold();
        if (Misc.isStoryCritical(this.market)) {
            destroy = false;
        }
        int fuel = (int)this.playerFleet.getCargo().getFuel();
        if (destroy) {
            this.text.addPara("A saturation bombardment of a colony this size will destroy it utterly.");
        } else {
            this.text.addPara("A saturation bombardment will destabilize the colony, reduce its population, and disrupt all operations for a long time.");
        }
        if (nonHostile.isEmpty()) {
            this.text.addPara("An atrocity of this scale can not be hidden, but any factions that would be dismayed by such actions are already hostile to you.");
        } else {
            this.text.addPara("An atrocity of this scale can not be hidden, and will make the following factions hostile:");
        }
        if (!nonHostile.isEmpty()) {
            TooltipMakerAPI info = this.text.beginTooltip();
            info.setParaFontDefault();
            info.setBulletedListMode("      ");
            float initPad = 0.0f;
            for (FactionAPI fac : nonHostile) {
                info.addPara(Misc.ucFirst(fac.getDisplayName()), fac.getBaseUIColor(), initPad);
                initPad = 3.0f;
            }
            info.setBulletedListMode(null);
            this.text.addTooltip();
        }
        this.text.addPara("The bombardment requires %s fuel. You have %s fuel.", h, "" + this.temp.bombardCost, "" + fuel);
        this.addBombardConfirmOptions();
    }

    protected void bombardConfirm() {
        boolean bl;
        boolean bl2;
        if (this.temp.bombardType == null) {
            this.bombardNeverMind();
            return;
        }
        if (this.temp.bombardType == BombardType.TACTICAL) {
            this.dialog.getVisualPanel().showImagePortion("illustrations", "bombard_tactical_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        } else {
            this.dialog.getVisualPanel().showImagePortion("illustrations", "bombard_saturation_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        }
        Random random = this.getRandom();
        if (!DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            float timeout = TACTICAL_BOMBARD_TIMEOUT_DAYS;
            if (this.temp.bombardType == BombardType.SATURATION) {
                timeout = SATURATION_BOMBARD_TIMEOUT_DAYS;
            }
            Misc.increaseMarketHostileTimeout(this.market, timeout);
            timeout *= 0.7f;
            for (MarketAPI marketAPI : Global.getSector().getEconomy().getMarkets(this.market.getContainingLocation())) {
                if (marketAPI == this.market) continue;
                boolean cares = marketAPI.getFaction().getCustomBoolean("caresAboutAtrocities");
                if (marketAPI.getFaction().isNeutralFaction() || marketAPI.getFaction().isPlayerFaction() || marketAPI.getFaction().isHostileTo(this.market.getFaction()) && !(cares &= this.temp.bombardType == BombardType.SATURATION)) continue;
                Misc.increaseMarketHostileTimeout(marketAPI, timeout);
            }
        }
        this.addMilitaryResponse();
        this.playerFleet.getCargo().removeFuel(this.temp.bombardCost);
        AddRemoveCommodity.addCommodityLossText("fuel", this.temp.bombardCost, this.text);
        for (FactionAPI curr : this.temp.willBecomeHostile) {
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = (float)this.market.getSize() * -0.01f * 1.0f;
            impact.ensureAtBest = RepLevel.HOSTILE;
            if (this.temp.bombardType == BombardType.SATURATION) {
                if (curr == this.faction) {
                    impact.ensureAtBest = RepLevel.VENGEFUL;
                }
                impact.delta = (float)this.market.getSize() * -0.01f * 1.0f;
            }
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.text, true, true), curr.getId());
        }
        if (this.temp.bombardType == BombardType.SATURATION) {
            int atrocities = (int)Global.getSector().getCharacterData().getMemoryWithoutUpdate().getFloat("$atrocities");
            Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$atrocities", ++atrocities);
            if (this.market != null && this.market.getFaction() != null) {
                MemoryAPI memoryAPI = this.market.getFaction().getMemoryWithoutUpdate();
                int count = memoryAPI.getInt("$numTimesSatBombardedByPlayer");
                memoryAPI.set("$numTimesSatBombardedByPlayer", ++count);
            }
        }
        int stabilityPenalty = MarketCMD.getTacticalBombardmentStabilityPenalty();
        if (this.temp.bombardType == BombardType.SATURATION) {
            stabilityPenalty = MarketCMD.getSaturationBombardmentStabilityPenalty();
        }
        boolean bl3 = bl2 = this.temp.bombardType == BombardType.SATURATION && this.market.getSize() <= MarketCMD.getBombardDestroyThreshold();
        if (Misc.isStoryCritical(this.market)) {
            bl = false;
        }
        if (stabilityPenalty > 0 && !bl) {
            String reason = "Recently bombarded";
            if (Misc.isPlayerFactionSetUp()) {
                reason = String.valueOf(this.playerFaction.getDisplayName()) + " bombardment";
            }
            RecentUnrest.get(this.market).add(stabilityPenalty, reason);
            this.text.addPara("Stability of " + this.market.getName() + " reduced by %s.", Misc.getHighlightColor(), "" + stabilityPenalty);
        }
        if (this.market.hasCondition("habitable") && !this.market.hasCondition("pollution")) {
            this.market.addCondition("pollution");
        }
        if (!bl) {
            for (Industry curr : this.temp.bombardmentTargets) {
                int dur = MarketCMD.getBombardDisruptDuration();
                dur = (int)((float)dur * StarSystemGenerator.getNormalRandom(random, 1.0f, 1.25f));
                curr.setDisrupted(dur);
            }
        }
        if (this.temp.bombardType == BombardType.TACTICAL) {
            this.text.addPara("Military operations disrupted.");
            ListenerUtil.reportTacticalBombardmentFinished(this.dialog, this.market, this.temp);
        } else if (this.temp.bombardType == BombardType.SATURATION) {
            if (bl) {
                DecivTracker.decivilize(this.market, true);
                this.text.addPara(String.valueOf(this.market.getName()) + " destroyed.");
            } else {
                int prevSize = this.market.getSize();
                CoreImmigrationPluginImpl.reduceMarketSize(this.market);
                if (prevSize == this.market.getSize()) {
                    this.text.addPara("All operations disrupted.");
                } else {
                    this.text.addPara("All operations disrupted. Colony size reduced to %s.", Misc.getHighlightColor(), "" + this.market.getSize());
                }
            }
            ListenerUtil.reportSaturationBombardmentFinished(this.dialog, this.market, this.temp);
        }
        if (this.dialog != null && this.dialog.getPlugin() instanceof RuleBasedDialog) {
            if (this.dialog.getInteractionTarget() != null && this.dialog.getInteractionTarget().getMarket() != null) {
                Global.getSector().setPaused(false);
                this.dialog.getInteractionTarget().getMarket().getMemoryWithoutUpdate().advance(1.0E-4f);
                Global.getSector().setPaused(true);
            }
            ((RuleBasedDialog)((Object)this.dialog.getPlugin())).updateMemory();
        }
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyBombarded", "player", true, 30.0f);
        if (bl && this.dialog != null && this.dialog.getPlugin() instanceof RuleBasedDialog) {
            ((RuleBasedDialog)((Object)this.dialog.getPlugin())).updateMemory();
        }
        MarketCMD.addBombardVisual(this.market.getPrimaryEntity());
        this.addBombardContinueOption();
    }

    protected void bombardNeverMind() {
        this.bombardMenu();
    }

    protected void raidResult() {
        if (this.temp.raidLoot != null) {
            if (this.temp.raidLoot.isEmpty()) {
                this.finishedRaidOrBombard();
            } else {
                this.raidShowLoot();
            }
            return;
        }
        this.finishedRaidOrBombard();
    }

    protected void bombardResult() {
        this.finishedRaidOrBombard();
    }

    protected void finishedRaidOrBombard() {
        new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
        this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$menuState", "main", 0.0f);
        if (this.dialog.getInteractionTarget().getMemoryWithoutUpdate().contains("$tradeMode")) {
            if (this.market.isPlanetConditionMarketOnly()) {
                this.dialog.getInteractionTarget().getMemoryWithoutUpdate().unset("$hasMarket");
            }
            this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "NONE", 0.0f);
        } else {
            this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "OPEN", 0.0f);
        }
        if (this.temp.nonMarket) {
            String trigger = this.temp.raidContinueTrigger;
            if (trigger == null || trigger.isEmpty()) {
                trigger = "OpenInteractionDialog";
            }
            FireAll.fire(null, this.dialog, this.memoryMap, trigger);
        } else {
            FireAll.fire(null, this.dialog, this.memoryMap, "PopulateOptions");
        }
        this.clearTemp();
    }

    protected void addBombardContinueOption() {
        this.addBombardContinueOption(null);
    }

    protected void addBombardContinueOption(String text) {
        if (text == null) {
            text = "Continue";
        }
        this.options.clearOptions();
        this.options.addOption(text, BOMBARD_RESULT);
    }

    protected boolean checkDebtEffect() {
        float f;
        String key = "$debt_effectTimeout";
        if (Global.getSector().getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        if (this.market.isPlayerOwned() && this.market.getSize() <= 3) {
            return false;
        }
        MonthlyReport report = SharedData.getData().getPreviousReport();
        if (report.getPreviousDebt() <= 0 || report.getDebt() <= 0) {
            return false;
        }
        float debt = report.getDebt() + report.getPreviousDebt();
        float income = report.getRoot().totalIncome;
        if (income < 1.0f) {
            income = 1.0f;
        }
        if ((f = debt / income) > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f < 0.1f) {
            return false;
        }
        int crew = this.playerFleet.getCargo().getCrew();
        int marines = this.playerFleet.getCargo().getMarines();
        return crew > 10 || marines > 10;
    }

    protected void applyDebtEffect() {
        int marineLoss;
        float f;
        MonthlyReport report = SharedData.getData().getPreviousReport();
        float debt = report.getDebt() + report.getPreviousDebt();
        float income = report.getRoot().totalIncome;
        if (income < 1.0f) {
            income = 1.0f;
        }
        if ((f = debt / income) > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        int crew = this.playerFleet.getCargo().getCrew();
        int marines = this.playerFleet.getCargo().getMarines();
        float maxLossFraction = 0.03f + Math.min(f + 0.05f, 0.2f) * (float)Math.random();
        float marineLossFraction = 0.03f + Math.min(f + 0.05f, 0.2f) * (float)Math.random();
        int crewLoss = (int)((float)crew * maxLossFraction);
        if (crewLoss < 2) {
            crewLoss = 2;
        }
        if ((marineLoss = (int)((float)marines * marineLossFraction)) < 2) {
            marineLoss = 2;
        }
        this.dialog.getVisualPanel().showImagePortion("illustrations", "crew_leaving", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        this.text.addPara("The lack of consistent pay over the last few months has caused discontent among your crew. A number take this opportunity to leave your employment.");
        if (crewLoss < crew) {
            this.playerFleet.getCargo().removeCrew(crewLoss);
            AddRemoveCommodity.addCommodityLossText("crew", crewLoss, this.text);
        }
        if (marineLoss <= marines) {
            this.playerFleet.getCargo().removeMarines(marineLoss);
            AddRemoveCommodity.addCommodityLossText("marines", marineLoss, this.text);
        }
        String key = "$debt_effectTimeout";
        Global.getSector().getMemoryWithoutUpdate().set(key, true, 30.0f + (float)Math.random() * 10.0f);
        this.options.clearOptions();
        this.options.addOption("Continue", DEBT_RESULT_CONTINUE);
    }

    public void doGenericRaid(FactionAPI faction, float attackerStr) {
        this.doGenericRaid(faction, attackerStr, 3.0f);
    }

    public void doGenericRaid(FactionAPI faction, float attackerStr, float maxPenalty) {
        this.doGenericRaid(faction, attackerStr, maxPenalty, false);
    }

    public void doGenericRaid(FactionAPI faction, float attackerStr, float maxPenalty, boolean allowedRepeat) {
        if (!allowedRepeat && Misc.flagHasReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId())) {
            return;
        }
        float re = MarketCMD.getRaidEffectiveness(this.market, attackerStr);
        if (maxPenalty == 3.0f) {
            MarketCMD.applyRaidStabiltyPenalty(this.market, String.valueOf(Misc.ucFirst(faction.getPersonNamePrefix())) + " raid", re);
        } else {
            MarketCMD.applyRaidStabiltyPenalty(this.market, String.valueOf(Misc.ucFirst(faction.getPersonNamePrefix())) + " raid", re, maxPenalty);
        }
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId(), true, 30.0f);
        Misc.setRaidedTimestamp(this.market);
    }

    public boolean doIndustryRaid(FactionAPI faction, float attackerStr, Industry industry, float durMult) {
        this.temp.raidType = RaidType.DISRUPT;
        this.temp.target = industry;
        StatBonus defenderBase = new StatBonus();
        StatBonus defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        String increasedDefensesKey = "core_addedDefStr";
        float added = MarketCMD.getDefenderIncreaseValue(this.market);
        if (added > 0.0f) {
            defender.modifyFlat(increasedDefensesKey, added, "Increased defender preparedness");
        }
        float defenderStr = Math.round(defender.computeEffective(defenderBase.computeEffective(0.0f)));
        defender.unmodifyFlat(increasedDefensesKey);
        this.temp.attackerStr = attackerStr;
        this.temp.defenderStr = defenderStr;
        boolean hasForces = true;
        boolean canDisrupt = true;
        this.temp.raidMult = attackerStr / Math.max(1.0f, attackerStr + defenderStr);
        this.temp.raidMult = (float)Math.round(this.temp.raidMult * 100.0f) / 100.0f;
        if (this.temp.raidMult < VALUABLES_THRESHOLD) {
            hasForces = false;
        }
        if (this.temp.raidMult < DISRUPTION_THRESHOLD) {
            canDisrupt = false;
        }
        if (!canDisrupt) {
            return false;
        }
        Random random = this.getRandom();
        MarketCMD.applyDefenderIncreaseFromRaid(this.market);
        String reason = String.valueOf(faction.getDisplayName()) + " raid";
        if (faction.getPersonNamePrefix() != null) {
            reason = String.valueOf(Misc.ucFirst(faction.getPersonNamePrefix())) + " raid";
        }
        MarketCMD.applyRaidStabiltyPenalty(this.market, reason, this.temp.raidMult);
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId(), true, 30.0f);
        Misc.setRaidedTimestamp(this.market);
        if (this.temp.target != null) {
            float dur = this.computeBaseDisruptDuration(this.temp.target);
            dur *= StarSystemGenerator.getNormalRandom(random, 1.0f, 1.25f);
            if ((dur *= durMult) < 2.0f) {
                dur = 2.0f;
            }
            float already = this.temp.target.getDisruptedDays();
            this.temp.target.setDisrupted(already + dur);
        }
        return true;
    }

    public void doBombardment(FactionAPI faction, BombardType type) {
        this.temp.bombardType = type;
        Random random = this.getRandom();
        int dur = MarketCMD.getBombardDisruptDuration();
        int stabilityPenalty = MarketCMD.getTacticalBombardmentStabilityPenalty();
        if (this.temp.bombardType == BombardType.SATURATION) {
            stabilityPenalty = MarketCMD.getSaturationBombardmentStabilityPenalty();
            targets = new ArrayList();
            for (Industry ind : this.market.getIndustries()) {
                if (ind.getSpec().hasTag("no_saturation_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
                targets.add(ind);
            }
            this.temp.bombardmentTargets.clear();
            this.temp.bombardmentTargets.addAll(targets);
        } else {
            targets = new ArrayList<Industry>();
            for (Industry ind : this.market.getIndustries()) {
                if (!ind.getSpec().hasTag("tactical_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
                targets.add(ind);
            }
            this.temp.bombardmentTargets.clear();
            this.temp.bombardmentTargets.addAll(targets);
        }
        if (stabilityPenalty > 0) {
            String reason = "Saturation bombardment";
            if (this.temp.bombardType == BombardType.TACTICAL) {
                reason = "Tactical bombardment";
            }
            RecentUnrest.get(this.market).add(stabilityPenalty, reason);
        }
        if (this.market.hasCondition("habitable") && !this.market.hasCondition("pollution")) {
            this.market.addCondition("pollution");
        }
        for (Industry curr : this.temp.bombardmentTargets) {
            dur = MarketCMD.getBombardDisruptDuration();
            dur = (int)((float)dur * StarSystemGenerator.getNormalRandom(random, 1.0f, 1.25f));
            curr.setDisrupted(dur);
        }
        if (this.temp.bombardType != BombardType.TACTICAL && this.temp.bombardType == BombardType.SATURATION) {
            boolean destroy;
            boolean bl = destroy = this.market.getSize() <= MarketCMD.getBombardDestroyThreshold();
            if (Misc.isStoryCritical(this.market)) {
                destroy = false;
            }
            if (destroy) {
                DecivTracker.decivilize(this.market, true);
            } else {
                CoreImmigrationPluginImpl.reduceMarketSize(this.market);
            }
        }
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyBombarded", faction.getId(), true, 30.0f);
        MarketCMD.addBombardVisual(this.market.getPrimaryEntity());
    }

    public static void addBombardVisual(SectorEntityToken target) {
        if (target != null && target.isInCurrentLocation()) {
            int num = (int)(target.getRadius() * target.getRadius() / 300.0f);
            if ((num *= 2) > 150) {
                num = 150;
            }
            if (num < 10) {
                num = 10;
            }
            target.addScript(new BombardmentAnimation(num, target));
        }
    }

    protected boolean checkMercsLeaving() {
        String key = "$mercs_leaveTimeout";
        if (Global.getSector().getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        if (this.market.isHidden()) {
            return false;
        }
        if (this.market.getSize() <= 3) {
            return false;
        }
        List<OfficerDataAPI> mercs = Misc.getMercs(this.playerFleet);
        if (mercs.isEmpty()) {
            return false;
        }
        MonthlyReport report = SharedData.getData().getPreviousReport();
        boolean debt = report.getDebt() > 0;
        float contractDur = Global.getSettings().getFloat("officerMercContractDur");
        for (OfficerDataAPI od : mercs) {
            float elapsed;
            if (debt && od.getPerson().getMemoryWithoutUpdate().contains(key) || !((elapsed = Misc.getMercDaysSinceHired(od.getPerson())) > contractDur) && (!debt || !(elapsed > 45.0f))) continue;
            this.dialog.getInteractionTarget().setActivePerson(od.getPerson());
            ((RuleBasedInteractionDialogPluginImpl)this.dialog.getPlugin()).notifyActivePersonChanged();
            return true;
        }
        return false;
    }

    protected void convinceMercToStay() {
        PersonAPI merc = this.dialog.getInteractionTarget().getActivePerson();
        this.dialog.getInteractionTarget().setActivePerson(null);
        if (merc != null) {
            Misc.setMercHiredNow(merc);
            String key = "$mercs_leaveTimeout";
            Global.getSector().getMemoryWithoutUpdate().set(key, true, 5.0f + (float)Math.random() * 5.0f);
            merc.getMemoryWithoutUpdate().set(key, true, 35.0f + (float)Math.random() * 5.0f);
        }
    }

    protected void mercLeaves() {
        PersonAPI merc = this.dialog.getInteractionTarget().getActivePerson();
        this.dialog.getInteractionTarget().setActivePerson(null);
        if (merc != null) {
            FleetMemberAPI member = this.playerFleet.getFleetData().getMemberWithCaptain(merc);
            if (member != null) {
                member.setCaptain(null);
            }
            this.playerFleet.getFleetData().removeOfficer(merc);
            AddRemoveCommodity.addOfficerLossText(merc, this.text);
            String key = "$mercs_leaveTimeout";
            Global.getSector().getMemoryWithoutUpdate().set(key, true, 5.0f + (float)Math.random() * 5.0f);
        }
    }

    public static enum BombardType {
        TACTICAL,
        SATURATION;

    }

    public static class BombardmentAnimation
    implements EveryFrameScript {
        int num = 0;
        SectorEntityToken target;
        int added = 0;
        float elapsed = 0.0f;

        public BombardmentAnimation(int num, SectorEntityToken target) {
            this.num = num;
            this.target = target;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.added >= this.num;
        }

        @Override
        public void advance(float amount) {
            this.elapsed += amount * (float)Math.random();
            if (this.elapsed < 0.03f) {
                return;
            }
            this.elapsed = 0.0f;
            int curr = (int)Math.round(Math.random() * 4.0);
            if (curr < 1) {
                curr = 0;
            }
            Color color = new Color(255, 165, 100, 255);
            Vector2f vel = new Vector2f();
            if (this.target.getOrbit() != null && this.target.getCircularOrbitRadius() > 0.0f && this.target.getCircularOrbitPeriod() > 0.0f && this.target.getOrbitFocus() != null) {
                float circumference = (float)Math.PI * 2 * this.target.getCircularOrbitRadius();
                float speed = circumference / this.target.getCircularOrbitPeriod();
                float dir = Misc.getAngleInDegrees(this.target.getLocation(), this.target.getOrbitFocus().getLocation()) + 90.0f;
                vel = Misc.getUnitVectorAtDegreeAngle(dir);
                vel.scale(speed / Global.getSector().getClock().getSecondsPerDay());
            }
            int i = 0;
            while (i < curr) {
                float glowSize = 50.0f + 50.0f * (float)Math.random();
                float angle = (float)Math.random() * 360.0f;
                float dist = (float)Math.sqrt(Math.random()) * this.target.getRadius();
                float factor = 0.5f + 0.5f * (1.0f - (float)Math.sqrt(dist / this.target.getRadius()));
                glowSize *= factor;
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
                loc.scale(dist);
                Vector2f.add((Vector2f)loc, (Vector2f)this.target.getLocation(), (Vector2f)loc);
                Color c2 = Misc.scaleColor(color, factor);
                Misc.addHitGlow(this.target.getContainingLocation(), loc, vel, glowSize, c2);
                ++this.added;
                if (i == 0 && (dist = Misc.getDistance(loc, Global.getSector().getPlayerFleet().getLocation())) < HyperspaceTerrainPlugin.STORM_STRIKE_SOUND_RANGE) {
                    float volumeMult = 1.0f - dist / HyperspaceTerrainPlugin.STORM_STRIKE_SOUND_RANGE;
                    volumeMult = (float)Math.sqrt(volumeMult);
                    if ((volumeMult *= 0.1f * factor) > 0.0f) {
                        Global.getSoundPlayer().playSound("mine_explosion", 1.0f, 1.0f * volumeMult, loc, Misc.ZERO);
                    }
                }
                ++i;
            }
        }
    }

    public static enum RaidDangerLevel {
        NONE("None", "None", Misc.getPositiveHighlightColor(), 0.0f, 60.0f, 1),
        MINIMAL("Minimal", "Minimal", Misc.getPositiveHighlightColor(), 0.02f, 50.0f, 1),
        LOW("Low", "Light", Misc.getPositiveHighlightColor(), 0.04f, 40.0f, 2),
        MEDIUM("Medium", "Moderate", Misc.getHighlightColor(), 0.08f, 30.0f, 3),
        HIGH("High", "Heavy", Misc.getNegativeHighlightColor(), 0.16f, 20.0f, 5),
        EXTREME("Extreme", "Extreme", Misc.getNegativeHighlightColor(), 0.32f, 10.0f, 7);

        private static RaidDangerLevel[] vals;
        public String name;
        public String lossesName;
        public Color color;
        public float marineLossesMult;
        public int marineTokens;
        public float disruptionDays;

        static {
            vals = RaidDangerLevel.values();
        }

        private RaidDangerLevel(String name, String lossesName, Color color, float marineLossesMult, float disruptionDays, int marineTokens) {
            this.name = name;
            this.lossesName = lossesName;
            this.color = color;
            this.marineLossesMult = marineLossesMult;
            this.disruptionDays = disruptionDays;
            this.marineTokens = marineTokens;
        }

        public RaidDangerLevel next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public RaidDangerLevel prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }

    public static enum RaidType {
        CUSTOM_ONLY,
        VALUABLE,
        DISRUPT;

    }

    public static enum StationState {
        NONE,
        OPERATIONAL,
        UNDER_CONSTRUCTION,
        REPAIRS;

    }

    public static class TempData {
        public boolean canRaid;
        public boolean canBombard;
        public int bombardCost;
        public int marinesLost;
        public float raidMult;
        public float attackerStr;
        public float defenderStr;
        public boolean nonMarket = false;
        public boolean secret = false;
        public RaidType raidType = null;
        public BombardType bombardType = null;
        public CargoAPI raidLoot;
        public int xpGained;
        public Industry target = null;
        public List<FactionAPI> willBecomeHostile = new ArrayList<FactionAPI>();
        public List<Industry> bombardmentTargets = new ArrayList<Industry>();
        public List<GroundRaidObjectivePlugin> objectives = new ArrayList<GroundRaidObjectivePlugin>();
        public String contText;
        public String raidGoBackTrigger;
        public String raidContinueTrigger;
    }
}

