/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoPickerListener;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityPlugin;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CampaignObjective;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTNeutrinoBurstFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.CommSnifferIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MiscCMD;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamVisibilityManager;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class Objectives
extends BaseCommandPlugin {
    public static String BURST_RANGE = "$COB_burstRange";
    public static int WORMHOLE_FUEL = 100;
    public static String WORMHOLE_TYPE_STR = "wormhole";
    public static float BURST_RANGE_MAKESHIFT = 10.0f;
    public static float BURST_RANGE_DOMAIN = 15.0f;
    public static float BURST_RANGE_SCAVENGER_MIN = 5.0f;
    public static float BURST_RANGE_SCAVENGER_MAX = 10.0f;
    public static float SALVAGE_FRACTION = 0.5f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected FactionAPI faction;

    public Objectives() {
    }

    public Objectives(SectorEntityToken entity) {
        this.init(entity);
    }

    protected void init(SectorEntityToken entity) {
        this.memory = entity.getMemoryWithoutUpdate();
        this.entity = entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = entity.getFaction();
        this.faction = entity.getFaction();
        if (entity.hasTag("makeshift")) {
            this.memory.set(BURST_RANGE, (int)BURST_RANGE_MAKESHIFT, 0.0f);
        } else {
            this.memory.set(BURST_RANGE, (int)BURST_RANGE_DOMAIN, 0.0f);
        }
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.entity = dialog.getInteractionTarget();
        this.init(this.entity);
        this.memory = Objectives.getEntityMemory(memoryMap);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        if (command.equals("printCost")) {
            String type = params.get(1).getString(memoryMap);
            this.printCost(type);
        } else if (command.equals("showSalvage")) {
            this.printSalvage();
        } else if (command.equals("selectWormholeAnchor")) {
            this.selectWormholeAnchor();
        } else {
            if (command.equals("hasWormholeAnchor")) {
                return this.hasWormholeAnchor();
            }
            if (command.equals("hasRepImpact")) {
                return this.hasRepImpact();
            }
            if (command.equals("showRepairCost")) {
                this.printRepairCost(true);
            } else if (command.equals("showBurstCost")) {
                boolean hasRecent = HyperspaceTopographyEventIntel.hasRecentReadingsNearPlayer();
                this.printBurstCost(this.canBurst() && !hasRecent);
            } else if (command.equals("showRepairCostNoPrompt")) {
                this.printRepairCost(false);
            } else if (command.equals("printHackDesc")) {
                this.printHackDesc();
            } else {
                if (command.equals("canBuild")) {
                    String type = params.get(1).getString(memoryMap);
                    return this.canBuild(type);
                }
                if (command.equals("canActivate")) {
                    return this.canActivate(this.entity.getCustomEntityType());
                }
                if (command.equals("canBurst")) {
                    return this.canBurst();
                }
                if (command.equals("build")) {
                    String type = params.get(1).getString(memoryMap);
                    this.build(type, "player");
                } else if (command.equals("printDescription")) {
                    this.updateMemory();
                    String type = this.entity.getCustomEntityType();
                    this.printDescription(type);
                } else {
                    if (command.equals("isHacked")) {
                        return this.isHacked();
                    }
                    if (command.equals("doAction")) {
                        String action = params.get(1).getString(memoryMap);
                        if (action.equals("hack")) {
                            this.hack();
                        } else if (action.equals("reset")) {
                            this.reset();
                        } else if (action.equals("unhack")) {
                            this.unhack();
                        } else if (action.equals("control")) {
                            this.control("player");
                        } else if (action.equals("salvage")) {
                            this.salvage("player");
                        } else if (action.equals("burst")) {
                            this.doBurst();
                        }
                    }
                }
            }
        }
        return true;
    }

    protected void doBurst() {
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getBurstResources();
        int[] quantities = this.getBurstQuantities();
        int i = 0;
        while (i < res.length) {
            String commodityId = res[i];
            int quantity = quantities[i];
            cargo.removeCommodity(commodityId, quantity);
            AddRemoveCommodity.addCommodityLossText(commodityId, quantity, this.text);
            ++i;
        }
        float range = this.memory.getFloat(BURST_RANGE);
        SlipstreamVisibilityManager.updateSlipstreamVisibility(this.entity.getLocationInHyperspace(), range);
        int points = 0;
        points = this.entity.hasTag("makeshift") ? HTPoints.NEUTRINO_BURST_MAKESHIFT : HTPoints.NEUTRINO_BURST_DOMAIN;
        boolean hasRecent = HyperspaceTopographyEventIntel.hasRecentReadingsNearPlayer();
        if (!hasRecent && points > 0) {
            HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTNeutrinoBurstFactor(points), this.dialog);
            if (HyperspaceTopographyEventIntel.get() != null) {
                HyperspaceTopographyEventIntel.get().addRecentReadings(this.entity.getLocationInHyperspace());
            }
        }
    }

    protected boolean hasRepImpact() {
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(this.entity.getContainingLocation())) {
            if (curr.getFaction() != this.entity.getFaction() || curr.getFaction().isNeutralFaction() || curr.getFaction().isPlayerFaction()) continue;
            return true;
        }
        return false;
    }

    public void salvage(final String factionId) {
        CargoAPI salvage = Global.getFactory().createCargo(true);
        String[] r = this.getResources();
        int[] q = this.getSalvageQuantities();
        int i = 0;
        while (i < r.length) {
            salvage.addCommodity(r[i], q[i]);
            ++i;
        }
        this.dialog.getVisualPanel().showLoot("Salvaged", salvage, false, true, true, new CoreInteractionListener(){

            @Override
            public void coreUIDismissed() {
                Objectives.this.dialog.dismiss();
                Objectives.this.dialog.hideTextPanel();
                Objectives.this.dialog.hideVisualPanel();
                LocationAPI loc = Objectives.this.entity.getContainingLocation();
                CustomCampaignEntityAPI built = loc.addCustomEntity(null, null, "stable_location", "neutral");
                if (Objectives.this.entity.getOrbit() != null) {
                    built.setOrbit(Objectives.this.entity.getOrbit().makeCopy());
                } else {
                    built.setLocation(Objectives.this.entity.getLocation().x, Objectives.this.entity.getLocation().y);
                }
                loc.removeEntity(Objectives.this.entity);
                Objectives.this.updateOrbitingEntities(loc, Objectives.this.entity, built);
                built.getMemoryWithoutUpdate().set("$recentlySalvaged", true, 30.0f);
                if ("player".equals(factionId) && Objectives.this.hasRepImpact() && !Objectives.this.entity.getFaction().isPlayerFaction() && !Objectives.this.entity.getFaction().isNeutralFaction()) {
                    CoreReputationPlugin.RepActions action = CoreReputationPlugin.RepActions.COMBAT_AGGRESSIVE;
                    if (Objectives.this.entity.hasTag("makeshift")) {
                        action = CoreReputationPlugin.RepActions.COMBAT_AGGRESSIVE_TOFF;
                    }
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, null, null, null, false, true, "Change caused by destruction of " + Objectives.this.entity.getCustomEntitySpec().getDefaultName().toLowerCase()), Objectives.this.faction.getId());
                }
                ListenerUtil.reportObjectiveDestroyed(Objectives.this.entity, built, Global.getSector().getFaction(factionId));
            }
        });
        this.options.clearOptions();
        this.dialog.setPromptText("");
    }

    public void updateOrbitingEntities(LocationAPI loc, SectorEntityToken prev, SectorEntityToken built) {
        if (loc == null) {
            return;
        }
        for (SectorEntityToken other : loc.getAllEntities()) {
            if (other == prev || other.getOrbit() == null || other.getOrbitFocus() != prev) continue;
            other.setOrbitFocus(built);
        }
    }

    public boolean isNonFunctional() {
        return this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional");
    }

    public void control(String factionId) {
        if (this.dialog != null) {
            if ("player".equals(factionId) && this.isNonFunctional()) {
                this.removeRepairCosts(this.text);
            }
            if ("player".equals(factionId) && this.hasRepImpact() && !this.entity.getFaction().isPlayerFaction() && !this.entity.getFaction().isNeutralFaction()) {
                CoreReputationPlugin.RepActions action = CoreReputationPlugin.RepActions.COMBAT_AGGRESSIVE;
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, null, null, this.text, false, true), this.faction.getId());
            }
        }
        FactionAPI prev = this.entity.getFaction();
        this.entity.setFaction(factionId);
        this.faction = this.entity.getFaction();
        if (!this.entity.hasTag("comm_relay") && this.faction.isPlayerFaction()) {
            this.unhack();
        }
        this.entity.getMemoryWithoutUpdate().unset("$objectiveNonFunctional");
        if (this.dialog != null) {
            ((RuleBasedDialog)((Object)this.dialog.getPlugin())).updateMemory();
            this.updateMemory();
            this.printOwner();
        }
        ListenerUtil.reportObjectiveChangedHands(this.entity, prev, this.faction);
    }

    public void unhack() {
        CommSnifferIntel intel = CommSnifferIntel.getExistingSnifferIntelForRelay(this.entity);
        if (intel != null) {
            intel.uninstall();
            this.updateMemory();
        } else {
            CustomCampaignEntityPlugin plugin = this.entity.getCustomPlugin();
            if (plugin instanceof CampaignObjective) {
                CampaignObjective o = (CampaignObjective)((Object)plugin);
                o.setHacked(false);
            }
            this.updateMemory();
        }
    }

    public void hack() {
        CustomCampaignEntityPlugin plugin = this.entity.getCustomPlugin();
        if (plugin instanceof CampaignObjective) {
            CampaignObjective o = (CampaignObjective)((Object)plugin);
            o.setHacked(true);
        }
        this.updateMemory();
    }

    public void reset() {
        CustomCampaignEntityPlugin plugin = this.entity.getCustomPlugin();
        if (plugin instanceof CampaignObjective) {
            CampaignObjective o = (CampaignObjective)((Object)plugin);
            o.setReset(true);
        }
        Global.getSector().getPlayerFleet().getMemoryWithoutUpdate().set("$core_fleetNotChasingGhost", true, 0.5f + Misc.random.nextFloat() * 1.0f);
        this.updateMemory();
    }

    public boolean isHacked() {
        CustomCampaignEntityPlugin plugin = this.entity.getCustomPlugin();
        if (plugin instanceof CampaignObjective) {
            CampaignObjective o = (CampaignObjective)((Object)plugin);
            return o.isHacked();
        }
        return false;
    }

    public void build(String type, String factionId) {
        if (this.entity.hasTag("non_clickable")) {
            return;
        }
        if (this.entity.hasTag("fading_out_and_expiring")) {
            return;
        }
        LocationAPI loc = this.entity.getContainingLocation();
        CustomCampaignEntityAPI built = loc.addCustomEntity(null, null, type, factionId);
        if (this.entity.getOrbit() != null) {
            built.setOrbit(this.entity.getOrbit().makeCopy());
        }
        built.setLocation(this.entity.getLocation().x, this.entity.getLocation().y);
        loc.removeEntity(this.entity);
        this.updateOrbitingEntities(loc, this.entity, built);
        built.getMemoryWithoutUpdate().set("$originalStableLocation", this.entity);
        if (this.text != null) {
            this.removeBuildCosts();
            Global.getSoundPlayer().playUISound("ui_objective_constructed", 1.0f, 1.0f);
        }
    }

    public boolean canBuild(String type) {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return true;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getResources();
        int[] quantities = this.getQuantities();
        if (type.equals(WORMHOLE_TYPE_STR)) {
            res = this.getWormholeResources();
            quantities = this.getWormholeQuantities();
        }
        int i = 0;
        while (i < res.length) {
            int quantity = quantities[i];
            String commodityId = res[i];
            if ((float)quantity > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeBuildCosts() {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getResources();
        int[] quantities = this.getQuantities();
        int i = 0;
        while (i < res.length) {
            String commodityId = res[i];
            int quantity = quantities[i];
            cargo.removeCommodity(commodityId, quantity);
            ++i;
        }
    }

    public void removeRepairCosts(TextPanelAPI text) {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getRepairResources();
        int[] quantities = this.getRepairQuantities();
        int i = 0;
        while (i < res.length) {
            String commodityId = res[i];
            int quantity = quantities[i];
            cargo.removeCommodity(commodityId, quantity);
            AddRemoveCommodity.addCommodityLossText(commodityId, quantity, text);
            ++i;
        }
    }

    public boolean canActivate(String type) {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return true;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getRepairResources();
        int[] quantities = this.getRepairQuantities();
        int i = 0;
        while (i < res.length) {
            int quantity = quantities[i];
            String commodityId = res[i];
            if ((float)quantity > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canBurst() {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return true;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getBurstResources();
        int[] quantities = this.getBurstQuantities();
        int i = 0;
        while (i < res.length) {
            int quantity = quantities[i];
            String commodityId = res[i];
            if ((float)quantity > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void updateMemory() {
    }

    public void printDescription(String type) {
        Description desc = Global.getSettings().getDescription(type, Description.Type.CUSTOM);
        if (desc != null) {
            this.text.addParagraph(desc.getText1());
        }
        CustomEntitySpecAPI spec = Global.getSettings().getCustomEntitySpec(type);
        CustomCampaignEntityPlugin plugin = spec.getPlugin();
        SectorEntityToken temp = this.entity.getContainingLocation().createToken(0.0f, 0.0f);
        for (String tag : spec.getTags()) {
            temp.addTag(tag);
        }
        plugin.init(temp, null);
        boolean objective = this.entity.hasTag("objective");
        if (objective) {
            plugin = this.entity.getCustomPlugin();
        }
        Class<?> c = null;
        if (plugin instanceof CampaignObjective) {
            CampaignObjective o = (CampaignObjective)((Object)plugin);
            c = o.getClass();
            TooltipMakerAPI info = this.text.beginTooltip();
            o.printEffect(info, 0.0f);
            this.text.addTooltip();
            o.printNonFunctionalAndHackDescription(this.text);
        }
        this.printOwner();
        for (SectorEntityToken curr : this.entity.getContainingLocation().getEntitiesWithTag("objective")) {
            CampaignObjective o;
            CustomCampaignEntityPlugin ccep;
            if (!curr.hasTag("objective") || curr.getFaction() == null || !curr.getFaction().isPlayerFaction() || curr.getCustomEntitySpec() == null || !((ccep = curr.getCustomPlugin()) instanceof CampaignObjective) || c != (o = (CampaignObjective)((Object)ccep)).getClass()) continue;
            if (this.entity == curr) {
                this.text.addPara("Another one in this star system would have no effect beyond providing redundancy in case this one is lost.");
                break;
            }
            this.text.addPara("There's already " + curr.getCustomEntitySpec().getAOrAn() + " " + curr.getCustomEntitySpec().getNameInText() + " under your control " + "in this star system. Another one would have no effect " + "beyond providing redundancy if one is lost.");
            break;
        }
    }

    public void printOwner() {
        boolean objective = this.entity.hasTag("objective");
        if (objective) {
            if (!this.faction.isNeutralFaction()) {
                if (this.entity.getFaction().isPlayerFaction() && !Misc.isPlayerFactionSetUp()) {
                    this.text.addPara("This " + this.entity.getCustomEntitySpec().getShortName() + " is under your control.", this.entity.getFaction().getBaseUIColor(), "your");
                } else {
                    this.text.addPara("This " + this.entity.getCustomEntitySpec().getShortName() + " is under %s control.", this.entity.getFaction().getBaseUIColor(), this.entity.getFaction().getPersonNamePrefix());
                }
            } else {
                this.text.addPara("This " + this.entity.getCustomEntitySpec().getShortName() + " is not claimed by any faction.");
            }
        }
    }

    public void printHackDesc() {
    }

    public void printRepairCost(boolean withPrompt) {
        Misc.showCost(this.text, null, null, this.getRepairResources(), this.getRepairQuantities());
        if (withPrompt) {
            this.text.addPara("Proceed with reactivation?");
        }
    }

    public void printBurstCost(boolean withPrompt) {
        Misc.showCost(this.text, null, null, this.getBurstResources(), this.getBurstQuantities());
        boolean hasRecent = HyperspaceTopographyEventIntel.hasRecentReadingsNearPlayer();
        if (hasRecent) {
            LabelAPI label = this.text.addPara("You've recently acquired topographic data within %s light-years of your current location, and a neutrino burst here will not meaningfully contribute to your understanding of hyperspace topology. It will, however, still reveal all nearby slipstreams.", Misc.getHighlightColor(), "" + (int)HyperspaceTopographyEventIntel.RECENT_READINGS_RANGE_LY);
            label.setHighlightColors(Misc.getHighlightColor(), Misc.getNegativeHighlightColor(), Misc.getNegativeHighlightColor());
            label.setHighlight("" + (int)HyperspaceTopographyEventIntel.RECENT_READINGS_RANGE_LY, "will not meaningfully contribute", "hyperspace topology");
        }
        if (withPrompt) {
            this.text.addPara("Proceed with neutrino burst?");
        }
    }

    public void printSalvage() {
        Misc.showCost(this.text, "Potential salvage", false, null, null, this.getResources(), this.getSalvageQuantities());
        this.text.addPara("Proceed with salvage operation?");
    }

    public void printCost(String type) {
        if (type.equals(WORMHOLE_TYPE_STR)) {
            Misc.showCost(this.text, null, null, this.getWormholeResources(), this.getWormholeQuantities());
            return;
        }
        this.printDescription(type);
        Misc.showCost(this.text, null, null, this.getResources(), this.getQuantities());
        if (this.canBuild(type)) {
            this.text.addPara("Proceed with construction?");
        } else {
            this.text.addPara("You do not have the necessary resources to build this structure.");
        }
    }

    public String[] getWormholeResources() {
        return new String[]{"fuel"};
    }

    public int[] getWormholeQuantities() {
        return new int[]{WORMHOLE_FUEL};
    }

    public String[] getResources() {
        if (this.entity.hasTag("makeshift") || this.entity.hasTag("stable_location")) {
            return new String[]{"heavy_machinery", "metals", "rare_metals"};
        }
        return new String[]{"heavy_machinery", "metals", "rare_metals", "volatiles"};
    }

    public int[] getSalvageQuantities() {
        int[] q = this.getQuantities();
        int[] result = new int[q.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (int)((float)q[i] * SALVAGE_FRACTION);
            ++i;
        }
        return result;
    }

    public int[] getQuantities() {
        if (this.entity.hasTag("makeshift") || this.entity.hasTag("stable_location")) {
            return new int[]{15, 30, 5};
        }
        return new int[]{50, 200, 20, 20};
    }

    public String[] getRepairResources() {
        return new String[]{"heavy_machinery"};
    }

    public int[] getRepairQuantities() {
        return new int[]{5};
    }

    public int[] getBurstQuantities() {
        return new int[]{HTPoints.NEUTRINO_BURST_VOLATILES_COST};
    }

    public String[] getBurstResources() {
        return new String[]{"volatiles"};
    }

    public boolean hasWormholeAnchor() {
        return !this.getWormholeAnchors().isEmpty();
    }

    public CargoAPI getWormholeAnchors() {
        CargoAPI copy = Global.getFactory().createCargo(false);
        for (CargoStackAPI stack : this.playerCargo.getStacksCopy()) {
            if (!stack.isSpecialStack() || !"wormhole_anchor".equals(stack.getSpecialDataIfSpecial().getId())) continue;
            copy.addFromStack(stack);
        }
        copy.sort();
        return copy;
    }

    public void selectWormholeAnchor() {
        CargoAPI copy = this.getWormholeAnchors();
        float width = 310.0f;
        this.dialog.showCargoPickerDialog("Select wormhole anchor to deploy", "Deploy", "Cancel", true, 310.0f, copy, new CargoPickerListener(){

            @Override
            public void pickedCargo(CargoAPI cargo) {
                if (cargo.isEmpty()) {
                    this.cancelledCargoSelection();
                    return;
                }
                cargo.sort();
                for (CargoStackAPI stack : cargo.getStacksCopy()) {
                    if (!stack.isSpecialStack()) continue;
                    JumpPointAPI jp = WormholeManager.get().addWormhole(stack.getSpecialDataIfSpecial(), Objectives.this.entity, Objectives.this.dialog);
                    if (!DebugFlags.OBJECTIVES_DEBUG) {
                        Objectives.this.playerCargo.removeCommodity("fuel", WORMHOLE_FUEL);
                        AddRemoveCommodity.addCommodityLossText("fuel", WORMHOLE_FUEL, Objectives.this.text);
                    }
                    FireBest.fire(null, Objectives.this.dialog, Objectives.this.memoryMap, "WormholeDeploymentFinished");
                    if (jp == null) break;
                    MiscCMD.addWormholeIntelIfNeeded(jp, Objectives.this.text, true);
                    break;
                }
            }

            @Override
            public void cancelledCargoSelection() {
            }

            @Override
            public void recreateTextPanel(TooltipMakerAPI panel, CargoAPI cargo, CargoStackAPI pickedUp, boolean pickedUpFromSource, CargoAPI combined) {
                panel.addPara("Deploying and activating a wormhole anchor, turning it into an active terminus, will consume %s fuel. Your fleet is carrying %s fuel.", 0.0f, Misc.getHighlightColor(), "" + WORMHOLE_FUEL, "" + (int)Objectives.this.playerCargo.getFuel());
                boolean makeUnstable = WormholeManager.willWormholeBecomeUnstable(Objectives.this.entity);
                if (makeUnstable) {
                    panel.addPara("Once the operation is completed, the wormhole will take about half a cycle to stablize,before it can be used.", 10.0f, Misc.getHighlightColor(), "half a cycle");
                } else {
                    panel.addPara("Usually, the wormhole will take about a cycle to stablize, but you have calibration data that will allow it to be used immediately.", 10.0f);
                }
            }
        });
    }
}

