/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class SalvageSpecialInteraction
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        SectorEntityToken entity = dialog.getInteractionTarget();
        MemoryAPI memory = SalvageSpecialInteraction.getEntityMemory(memoryMap);
        InteractionDialogPlugin originalPlugin = dialog.getPlugin();
        Object specialData = memory.get("$salvageSpecialData");
        SalvageSpecialPlugin special = null;
        if (specialData instanceof SalvageSpecialData) {
            special = ((SalvageSpecialData)specialData).createSpecialPlugin();
        }
        if (special == null) {
            FireBest.fire(null, dialog, memoryMap, "SalvageSpecialFinishedNoContinue");
            return true;
        }
        SalvageSpecialDialogPlugin plugin = new SalvageSpecialDialogPlugin(originalPlugin, special, specialData, memoryMap);
        dialog.setPlugin(plugin);
        plugin.init(dialog);
        return true;
    }

    public static interface SalvageSpecialData {
        public SalvageSpecialPlugin createSpecialPlugin();
    }

    public static class SalvageSpecialDialogPlugin
    implements InteractionDialogPlugin {
        private InteractionDialogAPI dialog;
        private InteractionDialogPlugin originalPlugin;
        private Map<String, MemoryAPI> memoryMap;
        private final SalvageSpecialPlugin special;
        private final Object specialData;

        public SalvageSpecialDialogPlugin(InteractionDialogPlugin originalPlugin, SalvageSpecialPlugin special, Object specialData, Map<String, MemoryAPI> memoryMap) {
            this.originalPlugin = originalPlugin;
            this.special = special;
            this.specialData = specialData;
            this.memoryMap = memoryMap;
        }

        @Override
        public void init(InteractionDialogAPI dialog) {
            this.dialog = dialog;
            this.special.init(dialog, this.specialData);
            if (this.special.isDone()) {
                this.endSpecial(this.special.endWithContinue(), this.special.shouldAbortSalvageAndRemoveEntity());
            } else if (Global.getSettings().isDevMode()) {
                DevMenuOptions.addOptions(dialog);
            }
        }

        @Override
        public void optionSelected(String optionText, Object optionData) {
            if (optionText != null) {
                this.dialog.getTextPanel().addParagraph(optionText, Global.getSettings().getColor("buttonText"));
            }
            if (optionData == "DumpMemory.option_dump_memory") {
                new DumpMemory().execute(null, this.dialog, null, this.getMemoryMap());
                return;
            }
            if (DevMenuOptions.isDevOption(optionData)) {
                DevMenuOptions.execute(this.dialog, (String)optionData);
                return;
            }
            this.special.optionSelected(optionText, optionData);
            if (this.special.isDone()) {
                this.endSpecial(this.special.endWithContinue(), this.special.shouldAbortSalvageAndRemoveEntity());
            } else if (Global.getSettings().isDevMode()) {
                DevMenuOptions.addOptions(this.dialog);
            }
        }

        public void endSpecial(boolean withContinue, boolean withAbort) {
            if (!this.special.shouldShowAgain()) {
                BaseCommandPlugin.getEntityMemory(this.memoryMap).unset("$salvageSpecialData");
            }
            this.dialog.setPlugin(this.originalPlugin);
            if (withAbort) {
                Misc.fadeAndExpire(this.dialog.getInteractionTarget(), 1.0f);
                this.dialog.dismiss();
            } else if (withContinue) {
                FireBest.fire(null, this.dialog, this.memoryMap, "SalvageSpecialFinished");
            } else {
                FireBest.fire(null, this.dialog, this.memoryMap, "SalvageSpecialFinishedNoContinue");
            }
        }

        @Override
        public void advance(float amount) {
        }

        @Override
        public void backFromEngagement(EngagementResultAPI battleResult) {
        }

        @Override
        public Object getContext() {
            return null;
        }

        @Override
        public Map<String, MemoryAPI> getMemoryMap() {
            return this.memoryMap;
        }

        @Override
        public void optionMousedOver(String optionText, Object optionData) {
        }
    }

    public static interface SalvageSpecialPlugin {
        public void init(InteractionDialogAPI var1, Object var2);

        public void optionSelected(String var1, Object var2);

        public boolean isDone();

        public boolean endWithContinue();

        public boolean shouldShowAgain();

        public boolean shouldAbortSalvageAndRemoveEntity();
    }
}

