/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;

public class CargoManifestSpecial
extends BaseSalvageSpecial {
    private CargoManifestSpecialData data;

    @Override
    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (CargoManifestSpecialData)specialData;
        this.initManifest();
    }

    private void initManifest() {
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.data.commodityId);
        if (spec == null) {
            this.initNothing();
            return;
        }
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        String name = "sent to the $shortName";
        if (debris) {
            name = "searching through the debris";
        }
        if (this.entity instanceof PlanetAPI) {
            name = "sent to the surface";
        }
        String text1 = "A cargo manifest found by the salvage crews " + name + " indicates " + "the presence of a quantity of " + spec.getName().toLowerCase() + ", " + "likely to be found if proper salvage operations are conducted.";
        this.addText(text1);
        CargoAPI extra = Global.getFactory().createCargo(true);
        float quantity = this.data.min + (this.data.max - this.data.min) * this.random.nextFloat();
        quantity = Math.round(quantity);
        extra.addCommodity(this.data.commodityId, quantity);
        this.addTempExtraSalvage(extra);
        this.setDone(true);
        this.setShowAgain(true);
    }

    public static class CargoManifestSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public String commodityId = null;
        public float min;
        public float max;

        public CargoManifestSpecialData(String commodityId, float min, float max) {
            this.commodityId = commodityId;
            this.min = min;
            this.max = max;
        }

        @Override
        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new CargoManifestSpecial();
        }
    }
}

