/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetMemberPickerListener;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;

public class ShipRecoverySpecial
extends BaseSalvageSpecial {
    public static final String RECOVER = "recover";
    public static final String NOT_NOW = "not_now";
    public static final String RECOVERY_FINISHED = "finished";
    public static final String ABORT_CONTINUE = "abort_continue";
    protected ShipRecoverySpecialData data;
    protected List<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
    protected List<FleetMemberAPI> recovered = new ArrayList<FleetMemberAPI>();
    protected FleetMemberAPI first = null;

    public static ShipRecoverySpecialData getSpecialData(SectorEntityToken entity, String desc, boolean create, boolean replace) {
        Object o = Misc.getSalvageSpecial(entity);
        ShipRecoverySpecialData data = null;
        if (o instanceof ShipRecoverySpecialData) {
            data = (ShipRecoverySpecialData)o;
        }
        if (data == null && !create) {
            return null;
        }
        if (o != null && data == null && !replace) {
            return null;
        }
        if (data == null) {
            data = new ShipRecoverySpecialData(desc);
            Misc.setSalvageSpecial(entity, data);
        }
        return data;
    }

    @Override
    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (ShipRecoverySpecialData)specialData;
        if (this.data.ships.isEmpty()) {
            this.initNothing();
        } else {
            this.init();
        }
    }

    protected void init() {
        this.members.clear();
        for (PerShipData curr : this.data.ships) {
            this.addMember(curr);
        }
        if (this.members.isEmpty()) {
            this.initNothing();
            return;
        }
        CampaignFleetAPI recoverable = Global.getFactory().createEmptyFleet("neutral", "patrolSmall", true);
        for (FleetMemberAPI member : this.members) {
            recoverable.getFleetData().addFleetMember(member);
        }
        if (recoverable.getFleetData().getMembersListCopy().size() == 1) {
            this.visual.showFleetMemberInfo(recoverable.getFleetData().getMembersListCopy().get(0), true);
        } else {
            this.visual.showFleetInfo("Your fleet", this.playerFleet, "Recoverable ships", recoverable, null, true);
        }
        this.addInitialText();
        if (this.isStoryPointRecovery()) {
            this.addStoryOptions();
        } else {
            this.options.clearOptions();
            this.options.addOption("Consider ship recovery", RECOVER);
            if (this.data.notNowOptionExits != null && this.data.notNowOptionExits.booleanValue()) {
                this.options.addOption("Leave", NOT_NOW);
                this.options.setShortcut(NOT_NOW, 1, false, false, false, true);
            } else {
                this.options.addOption("Not now", NOT_NOW);
            }
        }
    }

    protected void addStoryOptions() {
        this.options.clearOptions();
        this.options.addOption("Take a look at the chief engineer's report and make a decision", RECOVER);
        this.options.addOption("\"I'll need to consider my options.\"", NOT_NOW);
        this.dialog.setOptionColor(RECOVER, Misc.getStoryOptionColor());
    }

    protected boolean isStoryPointRecovery() {
        return this.data != null && this.data.storyPointRecovery != null && this.data.storyPointRecovery != false;
    }

    protected void addInitialText() {
        boolean withDesc;
        if (this.data.noDescriptionText != null && this.data.noDescriptionText.booleanValue()) {
            return;
        }
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        boolean wreck = "wreck".equals(this.entity.getCustomEntityType());
        boolean bl = withDesc = !debris && !(wreck |= this.entity.hasTag("wreck"));
        if (this.isStoryPointRecovery()) {
            this.addText("Some time later, you hear back from your chief engineer, who mumbles about being a miracle worker to someone offscreen before noticing you've picked up the call.");
            if (this.members.size() == 1) {
                this.addText("\"Commander, looks like we might be able to pull this off, though I'll say you're not going to find what I'm going to do in any manual. And it wouldn't pass any inspection, but then again we're not in the Hegemony fleet. It'll fly, though.");
            } else {
                this.addText("\"Commander, looks like we might be able to pull this off, though I'll say you're not going to find what I'm going to do in any manual. And it wouldn't pass any inspection, but then again we're not in the Hegemony fleet. These ships can be made to fly again, though.");
            }
            return;
        }
        String ships = "several ships";
        String they = "they";
        if (this.members.size() == 1) {
            ships = "a ship";
            they = "it";
        }
        if (wreck) {
            if (this.data.storyPointRecovery != null && this.data.storyPointRecovery.booleanValue()) {
                this.addText("A crack engineering team sent to the wreck reports successfully preparing it for recovery.");
            } else if (!FireBest.fire(null, this.dialog, this.memoryMap, "ShipRecoveryCustomText")) {
                this.addText("Salvage crews boarding the wreck discover that many essential systems are undamaged and the ship could be restored to basic functionality.");
                BaseSalvageSpecial.ExtraSalvage es = BaseSalvageSpecial.getExtraSalvage(this.entity);
                if (es != null && !es.cargo.isEmpty()) {
                    this.addText("There are also indications that it has some sort of cargo on board.");
                }
            }
        } else if (debris) {
            this.addText("Close-range scans of the debris field reveal " + ships + " that could be restored to basic functionality.");
        } else if (withDesc) {
            String desc = this.data.desc;
            if (desc == null) {
                desc = "floating near";
            }
            if (this.entity instanceof PlanetAPI) {
                this.addText("Salvage crews report " + ships + " " + desc + ". " + "Closer inspection reveals " + they + " could be restored to basic functionality.");
            } else {
                this.addText("Salvage crews report " + ships + " " + desc + " the $shortName. " + "Closer inspection reveals " + they + " could be restored to basic functionality.");
            }
        }
        if (this.members.size() == 1) {
            if (this.members.size() > 0 && Misc.getCurrSpecialMods(this.members.get(0).getVariant()) > 0) {
                this.text.addPara("The crew chief also reports that the hull has undergone %s, which appear to have survived its present state.", Misc.getStoryOptionColor(), "special modifications");
            }
            this.addText("If not recovered, the ship will be scuttled, and any fitted weapons and fighter LPCs will be retrieved.");
        } else {
            this.addText("Any ships that aren't recovered will be scuttled, and any fitted weapons and fighter LPCs will be retrieved.");
        }
    }

    protected void addMember(PerShipData shipData) {
        if (shipData.variant == null && shipData.variantId == null) {
            return;
        }
        FleetMemberAPI member = null;
        member = shipData.variantId != null ? Global.getFactory().createFleetMember(FleetMemberType.SHIP, shipData.variantId) : Global.getFactory().createFleetMember(FleetMemberType.SHIP, shipData.variant);
        if (Misc.isUnboardable(member)) {
            return;
        }
        this.members.add(member);
        if (this.first == null) {
            this.first = member;
        }
        member.setOwner(1);
        if (shipData.fleetMemberId != null) {
            member.setId(shipData.fleetMemberId);
        }
        if (shipData.captain != null) {
            member.setCaptain(shipData.captain);
        }
        if (ShipRecoverySpecial.isNameKnown(shipData.condition) || shipData.nameAlwaysKnown != null && shipData.nameAlwaysKnown.booleanValue()) {
            member.setShipName(shipData.shipName);
        } else {
            member.setShipName("<name unknown>");
        }
        this.prepareMember(member, shipData);
    }

    public static boolean isNameKnown(ShipCondition condition) {
        return condition == ShipCondition.PRISTINE || condition == ShipCondition.GOOD;
    }

    public void prepareMember(FleetMemberAPI member, PerShipData shipData) {
        int hits = this.getHitsForCondition(member, shipData.condition);
        int dmods = this.getDmodsForCondition(shipData.condition);
        int reduction = (int)this.playerFleet.getStats().getDynamic().getValue("ship_dmod_reduction_mod", 0.0f);
        reduction = this.random.nextInt(reduction + 1);
        dmods -= reduction;
        member.getStatus().setRandom(this.random);
        int i = 0;
        while (i < hits) {
            member.getStatus().applyDamage(1000000.0f);
            ++i;
        }
        member.getStatus().setHullFraction(this.getHullForCondition(shipData.condition));
        member.getRepairTracker().setCR(0.0f);
        ShipVariantAPI variant = member.getVariant();
        variant = variant.clone();
        variant.setOriginalVariant(null);
        int dModsAlready = DModManager.getNumDMods(variant);
        dmods = Math.max(0, dmods - dModsAlready);
        if (dmods > 0 && shipData.addDmods) {
            DModManager.setDHull(variant);
        }
        member.setVariant(variant, false, true);
        if (dmods > 0 && shipData.addDmods) {
            DModManager.addDMods(member, true, dmods, this.random);
        }
        if (shipData.sModProb > 0.0f && this.random.nextFloat() < shipData.sModProb) {
            int num = 1;
            float r = this.random.nextFloat();
            if (r > 0.85f) {
                num = 3;
            } else if (r > 0.5f) {
                num = 2;
            }
            WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
            for (String id : variant.getHullMods()) {
                HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
                if (spec.isHidden() || spec.isHiddenEverywhere() || spec.hasTag("dmod") || spec.hasTag("no_build_in") || variant.getPermaMods().contains(spec.getId())) continue;
                picker.add(id, spec.getCapitalCost());
            }
            int i2 = 0;
            while (i2 < num && !picker.isEmpty()) {
                String id = (String)picker.pickAndRemove();
                variant.addPermaMod(id, true);
                ++i2;
            }
        }
        if (shipData.pruneWeapons) {
            float retain = this.getFighterWeaponRetainProb(shipData.condition);
            FleetEncounterContext.prepareShipForRecovery(member, false, false, false, retain, retain, this.random);
            member.getVariant().autoGenerateWeaponGroups();
        }
    }

    protected float getHullForCondition(ShipCondition condition) {
        switch (condition) {
            case PRISTINE: {
                return 1.0f;
            }
            case GOOD: {
                return 0.6f + this.random.nextFloat() * 0.2f;
            }
            case AVERAGE: {
                return 0.4f + this.random.nextFloat() * 0.2f;
            }
            case BATTERED: {
                return 0.2f + this.random.nextFloat() * 0.2f;
            }
            case WRECKED: {
                return this.random.nextFloat() * 0.1f;
            }
        }
        return 1.0f;
    }

    protected int getDmodsForCondition(ShipCondition condition) {
        if (condition == ShipCondition.PRISTINE) {
            return 0;
        }
        switch (condition) {
            case GOOD: {
                return 1;
            }
            case AVERAGE: {
                return 1 + this.random.nextInt(2);
            }
            case BATTERED: {
                return 2 + this.random.nextInt(2);
            }
            case WRECKED: {
                return 3 + this.random.nextInt(2);
            }
        }
        return 1;
    }

    protected float getFighterWeaponRetainProb(ShipCondition condition) {
        switch (condition) {
            case PRISTINE: {
                return 1.0f;
            }
            case GOOD: {
                return 0.67f;
            }
            case AVERAGE: {
                return 0.5f;
            }
            case BATTERED: {
                return 0.33f;
            }
            case WRECKED: {
                return 0.2f;
            }
        }
        return 0.0f;
    }

    protected int getHitsForCondition(FleetMemberAPI member, ShipCondition condition) {
        if (condition == ShipCondition.PRISTINE) {
            return 0;
        }
        if (condition == ShipCondition.WRECKED) {
            return 20;
        }
        switch (member.getHullSpec().getHullSize()) {
            case CAPITAL_SHIP: {
                switch (condition) {
                    case GOOD: {
                        return 2 + this.random.nextInt(2);
                    }
                    case AVERAGE: {
                        return 4 + this.random.nextInt(3);
                    }
                    case BATTERED: {
                        return 7 + this.random.nextInt(6);
                    }
                }
                break;
            }
            case CRUISER: {
                switch (condition) {
                    case GOOD: {
                        return 1 + this.random.nextInt(2);
                    }
                    case AVERAGE: {
                        return 2 + this.random.nextInt(3);
                    }
                    case BATTERED: {
                        return 4 + this.random.nextInt(4);
                    }
                }
                break;
            }
            case DESTROYER: {
                switch (condition) {
                    case GOOD: {
                        return 1 + this.random.nextInt(2);
                    }
                    case AVERAGE: {
                        return 2 + this.random.nextInt(2);
                    }
                    case BATTERED: {
                        return 3 + this.random.nextInt(3);
                    }
                }
                break;
            }
            case FRIGATE: {
                switch (condition) {
                    case GOOD: {
                        return 1;
                    }
                    case AVERAGE: {
                        return 2;
                    }
                    case BATTERED: {
                        return 3;
                    }
                }
            }
        }
        return 1;
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (RECOVER.equals(optionData)) {
            if (this.isStoryPointRecovery()) {
                this.addStoryOptions();
            } else {
                this.options.clearOptions();
                this.options.addOption("Consider ship recovery", RECOVER);
                if (this.data.notNowOptionExits != null && this.data.notNowOptionExits.booleanValue()) {
                    this.options.addOption("Leave", NOT_NOW);
                    this.options.setShortcut(NOT_NOW, 1, false, false, false, true);
                } else {
                    this.options.addOption("Not now", NOT_NOW);
                }
            }
            List<FleetMemberAPI> pool = this.members;
            List<FleetMemberAPI> storyPool = new ArrayList<FleetMemberAPI>();
            if (this.isStoryPointRecovery()) {
                pool = storyPool;
                storyPool = this.members;
            }
            this.dialog.showFleetMemberRecoveryDialog("Select ships to recover", pool, storyPool, new FleetMemberPickerListener(){

                @Override
                public void pickedFleetMembers(List<FleetMemberAPI> selected) {
                    if (selected.isEmpty()) {
                        return;
                    }
                    new ShowDefaultVisual().execute(null, ShipRecoverySpecial.this.dialog, Misc.tokenize(""), ShipRecoverySpecial.this.memoryMap);
                    for (FleetMemberAPI member : selected) {
                        int index = ShipRecoverySpecial.this.members.indexOf(member);
                        if (index < 0) continue;
                        PerShipData shipData = ShipRecoverySpecial.this.data.ships.get(index);
                        ShipRecoverySpecial.this.data.ships.remove(index);
                        ShipRecoverySpecial.this.members.remove(index);
                        member.setShipName(shipData.shipName);
                        if (shipData.fleetMemberId != null) {
                            member.setId(shipData.fleetMemberId);
                        }
                        float minHull = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_hull_min", 0.0f);
                        float maxHull = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_hull_max", 0.0f);
                        float minCR = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_cr_min", 0.0f);
                        float maxCR = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_cr_max", 0.0f);
                        float hull = (float)Math.random() * (maxHull - minHull) + minHull;
                        hull = Math.max(hull, member.getStatus().getHullFraction());
                        member.getStatus().setHullFraction(hull);
                        float cr = (float)Math.random() * (maxCR - minCR) + minCR;
                        member.getRepairTracker().setCR(cr);
                        ShipRecoverySpecial.this.playerFleet.getFleetData().addFleetMember(member);
                        ShipRecoverySpecial.this.recovered.add(member);
                    }
                    if (ShipRecoverySpecial.this.dialog.getPlugin() instanceof SalvageSpecialInteraction.SalvageSpecialDialogPlugin) {
                        SalvageSpecialInteraction.SalvageSpecialDialogPlugin plugin = (SalvageSpecialInteraction.SalvageSpecialDialogPlugin)ShipRecoverySpecial.this.dialog.getPlugin();
                        plugin.optionSelected(null, ShipRecoverySpecial.RECOVERY_FINISHED);
                    } else {
                        ShipRecoverySpecial.this.dialog.dismiss();
                    }
                }

                @Override
                public void cancelledFleetMemberPicking() {
                }
            });
        } else if (NOT_NOW.equals(optionData)) {
            if (this.data.notNowOptionExits != null && this.data.notNowOptionExits.booleanValue()) {
                this.dialog.dismiss();
            } else {
                if (this.isStoryPointRecovery()) {
                    Misc.setSalvageSpecial(this.entity, Misc.getPrevSalvageSpecial(this.entity));
                }
                new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
                if (!this.isStoryPointRecovery()) {
                    this.addExtraSalvageFromUnrecoveredShips();
                }
                this.setDone(true);
                this.setEndWithContinue(false);
                this.setShowAgain(true);
            }
        } else if (RECOVERY_FINISHED.equals(optionData)) {
            new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
            boolean wreck = "wreck".equals(this.entity.getCustomEntityType());
            if (wreck |= this.entity.hasTag("wreck")) {
                CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(this.entity);
                if (extra != null && !extra.isEmpty()) {
                    this.addText("Your crews find some securely stowed cargo during the recovery operation.");
                    extra.sort();
                    this.playerFleet.getCargo().addAll(extra);
                    for (CargoStackAPI stack : extra.getStacksCopy()) {
                        AddRemoveCommodity.addStackGainText(stack, this.text);
                    }
                    ShipRecoverySpecial.clearExtraSalvage(this.entity);
                    ListenerUtil.reportSpecialCargoGainedFromRecoveredDerelict(extra, this.dialog);
                }
                this.addText("The " + this.first.getShipName() + " is now part of your fleet.");
                this.setShouldAbortSalvageAndRemoveEntity(true);
                this.options.clearOptions();
                this.options.addOption("Leave", ABORT_CONTINUE);
                this.options.setShortcut(ABORT_CONTINUE, 1, false, false, false, true);
                ListenerUtil.reportShipsRecovered(this.recovered, this.dialog);
                for (FleetMemberAPI member : this.recovered) {
                    this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$srs_memberId", member.getId(), 0.0f);
                    this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$srs_hullId", member.getHullId(), 0.0f);
                    this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$srs_baseHullId", member.getHullSpec().getBaseHullId(), 0.0f);
                    FireAll.fire(null, this.dialog, this.memoryMap, "PostShipRecoverySpecial");
                }
            } else {
                this.addExtraSalvageFromUnrecoveredShips();
                this.setEndWithContinue(false);
                this.setDone(true);
                this.setShowAgain(!this.data.ships.isEmpty());
            }
        } else if (ABORT_CONTINUE.equals(optionData)) {
            this.setDone(true);
            this.setEndWithContinue(false);
        }
    }

    protected void addExtraSalvageFromUnrecoveredShips() {
        if (this.members.isEmpty()) {
            return;
        }
        CargoAPI extra = Global.getFactory().createCargo(true);
        for (FleetMemberAPI member : this.members) {
            this.addStuffFromMember(extra, member);
        }
        this.addTempExtraSalvage(extra);
    }

    protected void addStuffFromMember(CargoAPI cargo, FleetMemberAPI member) {
        cargo.addCommodity("supplies", member.getRepairTracker().getSuppliesFromScuttling());
        cargo.addCommodity("fuel", member.getRepairTracker().getFuelFromScuttling());
        cargo.addCommodity("heavy_machinery", member.getRepairTracker().getHeavyMachineryFromScuttling());
        ShipVariantAPI variant = member.getVariant();
        for (String slotId : variant.getNonBuiltInWeaponSlots()) {
            cargo.addWeapons(variant.getWeaponId(slotId), 1);
        }
        int index = 0;
        for (String wingId : variant.getWings()) {
            if (wingId != null && !wingId.isEmpty() && !variant.getHullSpec().isBuiltInWing(index)) {
                cargo.addFighters(wingId, 1);
            }
            ++index;
        }
    }

    public static class PerShipData
    implements Cloneable {
        public ShipCondition condition = ShipCondition.AVERAGE;
        public String variantId = null;
        public ShipVariantAPI variant = null;
        public PersonAPI captain = null;
        public String shipName = null;
        public String fleetMemberId = null;
        public boolean addDmods = true;
        public boolean pruneWeapons = true;
        public Boolean nameAlwaysKnown = null;
        public float sModProb = 0.0f;

        public PerShipData(String variantId, ShipCondition condition) {
            this(variantId, condition, 0.0f);
        }

        public PerShipData(String variantId, ShipCondition condition, float sModProb) {
            this(variantId, condition, "independent", sModProb);
        }

        public PerShipData(ShipVariantAPI variant, ShipCondition condition, String shipName, String factionIdForShipName, float sModProb) {
            this.variant = variant;
            this.condition = condition;
            if (shipName != null) {
                this.shipName = shipName;
            } else {
                FactionAPI faction = Global.getSector().getFaction(factionIdForShipName);
                this.shipName = faction.pickRandomShipName();
            }
            this.sModProb = sModProb;
        }

        public PerShipData(String variantId, ShipCondition condition, String factionIdForShipName, float sModProb) {
            this.variantId = variantId;
            this.condition = condition;
            FactionAPI faction = Global.getSector().getFaction(factionIdForShipName);
            this.shipName = faction.pickRandomShipName();
            this.sModProb = sModProb;
        }

        public ShipVariantAPI getVariant() {
            ShipVariantAPI result = this.variant;
            if (result == null && this.variantId != null) {
                result = Global.getSettings().getVariant(this.variantId);
            }
            return result;
        }

        public PerShipData clone() {
            try {
                return (PerShipData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static enum ShipCondition {
        PRISTINE,
        GOOD,
        AVERAGE,
        BATTERED,
        WRECKED;

    }

    public static class ShipRecoverySpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public List<PerShipData> ships = new ArrayList<PerShipData>();
        public String desc = null;
        public Boolean storyPointRecovery = null;
        public Boolean notNowOptionExits = null;
        public Boolean noDescriptionText = null;

        public ShipRecoverySpecialData(String desc) {
            this.desc = desc;
        }

        public void addShip(PerShipData ship) {
            this.ships.add(ship);
        }

        public void addShip(String variantId, ShipCondition condition, float sModProb) {
            this.ships.add(new PerShipData(variantId, condition, sModProb));
        }

        public void addShip(String variantId, ShipCondition condition, String factionIdForShipName, float sModProb) {
            this.ships.add(new PerShipData(variantId, condition, factionIdForShipName, sModProb));
        }

        @Override
        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new ShipRecoverySpecial();
        }
    }
}

