/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import java.util.ArrayList;
import java.util.List;

public class PersonBountyEventData {
    private List<String> participatingFactions = new ArrayList<String>();
    private int level = 0;
    private int successesThisLevel = 0;

    public PersonBountyEventData() {
        this.addParticipatingFaction("hegemony");
        this.addParticipatingFaction("sindrian_diktat");
        this.addParticipatingFaction("luddic_church");
        this.addParticipatingFaction("tritachyon");
        this.addParticipatingFaction("independent");
        this.addParticipatingFaction("persean");
    }

    public void reportSuccess() {
        ++this.successesThisLevel;
        int threshold = this.getThresholdForLevel(this.level);
        if (this.successesThisLevel >= threshold) {
            ++this.level;
            this.successesThisLevel = 0;
        }
        if (this.level > 10) {
            this.level = 10;
        }
    }

    public int getThresholdForLevel(int level) {
        if (level == 0) {
            return 2;
        }
        if (level == 1) {
            return 2;
        }
        if (level == 2) {
            return 2;
        }
        if (level == 3) {
            return 3;
        }
        if (level == 4) {
            return 3;
        }
        if (level == 5) {
            return 3;
        }
        if (level == 6) {
            return 3;
        }
        if (level == 7) {
            return 4;
        }
        if (level == 8) {
            return 5;
        }
        if (level == 9) {
            return 6;
        }
        return 6;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setSuccessesThisLevel(int successesThisLevel) {
        this.successesThisLevel = successesThisLevel;
    }

    public List<String> getParticipatingFactions() {
        return this.participatingFactions;
    }

    public void addParticipatingFaction(String factionId) {
        this.participatingFactions.add(factionId);
    }

    public void removeParticipatingFaction(String factionId) {
        this.participatingFactions.remove(factionId);
    }

    public boolean isParticipating(String factionId) {
        return this.participatingFactions.contains(factionId);
    }
}

