/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.AICoreOfficerPluginImpl;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.hullmods.Automated;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class AutomatedShips {
    public static float MAX_CR_BONUS = 100.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            int alpha = Math.round(AICoreOfficerPluginImpl.ALPHA_MULT);
            int beta = Math.round(AICoreOfficerPluginImpl.BETA_MULT);
            int gamma = Math.round(AICoreOfficerPluginImpl.GAMMA_MULT);
            return "*The total \"automated ship points\" are equal to the deployment points cost of all automated ships in the fleet, with a multiplier for installed AI cores - " + alpha + "\u00d7" + " for an Alpha Core, " + beta + "\u00d7" + " for a Beta Core, and " + gamma + "\u00d7" + " for a Gamma Core. " + "Due to safety interlocks, ships with AI cores do not contribute to the deployment point distribution.";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            Color bad = Misc.getNegativeHighlightColor();
            return new Color[]{h, h, h, bad};
        }

        @Override
        public String[] getHighlights() {
            int alpha = Math.round(AICoreOfficerPluginImpl.ALPHA_MULT);
            int beta = Math.round(AICoreOfficerPluginImpl.BETA_MULT);
            int gamma = Math.round(AICoreOfficerPluginImpl.GAMMA_MULT);
            return new String[]{alpha + "\u00d7", beta + "\u00d7", gamma + "\u00d7", "do not contribute to the deployment point distribution"};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        @Override
        public FleetTotalItem getFleetTotalItem() {
            return this.getAutomatedPointsTotal();
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (Misc.isAutomated(stats) && !Automated.isAutomatedNoPenalty(stats)) {
                float crBonus = this.computeAndCacheThresholdBonus(stats, "auto_cr", MAX_CR_BONUS, BaseSkillEffectDescription.ThresholdBonusType.AUTOMATED_POINTS);
                SkillSpecAPI skill = Global.getSettings().getSkillSpec("automated_ships");
                stats.getMaxCombatReadiness().modifyFlat(id, crBonus * 0.01f, String.valueOf(skill.getName()) + " skill");
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float crBonus = this.computeAndCacheThresholdBonus(data, stats, "auto_cr", MAX_CR_BONUS, BaseSkillEffectDescription.ThresholdBonusType.AUTOMATED_POINTS);
            String partially = "";
            String penalty = Math.round(Automated.MAX_CR_PENALTY * 100.0f) + "%%";
            if ((float)((int)crBonus) < 100.0f) {
                partially = "partially ";
            }
            info.addPara("+%s combat readiness (maximum: %s); " + partially + "offsets built-in " + penalty + " penalty", 0.0f, this.hc, this.hc, (int)crBonus + "%", (int)MAX_CR_BONUS + "%");
            this.addAutomatedThresholdInfo(info, data, stats);
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            if (stats.isPlayerStats()) {
                Misc.getAllowedRecoveryTags().add("auto_rec");
            }
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            if (stats.isPlayerStats()) {
                Misc.getAllowedRecoveryTags().remove("auto_rec");
            }
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("Enables the recovery of some automated ships, such as derelict drones", this.hc, 0.0f);
            info.addPara("Automated ships can only be captained by AI cores", this.hc, 0.0f);
            info.addSpacer(5.0f);
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

