/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;

public class BulkTransport {
    public static float CARGO_CAPACITY_MAX_PERCENT = 50.0f;
    public static float CARGO_CAPACITY_THRESHOLD = 2000.0f;
    public static float FUEL_CAPACITY_MAX_PERCENT = 50.0f;
    public static float FUEL_CAPACITY_THRESHOLD = 2000.0f;
    public static float PERSONNEL_CAPACITY_MAX_PERCENT = 50.0f;
    public static float PERSONNEL_CAPACITY_THRESHOLD = 5000.0f;
    public static float BURN_BONUS = 2.0f;

    public static abstract class BaseCapacityModifierEffect
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        protected abstract String getModifierId();

        protected abstract String getCacheKey();

        protected abstract String getCapacityString();

        protected abstract float getCapacity(FleetMemberAPI var1);

        protected abstract float getMaxPercent();

        protected abstract float getThreshold();

        protected abstract StatBonus getShipStat(MutableShipStatsAPI var1);

        protected abstract boolean withSpacerAfter();

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = this.getModifierId();
            float capBonus = this.getCapacityBonus(id, BaseCapacityModifierEffect.getFleetData(stats));
            this.getShipStat(stats).modifyMult(id, 1.0f + capBonus / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = this.getModifierId();
            this.getShipStat(stats).unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        protected float getCapacityBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float cap = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                cap += this.getCapacityBase(id, curr);
            }
            return cap;
        }

        protected float getCapacityBase(String id, FleetMemberAPI curr) {
            StatBonus stat = this.getShipStat(curr.getStats());
            MutableStat.StatMod mod = stat.getMultBonus(id);
            if (mod != null) {
                stat.unmodifyMult(mod.source);
            }
            float cap = this.getCapacity(curr);
            if (mod != null) {
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return cap;
        }

        protected float getCapacityBonus(String id, FleetDataAPI data) {
            if (data == null) {
                return this.getMaxPercent();
            }
            String key = this.getCacheKey();
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float base = this.getCapacityBase(id, data);
            bonus = Float.valueOf(this.getThresholdBasedRoundedBonus(this.getMaxPercent(), base, this.getThreshold()));
            data.getCacheClearedOnSync().put(key, bonus);
            return bonus.floatValue();
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = BaseCapacityModifierEffect.getFleetData(null);
            float capBonus = this.getCapacityBonus(this.getModifierId(), data);
            info.addPara("+%s " + this.getCapacityString().toLowerCase() + " (maximum: %s)", 0.0f, this.hc, this.hc, Math.round(capBonus) + "%", (int)this.getMaxPercent() + "%");
            if (BaseCapacityModifierEffect.isInCampaign()) {
                float baseCap = this.getCapacityBase(this.getModifierId(), data);
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less base " + this.getCapacityString().toLowerCase() + " in fleet, your fleet has %s base " + this.getCapacityString().toLowerCase(), 0.0f, this.tc, this.hc, "" + (int)this.getThreshold(), "" + Math.round(baseCap));
            } else {
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less base " + this.getCapacityString().toLowerCase() + " in fleet", 0.0f, this.tc, this.hc, "" + (int)this.getThreshold());
            }
            if (this.withSpacerAfter()) {
                info.addSpacer(5.0f);
            }
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1
    extends BaseCapacityModifierEffect {
        @Override
        public String getModifierId() {
            return "bt_cargo_cap_mod";
        }

        @Override
        public String getCacheKey() {
            return "bt_cargo_cap";
        }

        @Override
        public StatBonus getShipStat(MutableShipStatsAPI stats) {
            return stats.getCargoMod();
        }

        @Override
        public float getCapacity(FleetMemberAPI member) {
            return member.getCargoCapacity();
        }

        @Override
        public String getCapacityString() {
            return "Cargo capacity";
        }

        @Override
        public float getMaxPercent() {
            return CARGO_CAPACITY_MAX_PERCENT;
        }

        @Override
        public float getThreshold() {
            return CARGO_CAPACITY_THRESHOLD;
        }

        @Override
        public boolean withSpacerAfter() {
            return true;
        }
    }

    public static class Level2
    extends BaseCapacityModifierEffect {
        @Override
        public String getModifierId() {
            return "bt_fuel_cap_mod";
        }

        @Override
        public String getCacheKey() {
            return "bt_fuel_cap";
        }

        @Override
        public StatBonus getShipStat(MutableShipStatsAPI stats) {
            return stats.getFuelMod();
        }

        @Override
        public float getCapacity(FleetMemberAPI member) {
            return member.getFuelCapacity();
        }

        @Override
        public String getCapacityString() {
            return "Fuel capacity";
        }

        @Override
        public float getMaxPercent() {
            return FUEL_CAPACITY_MAX_PERCENT;
        }

        @Override
        public float getThreshold() {
            return FUEL_CAPACITY_THRESHOLD;
        }

        @Override
        public boolean withSpacerAfter() {
            return true;
        }
    }

    public static class Level3
    extends BaseCapacityModifierEffect {
        @Override
        public String getModifierId() {
            return "bt_crew_cap_mod";
        }

        @Override
        public String getCacheKey() {
            return "bt_crew_cap";
        }

        @Override
        public StatBonus getShipStat(MutableShipStatsAPI stats) {
            return stats.getMaxCrewMod();
        }

        @Override
        public float getCapacity(FleetMemberAPI member) {
            return member.getMaxCrew();
        }

        @Override
        public String getCapacityString() {
            return "Personnel capacity";
        }

        @Override
        public float getMaxPercent() {
            return PERSONNEL_CAPACITY_MAX_PERCENT;
        }

        @Override
        public float getThreshold() {
            return PERSONNEL_CAPACITY_THRESHOLD;
        }

        @Override
        public boolean withSpacerAfter() {
            return true;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (Level4.isCivilian(stats)) {
                stats.getMaxBurnLevel().modifyFlat(id, BURN_BONUS);
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxBurnLevel().unmodifyFlat(id);
        }

        @Override
        public boolean hasCustomDescription() {
            return false;
        }

        @Override
        public String getEffectDescription(float level) {
            return "Increases the burn level of all non-militarized civilian-grade ships by " + (int)BURN_BONUS;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

