/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class CarrierCommand {
    public static final float FIGHTER_CREW_LOSS_REDUCTION = 20.0f;
    public static final float FIGHTER_RAMAGE_REDUCTION = 20.0f;
    public static final float FIGHTER_REPLACEMENT_RATE_BONUS = 20.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getStat("fighter_crew_loss_mult").modifyMult(id, 0.8f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getStat("fighter_crew_loss_mult").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-20% crew lost due to fighter losses in combat";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHullDamageTakenMult().modifyMult(id, 0.8f);
            stats.getArmorDamageTakenMult().modifyMult(id, 0.8f);
            stats.getShieldDamageTakenMult().modifyMult(id, 0.8f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHullDamageTakenMult().unmodify(id);
            stats.getArmorDamageTakenMult().unmodify(id);
            stats.getShieldDamageTakenMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-20% damage taken";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float timeMult = 0.8333333f;
            stats.getFighterRefitTimeMult().modifyMult(id, timeMult);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFighterRefitTimeMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "20% faster fighter replacements";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

