/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ColonyManagement {
    public static int ADMINS = 1;
    public static int COLONY_NUM_BONUS = 1;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            int baseAdmins = (int)Global.getSector().getPlayerStats().getAdminNumber().getBaseValue();
            int baseOutposts = (int)Global.getSector().getPlayerStats().getOutpostNumber().getBaseValue();
            String colonies = "colonies";
            String admins = "administrators";
            if (baseOutposts == 1) {
                colonies = "colony";
            }
            if (baseAdmins == 1) {
                admins = "administrator";
            }
            return "At a base level, able to manage up to " + baseAdmins + " " + admins + " and to personally govern " + baseOutposts + " " + colonies + ". " + "The maximum number of colonies governed personally can be" + " exceeded at the cost of a stability penalty.";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h, h};
        }

        @Override
        public String[] getHighlights() {
            String baseAdmins = "" + (int)Global.getSector().getPlayerStats().getAdminNumber().getBaseValue();
            String baseOutposts = "" + (int)Global.getSector().getPlayerStats().getOutpostNumber().getBaseValue();
            return new String[]{baseAdmins, baseOutposts};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getOutpostNumber().modifyFlat(id, COLONY_NUM_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getOutpostNumber().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Able to personally govern " + COLONY_NUM_BONUS + " additional colony";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getAdminNumber().modifyFlat(id, ADMINS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getAdminNumber().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Able to manage " + ADMINS + " additional administrator";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }
}

