/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ContainmentProcedures {
    public static float FUEL_PROD_BONUS = 1.0f;
    public static float CREW_LOSS_REDUCTION = 50.0f;
    public static float FUEL_SALVAGE_BONUS = 25.0f;
    public static float FUEL_USE_REDUCTION_MAX_PERCENT = 25.0f;
    public static float FUEL_USE_REDUCTION_MAX_FUEL = 25.0f;
    public static String FUEL_EFFECT_ID = "sp_fuel_use_mod";

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        @Override
        public FleetTotalItem getFleetTotalItem() {
            return this.getOPTotal();
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float lossPercent = this.computeAndCacheThresholdBonus(stats, "sp_crewloss", CREW_LOSS_REDUCTION, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            stats.getCrewLossMult().modifyMult(id, 1.0f - lossPercent * 0.01f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCrewLossMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float damBonus = this.computeAndCacheThresholdBonus(data, stats, "sp_crewloss", CREW_LOSS_REDUCTION, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            info.addPara("-%s crew lost due to hull damage in combat (maximum: %s)", 0.0f, this.hc, this.hc, (int)damBonus + "%", (int)CREW_LOSS_REDUCTION + "%");
            this.addOPThresholdAll(info, data, stats, OP_ALL_THRESHOLD);
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("emergency_burn_mult").modifyMult(id, 0.0f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("emergency_burn_mult").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "The \"Emergency Burn\" ability no longer reduces combat readiness";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").modifyFlat(id, FUEL_SALVAGE_BONUS * 0.01f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            float max = 0.0f;
            return "+" + (int)(max += FUEL_SALVAGE_BONUS) + "% fuel salvaged";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = FUEL_EFFECT_ID;
            float useMult = this.getFuelUseMult(id, Level4.getFleetData(stats));
            stats.getFuelUseMod().modifyMult(id, useMult);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = FUEL_EFFECT_ID;
            stats.getFuelUseMod().unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        protected float getFuelUseBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float fuelUse = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                StatBonus stat = curr.getStats().getFuelUseMod();
                MutableStat.StatMod mod = stat.getMultBonus(id);
                if (mod != null) {
                    stat.unmodifyMult(mod.source);
                }
                fuelUse += curr.getFuelUse();
                if (mod == null) continue;
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return fuelUse;
        }

        protected float getFuelUseMult(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            String key = "conproc1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float fuelUse = this.getFuelUseBase(id, data);
            float useMult = 0.0f;
            if (fuelUse > 0.0f) {
                float maxReduced = Math.min(fuelUse * (FUEL_USE_REDUCTION_MAX_PERCENT * 0.01f), FUEL_USE_REDUCTION_MAX_FUEL);
                useMult = 1.0f - maxReduced / fuelUse;
            }
            data.getCacheClearedOnSync().put(key, Float.valueOf(useMult));
            return useMult;
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addSpacer(5.0f);
            info.addPara("Reduces fuel consumption by %s or %s units, whichever is lower", 0.0f, this.hc, this.hc, (int)FUEL_USE_REDUCTION_MAX_PERCENT + "%", "" + (int)FUEL_USE_REDUCTION_MAX_FUEL);
            if (Level4.isInCampaign()) {
                FleetDataAPI data = Global.getSector().getPlayerFleet().getFleetData();
                String id = FUEL_EFFECT_ID;
                float fuelUse = this.getFuelUseBase(id, data);
                float useMult = this.getFuelUseMult(id, data);
                float reduction = fuelUse * (1.0f - useMult);
                boolean has = stats.getSkillLevel(skill.getId()) > 0.0f;
                String is = "is";
                if (!has) {
                    is = "would be";
                }
                info.addPara(String.valueOf(this.indent) + "Your fleet has a base fuel consumption of %s, which " + is + " reduced by %s, or %s units", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(fuelUse), Math.round((1.0f - useMult) * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(reduction));
                info.addSpacer(5.0f);
            }
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level5
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("fuel_supply_bonus").modifyFlat(id, FUEL_PROD_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("fuel_supply_bonus").unmodifyFlat(id);
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "governed colony");
            info.addSpacer(opad);
            info.addPara("+%s fuel production", 0.0f, this.hc, this.hc, "" + (int)FUEL_PROD_BONUS);
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }
}

