/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class DamageControl {
    public static float SECONDS_PER_PROC = 2.0f;
    public static float INSTA_REPAIR = 0.25f;
    public static float CREW_LOSS_REDUCTION = 50.0f;
    public static float MODULE_REPAIR_BONUS = 50.0f;
    public static float HULL_DAMAGE_REDUCTION = 25.0f;
    public static float EMP_DAMAGE_REDUCTION = 25.0f;
    public static float ELITE_DAMAGE_THRESHOLD = 500.0f;
    public static float ELITE_DAMAGE_REDUCTION_PERCENT = 60.0f;
    public static float ELITE_DAMAGE_TO_HULL_PERCENT = 15.0f;

    public static class DamageControlDamageTakenMod
    implements DamageTakenModifier,
    AdvanceableListener {
        protected ShipAPI ship;
        protected float sinceProc = SECONDS_PER_PROC + 1.0f;

        public DamageControlDamageTakenMod(ShipAPI ship) {
            this.ship = ship;
        }

        @Override
        public void advance(float amount) {
            this.sinceProc += amount;
        }

        @Override
        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (!shieldHit && this.sinceProc > SECONDS_PER_PROC) {
                float mult = 1.0f - ELITE_DAMAGE_REDUCTION_PERCENT / 100.0f;
                this.ship.setNextHitHullDamageThresholdMult(ELITE_DAMAGE_THRESHOLD, mult);
                this.sinceProc = 0.0f;
            }
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").modifyFlat(id, 1000.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "If lost in combat, ship is almost always recoverable";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCrewLossMult().modifyMult(id, 1.0f - CREW_LOSS_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCrewLossMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)CREW_LOSS_REDUCTION + "% crew lost due to hull damage in combat";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float timeMult = 1.0f / ((100.0f + MODULE_REPAIR_BONUS) / 100.0f);
            stats.getCombatWeaponRepairTimeMult().modifyMult(id, timeMult);
            stats.getCombatEngineRepairTimeMult().modifyMult(id, timeMult);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCombatWeaponRepairTimeMult().unmodify(id);
            stats.getCombatEngineRepairTimeMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return (int)MODULE_REPAIR_BONUS + "% faster in-combat weapon and engine repairs";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHullDamageTakenMult().modifyMult(id, 1.0f - HULL_DAMAGE_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHullDamageTakenMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)HULL_DAMAGE_REDUCTION + "% hull damage taken";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("insta_repair_fraction").modifyFlat(id, INSTA_REPAIR);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("insta_repair_fraction").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return Math.round(INSTA_REPAIR * 100.0f) + "% of hull and armor damage taken repaired after combat ends, at no cost";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    extends BaseSkillEffectDescription
    implements AfterShipCreationSkillEffect {
        @Override
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new DamageControlDamageTakenMod(ship));
        }

        @Override
        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.removeListenerOfClass(DamageControlDamageTakenMod.class);
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            Color c = this.hc;
            float level = stats.getSkillLevel(skill.getId());
            if (level < 2.0f) {
                c = this.dhc;
            }
            String seconds = (int)SECONDS_PER_PROC + " seconds";
            if (SECONDS_PER_PROC == 1.0f) {
                seconds = "second";
            }
            info.addPara("At most once every " + seconds + ", single-hit hull damage above %s points has the portion above %s reduced by %s", 0.0f, c, c, "" + (int)ELITE_DAMAGE_THRESHOLD, "" + (int)ELITE_DAMAGE_THRESHOLD, (int)ELITE_DAMAGE_REDUCTION_PERCENT + "%");
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level7
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToTargetHullMult().modifyPercent(id, ELITE_DAMAGE_TO_HULL_PERCENT);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToTargetHullMult().unmodifyPercent(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)ELITE_DAMAGE_TO_HULL_PERCENT + "% damage dealt to hull";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level8
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("can_repair_modules_under_fire").modifyFlat(id, 1.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("can_repair_modules_under_fire").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Repairs of damaged but functional weapons and engines can continue while they are under fire*";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level8Desc
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            return "\n\n*Normally, a damaged but functional module will not be repaired until 5 seconds have passed without it taking damage.";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        @Override
        public String[] getHighlights() {
            return new String[]{"5"};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }
}

