/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.ElectronicWarfareScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ElectronicWarfare {
    public static float PER_SHIP_BONUS = 1.0f;
    public static float CAP_RANGE = 500.0f;
    public static float CAP_RATE = 5.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            String max = String.valueOf((int)ElectronicWarfareScript.BASE_MAXIMUM) + "%";
            return "*Enemy weapon range is reduced by the total ECM rating of your deployed ships, up to a maximum of " + max + ". This penalty is reduced by the ratio " + "of the enemy ECM rating to yours." + "Does not apply to fighters, affects all weapons including missiles.";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h, h};
        }

        @Override
        public String[] getHighlights() {
            String max = String.valueOf((int)ElectronicWarfareScript.BASE_MAXIMUM) + "%";
            return new String[]{max};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level0WithNewline
    extends Level0 {
        @Override
        public String getString() {
            return "\n" + super.getString();
        }
    }

    public static class Level1A
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!BaseSkillEffectDescription.isCivilian(stats)) {
                stats.getDynamic().getMod("electronic_warfare_flat").modifyFlat(id, PER_SHIP_BONUS);
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_flat").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Every deployed combat ship contributes +" + (int)PER_SHIP_BONUS + "% to ECM rating* of fleet";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level1B
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!BaseSkillEffectDescription.isCivilian(stats)) {
                stats.getDynamic().getMod("ship_objective_cap_range_mod").modifyFlat(id, CAP_RANGE);
                stats.getDynamic().getStat("ship_objective_cap_rate_mult").modifyMult(id, CAP_RATE);
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("ship_objective_cap_range_mod").unmodifyFlat(id);
            stats.getDynamic().getStat("ship_objective_cap_rate_mult").unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Combat objectives are captured much more quickly and from longer range";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level1C
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("ship_belongs_to_fleet_that_can_counter_ew").modifyFlat(id, 1.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("ship_belongs_to_fleet_that_can_counter_ew").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            String excess = "" + Math.round(ElectronicWarfareScript.BASE_MAXIMUM * 2.0f);
            return "Half of your fleet's excess (above " + excess + "%) ECM rating reduces the maximum range penalty due to enemy ECM";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

