/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class IndustrialPlanning {
    public static int SUPPLY_BONUS = 1;
    public static float CUSTOM_PRODUCTION_BONUS = 50.0f;

    public static class Level1
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("supply_bonus").modifyFlat(id, SUPPLY_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("supply_bonus").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "All industries supply " + SUPPLY_BONUS + " more unit of all the commodities they produce";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("custom_production_mod").modifyMult(id, 1.0f + CUSTOM_PRODUCTION_BONUS / 100.0f, "Industrial planning");
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("custom_production_mod").unmodifyMult(id);
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "all colonies");
            info.addSpacer(opad);
            info.addPara("+%s maximum value of custom ship and weapon production per month", 0.0f, this.hc, this.hc, (int)CUSTOM_PRODUCTION_BONUS + "%");
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_OUTPOSTS;
        }
    }
}

