/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class MissileSpecialization {
    public static final float MISSILE_AMMO_BONUS = 100.0f;
    public static final float MISSILE_SPEC_PERK_HEALTH_BONUS = 25.0f;
    public static final float MISSILE_SPEC_ROF_BONUS = 25.0f;
    public static final float MISSILE_SPEC_AMMO_REGEN_BONUS = 25.0f;
    public static final float MISSILE_SPEC_DAMAGE_BONUS = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileAmmoBonus().modifyPercent(id, 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileAmmoBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+100% missile weapon ammo capacity";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileHealthBonus().modifyPercent(id, 25.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileHealthBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+25% missile hitpoints";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileRoFMult().modifyPercent(id, 25.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileRoFMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+25% rate of fire for missile weapons";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3A
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileAmmoRegenMult().modifyPercent(id, 25.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileAmmoRegenMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+25% missile weapon ammo regeneration rate (only for missile weapons that regenerate ammo)";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileWeaponDamageMult().modifyPercent(id, 10.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileWeaponDamageMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+10% damage dealt by missile weapons";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

