/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class OfficerManagement {
    public static float NUM_OFFICERS_BONUS = 2.0f;
    public static float CP_BONUS = 2.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            int baseOfficers = (int)Global.getSector().getPlayerStats().getOfficerNumber().getBaseValue();
            return "*The base maximum number of officers you're able to command is " + baseOfficers + ".";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        @Override
        public String[] getHighlights() {
            String baseOfficers = "" + (int)Global.getSector().getPlayerStats().getOfficerNumber().getBaseValue();
            return new String[]{baseOfficers};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getOfficerNumber().modifyFlat(id, NUM_OFFICERS_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getOfficerNumber().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)NUM_OFFICERS_BONUS + " to maximum number of officers* you're able to command";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level1B
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getCommandPoints().modifyFlat(id, CP_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getCommandPoints().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)CP_BONUS + " command points";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

