/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MarketSkillEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class PlanetaryOperations {
    public static int ATTACK_BONUS = 100;
    public static int DEFEND_BONUS = 100;
    public static float CASUALTIES_MULT = 0.75f;
    public static float STABILITY_BONUS = 2.0f;

    public static class Level1
    implements MarketSkillEffect {
        @Override
        public void apply(MarketAPI market, String id, float level) {
            market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(id, 1.0f + (float)DEFEND_BONUS * 0.01f, "Ground operations");
        }

        @Override
        public void unapply(MarketAPI market, String id) {
            market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + DEFEND_BONUS + "% effectiveness of ground defenses";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level2
    implements MarketSkillEffect {
        @Override
        public void apply(MarketAPI market, String id, float level) {
            market.getStability().modifyFlat(id, STABILITY_BONUS, "Ground operations");
        }

        @Override
        public void unapply(MarketAPI market, String id) {
            market.getStability().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)STABILITY_BONUS + " stability";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level3
    extends BaseSkillEffectDescription
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ground_attack_mod").modifyPercent(id, ATTACK_BONUS, "Ground operations");
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ground_attack_mod").unmodifyPercent(id);
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "fleet");
            info.addSpacer(opad);
            info.addPara("+%s effectiveness of ground operations such as raids", 0.0f, this.hc, this.hc, ATTACK_BONUS + "%");
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + ATTACK_BONUS + "% effectiveness of ground operations such as raids";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("ground_attack_casualties_mult").modifyMult(id, CASUALTIES_MULT, "Ground operations");
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("ground_attack_casualties_mult").unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + Math.round((1.0f - CASUALTIES_MULT) * 100.0f) + "% marine casualties suffered during ground operations such as raids";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

