/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MarketSkillEffect;

public class SpaceOperations {
    public static final float ACCESS = 0.3f;
    public static final float FLEET_SIZE = 25.0f;

    public static class Level1
    implements MarketSkillEffect {
        @Override
        public void apply(MarketAPI market, String id, float level) {
            market.getAccessibilityMod().modifyFlat(id, 0.3f, "Space operations");
        }

        @Override
        public void unapply(MarketAPI market, String id) {
            market.getAccessibilityMod().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + Math.round(30.000002f) + "% accessibility";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level2
    implements MarketSkillEffect {
        @Override
        public void apply(MarketAPI market, String id, float level) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat(id, 0.25f, "Fleet logistics");
        }

        @Override
        public void unapply(MarketAPI market, String id) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + Math.round(25.0f) + "% fleet size";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }
}

