/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SpecialModifications {
    public static int VENTS_BONUS = 10;
    public static int CAPACITORS_BONUS = 10;
    public static int EXTRA_MODS = 1;
    public static float BUILD_IN_XP_BONUS = 0.2f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            int max = Misc.MAX_PERMA_MODS;
            return "*The base maximum number of permanent hullmods you're able to build into a ship is " + max + ".";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h, h};
        }

        @Override
        public String[] getHighlights() {
            int max = Misc.MAX_PERMA_MODS;
            return new String[]{"" + max};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxCapacitorsBonus().modifyFlat(id, CAPACITORS_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxCapacitorsBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + CAPACITORS_BONUS + " maximum flux capacitors";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxVentsBonus().modifyFlat(id, VENTS_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxVentsBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + VENTS_BONUS + " maximum flux vents";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("build_in_bonus_xp_mod").modifyFlat(id, BUILD_IN_XP_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("build_in_bonus_xp_mod").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + Math.round(BUILD_IN_XP_BONUS * 100.0f) + "% bonus experience from building permanent hullmods* into ships";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("max_permanent_hullmods_mod").modifyFlat(id, EXTRA_MODS);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("max_permanent_hullmods_mod").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Able to build " + EXTRA_MODS + " more permanent hullmod* into ships";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

