/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class SystemsExpertise {
    public static float BONUS_CHARGES = 1.0f;
    public static float REGEN_PERCENT = 50.0f;
    public static float SYSTEM_COOLDOWN_REDUCTION_PERCENT = 33.0f;
    public static float RANGE_PERCENT = 50.0f;
    public static float PEAK_TIME_BONUS = 30.0f;
    public static float OVERLOAD_REDUCTION = 25.0f;
    public static float MALFUNCTION_CHANCE_MULT = 0.5f;
    public static float ELITE_DAMAGE_REDUCTION = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemUsesBonus().modifyFlat(id, BONUS_CHARGES);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemUsesBonus().unmodifyPercent(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "If the ship's system has charges: +1 charge";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemRegenBonus().modifyPercent(id, REGEN_PERCENT);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemRegenBonus().unmodifyPercent(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "If the ship's system regenerates charges: +" + (int)REGEN_PERCENT + "% regeneration rate";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemRangeBonus().modifyPercent(id, RANGE_PERCENT);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemRangeBonus().unmodifyPercent(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "If the ship's system has range: +" + (int)RANGE_PERCENT + "% range";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemCooldownBonus().modifyMult(id, 1.0f - SYSTEM_COOLDOWN_REDUCTION_PERCENT / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemCooldownBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "If the ship's system has a cooldown: -" + (int)SYSTEM_COOLDOWN_REDUCTION_PERCENT + "% cooldown";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPeakCRDuration().modifyFlat(id, PEAK_TIME_BONUS);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)PEAK_TIME_BONUS + " seconds peak operating time";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getOverloadTimeMod().modifyMult(id, 1.0f - OVERLOAD_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getOverloadTimeMod().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)OVERLOAD_REDUCTION + "% overload duration";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level7
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getWeaponMalfunctionChance().modifyMult(id, MALFUNCTION_CHANCE_MULT);
            stats.getEngineMalfunctionChance().modifyMult(id, MALFUNCTION_CHANCE_MULT);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getWeaponMalfunctionChance().unmodifyMult(id);
            stats.getEngineMalfunctionChance().unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            String percent = Math.round((1.0f - MALFUNCTION_CHANCE_MULT) * 100.0f) + "%";
            return "Chance of malfunctions when at low combat readiness reduced by " + percent;
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level8
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getArmorDamageTakenMult().modifyMult(id, 1.0f - ELITE_DAMAGE_REDUCTION / 100.0f);
            stats.getHullDamageTakenMult().modifyMult(id, 1.0f - ELITE_DAMAGE_REDUCTION / 100.0f);
            stats.getShieldDamageTakenMult().modifyMult(id, 1.0f - ELITE_DAMAGE_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getArmorDamageTakenMult().unmodifyMult(id);
            stats.getHullDamageTakenMult().unmodifyMult(id);
            stats.getShieldDamageTakenMult().unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            String percent = "-" + (int)ELITE_DAMAGE_REDUCTION + "%";
            return String.valueOf(percent) + " damage taken";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

