/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class OpenMarketPlugin
extends BaseSubmarketPlugin {
    public static float ECON_UNIT_MULT_EXTRA = 1.0f;
    public static float ECON_UNIT_MULT_PRODUCTION = 0.4f;
    public static float ECON_UNIT_MULT_IMPORTS = 0.1f;
    public static float ECON_UNIT_MULT_DEFICIT = -0.2f;
    public static Set<String> SPECIAL_COMMODITIES = new HashSet<String>();

    static {
        SPECIAL_COMMODITIES.add("supplies");
        SPECIAL_COMMODITIES.add("fuel");
        SPECIAL_COMMODITIES.add("crew");
        SPECIAL_COMMODITIES.add("marines");
        SPECIAL_COMMODITIES.add("heavy_machinery");
    }

    @Override
    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    @Override
    public void updateCargoPrePlayerInteraction() {
        float seconds = Global.getSector().getClock().convertToSeconds(this.sinceLastCargoUpdate);
        this.addAndRemoveStockpiledResources(seconds, false, true, true);
        this.sinceLastCargoUpdate = 0.0f;
        if (this.okToUpdateShipsAndWeapons()) {
            this.sinceSWUpdate = 0.0f;
            boolean military = Misc.isMilitary(this.market);
            boolean hiddenBase = this.market.getMemoryWithoutUpdate().getBoolean(MemFlags.HIDDEN_BASE_MEM_FLAG);
            float extraShips = 0.0f;
            if (military && hiddenBase && !this.market.hasSubmarket("generic_military")) {
                extraShips = 150.0f;
            }
            this.pruneWeapons(0.0f);
            int weapons = 5 + Math.max(0, this.market.getSize() - 1) + (Misc.isMilitary(this.market) ? 5 : 0);
            int fighters = 1 + Math.max(0, (this.market.getSize() - 3) / 2) + (Misc.isMilitary(this.market) ? 2 : 0);
            this.addWeapons(weapons, weapons + 2, 0, this.market.getFactionId());
            this.addFighters(fighters, fighters + 2, 0, this.market.getFactionId());
            this.getCargo().getMothballedShips().clear();
            float freighters = 10.0f;
            CommodityOnMarketAPI com = this.market.getCommodityData("ships");
            freighters += (float)com.getMaxSupply() * 2.0f;
            if (freighters > 30.0f) {
                freighters = 30.0f;
            }
            this.addShips(this.market.getFactionId(), 10.0f + extraShips, freighters, 0.0f, 10.0f, 10.0f, 5.0f, null, 0.0f, FactionAPI.ShipPickMode.PRIORITY_THEN_ALL, null);
            this.addShips(this.market.getFactionId(), 40.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, -1.0f, null, null, 4);
            float tankers = 20.0f;
            com = this.market.getCommodityData("fuel");
            tankers += (float)com.getMaxSupply() * 3.0f;
            if (tankers > 40.0f) {
                tankers = 40.0f;
            }
            this.addShips(this.market.getFactionId(), 0.0f, 0.0f, tankers, 0.0f, 0.0f, 0.0f, null, 0.0f, FactionAPI.ShipPickMode.PRIORITY_THEN_ALL, null);
            this.addHullMods(1, 1 + this.itemGenRandom.nextInt(3), this.market.getFactionId());
        }
        this.getCargo().sort();
    }

    protected Object writeReplace() {
        if (this.okToUpdateShipsAndWeapons()) {
            this.pruneWeapons(0.0f);
            this.getCargo().getMothballedShips().clear();
        }
        return this;
    }

    @Override
    public boolean shouldHaveCommodity(CommodityOnMarketAPI com) {
        return !this.market.isIllegal(com);
    }

    @Override
    public int getStockpileLimit(CommodityOnMarketAPI com) {
        float limit = OpenMarketPlugin.getBaseStockpileLimit(com);
        Random random = new Random(this.market.getId().hashCode() + this.submarket.getSpecId().hashCode() + Global.getSector().getClock().getMonth() * 170000);
        limit *= 0.9f + 0.2f * random.nextFloat();
        float sm = this.market.getStabilityValue() / 10.0f;
        if ((limit *= 0.25f + 0.75f * sm) < 0.0f) {
            limit = 0.0f;
        }
        return (int)limit;
    }

    public static float getBaseStockpileLimit(CommodityOnMarketAPI com) {
        int shippingGlobal = Global.getSettings().getShippingCapacity(com.getMarket(), false);
        int available = com.getAvailable();
        int production = com.getMaxSupply();
        production = Math.min(production, available);
        int demand = com.getMaxDemand();
        int export = Math.min(production, shippingGlobal);
        int extra = available - Math.max(export, demand);
        if (extra < 0) {
            extra = 0;
        }
        int deficit = Math.max(0, demand - available);
        float unit = com.getCommodity().getEconUnit();
        int imports = available - production;
        if (imports < 0) {
            imports = 0;
        }
        float limit = 0.0f;
        limit += (float)imports * unit * ECON_UNIT_MULT_IMPORTS;
        limit += (float)production * unit * ECON_UNIT_MULT_PRODUCTION;
        limit += (float)extra * unit * ECON_UNIT_MULT_EXTRA;
        if ((limit -= (float)deficit * unit * ECON_UNIT_MULT_DEFICIT) < 0.0f) {
            limit = 0.0f;
        }
        return (int)limit;
    }

    public static int getApproximateStockpileLimit(CommodityOnMarketAPI com) {
        float limit = OpenMarketPlugin.getBaseStockpileLimit(com);
        return (int)limit;
    }

    @Override
    public SubmarketPlugin.PlayerEconomyImpactMode getPlayerEconomyImpactMode() {
        return SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_SELL_ONLY;
    }

    @Override
    public boolean isOpenMarket() {
        return true;
    }

    @Override
    public String getTooltipAppendix(CoreUIAPI ui) {
        if (ui.getTradeMode() == CampaignUIAPI.CoreUITradeMode.SNEAK) {
            return "Requires: proper docking authorization (transponder on)";
        }
        return super.getTooltipAppendix(ui);
    }

    @Override
    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        if (ui.getTradeMode() == CampaignUIAPI.CoreUITradeMode.SNEAK) {
            String appendix = this.getTooltipAppendix(ui);
            if (appendix == null) {
                return null;
            }
            Highlights h = new Highlights();
            h.setText(appendix);
            h.setColors(Misc.getNegativeHighlightColor());
            return h;
        }
        return super.getTooltipAppendixHighlights(ui);
    }
}

