/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidImpact;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidSource;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RingRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class AsteroidBeltTerrainPlugin
extends BaseRingTerrain
implements AsteroidSource {
    private transient RingRenderer rr;
    protected boolean needToCreateAsteroids = true;
    public AsteroidBeltParams params;

    @Override
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    @Override
    public void renderOnMap(float factor, float alphaMult) {
        if (this.params == null) {
            return;
        }
        if (this.rr == null) {
            this.rr = new RingRenderer("systemMap", "map_asteroid_belt");
        }
        Color color = Global.getSettings().getColor("asteroidBeltMapColor");
        float bandWidth = this.params.bandWidthInEngine;
        bandWidth = 300.0f;
        this.rr.render(this.entity.getLocation(), this.params.middleRadius - bandWidth * 0.5f, this.params.middleRadius + bandWidth * 0.5f, color, false, factor, alphaMult);
    }

    @Override
    public void regenerateAsteroids() {
        this.createAsteroids();
    }

    protected void createAsteroids() {
        if (!(this.params instanceof AsteroidBeltParams)) {
            return;
        }
        Random rand = new Random(Global.getSector().getClock().getTimestamp() + (long)this.entity.getId().hashCode());
        LocationAPI location = this.entity.getContainingLocation();
        int i = 0;
        while (i < this.params.numAsteroids) {
            float size = this.params.minSize + rand.nextFloat() * (this.params.maxSize - this.params.minSize);
            AsteroidAPI asteroid = location.addAsteroid(size);
            asteroid.setFacing(rand.nextFloat() * 360.0f);
            float currRadius = this.params.middleRadius - this.params.bandWidthInEngine / 2.0f + rand.nextFloat() * this.params.bandWidthInEngine;
            float angle = rand.nextFloat() * 360.0f;
            float orbitDays = this.params.minOrbitDays + rand.nextFloat() * (this.params.maxOrbitDays - this.params.minOrbitDays);
            asteroid.setCircularOrbit(this.entity, angle, currRadius, orbitDays);
            Misc.setAsteroidSource(asteroid, this);
            ++i;
        }
        this.needToCreateAsteroids = false;
    }

    @Override
    public void advance(float amount) {
        if (this.needToCreateAsteroids) {
            this.createAsteroids();
        }
        super.advance(amount);
    }

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        if (param instanceof AsteroidBeltParams) {
            this.params = (AsteroidBeltParams)param;
            this.name = this.params.name;
            if (this.name == null) {
                this.name = "Asteroid Belt";
            }
        }
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            if (Misc.isSlowMoving(fleet)) {
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_2", "Hiding inside " + this.getNameForTooltip().toLowerCase(), RingSystemTerrainPlugin.getVisibilityMult(fleet), fleet.getStats().getDetectedRangeMod());
            }
            if (!fleet.isInHyperspaceTransition()) {
                String key = "$asteroidImpactTimeout";
                String sKey = "$skippedImpacts";
                String recentKey = "$recentImpact";
                float probPerSkip = 0.15f;
                float maxProb = 1.0f;
                float maxSkipsToTrack = 7.0f;
                float durPerSkip = 0.2f;
                MemoryAPI mem = fleet.getMemoryWithoutUpdate();
                if (!mem.contains(key)) {
                    float expire2 = mem.getExpire(sKey);
                    if (expire2 < 0.0f) {
                        expire2 = 0.0f;
                    }
                    float hitProb = Misc.getFleetRadiusTerrainEffectMult(fleet) * 0.5f;
                    hitProb = 0.5f;
                    hitProb = expire2 / durPerSkip * probPerSkip;
                    if (hitProb > maxProb) {
                        hitProb = maxProb;
                    }
                    if ((float)Math.random() < hitProb) {
                        boolean hadRecent = mem.is(recentKey, true);
                        fleet.addScript(new AsteroidImpact(fleet, hadRecent &= (float)Math.random() > 0.5f));
                        mem.set(sKey, true, 0.0f);
                        mem.set(recentKey, true, 0.5f + 1.0f * (float)Math.random());
                    } else {
                        mem.set(sKey, true, Math.min(expire2 + durPerSkip, maxSkipsToTrack * durPerSkip));
                    }
                    mem.set(key, true, (float)((double)0.05f + (double)0.1f * Math.random()));
                }
            }
        }
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public String getNameForTooltip() {
        return "Asteroid Belt";
    }

    @Override
    public String getNameAOrAn() {
        return "an";
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.getNameForTooltip());
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("Chance of asteroid impacts that briefly knock the fleet off course and may occasionally impact ships directly, dealing moderate damage.", nextPad);
        tooltip.addPara("Smaller fleets are usually able to avoid the heavier impacts, and slow-moving fleets do not risk impacts at all.", pad, highlight, "slow-moving");
        String stop = Global.getSettings().getControlStringForEnumName("GO_SLOW");
        tooltip.addPara("Reduces the range at which stationary or slow-moving* fleets inside it can be detected by %s.", nextPad, highlight, (int)((1.0f - RingSystemTerrainPlugin.getVisibilityMult(Global.getSector().getPlayerFleet())) * 100.0f) + "%");
        tooltip.addPara("*Press and hold %s to stop; combine with holding the left mouse button down to move slowly. A slow-moving fleet moves at a burn level of half that of its slowest ship.", nextPad, Misc.getGrayColor(), highlight, stop);
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("Numerous asteroids present on the battlefield. Large enough to be an in-combat navigational hazard.", small);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getEffectCategory() {
        return "asteroid_belt";
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.REDUCES_SPEED_LARGE || flag == TerrainAIFlags.DANGEROUS_UNLESS_GO_SLOW || flag == TerrainAIFlags.NOT_SUPER_DANGEROUS_UNLESS_GO_SLOW;
    }

    @Override
    public void reportAsteroidPersisted(SectorEntityToken asteroid) {
        if (Misc.getAsteroidSource(asteroid) == this) {
            --this.params.numAsteroids;
        }
    }

    public static class AsteroidBeltParams
    extends BaseRingTerrain.RingParams {
        public int numAsteroids;
        public float minOrbitDays;
        public float maxOrbitDays;
        public float minSize;
        public float maxSize;

        public AsteroidBeltParams(int numAsteroids, float orbitRadius, float width, float minOrbitDays, float maxOrbitDays, float minSize, float maxSize, String name) {
            super(width, orbitRadius, null, name);
            this.numAsteroids = numAsteroids;
            this.minOrbitDays = minOrbitDays;
            this.maxOrbitDays = maxOrbitDays;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }
    }
}

