/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.RangeBlockerUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class AuroraRenderer {
    private AuroraRendererDelegate delegate;
    private float phaseAngle;

    public AuroraRenderer(AuroraRendererDelegate delegate) {
        this.delegate = delegate;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.phaseAngle += days * 360.0f * 0.5f;
        this.phaseAngle = Misc.normalizeAngle(this.phaseAngle);
    }

    public void render(float alphaMult) {
        if (alphaMult <= 0.0f) {
            return;
        }
        float bandWidthInTexture = this.delegate.getAuroraBandWidthInTexture();
        float radStart = this.delegate.getAuroraInnerRadius();
        float radEnd = this.delegate.getAuroraOuterRadius();
        if (radEnd < radStart + 10.0f) {
            radEnd = radStart + 10.0f;
        }
        float circ = (float)(Math.PI * 2 * (double)(radStart + radEnd) / 2.0);
        float pixelsPerSegment = 50.0f;
        float segments = Math.round(circ / pixelsPerSegment);
        float startRad = (float)Math.toRadians(0.0);
        float endRad = (float)Math.toRadians(360.0);
        float spanRad = Math.abs(endRad - startRad);
        float anglePerSegment = spanRad / segments;
        Vector2f loc = this.delegate.getAuroraCenterLoc();
        float x = loc.x;
        float y = loc.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glEnable((int)3553);
        this.delegate.getAuroraTexture().bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float thickness = (radEnd - radStart) * 1.0f;
        float radius = radStart;
        float texProgress = 0.0f;
        float texHeight = this.delegate.getAuroraTexture().getTextureHeight();
        float imageHeight = this.delegate.getAuroraTexture().getHeight();
        float texPerSegment = pixelsPerSegment * texHeight / imageHeight * bandWidthInTexture / thickness;
        float totalTex = Math.max(1.0f, (float)Math.round((texPerSegment *= this.delegate.getAuroraTexPerSegmentMult()) * segments));
        texPerSegment = totalTex / segments;
        float texWidth = this.delegate.getAuroraTexture().getTextureWidth();
        float imageWidth = this.delegate.getAuroraTexture().getWidth();
        RangeBlockerUtil blocker = this.delegate.getAuroraBlocker();
        int iter = 0;
        while (iter < 2) {
            float bandIndex = iter == 0 ? 1.0f : 0.0f;
            float leftTX = bandIndex * texWidth * bandWidthInTexture / imageWidth;
            float rightTX = (bandIndex + 1.0f) * texWidth * bandWidthInTexture / imageWidth - 0.001f;
            GL11.glBegin((int)8);
            float i = 0.0f;
            while (i < segments + 1.0f) {
                float segIndex = i % (float)((int)segments);
                float phaseAngleRad = iter == 0 ? (float)Math.toRadians(this.phaseAngle) + segIndex * anglePerSegment * 10.0f : (float)Math.toRadians(-this.phaseAngle) + segIndex * anglePerSegment * 5.0f;
                float angle = (float)Math.toDegrees(segIndex * anglePerSegment);
                if (iter == 1) {
                    angle += 180.0f;
                }
                float blockerMax = 100000.0f;
                if (blocker != null) {
                    blockerMax = blocker.getCurrMaxAt(angle);
                    if ((blockerMax *= 0.75f) > blocker.getMaxRange()) {
                        blockerMax = blocker.getMaxRange();
                    }
                }
                float pulseSin = (float)Math.sin(phaseAngleRad);
                float pulseMax = thickness * this.delegate.getAuroraShortenMult(angle);
                if (pulseMax > blockerMax * 0.5f) {
                    pulseMax = blockerMax * 0.5f;
                }
                float pulseAmount = pulseSin * pulseMax;
                float pulseInner = pulseAmount * 0.1f;
                pulseInner *= this.delegate.getAuroraInnerOffsetMult(angle);
                float r = radius;
                float thicknessMult = this.delegate.getAuroraThicknessMult(angle);
                float thicknessFlat = this.delegate.getAuroraThicknessFlat(angle);
                float theta = anglePerSegment * segIndex;
                float cos = (float)Math.cos(theta);
                float sin = (float)Math.sin(theta);
                float rInner = r - pulseInner;
                if (rInner < r * 0.9f) {
                    rInner = r * 0.9f;
                }
                float rOuter = r + thickness * thicknessMult - pulseAmount + thicknessFlat;
                if (blocker != null) {
                    if (rOuter > blockerMax - pulseAmount && (rOuter = blockerMax - pulseAmount) < r) {
                        rOuter = r;
                    }
                    if (rInner > rOuter) {
                        rInner = rOuter;
                    }
                }
                float x1 = cos * rInner;
                float y1 = sin * rInner;
                float x2 = cos * rOuter;
                float y2 = sin * rOuter;
                x2 += (float)(Math.cos(phaseAngleRad) * (double)pixelsPerSegment * (double)0.33f);
                y2 += (float)(Math.sin(phaseAngleRad) * (double)pixelsPerSegment * (double)0.33f);
                Color color = this.delegate.getAuroraColorForAngle(angle);
                float alpha = this.delegate.getAuroraAlphaMultForAngle(angle);
                if (blocker != null) {
                    alpha *= blocker.getAlphaAt(angle);
                }
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * alpha)));
                GL11.glTexCoord2f((float)leftTX, (float)texProgress);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)rightTX, (float)texProgress);
                GL11.glVertex2f((float)x2, (float)y2);
                texProgress += texPerSegment * 1.0f;
                i += 1.0f;
            }
            GL11.glEnd();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ++iter;
        }
        GL11.glPopMatrix();
    }

    public float getRenderDistMax(float angle) {
        float radStart = this.delegate.getAuroraInnerRadius();
        float radEnd = this.delegate.getAuroraOuterRadius();
        if (radEnd < radStart + 10.0f) {
            radEnd = radStart + 10.0f;
        }
        float angleRad = (float)Math.toRadians(angle);
        float thickness = (radEnd - radStart) * 1.0f;
        float radius = radStart;
        RangeBlockerUtil blocker = this.delegate.getAuroraBlocker();
        float max = 0.0f;
        int i = 0;
        while (i < 2) {
            float phaseAngleRad;
            if (i == 0) {
                phaseAngleRad = (float)Math.toRadians(this.phaseAngle) + angleRad * 10.0f;
            } else {
                phaseAngleRad = (float)Math.toRadians(-this.phaseAngle) + angle * 5.0f;
                angle += 180.0f;
            }
            float blockerMax = 100000.0f;
            if (blocker != null) {
                blockerMax = blocker.getCurrMaxAt(angle);
                if ((blockerMax *= 1.5f) > blocker.getMaxRange()) {
                    blockerMax = blocker.getMaxRange();
                }
            }
            float pulseSin = (float)Math.sin(phaseAngleRad);
            float pulseMax = thickness * this.delegate.getAuroraShortenMult(angle);
            if (pulseMax > blockerMax * 0.5f) {
                pulseMax = blockerMax * 0.5f;
            }
            float pulseAmount = pulseSin * pulseMax;
            float thicknessMult = this.delegate.getAuroraThicknessMult(angle);
            float thicknessFlat = this.delegate.getAuroraThicknessFlat(angle);
            float rOuter = radius + thickness * thicknessMult - pulseAmount + thicknessFlat;
            if (blocker != null && rOuter > blockerMax - pulseAmount && (rOuter = blockerMax - pulseAmount) < radius) {
                rOuter = radius;
            }
            if (rOuter > max) {
                max = rOuter;
            }
            ++i;
        }
        return max;
    }

    public static interface AuroraRendererDelegate {
        public float getAuroraInnerRadius();

        public float getAuroraOuterRadius();

        public Vector2f getAuroraCenterLoc();

        public Color getAuroraColorForAngle(float var1);

        public float getAuroraAlphaMultForAngle(float var1);

        public float getAuroraShortenMult(float var1);

        public float getAuroraInnerOffsetMult(float var1);

        public float getAuroraThicknessMult(float var1);

        public float getAuroraThicknessFlat(float var1);

        public float getAuroraTexPerSegmentMult();

        public float getAuroraBandWidthInTexture();

        public SpriteAPI getAuroraTexture();

        public RangeBlockerUtil getAuroraBlocker();
    }
}

