/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class DebrisPiece {
    public static final float CELL_SIZE = 32.0f;
    protected SpriteAPI shadowMask;
    protected SpriteAPI sprite;
    protected SpriteAPI glow;
    protected float width;
    protected float height;
    protected float radius;
    protected DebrisFieldTerrainPlugin field;
    protected Vector2f loc = new Vector2f();
    protected Vector2f vel = new Vector2f();
    protected float timeLeft = 0.0f;
    protected float facing = 0.0f;
    protected float angVel = 0.0f;
    protected FaderUtil fader = new FaderUtil(0.0f, 0.2f, 0.2f);
    protected FaderUtil glowBounce;
    protected FaderUtil glowFader = new FaderUtil(0.0f, 0.1f, 0.1f);
    protected FaderUtil indFader = new FaderUtil(0.0f, 0.3f, 0.8f, false, true);

    public DebrisPiece(DebrisFieldTerrainPlugin field) {
        this.field = field;
        this.glowBounce = new FaderUtil(0.0f, 0.1f + (float)Math.random() * 0.1f, 0.1f + (float)Math.random() * 0.1f);
        this.glowBounce.setBounce(true, true);
        this.glowBounce.fadeIn();
        if ((float)Math.random() < field.getPieceGlowProbability()) {
            this.glowFader.fadeIn();
        }
        this.sprite = Global.getSettings().getSprite("terrain", "debrisFieldSheet");
        this.glow = Global.getSettings().getSprite("terrain", "debrisFieldGlowSheet");
        float sizeRangeMult = 0.5f + 0.5f * field.params.density;
        this.height = this.width = field.getParams().minSize + (float)Math.random() * sizeRangeMult * (field.getParams().maxSize - field.getParams().minSize);
        this.radius = this.width * 1.41f * 0.5f;
        float w = this.sprite.getWidth();
        float h = this.sprite.getHeight();
        int cols = (int)(w / 32.0f);
        int rows = (int)(h / 32.0f);
        float cellX = (int)(Math.random() * (double)cols);
        float cellY = (int)(Math.random() * (double)rows);
        float ctw = this.sprite.getTextureWidth() / (float)cols;
        float cth = this.sprite.getTextureHeight() / (float)rows;
        this.sprite.setTexX(cellX * ctw);
        this.sprite.setTexY(cellY * cth);
        this.sprite.setTexWidth(ctw);
        this.sprite.setTexHeight(cth);
        this.glow.setTexX(cellX * ctw);
        this.glow.setTexY(cellY * cth);
        this.glow.setTexWidth(ctw);
        this.glow.setTexHeight(cth);
        this.sprite.setSize(this.width, this.height);
        this.glow.setSize(this.width, this.height);
        this.glow.setColor(field.getParams().glowColor);
        this.shadowMask = Global.getSettings().getSprite("graphics/fx/ship_shadow_mask.png");
        this.shadowMask.setSize(this.width * 1.5f, this.height * 1.5f);
        this.fader.fadeIn();
        this.facing = (float)Math.random() * 360.0f;
        this.angVel = (float)Math.random() * 360.0f - 180.0f;
        float spawnRadius = field.params.bandWidthInEngine * field.getExpander().getBrightness();
        float r = (float)Math.random();
        r = (float)Math.sqrt(r);
        float dist = r * spawnRadius;
        this.loc = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        this.loc.scale(dist);
        this.vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        this.vel = Misc.getPerp(this.loc);
        float off = 0.25f;
        this.vel.x += off - (float)Math.random() * 0.5f * off;
        this.vel.y += off - (float)Math.random() * 0.5f * off;
        if ((float)Math.random() > 0.5f) {
            this.vel.negate();
        }
        Misc.normalise(this.vel);
        float speed = 20.0f + (float)Math.random() * 100.0f;
        this.vel.scale(speed);
        this.timeLeft = 1.0f + (float)Math.random();
    }

    public void render(float alphaMult) {
        if (alphaMult <= 0.0f) {
            return;
        }
        SectorEntityToken entity = this.field.getEntity();
        SectorEntityToken lightSource = entity.getLightSource();
        if (lightSource != null && entity.getLightColor() != null) {
            this.sprite.setColor(entity.getLightColor());
        } else {
            this.sprite.setColor(Color.white);
        }
        this.sprite.setAngle(this.facing - 90.0f);
        this.sprite.setNormalBlend();
        this.sprite.setAlphaMult(alphaMult * this.fader.getBrightness());
        this.sprite.renderAtCenter(this.loc.x, this.loc.y);
        if (lightSource != null && !entity.getLightSource().hasTag("ambient_ls")) {
            float w;
            float h = w = this.shadowMask.getWidth() * 1.41f;
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.loc.x, (float)this.loc.y, (float)0.0f);
            Misc.renderQuadAlpha(0.0f - w / 2.0f - 1.0f, 0.0f - h / 2.0f - 1.0f, w + 2.0f, h + 2.0f, Misc.zeroColor, 0.0f);
            GL11.glPopMatrix();
            this.sprite.setBlendFunc(1, 0);
            this.sprite.renderAtCenter(this.loc.x, this.loc.y);
            float lightDir = Misc.getAngleInDegreesStrict(this.field.getEntity().getLocation(), lightSource.getLocation());
            this.shadowMask.setAlphaMult(alphaMult);
            this.shadowMask.setAngle(lightDir);
            this.shadowMask.setBlendFunc(0, 770);
            this.shadowMask.renderAtCenter(this.loc.x, this.loc.y);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.shadowMask.setBlendFunc(772, 773);
            this.shadowMask.renderAtCenter(this.loc.x, this.loc.y);
        }
        if (this.glowFader.getBrightness() > 0.0f) {
            this.glow.setAngle(this.facing - 90.0f);
            this.glow.setAdditiveBlend();
            this.glow.setAlphaMult(alphaMult * this.fader.getBrightness() * (0.5f + 0.5f * this.glowBounce.getBrightness()) * this.glowFader.getBrightness());
            this.glow.renderAtCenter(this.loc.x, this.loc.y);
        }
    }

    public void renderIndicator(float alphaMult) {
        if (this.indFader.isFadedOut()) {
            return;
        }
        if ((alphaMult *= this.fader.getBrightness()) <= 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.loc.x, (float)this.loc.y, (float)0.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        float thickness = 1.5f;
        GL11.glLineWidth((float)thickness);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = Global.getSector().getFaction("neutral").getBaseUIColor();
        this.field.isScavenged();
        float size = this.width + 5.0f;
        float half = size * 0.5f;
        float corner = size * 0.25f;
        float x = 0.0f;
        float y = 0.0f;
        float b = alphaMult;
        float f = this.indFader.getBrightness();
        float glow = 0.0f;
        if (f < 0.1f) {
            b *= f / 0.1f;
        } else if (this.indFader.isFadingIn() && f < 0.4f) {
            float p = (f - 0.1f) / 0.3f;
            glow = (float)(Math.sin(p * (float)Math.PI * 6.0f - (float)Math.PI) + 1.0) / 2.0f;
            glow = glow < 0.5f ? 0.0f : 1.0f;
            glow *= 0.25f;
        }
        int i = 0;
        while (i < 2) {
            if (i == 1) {
                GL11.glBlendFunc((int)770, (int)1);
                b = glow;
            }
            if (!(b <= 0.0f)) {
                GL11.glBegin((int)3);
                Misc.setColor(color, b);
                GL11.glVertex2f((float)(x - half), (float)(y + half - corner));
                GL11.glVertex2f((float)(x - half), (float)(y + half));
                GL11.glVertex2f((float)(x - half + corner), (float)(y + half));
                GL11.glEnd();
                GL11.glBegin((int)3);
                Misc.setColor(color, b);
                GL11.glVertex2f((float)(x + half), (float)(y + half - corner));
                GL11.glVertex2f((float)(x + half), (float)(y + half));
                GL11.glVertex2f((float)(x + half - corner), (float)(y + half));
                GL11.glEnd();
                GL11.glBegin((int)3);
                Misc.setColor(color, b);
                GL11.glVertex2f((float)(x - half), (float)(y - half + corner));
                GL11.glVertex2f((float)(x - half), (float)(y - half));
                GL11.glVertex2f((float)(x - half + corner), (float)(y - half));
                GL11.glEnd();
                GL11.glBegin((int)3);
                Misc.setColor(color, b);
                GL11.glVertex2f((float)(x + half), (float)(y - half + corner));
                GL11.glVertex2f((float)(x + half), (float)(y - half));
                GL11.glVertex2f((float)(x + half - corner), (float)(y - half));
                GL11.glEnd();
            }
            ++i;
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2848);
    }

    public void advance(float days) {
        this.fader.advance(days);
        this.glowBounce.advance(days);
        this.glowFader.advance(days);
        this.facing += this.angVel * days;
        this.loc.x += this.vel.x * days;
        this.loc.y += this.vel.y * days;
        this.timeLeft -= days;
        if (this.timeLeft < 0.0f) {
            this.fader.fadeOut();
        }
        this.indFader.advance(days);
    }

    public void showIndicator() {
        if (this.indFader.isIdle()) {
            float in = 0.3f;
            float out = 0.3f + 0.7f * (float)Math.random();
            this.indFader.setDuration(in, out);
        }
        this.indFader.fadeIn();
    }

    public boolean hasIndicator() {
        return !this.indFader.isIdle();
    }

    public boolean isDone() {
        return this.fader.isFadedOut();
    }

    public FaderUtil getGlowFader() {
        return this.glowFader;
    }
}

