/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class FlareManager {
    private IntervalUtil flareTracker = new IntervalUtil(0.5f, 1.5f);
    private List<Flare> flares = new ArrayList<Flare>();
    private FlareManagerDelegate delegate;

    public FlareManager(FlareManagerDelegate delegate) {
        this.delegate = delegate;
    }

    Object readResolve() {
        return this;
    }

    Object writeReplace() {
        if (this.flares != null && this.flares.isEmpty()) {
            this.flares = null;
        }
        return this;
    }

    public List<Flare> getFlares() {
        if (this.flares == null) {
            this.flares = new ArrayList<Flare>();
        }
        return this.flares;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        Flare curr = null;
        if (!this.getFlares().isEmpty()) {
            curr = this.getFlares().get(0);
        }
        if (curr != null) {
            curr.fader.advance(days);
            if (curr.fader.isFadedOut()) {
                curr = null;
                this.getFlares().remove(0);
                if (!this.getFlares().isEmpty()) {
                    this.getFlares().get((int)0).fader.fadeIn();
                }
            }
        }
        this.flareTracker.advance(days);
        if (this.flareTracker.intervalElapsed() && this.getFlares().isEmpty() && Math.random() < (double)this.delegate.getFlareProbability()) {
            this.initNewFlareSequence();
        }
    }

    public Flare getActiveFlare() {
        if (this.getFlares().isEmpty()) {
            return null;
        }
        return this.getFlares().get(0);
    }

    public boolean isInActiveFlareArc(Vector2f point) {
        float angle = Misc.getAngleInDegrees(this.delegate.getFlareCenterEntity().getLocation(), point);
        return this.isInActiveFlareArc(angle);
    }

    public boolean isInActiveFlareArc(SectorEntityToken other) {
        float angle = Misc.getAngleInDegrees(this.delegate.getFlareCenterEntity().getLocation(), other.getLocation());
        return this.isInActiveFlareArc(angle);
    }

    public boolean isInActiveFlareArc(float angle) {
        Flare curr = this.getActiveFlare();
        if (curr == null) {
            return false;
        }
        return Misc.isInArc(curr.direction, curr.arc, angle);
    }

    public Color getColorForAngle(Color baseColor, float angle) {
        float progress;
        Flare curr = this.getActiveFlare();
        if (curr == null) {
            return baseColor;
        }
        if (!Misc.isInArc(curr.direction, curr.arc, angle)) {
            return baseColor;
        }
        angle = Misc.normalizeAngle(angle);
        float arcStart = curr.direction - curr.arc / 2.0f;
        float arcEnd = curr.direction + curr.arc / 2.0f;
        if ((angle -= arcStart) < 0.0f) {
            angle += 360.0f;
        }
        if ((progress = angle / (arcEnd - arcStart)) < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        float numColors = curr.colors.size();
        float fractionalIndex = (numColors - 1.0f) * progress;
        int colorOne = (int)fractionalIndex;
        int colorTwo = (int)Math.ceil(fractionalIndex);
        float interpProgress = fractionalIndex - (float)((int)fractionalIndex);
        Color one = curr.colors.get(colorOne);
        Color two = curr.colors.get(colorTwo);
        Color result = Misc.interpolateColor(one, two, interpProgress);
        result = Misc.interpolateColor(baseColor, result, curr.fader.getBrightness());
        return result;
    }

    public float getExtraLengthFlat(float angle) {
        Flare curr = this.getActiveFlare();
        if (curr == null) {
            return 0.0f;
        }
        if (!Misc.isInArc(curr.direction, curr.arc, angle)) {
            return 0.0f;
        }
        return curr.extraLengthFlat * (float)Math.sqrt(curr.fader.getBrightness());
    }

    public float getExtraLengthMult(float angle) {
        Flare curr = this.getActiveFlare();
        if (curr == null) {
            return 1.0f;
        }
        if (!Misc.isInArc(curr.direction, curr.arc, angle)) {
            return 1.0f;
        }
        return 1.0f + (curr.extraLengthMult - 1.0f) * (float)Math.sqrt(curr.fader.getBrightness());
    }

    public float getShortenMod(float angle) {
        Flare curr = this.getActiveFlare();
        if (curr == null) {
            return 0.0f;
        }
        if (!Misc.isInArc(curr.direction, curr.arc, angle)) {
            return 0.0f;
        }
        return curr.shortenFlatMod * (float)Math.sqrt(curr.fader.getBrightness());
    }

    public float getInnerOffsetMult(float angle) {
        Flare curr = this.getActiveFlare();
        if (curr == null) {
            return 0.0f;
        }
        if (!Misc.isInArc(curr.direction, curr.arc, angle)) {
            return 0.0f;
        }
        return (float)Math.sqrt(curr.fader.getBrightness());
    }

    protected void initNewFlareSequence() {
        this.getFlares().clear();
        int numSmall = this.delegate.getFlareMinSmallCount() + (int)Math.ceil((float)(this.delegate.getFlareMaxSmallCount() - this.delegate.getFlareMinSmallCount()) * (float)Math.random());
        Flare large = this.genLargeFlare();
        int i = 0;
        while (i < numSmall) {
            this.getFlares().add(this.genSmallFlare(large.direction, large.arc));
            ++i;
        }
        if (Math.random() > (double)this.delegate.getFlareSkipLargeProbability()) {
            this.getFlares().add(large);
        }
        if (!this.getFlares().isEmpty()) {
            this.getFlares().get((int)0).fader.fadeIn();
        }
    }

    protected Flare genSmallFlare(float dir, float arc) {
        Flare flare = new Flare();
        flare.direction = dir - arc / 2.0f + (float)Math.random() * arc;
        flare.arc = this.delegate.getFlareSmallArcMin() + (this.delegate.getFlareSmallArcMax() - this.delegate.getFlareSmallArcMin()) * (float)Math.random();
        flare.extraLengthFlat = this.delegate.getFlareSmallExtraLengthFlatMin() + (this.delegate.getFlareSmallExtraLengthFlatMax() - this.delegate.getFlareSmallExtraLengthFlatMin()) * (float)Math.random();
        flare.extraLengthMult = this.delegate.getFlareSmallExtraLengthMultMin() + (this.delegate.getFlareSmallExtraLengthMultMax() - this.delegate.getFlareSmallExtraLengthMultMin()) * (float)Math.random();
        flare.shortenFlatMod = this.delegate.getFlareSmallShortenFlatModMin() + (this.delegate.getFlareSmallShortenFlatModMax() - this.delegate.getFlareSmallShortenFlatModMin()) * (float)Math.random();
        flare.fader = new FaderUtil(0.0f, this.delegate.getFlareSmallFadeInMin() + (this.delegate.getFlareSmallFadeInMax() - this.delegate.getFlareSmallFadeInMin()) * (float)Math.random(), this.delegate.getFlareSmallFadeOutMin() + (this.delegate.getFlareSmallFadeOutMax() - this.delegate.getFlareSmallFadeOutMin()) * (float)Math.random(), false, true);
        this.setColors(flare);
        return flare;
    }

    protected Flare genLargeFlare() {
        Flare flare = new Flare();
        flare.direction = this.delegate.getFlareOccurrenceAngle() - this.delegate.getFlareOccurrenceArc() / 2.0f + (float)Math.random() * this.delegate.getFlareOccurrenceArc();
        flare.arc = this.delegate.getFlareArcMin() + (this.delegate.getFlareArcMax() - this.delegate.getFlareArcMin()) * (float)Math.random();
        flare.extraLengthFlat = this.delegate.getFlareExtraLengthFlatMin() + (this.delegate.getFlareExtraLengthFlatMax() - this.delegate.getFlareExtraLengthFlatMin()) * (float)Math.random();
        flare.extraLengthMult = this.delegate.getFlareExtraLengthMultMin() + (this.delegate.getFlareExtraLengthMultMax() - this.delegate.getFlareExtraLengthMultMin()) * (float)Math.random();
        flare.shortenFlatMod = this.delegate.getFlareShortenFlatModMin() + (this.delegate.getFlareShortenFlatModMax() - this.delegate.getFlareShortenFlatModMin()) * (float)Math.random();
        flare.fader = new FaderUtil(0.0f, this.delegate.getFlareFadeInMin() + (this.delegate.getFlareFadeInMax() - this.delegate.getFlareFadeInMin()) * (float)Math.random(), this.delegate.getFlareFadeOutMin() + (this.delegate.getFlareFadeOutMax() - this.delegate.getFlareFadeOutMin()) * (float)Math.random(), false, true);
        flare.direction = Misc.normalizeAngle(flare.direction);
        this.setColors(flare);
        return flare;
    }

    protected void setColors(Flare flare) {
        int totalColors;
        float colorRangeFraction = flare.arc / this.delegate.getFlareArcMax();
        int numColors = Math.round(colorRangeFraction * (float)(totalColors = this.delegate.getFlareColorRange().size()));
        if (numColors < 1) {
            numColors = 1;
        }
        flare.colors.clear();
        Random r = new Random();
        int start = 0;
        if (numColors < totalColors) {
            start = r.nextInt(totalColors - numColors);
        }
        int i = start;
        while (i < totalColors) {
            flare.colors.add(this.delegate.getFlareColorRange().get(i));
            ++i;
        }
    }

    public static class Flare {
        public float direction;
        public float arc;
        public float extraLengthMult;
        public float extraLengthFlat;
        public float shortenFlatMod;
        public transient List<Color> colors = new ArrayList<Color>();
        public String c = null;
        public FaderUtil fader;

        Object readResolve() {
            this.colors = this.c != null ? Misc.colorsFromString(this.c) : new ArrayList<Color>();
            return this;
        }

        Object writeReplace() {
            this.c = Misc.colorsToString(this.colors);
            return this;
        }
    }

    public static interface FlareManagerDelegate {
        public SectorEntityToken getFlareCenterEntity();

        public List<Color> getFlareColorRange();

        public float getFlareProbability();

        public float getFlareSkipLargeProbability();

        public int getFlareMinSmallCount();

        public int getFlareMaxSmallCount();

        public float getFlareOccurrenceAngle();

        public float getFlareOccurrenceArc();

        public float getFlareArcMin();

        public float getFlareArcMax();

        public float getFlareFadeInMin();

        public float getFlareFadeInMax();

        public float getFlareFadeOutMin();

        public float getFlareFadeOutMax();

        public float getFlareExtraLengthMultMin();

        public float getFlareExtraLengthMultMax();

        public float getFlareExtraLengthFlatMin();

        public float getFlareExtraLengthFlatMax();

        public float getFlareShortenFlatModMin();

        public float getFlareShortenFlatModMax();

        public float getFlareSmallArcMin();

        public float getFlareSmallArcMax();

        public float getFlareSmallFadeInMin();

        public float getFlareSmallFadeInMax();

        public float getFlareSmallFadeOutMin();

        public float getFlareSmallFadeOutMax();

        public float getFlareSmallExtraLengthMultMin();

        public float getFlareSmallExtraLengthMultMax();

        public float getFlareSmallExtraLengthFlatMin();

        public float getFlareSmallExtraLengthFlatMax();

        public float getFlareSmallShortenFlatModMin();

        public float getFlareSmallShortenFlatModMax();
    }
}

