/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPointProvider;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseHyperspaceAbyssPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class HyperspaceAbyssPluginImpl
extends BaseHyperspaceAbyssPlugin
implements EncounterPointProvider {
    public static String EP_TYPE_ABYSSAL = "ep_type_abyssal";
    public static float ENCOUNTER_NEAR_ABYSSAL_SYSTEM_DIST = 2000.0f;
    public static float NASCENT_WELL_DETECTED_RANGE = 1000.0f;
    public static float JUMP_POINT_DETECTED_RANGE = 1300.0f;
    public static float GAS_GIANT_DETECTED_RANGE = 1600.0f;
    public static float STAR_DETECTED_RANGE = 2000.0f;
    public static float DEPTH_THRESHOLD_FOR_ENCOUNTER = 0.25f;
    public static float DEPTH_THRESHOLD_FOR_DWELLER_LIGHT = 3.0f;
    public static float DEPTH_THRESHOLD_FOR_ABYSSAL_LIGHT = 1.0f;
    public static float DEPTH_THRESHOLD_FOR_ABYSSAL_STELLAR_OBJECT = 1.0f;
    public static float DEPTH_THRESHOLD_FOR_ABYSSAL_STAR_SYSTEM = 0.5f;
    public static float DEPTH_THRESHOLD_FOR_NO_DUST_PARTICLES_IN_COMBAT = 0.5f;
    public static float DEPTH_THRESHOLD_FOR_FLEETS_FLEEING = 0.5f;
    public static float PLAYER_DIST_TRAVELLED_TO_REGEN_EPS = 1000.0f;
    protected Vector2f playerLocWhenGeneratingEPs = null;
    protected List<EncounterPoint> encounterPoints = null;
    protected Random random = new Random();

    public HyperspaceAbyssPluginImpl() {
        Global.getSector().getListenerManager().addListener(this);
    }

    protected Object readResolve() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this;
    }

    @Override
    public float getAbyssalDepth(Vector2f loc, boolean uncapped) {
        float below;
        float above;
        float right;
        float left;
        float max;
        float w = Global.getSettings().getFloat("sectorWidth");
        float h = Global.getSettings().getFloat("sectorHeight");
        float baseW = 100000.0f;
        float baseH = 50000.0f;
        float normalizedX = (loc.x + w / 2.0f) / baseW;
        float normalizedY = (loc.y + h / 2.0f) / baseH;
        float test = (float)(Math.sqrt(Math.max(0.0f, normalizedX)) + Math.sqrt(Math.max(0.0f, normalizedY)));
        float depthBasedOnCorner = 0.0f;
        if (test < 1.0f) {
            float threshold = 0.95f;
            depthBasedOnCorner = uncapped ? 1.0f - (test - threshold) / (1.0f - threshold) : (test < threshold ? 1.0f : 1.0f - (test - threshold) / (1.0f - threshold));
        }
        if ((max = Math.max(left = -w / 2.0f - loc.x, Math.max(right = loc.x - w / 2.0f, Math.max(above = loc.y - h / 2.0f, below = -h / 2.0f - loc.y)))) > 0.0f) {
            if (uncapped) {
                return Math.max(depthBasedOnCorner, max / 2000.0f);
            }
            return Math.min(1.0f, Math.max(depthBasedOnCorner, max / 2000.0f));
        }
        return depthBasedOnCorner;
    }

    @Override
    public void advance(float amount) {
        if (!Global.getSector().getListenerManager().hasListener(this)) {
            Global.getSector().getListenerManager().addListener(this);
        }
    }

    @Override
    public List<StarSystemAPI> getAbyssalSystems() {
        ArrayList<StarSystemAPI> abyssal = new ArrayList<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float depth = Misc.getAbyssalDepth(system.getLocation());
            if (!(depth > DEPTH_THRESHOLD_FOR_ABYSSAL_STAR_SYSTEM)) continue;
            abyssal.add(system);
        }
        return abyssal;
    }

    @Override
    public List<EncounterPoint> generateEncounterPoints(LocationAPI where) {
        float startAngle;
        if (!where.isHyperspace()) {
            return null;
        }
        boolean regenerate = this.encounterPoints == null || this.playerLocWhenGeneratingEPs == null;
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (!regenerate) {
            Vector2f loc = pf.getLocation();
            float dist = Misc.getDistance(loc, this.playerLocWhenGeneratingEPs);
            boolean bl = regenerate = dist > PLAYER_DIST_TRAVELLED_TO_REGEN_EPS;
        }
        if (!regenerate) {
            return this.encounterPoints;
        }
        List<StarSystemAPI> abyssal = this.getAbyssalSystems();
        this.playerLocWhenGeneratingEPs = new Vector2f((ReadableVector2f)pf.getLocation());
        this.encounterPoints = new ArrayList<EncounterPoint>();
        float angle = startAngle = this.random.nextFloat() * 360.0f;
        while (angle < startAngle + 360.0f) {
            Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
            float dist = 3000.0f;
            loc.scale(dist);
            Vector2f.add((Vector2f)loc, (Vector2f)this.playerLocWhenGeneratingEPs, (Vector2f)loc);
            loc = Misc.getPointWithinRadius(loc, 1000.0f, this.random);
            float depth = this.getAbyssalDepth(loc, true);
            if (!(depth < DEPTH_THRESHOLD_FOR_ENCOUNTER)) {
                String id = "abyssal_" + (int)(loc.x / 1000.0f) + "_" + (int)(loc.y / 1000.0f);
                EncounterPoint point = new EncounterPoint(id, where, loc, EP_TYPE_ABYSSAL);
                AbyssalEPData data = new AbyssalEPData();
                data.depth = depth;
                data.random = Misc.getRandom(this.random.nextLong(), 7);
                float minDist = Float.MAX_VALUE;
                StarSystemAPI nearest = null;
                for (StarSystemAPI system : abyssal) {
                    float distToSystem = Misc.getDistance(system.getLocation(), loc);
                    float testDist = ENCOUNTER_NEAR_ABYSSAL_SYSTEM_DIST;
                    if (system.getType() == StarSystemGenerator.StarSystemType.DEEP_SPACE) {
                        testDist *= 0.5f;
                    }
                    if (!(distToSystem < testDist) || !(distToSystem < minDist)) continue;
                    minDist = distToSystem;
                    nearest = system;
                }
                if (nearest != null) {
                    data.nearest = nearest;
                    data.distToNearest = minDist;
                }
                point.custom = data;
                this.encounterPoints.add(point);
            }
            angle += 30.0f;
        }
        return this.encounterPoints;
    }

    public static class AbyssalEPData {
        public float depth;
        public Random random;
        public StarSystemAPI nearest = null;
        public float distToNearest = Float.MAX_VALUE;
    }
}

