/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.RangeBlockerUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class PulsarRenderer {
    private PulsarRendererDelegate delegate;
    private float texOffset = 0.0f;
    private float currAngle;
    private transient FloatBuffer vertexBuffer;
    private transient FloatBuffer textureBuffer;
    private transient ByteBuffer colorBuffer;
    private transient boolean rendered = false;

    public PulsarRenderer(PulsarRendererDelegate delegate) {
        this.delegate = delegate;
    }

    public float getCurrAngle() {
        return this.currAngle;
    }

    public void setCurrAngle(float currAngle) {
        this.currAngle = currAngle;
    }

    public void advance(float amount) {
        float imageWidth = this.delegate.getPulsarTexture().getWidth();
        this.texOffset += amount * this.delegate.getPulsarScrollSpeed() / imageWidth;
        while (this.texOffset > 1.0f) {
            this.texOffset -= 1.0f;
        }
        if (!this.rendered && this.vertexBuffer != null) {
            Misc.cleanBuffer(this.vertexBuffer);
            Misc.cleanBuffer(this.textureBuffer);
            Misc.cleanBuffer(this.colorBuffer);
            this.textureBuffer = null;
            this.vertexBuffer = null;
            this.colorBuffer = null;
        }
        this.rendered = false;
    }

    public void render(float alphaMult) {
        if (alphaMult <= 0.0f) {
            return;
        }
        float distClose = this.delegate.getPulsarInnerRadius();
        float distFar = this.delegate.getPulsarOuterRadius();
        if (distFar < distClose + 10.0f) {
            distFar = distClose + 10.0f;
        }
        float length = distFar - distClose;
        float wClose = this.delegate.getPulsarInnerWidth();
        float wFar = this.delegate.getPulsarOuterWidth();
        float pixelsPerSegment = 25.0f;
        float segments = Math.round(wFar / pixelsPerSegment);
        pixelsPerSegment = wFar / segments;
        Vector2f loc = this.delegate.getPulsarCenterLoc();
        float x = loc.x;
        float y = loc.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float texHeight = this.delegate.getPulsarTexture().getTextureHeight();
        float imageHeight = this.delegate.getPulsarTexture().getHeight();
        float texPerSegment = texHeight / segments;
        float texWidth = this.delegate.getPulsarTexture().getTextureWidth();
        float imageWidth = this.delegate.getPulsarTexture().getWidth();
        RangeBlockerUtil blocker = this.delegate.getPulsarBlocker();
        float numIter = (float)Math.ceil(distFar - distClose) / (imageWidth * texWidth);
        float widthFactor = (wClose + wFar) / 2.0f / (imageHeight * texHeight);
        numIter /= widthFactor;
        float texPerUnitLength = 1.0f / (imageWidth * widthFactor);
        float angle = this.currAngle;
        float fadeInDist = Math.min(1000.0f, length * 0.25f);
        float fadeOutDist = Math.min(1500.0f, length * 0.25f);
        boolean wireframe = false;
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)3553);
        }
        float[] rPrev = new float[(int)segments + 1];
        float[] blockedPrev = new float[(int)segments + 1];
        float[] xPrev = new float[(int)segments + 1];
        float[] yPrev = new float[(int)segments + 1];
        float[] texPrev = new float[(int)segments + 1];
        int numInnerSegments = (int)((length - fadeInDist - fadeOutDist) / (pixelsPerSegment * 5.0f));
        if (numInnerSegments < 1) {
            numInnerSegments = 1;
        }
        numInnerSegments = 1;
        int numSegments = 2 + numInnerSegments;
        float distPerInnerSegment = (length - fadeInDist - fadeOutDist) / (float)numInnerSegments;
        boolean arrays = false;
        int numVertices = numSegments * ((int)segments + 1) * 2;
        if (arrays) {
            if (this.vertexBuffer == null) {
                this.vertexBuffer = ByteBuffer.allocateDirect(numVertices * 4 * 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
            }
            if (this.textureBuffer == null) {
                this.textureBuffer = ByteBuffer.allocateDirect(numVertices * 4 * 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
            }
            if (this.colorBuffer == null) {
                this.colorBuffer = ByteBuffer.allocateDirect(numVertices * 4).order(ByteOrder.nativeOrder());
            }
            this.vertexBuffer.clear();
            this.textureBuffer.clear();
            this.colorBuffer.clear();
        }
        this.rendered = true;
        this.delegate.getPulsarTexture().bindTexture();
        int j = 0;
        while (j < numSegments) {
            boolean isFirst = j == 0;
            boolean isLast = j == numSegments - 1;
            boolean isMid = !isFirst && !isLast;
            float alphaCloser = 1.0f;
            float alphaFarther = 1.0f;
            float r1 = distClose;
            float r2 = distFar;
            if (isFirst) {
                alphaCloser = 0.0f;
                alphaFarther = 1.0f;
                r1 = distClose;
                r2 = distClose + fadeInDist;
            } else if (isMid) {
                alphaCloser = 1.0f;
                alphaFarther = 1.0f;
                r1 = distClose + (float)(j - 1) * distPerInnerSegment + fadeInDist;
                r2 = r1 + distPerInnerSegment;
            } else if (isLast) {
                alphaCloser = 1.0f;
                alphaFarther = 0.0f;
                r1 = distFar - fadeOutDist;
                r2 = distFar;
            }
            float w1 = wClose + (wFar - wClose) * (r1 - distClose) / length;
            float w2 = wClose + (wFar - wClose) * (r2 - distClose) / length;
            float arcClose = (float)Math.toRadians(Misc.computeAngleSpan(w1 / 2.0f, r1));
            float arcFar = (float)Math.toRadians(Misc.computeAngleSpan(w2 / 2.0f, r2));
            float closeAnglePerSegment = arcClose / segments;
            float farAnglePerSegment = arcFar / segments;
            float currCloseAngle = (float)Math.toRadians(angle) - arcClose / 2.0f;
            float currFarAngle = (float)Math.toRadians(angle) - arcFar / 2.0f;
            float texProgress = 0.0f;
            GL11.glBegin((int)8);
            float i = 0.0f;
            while (i < segments + 1.0f) {
                float blockedAt = 1.0f;
                float blockerMax = 100000.0f;
                if (isMid && blocker != null) {
                    blockerMax = blocker.getCurrMaxAt((float)Math.toDegrees(currCloseAngle));
                    if (blockerMax > blocker.getMaxRange()) {
                        blockerMax = blocker.getMaxRange();
                    }
                    if (blockerMax < fadeInDist + 100.0f) {
                        blockerMax = fadeInDist + 100.0f;
                    }
                    if ((blockedAt = (blockerMax - r1) / (r2 - r1)) > 1.0f) {
                        blockedAt = 1.0f;
                    }
                    if (blockedAt < 0.0f) {
                        blockedAt = 0.0f;
                    }
                    rPrev[(int)i] = Math.min(r2, blockerMax);
                    blockedPrev[(int)i] = blockedAt;
                }
                float curr1 = r1;
                float curr2 = r2;
                float extraAlpha = 1.0f;
                if (isLast) {
                    curr1 = rPrev[(int)i];
                    float block = blockedPrev[(int)i];
                    curr2 = curr1 + Math.max(300.0f, fadeOutDist * block);
                    w2 = wClose + (wFar - wClose) * (curr2 - distClose) / length;
                    arcFar = (float)Math.toRadians(Misc.computeAngleSpan(w2 / 2.0f, curr2));
                    farAnglePerSegment = arcFar / segments;
                    currFarAngle = (float)Math.toRadians(angle) - arcFar / 2.0f + farAnglePerSegment * i;
                }
                float cosClose = (float)Math.cos(currCloseAngle);
                float sinClose = (float)Math.sin(currCloseAngle);
                float cosFar = (float)Math.cos(currFarAngle);
                float sinFar = (float)Math.sin(currFarAngle);
                float x1 = cosClose * curr1;
                float y1 = sinClose * curr1;
                float x2 = cosFar * curr2;
                float y2 = sinFar * curr2;
                if (isMid || isLast) {
                    x1 = xPrev[(int)i];
                    y1 = yPrev[(int)i];
                }
                x2 = x1 + (x2 - x1) * blockedAt;
                y2 = y1 + (y2 - y1) * blockedAt;
                xPrev[(int)i] = x2;
                yPrev[(int)i] = y2;
                float closeTX = texWidth * texPerUnitLength * (curr1 - distClose) - this.texOffset;
                float farTX = texWidth * texPerUnitLength * (curr1 + (curr2 - curr1) * blockedAt - distClose) - this.texOffset;
                if (isMid || isLast) {
                    closeTX = texPrev[(int)i];
                }
                texPrev[(int)i] = farTX;
                float edgeMult = 1.0f;
                float max = 10.0f;
                if (i < max) {
                    edgeMult = i / max;
                } else if (i > segments - 1.0f - max) {
                    edgeMult = 1.0f - (i - (segments - max)) / max;
                }
                Color color = this.delegate.getPulsarColorForAngle(angle);
                if (arrays) {
                    this.vertexBuffer.put(x1).put(y1).put(x2).put(y2);
                    this.textureBuffer.put(closeTX).put(texProgress).put(farTX).put(texProgress);
                    this.colorBuffer.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue()).put((byte)((float)color.getAlpha() * alphaMult * alphaCloser * edgeMult * extraAlpha));
                    this.colorBuffer.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue()).put((byte)((float)color.getAlpha() * alphaMult * alphaFarther * edgeMult * extraAlpha));
                } else {
                    GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * alphaCloser * edgeMult * extraAlpha)));
                    GL11.glTexCoord2f((float)closeTX, (float)texProgress);
                    GL11.glVertex2f((float)x1, (float)y1);
                    GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * alphaFarther * edgeMult * extraAlpha)));
                    GL11.glTexCoord2f((float)farTX, (float)texProgress);
                    GL11.glVertex2f((float)x2, (float)y2);
                }
                texProgress += texPerSegment * 1.0f;
                currCloseAngle += closeAnglePerSegment;
                currFarAngle += farAnglePerSegment;
                i += 1.0f;
            }
            GL11.glEnd();
            ++j;
        }
        if (arrays) {
            this.vertexBuffer.position(0);
            this.textureBuffer.position(0);
            this.colorBuffer.position(0);
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32888);
            GL11.glEnableClientState((int)32886);
            GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.textureBuffer);
            GL11.glColorPointer((int)4, (boolean)true, (int)0, (ByteBuffer)this.colorBuffer);
            GL11.glVertexPointer((int)2, (int)0, (FloatBuffer)this.vertexBuffer);
            GL11.glDrawArrays((int)8, (int)0, (int)numVertices);
            GL11.glDisableClientState((int)32884);
            GL11.glDisableClientState((int)32888);
            GL11.glDisableClientState((int)32886);
        }
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        GL11.glPopMatrix();
    }

    public static interface PulsarRendererDelegate {
        public float getPulsarInnerRadius();

        public float getPulsarOuterRadius();

        public Vector2f getPulsarCenterLoc();

        public float getPulsarInnerWidth();

        public float getPulsarOuterWidth();

        public Color getPulsarColorForAngle(float var1);

        public SpriteAPI getPulsarTexture();

        public RangeBlockerUtil getPulsarBlocker();

        public float getPulsarScrollSpeed();
    }
}

