/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RingRenderer;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RingSystemTerrainPlugin
extends BaseRingTerrain {
    private static float VISIBLITY_MULT = 0.25f;
    private static float VISIBLITY_MULT_NPC = 0.5f;
    private transient RingRenderer rr;
    private String nameForTooltip = null;

    public static float getVisibilityMult(CampaignFleetAPI fleet) {
        if (fleet != null && fleet.isPlayerFleet()) {
            return VISIBLITY_MULT;
        }
        return VISIBLITY_MULT_NPC;
    }

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "Ring System";
        }
    }

    @Override
    public void renderOnMap(float factor, float alphaMult) {
        if (this.params == null) {
            return;
        }
        if (this.rr == null) {
            this.rr = new RingRenderer("systemMap", "map_ring");
        }
        Color color = Global.getSettings().getColor("ringSystemMapColor");
        if (this.entity.getOrbitFocus() instanceof PlanetAPI) {
            PlanetAPI planetAPI = (PlanetAPI)this.entity.getOrbitFocus();
        }
        boolean spiral = this.params.bandWidthInEngine / 2.0f + 10.0f >= this.params.middleRadius;
        this.rr.render(this.entity.getLocation(), this.params.middleRadius - this.params.bandWidthInEngine * 0.5f, this.params.middleRadius + this.params.bandWidthInEngine * 0.5f, color, spiral, factor, alphaMult);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        CampaignFleetAPI fleet;
        if (entity instanceof CampaignFleetAPI && Misc.isSlowMoving(fleet = (CampaignFleetAPI)entity)) {
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", "Hiding inside ring system", RingSystemTerrainPlugin.getVisibilityMult(fleet), fleet.getStats().getDetectedRangeMod());
        }
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public String getNameForTooltip() {
        if (this.nameForTooltip == null) {
            return "Ring System";
        }
        return this.nameForTooltip;
    }

    public void setNameForTooltip(String nameForTooltip) {
        this.nameForTooltip = nameForTooltip;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.getNameForTooltip());
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        String stop = Global.getSettings().getControlStringForEnumName("GO_SLOW");
        tooltip.addPara("Reduces the range at which stationary or slow-moving* fleets inside it can be detected by %s.", nextPad, highlight, (int)((1.0f - VISIBLITY_MULT) * 100.0f) + "%");
        tooltip.addPara("*Press and hold %s to stop; combine with holding the left mouse button down to move slowly.", nextPad, Misc.getGrayColor(), highlight, stop);
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("Numerous small bodies that make up the ring system present on the battlefield. Not large enough to be an in-combat navigational hazard.", small);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getEffectCategory() {
        return "ringsystem-like";
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.HIDING_STATIONARY;
    }
}

