/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

public class TutorialPirateApproachesDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("Your fleet", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("A pirate fleet is approaching! First you'll spot it as a sensor contact, then as an unidentified fleet, and then - when it gets very close - you'll see its true colors.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                String load = Global.getSettings().getControlStringForEnumName("QUICK_LOAD");
                this.textPanel.addPara("Don't worry - the pirate ship is a shoddy rust bucket, and if you do lose, you can press %s to quick-load.", Misc.getHighlightColor(), load);
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                this.textPanel.addParagraph("Even so, combat can be expensive, especially if there's no bounty on the enemy you fight. Deploying ships into battle reduces their combat readiness, and recovering CR consumes supplies. Battle damage can cost even more supplies to repair.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT3, null);
                break;
            }
            case CONT3: {
                this.textPanel.addParagraph("However, fighting is often necessary to survive. Wait for the pirate fleet to approach, then defeat them!");
                this.options.clearOptions();
                this.options.addOption("Finish", (Object)OptionId.CONT4, null);
                break;
            }
            case CONT4: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3,
        CONT4;

    }
}

