/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import java.util.Map;

public class TutorialRespawnDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showImagePortion("illustrations", "space_wreckage", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("Your fleet has been defeated!");
                this.textPanel.addParagraph("Normally, if this happens you and your remaining crew will spend some time \"behind the scenes\" assembling a smaller fleet of recovered ships.");
                this.textPanel.addParagraph("During the course of this tutorial, the only available option is to reload the last save.");
                this.options.clearOptions();
                this.options.addOption("Load last save", (Object)OptionId.LOAD, null);
                this.options.addOption("Exit to main menu", (Object)OptionId.EXIT, null);
                break;
            }
            case LOAD: {
                this.dialog.dismiss();
                Global.getSector().getCampaignUI().quickLoad();
                break;
            }
            case EXIT: {
                this.dialog.dismiss();
                Global.getSector().getCampaignUI().cmdExitWithoutSaving();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    public static enum OptionId {
        INIT,
        LOAD,
        EXIT;

    }
}

