/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BoundingBox {
    protected transient List<Vector2f> points;
    protected transient List<Vector2f> convexHull;
    protected List<Vector2f> box;
    protected float padding;
    protected float[] rotatedBox;
    protected float angle;
    protected boolean boxComputed = false;
    protected Vector2f center = new Vector2f();
    protected float radius;

    public static BoundingBox create(List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments) {
        float unitsPerNormals;
        float padding = 0.0f;
        ArrayList<Vector2f> points = new ArrayList<Vector2f>();
        SlipstreamTerrainPlugin2.SlipstreamSegment prev = null;
        float distSoFar = unitsPerNormals = 2000.0f;
        int i = 0;
        while (i < segments.size()) {
            SlipstreamTerrainPlugin2.SlipstreamSegment seg = segments.get(i);
            if (distSoFar >= unitsPerNormals || i == segments.size() - 1) {
                distSoFar -= unitsPerNormals;
                Vector2f n1 = new Vector2f((ReadableVector2f)seg.loc);
                Vector2f n2 = new Vector2f((ReadableVector2f)seg.loc);
                n1.x += seg.normal.x * seg.width * 0.5f;
                n1.y += seg.normal.y * seg.width * 0.5f;
                n2.x -= seg.normal.x * seg.width * 0.5f;
                n2.y -= seg.normal.y * seg.width * 0.5f;
                points.add(n1);
                points.add(n2);
            } else {
                points.add(new Vector2f((ReadableVector2f)seg.loc));
            }
            if (seg.width * 0.5f > padding) {
                padding = seg.width * 0.5f;
            }
            if (prev != null) {
                distSoFar += Misc.getDistance(seg.loc, prev.loc);
            }
            prev = seg;
            ++i;
        }
        BoundingBox box = new BoundingBox(padding *= 0.5f);
        box.compute(points);
        return box;
    }

    public BoundingBox(float padding) {
        this.padding = padding;
    }

    public boolean pointNeedsDetailedCheck(Vector2f p) {
        return this.pointNeedsDetailedCheck(p, 0.0f);
    }

    public boolean pointNeedsDetailedCheck(Vector2f p, float extraRange) {
        float distSq = Misc.getDistanceSq(this.center, p);
        if (distSq > (this.radius + extraRange) * (this.radius + extraRange)) {
            return false;
        }
        if (!this.boxComputed) {
            return true;
        }
        Vector2f check = Misc.rotateAroundOrigin(p, this.angle);
        return check.x > this.rotatedBox[0] - extraRange && check.x < this.rotatedBox[2] + extraRange && check.y > this.rotatedBox[1] - extraRange && check.y < this.rotatedBox[3] + extraRange;
    }

    public void compute(List<Vector2f> points) {
        this.boxComputed = false;
        this.computeConvexHull(points);
        this.computeBox();
        this.computeCenterAndRadius();
    }

    public void computeCenterAndRadius() {
        this.center.set(0.0f, 0.0f);
        for (Vector2f p : this.points) {
            this.center.x += p.x;
            this.center.y += p.y;
        }
        this.center.scale(1.0f / Math.max(1.0f, (float)this.points.size()));
        float maxDistSq = 0.0f;
        for (Vector2f p : this.points) {
            float dist = Misc.getDistanceSq(this.center, p);
            if (!(dist > maxDistSq)) continue;
            maxDistSq = dist;
        }
        this.radius = (float)Math.sqrt(maxDistSq) + this.padding;
    }

    public void computeBox() {
        if (this.boxComputed) {
            return;
        }
        if (this.convexHull == null || this.convexHull.size() < 3) {
            this.boxComputed = false;
            return;
        }
        float minArea = Float.MAX_VALUE;
        float[] best = null;
        float bestAngle = 0.0f;
        int i = 0;
        while (i < this.convexHull.size()) {
            int e1 = i;
            int e2 = i + 1;
            if (i + 1 == this.convexHull.size()) {
                e2 = 0;
            }
            Vector2f p1 = this.convexHull.get(e1);
            Vector2f p2 = this.convexHull.get(e2);
            Vector2f edge = Vector2f.sub((Vector2f)p2, (Vector2f)p1, (Vector2f)new Vector2f());
            edge = Misc.normalise(edge);
            float angle = (float)Math.acos(edge.y) * Misc.DEG_PER_RAD;
            List<Vector2f> rotated = BoundingBox.rotate(this.convexHull, angle);
            float[] box = BoundingBox.getBoundingBox(rotated);
            float area = (box[2] - box[0]) * (box[3] - box[1]);
            if (area < minArea) {
                minArea = area;
                best = box;
                bestAngle = angle;
            }
            ++i;
        }
        if (best == null) {
            this.boxComputed = false;
            return;
        }
        best[0] = best[0] - this.padding;
        best[1] = best[1] - this.padding;
        best[2] = best[2] + this.padding;
        best[3] = best[3] + this.padding;
        Vector2f p1 = new Vector2f((float)best[0], (float)best[1]);
        Vector2f p2 = new Vector2f((float)best[2], (float)best[1]);
        Vector2f p3 = new Vector2f((float)best[2], (float)best[3]);
        Vector2f p4 = new Vector2f((float)best[0], (float)best[3]);
        this.box = new ArrayList<Vector2f>();
        this.box.add(p1);
        this.box.add(p2);
        this.box.add(p3);
        this.box.add(p4);
        this.rotatedBox = best;
        this.angle = bestAngle;
        this.box = BoundingBox.rotate(this.box, -bestAngle);
        this.boxComputed = true;
    }

    public static List<Vector2f> rotate(List<Vector2f> points, float angle) {
        ArrayList<Vector2f> result = new ArrayList<Vector2f>();
        for (Vector2f p : points) {
            result.add(Misc.rotateAroundOrigin(p, angle));
        }
        return result;
    }

    public static float[] getBoundingBox(List<Vector2f> points) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        for (Vector2f p : points) {
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        return new float[]{minX, minY, maxX, maxY};
    }

    public void computeConvexHull(List<Vector2f> points) {
        this.points = new ArrayList<Vector2f>(points);
        if (points.size() < 3) {
            this.boxComputed = false;
            return;
        }
        Vector2f p1 = null;
        float minY = Float.MAX_VALUE;
        for (Vector2f p : points) {
            if (!(p.y < minY)) continue;
            p1 = p;
            minY = p.y;
        }
        final HashMap<Vector2f, Float> angles = new HashMap<Vector2f, Float>();
        for (Vector2f p : points) {
            if (p == p1) continue;
            float angle = Misc.getAngleInDegreesStrict(p1, p);
            angles.put(p, Float.valueOf(angle));
        }
        ArrayList<Vector2f> sorted = new ArrayList<Vector2f>(points);
        sorted.remove(p1);
        Collections.sort(sorted, new Comparator<Vector2f>(){

            @Override
            public int compare(Vector2f o1, Vector2f o2) {
                float diff = ((Float)angles.get(o1)).floatValue() - ((Float)angles.get(o2)).floatValue();
                if (diff < 0.0f) {
                    return -1;
                }
                if (diff > 0.0f) {
                    return 1;
                }
                return 0;
            }
        });
        this.convexHull = new ArrayList<Vector2f>();
        this.convexHull.add(p1);
        block2: for (Vector2f p : sorted) {
            float turnDir;
            if (this.convexHull.size() == 1) {
                this.convexHull.add(p);
                continue;
            }
            while ((turnDir = BoundingBox.getTurnDir(this.convexHull.get(this.convexHull.size() - 2), this.convexHull.get(this.convexHull.size() - 1), p)) <= 0.0f) {
                this.convexHull.remove(this.convexHull.size() - 1);
                if (this.convexHull.size() >= 2) continue;
                continue block2;
            }
            this.convexHull.add(p);
        }
        if (this.convexHull.size() < 3) {
            this.boxComputed = false;
            return;
        }
    }

    public static float getTurnDir(Vector2f p1, Vector2f p2, Vector2f p3) {
        float r = (p2.x - p1.x) * (p3.y - p1.y) - (p2.y - p1.y) * (p3.x - p1.x);
        if (r > 0.0f) {
            return 1.0f;
        }
        if (r < 0.0f) {
            return -1.0f;
        }
        return 0.0f;
    }

    public void renderDebug(float alpha) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2832);
        GL11.glPointSize((float)10.0f);
        GL11.glBegin((int)0);
        Misc.setColor(Color.yellow);
        if (this.points != null) {
            for (Vector2f p : this.points) {
                GL11.glVertex2f((float)p.x, (float)p.y);
            }
        }
        GL11.glEnd();
        Misc.setColor(Color.white);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)3.0f);
        GL11.glBegin((int)2);
        if (this.convexHull != null) {
            for (Vector2f p : this.convexHull) {
                GL11.glVertex2f((float)p.x, (float)p.y);
            }
        }
        GL11.glEnd();
        Misc.setColor(Color.cyan);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)3.0f);
        GL11.glBegin((int)2);
        if (this.box != null) {
            for (Vector2f p : this.box) {
                GL11.glVertex2f((float)p.x, (float)p.y);
            }
        }
        GL11.glEnd();
    }
}

