/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.velfield.BoundingBox;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutatingVertexUtil;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamEntityPlugin2
extends BaseCustomEntityPlugin {
    public static int MAX_PARTICLES_ADD_PER_FRAME = 250;
    public static float RAD_PER_DEG = (float)Math.PI / 180;
    protected SlipstreamParams2 params = new SlipstreamParams2();
    protected List<SlipstreamSegment> segments = new ArrayList<SlipstreamSegment>();
    protected float totalLength = 0.0f;
    protected transient List<SlipstreamParticle> particles = new ArrayList<SlipstreamParticle>();
    protected transient int[] lengthToIndexMap;
    protected transient int lengthDivisor;
    protected boolean needsRecompute = true;
    protected List<BoundingBox> bounds = new ArrayList<BoundingBox>();
    protected int segmentsPerBox;
    protected FaderUtil fader = new FaderUtil(0.0f, 0.5f, 0.5f);
    protected int playerWasInSlipstreamFramesAgo = 1000;

    public static Vector2f rotateAroundOrigin(Vector2f v, float cos, float sin) {
        Vector2f r = new Vector2f();
        r.x = v.x * cos - v.y * sin;
        r.y = v.x * sin + v.y * cos;
        return r;
    }

    public void setNeedsRecompute() {
        this.needsRecompute = true;
    }

    public void updateLengthToIndexMap() {
        float minSegmentLength = Float.MAX_VALUE;
        for (SlipstreamSegment curr : this.segments) {
            if (!(curr.lengthToNext > 0.0f) || !(minSegmentLength > curr.lengthToNext)) continue;
            minSegmentLength = curr.lengthToNext;
        }
        if (minSegmentLength < 50.0f) {
            minSegmentLength = 50.0f;
        }
        this.lengthDivisor = (int)(minSegmentLength - 1.0f);
        int numIndices = (int)(this.totalLength / (float)this.lengthDivisor);
        this.lengthToIndexMap = new int[numIndices];
        int lengthSoFar = 0;
        int i = 0;
        while (i < this.segments.size()) {
            SlipstreamSegment curr = this.segments.get(i);
            while ((float)lengthSoFar < curr.totalLength + curr.lengthToNext) {
                int lengthIndex = lengthSoFar / this.lengthDivisor;
                if (lengthIndex < this.lengthToIndexMap.length) {
                    this.lengthToIndexMap[lengthIndex] = i;
                }
                lengthSoFar += this.lengthDivisor;
            }
            ++i;
        }
    }

    public SlipstreamSegment getSegmentForDist(float distAlongStream) {
        if (this.lengthToIndexMap == null) {
            return null;
        }
        int mapIndex = (int)(distAlongStream / (float)this.lengthDivisor);
        if (mapIndex < 0 || mapIndex >= this.lengthToIndexMap.length) {
            return null;
        }
        int segIndex = this.lengthToIndexMap[mapIndex];
        SlipstreamSegment segment = this.segments.get(segIndex);
        while (distAlongStream < segment.totalLength) {
            if (--segIndex < 0) {
                return null;
            }
            segment = this.segments.get(segIndex);
        }
        while (distAlongStream > segment.totalLength + segment.lengthToNext) {
            if (++segIndex >= this.segments.size()) {
                return null;
            }
            segment = this.segments.get(segIndex);
        }
        return segment;
    }

    public void addSegment(Vector2f loc, float width) {
        SlipstreamSegment s = new SlipstreamSegment();
        s.loc.set((ReadableVector2f)loc);
        s.width = width;
        float minRadius = 0.0f;
        float maxRadius = s.width * 0.05f;
        float rate = maxRadius * 0.5f;
        float angleRate = 50.0f;
        s.wobble1 = new MutatingVertexUtil(minRadius, maxRadius, rate, angleRate);
        s.wobble2 = new MutatingVertexUtil(minRadius, maxRadius, rate, angleRate);
        s.fader.fadeIn();
        this.segments.add(s);
        this.setNeedsRecompute();
    }

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.params = (SlipstreamParams2)pluginParams;
        this.fader.fadeIn();
        this.readResolve();
    }

    @Override
    public float getRenderRange() {
        return this.totalLength * 0.6f + 1000.0f;
    }

    Object readResolve() {
        if (this.particles == null) {
            this.particles = new ArrayList<SlipstreamParticle>();
        }
        return this;
    }

    @Override
    public void advance(float amount) {
        float width;
        if (!this.entity.isInCurrentLocation()) {
            return;
        }
        this.applyEffectToFleets(amount);
        this.fader.advance(amount);
        this.params.minColor = new Color(0.5f, 0.3f, 0.75f, 0.85f);
        this.params.maxColor = new Color(0.5f, 0.6f, 1.0f, 1.0f);
        this.params.spriteColor = new Color(0.3f, 0.5f, 1.0f, 1.0f);
        this.params.minDur = 1.0f;
        this.params.maxDur = 4.0f;
        this.params.minSpeed = 700.0f;
        this.params.maxSpeed = 1500.0f;
        this.params.burnLevel = 30;
        this.params.minSpeed = Misc.getSpeedForBurnLevel(this.params.burnLevel - 5);
        this.params.maxSpeed = Misc.getSpeedForBurnLevel(this.params.burnLevel + 5);
        this.params.lineLengthFractionOfSpeed = 0.25f * Math.max(0.25f, Math.min(1.0f, 30.0f / (float)this.params.burnLevel));
        this.params.minColor = new Color(0.5f, 0.3f, 0.75f, 0.1f);
        this.params.maxColor = new Color(0.5f, 0.6f, 1.0f, 0.5f);
        this.params.widthForMaxSpeed = width = 512.0f;
        this.params.slowDownInWiderSections = true;
        this.params.widthForMaxSpeedMinMult = 0.5f;
        this.params.edgeWidth = 256.0f;
        this.params.spriteColor = new Color(0.3f, 0.5f, 1.0f, 0.5f);
        this.params.edgeColor = new Color(0.3f, 0.5f, 1.0f, 0.75f);
        this.params.edgeColor = Color.white;
        this.params.minDur = 2.0f;
        this.params.maxDur = 6.0f;
        this.params.areaPerParticle = 10000.0f;
        if (this.segments.isEmpty()) {
            float spacing = 200.0f;
            int iter = 1000;
            int i = 0;
            while (i < iter) {
                float yOff = (float)Math.sin((float)i * 0.05f);
                this.addSegment(new Vector2f(this.entity.getLocation().x + (float)i * spacing, this.entity.getLocation().y + yOff * 2000.0f), width + (float)i * 10.0f);
                ++i;
            }
        }
        this.recomputeIfNeeded();
        this.advanceNearbySegments(amount);
        this.addParticles();
        this.advanceParticles(amount);
    }

    public void recomputeIfNeeded() {
        if (!this.needsRecompute) {
            return;
        }
        this.recompute();
    }

    public void recompute() {
        this.needsRecompute = false;
        Vector2f avgLoc = new Vector2f();
        int i = 0;
        while (i < this.segments.size()) {
            SlipstreamSegment curr = this.segments.get(i);
            curr.index = i++;
            Vector2f.add((Vector2f)avgLoc, (Vector2f)curr.loc, (Vector2f)avgLoc);
        }
        if (this.segments.size() > 0) {
            avgLoc.scale(1.0f / (float)this.segments.size());
            this.entity.setLocation(avgLoc.x, avgLoc.y);
        }
        SpriteAPI sprite = Global.getSettings().getSprite("misc", this.params.spriteKey1);
        SpriteAPI edge = Global.getSettings().getSprite("misc", this.params.edgeKey);
        float tx = 0.0f;
        float txe1 = 0.0f;
        float txe2 = 0.0f;
        float totalLength = 0.0f;
        int i2 = 0;
        while (i2 < this.segments.size()) {
            Vector2f dir;
            SlipstreamSegment prev = null;
            if (i2 > 0) {
                prev = this.segments.get(i2 - 1);
            }
            SlipstreamSegment curr = this.segments.get(i2);
            SlipstreamSegment next = null;
            SlipstreamSegment next2 = null;
            SlipstreamSegment next3 = null;
            if (i2 < this.segments.size() - 1) {
                next = this.segments.get(i2 + 1);
            }
            if (i2 < this.segments.size() - 2) {
                next2 = this.segments.get(i2 + 2);
            }
            if (i2 < this.segments.size() - 3) {
                next3 = this.segments.get(i2 + 3);
            }
            if (next == null) {
                if (prev != null) {
                    curr.dir.set((ReadableVector2f)prev.dir);
                }
            } else {
                dir = Vector2f.sub((Vector2f)next.loc, (Vector2f)curr.loc, (Vector2f)new Vector2f());
                curr.dir = dir = Misc.normalise(dir);
            }
            dir = curr.dir;
            Vector2f normal = new Vector2f(-dir.y, dir.x);
            curr.normal.set((ReadableVector2f)normal);
            float length = 0.0f;
            float texLength = 0.0f;
            float e1TexLength = 0.0f;
            float e2TexLength = 0.0f;
            if (prev != null) {
                Vector2f dir2 = Vector2f.sub((Vector2f)curr.loc, (Vector2f)prev.loc, (Vector2f)new Vector2f());
                length = dir2.length();
                texLength = length / sprite.getWidth();
                texLength = Math.min(texLength, sprite.getHeight() / curr.width);
                Vector2f edgeCurr = new Vector2f((ReadableVector2f)curr.loc);
                edgeCurr.x += curr.normal.x * curr.width * 0.5f;
                edgeCurr.y += curr.normal.y * curr.width * 0.5f;
                Vector2f edgePrev = new Vector2f((ReadableVector2f)prev.loc);
                edgePrev.x += prev.normal.x * prev.width * 0.5f;
                edgePrev.y += prev.normal.y * prev.width * 0.5f;
                float length2 = Vector2f.sub((Vector2f)edgeCurr, (Vector2f)edgePrev, (Vector2f)new Vector2f()).length();
                e1TexLength = length2 / edge.getWidth() * edge.getHeight() / this.params.edgeWidth;
                edgeCurr = new Vector2f((ReadableVector2f)curr.loc);
                edgeCurr.x -= curr.normal.x * curr.width * 0.5f;
                edgeCurr.y -= curr.normal.y * curr.width * 0.5f;
                edgePrev = new Vector2f((ReadableVector2f)prev.loc);
                edgePrev.x -= prev.normal.x * prev.width * 0.5f;
                edgePrev.y -= prev.normal.y * prev.width * 0.5f;
                length2 = Vector2f.sub((Vector2f)edgeCurr, (Vector2f)edgePrev, (Vector2f)new Vector2f()).length();
                e2TexLength = length2 / edge.getWidth() * edge.getHeight() / this.params.edgeWidth;
            }
            curr.tx = tx += texLength;
            curr.txe1 = txe1 += e1TexLength;
            curr.txe2 = txe2 += e2TexLength;
            curr.lengthToPrev = length;
            curr.totalLength = totalLength += length;
            if (prev != null) {
                prev.lengthToNext = length;
            }
            if (next != null && next2 != null && next3 != null) {
                Vector2f p0 = curr.loc;
                Vector2f p1 = next.loc;
                Vector2f p2 = next2.loc;
                Vector2f p3 = next3.loc;
                float p1ToP2 = Misc.getAngleInDegrees(p1, p2);
                float p2ToP3 = Misc.getAngleInDegrees(p2, p3);
                float diff = Misc.getAngleDiff(p1ToP2, p2ToP3);
                float adjustment = Math.min(diff, Math.max(diff * 0.25f, diff - 10.0f));
                adjustment = diff * 0.5f;
                float angle = p1ToP2 + Misc.getClosestTurnDirection(p1ToP2, p2ToP3) * adjustment * 1.0f + 180.0f;
                float dist = Misc.getDistance(p2, p1);
                Vector2f p1Adjusted = Misc.getUnitVectorAtDegreeAngle(angle);
                p1Adjusted.scale(dist);
                Vector2f.add((Vector2f)p1Adjusted, (Vector2f)p2, (Vector2f)p1Adjusted);
                next.locB = p1Adjusted;
            } else if (next != null) {
                next.locB = next.loc;
            }
            if (prev == null) {
                curr.locB = new Vector2f((ReadableVector2f)curr.loc);
            }
            ++i2;
        }
        this.totalLength = totalLength;
        this.updateLengthToIndexMap();
        this.updateBoundingBoxes();
    }

    protected void updateBoundingBoxes() {
        this.segmentsPerBox = (int)Math.sqrt(this.segments.size()) + 1;
        if (this.segmentsPerBox < 20) {
            this.segmentsPerBox = 20;
        }
        this.bounds.clear();
        int i = 0;
        while (i < this.segments.size()) {
            ArrayList<SlipstreamSegment> section = new ArrayList<SlipstreamSegment>();
            int j = i;
            while (j < i + this.segmentsPerBox && j < this.segments.size()) {
                section.add(this.segments.get(j));
                ++j;
            }
            if (i + this.segmentsPerBox < this.segments.size()) {
                section.add(this.segments.get(i + this.segmentsPerBox));
            }
            i += this.segmentsPerBox;
        }
    }

    protected void advanceNearbySegments(float amount) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null || !this.entity.isInCurrentLocation()) {
            return;
        }
        if (this.segments.size() > 0) {
            this.segments.get((int)0).fader.forceOut();
            this.segments.get((int)(this.segments.size() - 1)).fader.fadeOut();
        }
        ViewportAPI viewport = Global.getSector().getViewport();
        float viewRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
        viewRadius = Math.max(6000.0f, viewRadius);
        List<SlipstreamSegment> near = this.getSegmentsNear(viewport.getCenter(), viewRadius += 1000.0f);
        int i = 0;
        while (i < near.size()) {
            SlipstreamSegment curr = near.get(i);
            curr.fader.advance(amount);
            float r1 = 0.5f + (float)Math.random() * 1.0f;
            float r2 = 0.5f + (float)Math.random() * 1.0f;
            curr.wobble1.advance(amount * r1);
            curr.wobble2.advance(amount * r2);
            Vector2f p1 = new Vector2f((ReadableVector2f)curr.loc);
            Vector2f p2 = new Vector2f((ReadableVector2f)curr.loc);
            p1.x += curr.normal.x * curr.width * 0.5f;
            p1.y += curr.normal.y * curr.width * 0.5f;
            p2.x -= curr.normal.x * curr.width * 0.5f;
            p2.y -= curr.normal.y * curr.width * 0.5f;
            p1.x += curr.wobble1.vector.x;
            p1.y += curr.wobble1.vector.y;
            p2.x += curr.wobble2.vector.x;
            p2.y += curr.wobble2.vector.y;
            float d = Misc.getDistance(p1, p2);
            curr.wobbledWidth = d - this.params.edgeWidth * 2.0f * 0.5f;
            if (curr.wobbledWidth < d * 0.5f) {
                curr.wobbledWidth = d * 0.5f;
            }
            if (curr.index > 0) {
                SlipstreamSegment prev = this.segments.get(curr.index - 1);
                Vector2f prev1 = new Vector2f((ReadableVector2f)prev.loc);
                Vector2f prev2 = new Vector2f((ReadableVector2f)prev.loc);
                prev1.x += curr.normal.x * curr.width * 0.5f;
                prev1.y += curr.normal.y * curr.width * 0.5f;
                prev2.x -= curr.normal.x * curr.width * 0.5f;
                prev2.y -= curr.normal.y * curr.width * 0.5f;
                float maxWobbleRadius = Math.min(prev.width, curr.width) * 0.05f;
                float maxWobble1 = Misc.getDistance(p1, prev1) * 0.33f;
                float maxWobble2 = Misc.getDistance(p2, prev2) * 0.33f;
                maxWobble1 = Math.min(maxWobbleRadius, maxWobble1);
                maxWobble2 = Math.min(maxWobbleRadius, maxWobble2);
                prev.wobble1.radius.setMax(maxWobble1);
                prev.wobble2.radius.setMax(maxWobble2);
                curr.wobble1.radius.setMax(maxWobble1);
                curr.wobble2.radius.setMax(maxWobble2);
            }
            ++i;
        }
    }

    public void addParticles() {
        if (Global.getSector().getPlayerFleet() == null) {
            this.particles.clear();
            return;
        }
        boolean useNewSpawnMethod = true;
        if (useNewSpawnMethod) {
            int particlesToAdd;
            int numParticlesBasedOnArea;
            boolean inCurrentLocation = this.entity.isInCurrentLocation();
            boolean inHyperspace = this.entity.isInHyperspace();
            boolean spawnForAllSegments = false;
            ViewportAPI viewport = Global.getSector().getViewport();
            Vector2f locFrom = viewport.getCenter();
            float viewRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
            viewRadius += 2000.0f;
            viewRadius = Math.max(viewRadius, 10000.0f);
            if (!inCurrentLocation) {
                if (inHyperspace) {
                    viewRadius = 5000.0f;
                    locFrom = Global.getSector().getPlayerFleet().getLocationInHyperspace();
                } else {
                    float dist = Misc.getDistanceToPlayerLY(this.entity);
                    spawnForAllSegments = dist < 2.0f;
                }
            }
            LinkedHashSet<Object> veryNearSet = new LinkedHashSet();
            if (inCurrentLocation) {
                float veryNearRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
                viewRadius += 500.0f;
                veryNearSet = new LinkedHashSet<SlipstreamSegment>(this.getSegmentsNear(viewport.getCenter(), veryNearRadius));
            }
            List<SlipstreamSegment> near = spawnForAllSegments ? new ArrayList<SlipstreamSegment>(this.segments) : this.getSegmentsNear(locFrom, viewRadius);
            LinkedHashSet<SlipstreamSegment> nearSet = new LinkedHashSet<SlipstreamSegment>(near);
            LinkedHashMap<SlipstreamSegment, ArrayList<SlipstreamParticle>> particleMap = new LinkedHashMap<SlipstreamSegment, ArrayList<SlipstreamParticle>>();
            Iterator<SlipstreamParticle> iter = this.particles.iterator();
            while (iter.hasNext()) {
                SlipstreamParticle p = iter.next();
                SlipstreamSegment seg = this.getSegmentForDist(p.dist);
                if (seg == null) continue;
                if (!nearSet.contains(seg)) {
                    iter.remove();
                    continue;
                }
                ArrayList<SlipstreamParticle> list = (ArrayList<SlipstreamParticle>)particleMap.get(seg);
                if (list == null) {
                    list = new ArrayList<SlipstreamParticle>();
                    particleMap.put(seg, list);
                }
                list.add(p);
            }
            float totalArea = 0.0f;
            int nearParticles = 0;
            WeightedRandomPicker<SlipstreamSegment> segmentPicker = new WeightedRandomPicker<SlipstreamSegment>();
            int i = 0;
            while (i < near.size()) {
                SlipstreamSegment curr = near.get(i);
                if (!(curr.lengthToNext <= 0.0f)) {
                    float area = curr.lengthToNext * curr.width;
                    float desiredParticles = area / this.params.areaPerParticle;
                    if (desiredParticles < 1.0f) {
                        desiredParticles = 1.0f;
                    }
                    float particlesInSegment = 0.0f;
                    List list = (List)particleMap.get(curr);
                    if (list != null) {
                        particlesInSegment = list.size();
                    }
                    float mult = 1.0f;
                    if (veryNearSet.contains(curr)) {
                        mult = 10.0f;
                    }
                    float w = desiredParticles - particlesInSegment;
                    if ((w *= mult) < 5.0f) {
                        w = 5.0f;
                    }
                    segmentPicker.add(curr, w);
                    totalArea += area;
                    nearParticles = (int)((float)nearParticles + particlesInSegment);
                }
                ++i;
            }
            int actualDesired = numParticlesBasedOnArea = (int)(totalArea / this.params.areaPerParticle);
            if (numParticlesBasedOnArea < 10) {
                numParticlesBasedOnArea = 10;
            }
            if (numParticlesBasedOnArea > this.params.maxParticles) {
                numParticlesBasedOnArea = this.params.maxParticles;
            }
            if ((particlesToAdd = numParticlesBasedOnArea - nearParticles) > MAX_PARTICLES_ADD_PER_FRAME) {
                particlesToAdd = MAX_PARTICLES_ADD_PER_FRAME;
            }
            particlesToAdd = Math.min(particlesToAdd, this.params.maxParticles - this.particles.size());
            int added = 0;
            while (added < particlesToAdd) {
                ++added;
                SlipstreamSegment seg = (SlipstreamSegment)segmentPicker.pick();
                if (seg == null) continue;
                SlipstreamParticle p = new SlipstreamParticle();
                float fLength = (float)Math.random() * 1.0f;
                float fWidth = (float)Math.random() * 2.0f - 1.0f;
                float speed = this.params.minSpeed + (this.params.maxSpeed - this.params.minSpeed) * (float)Math.random();
                float dur = this.params.minDur + (this.params.maxDur - this.params.minDur) * (float)Math.random();
                p.yPos = fWidth;
                p.dist = seg.totalLength + seg.lengthToNext * fLength;
                p.speed = speed;
                float intensity = this.getIntensity(p.yPos);
                float wMult = this.getWidthBasedSpeedMult(p.dist);
                float speedMult = (0.65f + 0.35f * intensity) * wMult;
                p.speed *= speedMult;
                p.remaining = dur;
                p.color = this.getRandomColor();
                this.particles.add(p);
            }
        } else {
            float totalArea = 0.0f;
            int i = 0;
            while (i < this.segments.size()) {
                SlipstreamSegment curr = this.segments.get(i);
                totalArea += curr.lengthToPrev * curr.width;
                ++i;
            }
            int numParticlesBasedOnArea = (int)(totalArea / this.params.areaPerParticle);
            if (numParticlesBasedOnArea < 10) {
                numParticlesBasedOnArea = 10;
            }
            if (numParticlesBasedOnArea > this.params.maxParticles) {
                numParticlesBasedOnArea = this.params.maxParticles;
            }
            int added = 0;
            while (this.particles.size() < numParticlesBasedOnArea && added < MAX_PARTICLES_ADD_PER_FRAME) {
                ++added;
                SlipstreamParticle p = new SlipstreamParticle();
                float fLength = (float)Math.random() * 1.0f;
                float fWidth = (float)Math.random() * 2.0f - 1.0f;
                float speed = this.params.minSpeed + (this.params.maxSpeed - this.params.minSpeed) * (float)Math.random();
                float dur = this.params.minDur + (this.params.maxDur - this.params.minDur) * (float)Math.random();
                p.yPos = fWidth;
                p.dist = this.totalLength * fLength;
                p.speed = speed;
                float intensity = this.getIntensity(p.yPos);
                float wMult = this.getWidthBasedSpeedMult(p.dist);
                float speedMult = (0.65f + 0.35f * intensity) * wMult;
                p.speed *= speedMult;
                p.remaining = dur;
                p.color = this.getRandomColor();
                this.particles.add(p);
            }
        }
    }

    public void advanceParticles(float amount) {
        Iterator<SlipstreamParticle> iter = this.particles.iterator();
        while (iter.hasNext()) {
            SlipstreamParticle p = iter.next();
            p.remaining -= amount;
            p.elapsed += amount;
            if (p.remaining <= 0.0f) {
                iter.remove();
                continue;
            }
            p.dist += p.speed * amount;
        }
    }

    public float getWidthBasedSpeedMult(float distAlong) {
        SlipstreamSegment curr;
        float mult = 1.0f;
        if (this.params.slowDownInWiderSections && (curr = this.getSegmentForDist(distAlong)) != null) {
            float width = curr.width;
            if (this.segments.size() > curr.index + 1) {
                SlipstreamSegment next = this.segments.get(curr.index + 1);
                float f = (distAlong - curr.totalLength) / curr.lengthToNext;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                width = Misc.interpolate(width, next.width, f);
                mult = Math.min(this.params.widthForMaxSpeedMaxMult, this.params.widthForMaxSpeedMinMult + (1.0f - this.params.widthForMaxSpeedMinMult) * this.params.widthForMaxSpeed / width);
            }
        }
        return mult;
    }

    public float getIntensity(float yOff) {
        yOff = Math.abs(yOff);
        float intensity = 1.0f;
        if (yOff > 0.5f) {
            intensity = 1.0f - 1.0f * (yOff - 0.5f) / 0.5f;
        }
        return intensity;
    }

    public float getFaderBrightness(float distAlong) {
        SlipstreamSegment curr = this.getSegmentForDist(distAlong);
        if (curr != null) {
            if (this.segments.size() > curr.index + 1) {
                SlipstreamSegment next = this.segments.get(curr.index + 1);
                float f = (distAlong - curr.totalLength) / curr.lengthToNext;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                return Misc.interpolate(curr.fader.getBrightness(), next.fader.getBrightness(), f);
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.recomputeIfNeeded();
        if (this.lengthToIndexMap == null) {
            return;
        }
        float viewRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
        List<SlipstreamSegment> near = this.getSegmentsNear(viewport.getCenter(), viewRadius += 500.0f);
        LinkedHashSet<SlipstreamSegment> nearSet = new LinkedHashSet<SlipstreamSegment>(near);
        ArrayList subsections = new ArrayList();
        int prevIndex = -10;
        ArrayList<SlipstreamSegment> subsection = new ArrayList<SlipstreamSegment>();
        for (SlipstreamSegment seg : near) {
            if (prevIndex != seg.index - 1) {
                if (subsection != null && !subsection.isEmpty()) {
                    subsections.add(subsection);
                }
                subsection = new ArrayList();
            }
            subsection.add(seg);
            prevIndex = seg.index;
        }
        if (subsection != null && !subsection.isEmpty()) {
            subsections.add(subsection);
        }
        SpriteAPI sprite = Global.getSettings().getSprite("misc", this.params.spriteKey1);
        sprite.setNormalBlend();
        sprite.setColor(this.params.spriteColor);
        SpriteAPI edge = Global.getSettings().getSprite("misc", this.params.edgeKey);
        edge.setNormalBlend();
        edge.setColor(this.params.edgeColor);
        for (List list : subsections) {
            this.renderSegments(sprite, edge, viewport.getAlphaMult(), list);
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float f = Global.getSector().getViewport().getViewMult();
        GL11.glLineWidth((float)Math.max(1.0f, Math.min(2.0f, 2.0f / f)));
        GL11.glEnable((int)2848);
        Misc.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        Misc.setColor(Color.white);
        float f2 = -1.0f;
        boolean curvedTrails = true;
        boolean useTex = false;
        if (!useTex) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glLineWidth((float)Math.max(1.0f, Math.min(2.0f, 2.0f / f)));
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
        }
        if (!curvedTrails) {
            GL11.glBegin((int)1);
        }
        if (useTex) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            SpriteAPI line = Global.getSettings().getSprite("graphics/hud/line4x4.png");
            line.bindTexture();
        }
        for (SlipstreamParticle p : this.particles) {
            Vector2f end;
            Vector2f mid;
            SlipstreamSegment seg = this.getSegmentForDist(p.dist);
            if (seg == null || !nearSet.contains(seg)) continue;
            float a = viewport.getAlphaMult();
            if (p.remaining <= 0.5f) {
                a = p.remaining / 0.5f;
            } else if (p.elapsed < this.params.particleFadeInTime) {
                a = p.elapsed / this.params.particleFadeInTime;
            }
            a *= this.getFaderBrightness(p.dist);
            float yPos = p.yPos;
            if (curvedTrails) {
                Vector2f curr;
                if (useTex) {
                    GL11.glBegin((int)8);
                    curr = this.getPointAt(p.dist, yPos);
                    if (curr == null || !viewport.isNearViewport(curr, p.speed * this.params.lineLengthFractionOfSpeed + 50.0f)) {
                        GL11.glEnd();
                        continue;
                    }
                    float iter = 5.0f;
                    float incr = p.speed * this.params.lineLengthFractionOfSpeed / iter;
                    float lw = 1.0f;
                    float i = 0.0f;
                    while (i < iter) {
                        float min = incr * 1.0f;
                        float dist = p.dist - i * incr - min;
                        Vector2f next = this.getPointAt(dist, yPos);
                        if (next == null) break;
                        Vector2f perp = this.getNormalAt(dist);
                        if (perp == null) {
                            GL11.glEnd();
                            break;
                        }
                        float a1 = a * (iter - i) / (iter - 1.0f);
                        if (i == 0.0f) {
                            a1 = 0.0f;
                        }
                        Misc.setColor(p.color, a1);
                        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                        GL11.glVertex2f((float)(curr.x + perp.x * lw), (float)(curr.y + perp.y * lw));
                        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                        GL11.glVertex2f((float)(curr.x - perp.x * lw), (float)(curr.y - perp.y * lw));
                        curr = next;
                        i += 1.0f;
                    }
                    GL11.glEnd();
                    continue;
                }
                GL11.glBegin((int)3);
                curr = this.getPointAt(p.dist, yPos);
                if (curr == null || !viewport.isNearViewport(curr, p.speed * this.params.lineLengthFractionOfSpeed + 50.0f)) {
                    GL11.glEnd();
                    continue;
                }
                float iter = 5.0f;
                float incr = p.speed * this.params.lineLengthFractionOfSpeed / iter;
                float i = 0.0f;
                while (i < iter) {
                    float min = incr * 0.5f;
                    Vector2f next = this.getPointAt(p.dist - i * incr - min, yPos);
                    if (next == null) {
                        GL11.glEnd();
                        break;
                    }
                    float a1 = a * (iter - i) / (iter - 1.0f);
                    if (i == 0.0f) {
                        a1 = 0.0f;
                    }
                    Misc.setColor(p.color, a1);
                    GL11.glVertex2f((float)curr.x, (float)curr.y);
                    curr = next;
                    i += 1.0f;
                }
                GL11.glEnd();
                continue;
            }
            Vector2f start = this.getPointAt(p.dist + p.speed * this.params.lineLengthFractionOfSpeed * 0.1f, yPos);
            if (start == null || !viewport.isNearViewport(start, 500.0f) || (mid = this.getPointAt(p.dist, yPos)) == null || (end = this.getPointAt(p.dist - p.speed * this.params.lineLengthFractionOfSpeed * 0.9f, yPos)) == null) continue;
            Misc.setColor(p.color, 0.0f);
            GL11.glVertex2f((float)start.x, (float)start.y);
            Misc.setColor(p.color, a);
            GL11.glVertex2f((float)mid.x, (float)mid.y);
            GL11.glVertex2f((float)mid.x, (float)mid.y);
            Misc.setColor(p.color, 0.0f);
            GL11.glVertex2f((float)end.x, (float)end.y);
        }
        if (!curvedTrails) {
            GL11.glEnd();
        }
    }

    public void renderSegments(SpriteAPI sprite, SpriteAPI edge, float alpha, List<SlipstreamSegment> segments) {
        Vector2f p2;
        Vector2f p1;
        Vector2f p22;
        Vector2f p12;
        float a;
        SlipstreamSegment curr;
        boolean subtract;
        GL11.glEnable((int)3553);
        sprite.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = sprite.getColor();
        boolean wireframe = false;
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
        }
        if (subtract = false) {
            GL14.glBlendEquation((int)32779);
        }
        Color c = Color.black;
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        int alphaInDeep = 255;
        int alphaOutside = 0;
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        GL11.glBegin((int)8);
        int i = 0;
        while (i < segments.size()) {
            curr = segments.get(i);
            a = curr.fader.getBrightness();
            c = this.entity.isInHyperspace() && plugin.isInClouds(curr.loc, 100.0f) ? Misc.setAlpha(c, alphaInDeep) : Misc.setAlpha(c, alphaOutside);
            p12 = new Vector2f((ReadableVector2f)curr.loc);
            p12.x += curr.normal.x * curr.width * 0.5f;
            p12.y += curr.normal.y * curr.width * 0.5f;
            p22 = new Vector2f((ReadableVector2f)curr.loc);
            p22.x += curr.normal.x * (curr.width * 0.5f - this.params.edgeWidth);
            p22.y += curr.normal.y * (curr.width * 0.5f - this.params.edgeWidth);
            p12.x += curr.wobble1.vector.x;
            p12.y += curr.wobble1.vector.y;
            Misc.setColor(c, alpha * 0.0f * a);
            GL11.glVertex2f((float)p12.x, (float)p12.y);
            Misc.setColor(c, alpha * 1.0f * a);
            GL11.glVertex2f((float)p22.x, (float)p22.y);
            ++i;
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        i = 0;
        while (i < segments.size()) {
            curr = segments.get(i);
            a = curr.fader.getBrightness();
            c = this.entity.isInHyperspace() && plugin.isInClouds(curr.loc, 100.0f) ? Misc.setAlpha(c, alphaInDeep) : Misc.setAlpha(c, alphaOutside);
            p12 = new Vector2f((ReadableVector2f)curr.loc);
            p12.x -= curr.normal.x * curr.width * 0.5f;
            p12.y -= curr.normal.y * curr.width * 0.5f;
            p22 = new Vector2f((ReadableVector2f)curr.loc);
            p22.x -= curr.normal.x * (curr.width * 0.5f - this.params.edgeWidth);
            p22.y -= curr.normal.y * (curr.width * 0.5f - this.params.edgeWidth);
            p12.x += curr.wobble2.vector.x;
            p12.y += curr.wobble2.vector.y;
            Misc.setColor(c, alpha * 0.0f * a);
            GL11.glVertex2f((float)p12.x, (float)p12.y);
            Misc.setColor(c, alpha * 1.0f * a);
            GL11.glVertex2f((float)p22.x, (float)p22.y);
            ++i;
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        i = 0;
        while (i < segments.size()) {
            curr = segments.get(i);
            a = curr.fader.getBrightness();
            c = this.entity.isInHyperspace() && plugin.isInClouds(curr.loc, 100.0f) ? Misc.setAlpha(c, alphaInDeep) : Misc.setAlpha(c, alphaOutside);
            p12 = new Vector2f((ReadableVector2f)curr.loc);
            p12.x += curr.normal.x * (curr.width * 0.5f - this.params.edgeWidth);
            p12.y += curr.normal.y * (curr.width * 0.5f - this.params.edgeWidth);
            p22 = new Vector2f((ReadableVector2f)curr.loc);
            p22.x -= curr.normal.x * (curr.width * 0.5f - this.params.edgeWidth);
            p22.y -= curr.normal.y * (curr.width * 0.5f - this.params.edgeWidth);
            Misc.setColor(c, alpha * 1.0f * a);
            GL11.glVertex2f((float)p12.x, (float)p12.y);
            GL11.glVertex2f((float)p22.x, (float)p22.y);
            ++i;
        }
        GL11.glEnd();
        if (!wireframe) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
        }
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)8);
        i = 0;
        while (i < segments.size()) {
            curr = segments.get(i);
            a = curr.fader.getBrightness();
            p12 = new Vector2f((ReadableVector2f)curr.loc);
            p12.x += curr.normal.x * curr.width * 0.5f;
            p12.y += curr.normal.y * curr.width * 0.5f;
            p22 = new Vector2f((ReadableVector2f)curr.loc);
            p22.x -= curr.normal.x * curr.width * 0.5f;
            p22.y -= curr.normal.y * curr.width * 0.5f;
            p12.x += curr.wobble1.vector.x;
            p12.y += curr.wobble1.vector.y;
            p22.x += curr.wobble2.vector.x;
            p22.y += curr.wobble2.vector.y;
            Misc.setColor(color, alpha * 1.0f * a);
            GL11.glTexCoord2f((float)curr.tx, (float)0.0f);
            GL11.glVertex2f((float)p12.x, (float)p12.y);
            GL11.glTexCoord2f((float)curr.tx, (float)1.0f);
            GL11.glVertex2f((float)p22.x, (float)p22.y);
            ++i;
        }
        GL11.glEnd();
        color = edge.getColor();
        float wobbleMult = 0.5f;
        edge.bindTexture();
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glBegin((int)8);
        int i2 = 0;
        while (i2 < segments.size()) {
            SlipstreamSegment curr2 = segments.get(i2);
            float a2 = curr2.fader.getBrightness();
            p1 = new Vector2f((ReadableVector2f)curr2.loc);
            p1.x += curr2.normal.x * curr2.width * 0.5f;
            p1.y += curr2.normal.y * curr2.width * 0.5f;
            p2 = new Vector2f((ReadableVector2f)curr2.loc);
            p2.x += curr2.normal.x * (curr2.width * 0.5f - this.params.edgeWidth);
            p2.y += curr2.normal.y * (curr2.width * 0.5f - this.params.edgeWidth);
            p1.x += curr2.wobble1.vector.x * wobbleMult;
            p1.y += curr2.wobble1.vector.y * wobbleMult;
            p2.x += curr2.wobble1.vector.x * wobbleMult;
            p2.y += curr2.wobble1.vector.y * wobbleMult;
            Misc.setColor(color, alpha * 1.0f * a2);
            GL11.glTexCoord2f((float)curr2.txe1, (float)1.0f);
            GL11.glVertex2f((float)p1.x, (float)p1.y);
            GL11.glTexCoord2f((float)curr2.txe1, (float)0.0f);
            GL11.glVertex2f((float)p2.x, (float)p2.y);
            ++i2;
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        i2 = 0;
        while (i2 < segments.size()) {
            SlipstreamSegment curr3 = segments.get(i2);
            float a3 = curr3.fader.getBrightness();
            p1 = new Vector2f((ReadableVector2f)curr3.loc);
            p1.x -= curr3.normal.x * curr3.width * 0.5f;
            p1.y -= curr3.normal.y * curr3.width * 0.5f;
            p2 = new Vector2f((ReadableVector2f)curr3.loc);
            p2.x -= curr3.normal.x * (curr3.width * 0.5f - this.params.edgeWidth);
            p2.y -= curr3.normal.y * (curr3.width * 0.5f - this.params.edgeWidth);
            p1.x += curr3.wobble2.vector.x * wobbleMult;
            p1.y += curr3.wobble2.vector.y * wobbleMult;
            p2.x += curr3.wobble2.vector.x * wobbleMult;
            p2.y += curr3.wobble2.vector.y * wobbleMult;
            Misc.setColor(color, alpha * 1.0f * a3);
            GL11.glTexCoord2f((float)curr3.txe2, (float)1.0f);
            GL11.glVertex2f((float)p1.x, (float)p1.y);
            GL11.glTexCoord2f((float)curr3.txe2, (float)0.0f);
            GL11.glVertex2f((float)p2.x, (float)p2.y);
            ++i2;
        }
        GL11.glEnd();
        if (subtract) {
            GL14.glBlendEquation((int)32774);
        }
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    public Color getRandomColor() {
        return Misc.interpolateColor(this.params.minColor, this.params.maxColor, (float)Math.random());
    }

    public float[] getLengthAndWidthFractionWithinStream(Vector2f loc) {
        float dist = Misc.getDistance(loc, this.entity.getLocation());
        if (dist > this.getRenderRange()) {
            return null;
        }
        List<SlipstreamSegment> near = this.getSegmentsNear(loc, 0.0f);
        for (SlipstreamSegment curr : near) {
            float width;
            Vector2f nextNormalP;
            SlipstreamSegment next = null;
            if (this.segments.size() > curr.index + 1) {
                next = this.segments.get(curr.index + 1);
            } else {
                next = new SlipstreamSegment();
                next.wobbledWidth = curr.wobbledWidth;
                next.normal = curr.normal;
                next.loc = new Vector2f((ReadableVector2f)curr.dir);
                next.loc.scale(curr.lengthToPrev);
                Vector2f.add((Vector2f)next.loc, (Vector2f)curr.loc, (Vector2f)next.loc);
                next.lengthToPrev = curr.lengthToPrev;
            }
            Vector2f p3 = loc;
            Vector2f p1 = curr.loc;
            Vector2f p2 = next.loc;
            Vector2f currNormalP1 = new Vector2f((ReadableVector2f)curr.loc);
            Vector2f currNormalP2 = new Vector2f((ReadableVector2f)curr.normal);
            currNormalP2.scale(100.0f);
            Vector2f.add((Vector2f)currNormalP2, (Vector2f)currNormalP1, (Vector2f)currNormalP2);
            Vector2f nextNormalP1 = new Vector2f((ReadableVector2f)next.loc);
            Vector2f nextNormalP2 = new Vector2f((ReadableVector2f)next.normal);
            nextNormalP2.scale(100.0f);
            Vector2f.add((Vector2f)nextNormalP2, (Vector2f)nextNormalP1, (Vector2f)nextNormalP2);
            Vector2f dir = new Vector2f((ReadableVector2f)curr.dir);
            dir.scale(100.0f);
            Vector2f p4 = Vector2f.add((Vector2f)p3, (Vector2f)dir, (Vector2f)new Vector2f());
            Vector2f currNormalP = Misc.intersectLines(currNormalP1, currNormalP2, p3, p4);
            if (currNormalP == null || (nextNormalP = Misc.intersectLines(nextNormalP1, nextNormalP2, p3, p4)) == null) continue;
            float u = (p3.x - currNormalP.x) * (nextNormalP.x - currNormalP.x) + (p3.y - currNormalP.y) * (nextNormalP.y - currNormalP.y);
            float denom = Vector2f.sub((Vector2f)nextNormalP, (Vector2f)currNormalP, (Vector2f)new Vector2f()).length();
            if ((denom *= denom) == 0.0f || !((u /= denom) >= 0.0f) || !(u <= 1.0f)) continue;
            Vector2f normalAtP3 = Misc.interpolateVector(curr.normal, next.normal, u);
            normalAtP3.scale(100.0f);
            Vector2f p3PlusNormal = Vector2f.add((Vector2f)p3, (Vector2f)normalAtP3, (Vector2f)new Vector2f());
            Vector2f intersect = Misc.intersectLines(p1, p2, p3, p3PlusNormal);
            if (intersect == null) continue;
            float distFromLine = Vector2f.sub((Vector2f)intersect, (Vector2f)p3, (Vector2f)new Vector2f()).length();
            if (distFromLine >= (width = Misc.interpolate(curr.wobbledWidth, next.wobbledWidth, u)) / 2.0f) {
                return null;
            }
            float[] result = new float[]{curr.totalLength + u * next.lengthToPrev, distFromLine / (width / 2.0f)};
            float currToLoc = Misc.getAngleInDegrees(p1, p3);
            float segDir = Misc.getAngleInDegrees(p1, p2);
            if (Misc.getClosestTurnDirection(segDir, currToLoc) < 0.0f) {
                result[1] = -result[1];
            }
            return result;
        }
        return null;
    }

    public void applyEffectToFleets(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            this.applyEffect(fleet, days);
        }
    }

    public void applyEffect(SectorEntityToken other, float days) {
        if (other instanceof CampaignFleetAPI) {
            float fleetSpeedAlongWind;
            boolean fleetTryingToMove;
            CampaignFleetAPI fleet = (CampaignFleetAPI)other;
            float[] offset = this.getLengthAndWidthFractionWithinStream(fleet.getLocation());
            if (offset == null) {
                if (fleet.isPlayerFleet()) {
                    ++this.playerWasInSlipstreamFramesAgo;
                    if (this.playerWasInSlipstreamFramesAgo > 1000) {
                        this.playerWasInSlipstreamFramesAgo = 1000;
                    }
                }
                return;
            }
            float distAlong = offset[0];
            float yOff = offset[1];
            float intensity = this.getIntensity(yOff);
            float wMult = this.getWidthBasedSpeedMult(distAlong);
            intensity *= wMult;
            if ((intensity *= this.getFaderBrightness(distAlong)) <= 0.0f) {
                if (fleet.isPlayerFleet()) {
                    ++this.playerWasInSlipstreamFramesAgo;
                    if (this.playerWasInSlipstreamFramesAgo > 1000) {
                        this.playerWasInSlipstreamFramesAgo = 1000;
                    }
                }
                return;
            }
            if (fleet.isPlayerFleet()) {
                if (this.playerWasInSlipstreamFramesAgo > 5) {
                    fleet.addFloatingText("Entering slipstream", Misc.setAlpha(fleet.getIndicatorColor(), 255), 0.5f);
                }
                this.playerWasInSlipstreamFramesAgo = 0;
            }
            float maxFleetBurn = fleet.getFleetData().getBurnLevel();
            float currFleetBurn = fleet.getCurrBurnLevel();
            float maxWindBurn = (float)this.params.burnLevel * 2.0f;
            float currWindBurn = intensity * maxWindBurn;
            float maxFleetBurnIntoWind = maxFleetBurn - Math.abs(currWindBurn);
            float seconds = days * Global.getSector().getClock().getSecondsPerDay();
            Vector2f p1 = this.getPointAt(distAlong, yOff);
            Vector2f p2 = this.getPointAt(distAlong + 1.0f, yOff);
            if (p1 == null || p2 == null) {
                if (fleet.isPlayerFleet()) {
                    ++this.playerWasInSlipstreamFramesAgo;
                    if (this.playerWasInSlipstreamFramesAgo > 1000) {
                        this.playerWasInSlipstreamFramesAgo = 1000;
                    }
                }
                return;
            }
            Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
            if (currWindBurn < 0.0f) {
                windDir.negate();
            }
            Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)fleet.getVelocity()));
            float baseFleetAccel = fleet.getTravelSpeed();
            if (baseFleetAccel < 10.0f) {
                baseFleetAccel = 10.0f;
            }
            boolean bl = fleetTryingToMove = fleet.getMoveDestination() != null && Misc.getDistance(fleet.getLocation(), fleet.getMoveDestination()) > fleet.getRadius() + 10.0f;
            if (fleet.isPlayerFleet()) {
                fleetTryingToMove &= Global.getSector().getCampaignUI().isPlayerFleetFollowingMouse() || fleet.wasSlowMoving();
            }
            float windSpeedReduction = 0.0f;
            if (!fleetTryingToMove) {
                Vector2f dest = new Vector2f((ReadableVector2f)windDir);
                dest.scale(1000.0f);
                Vector2f.add((Vector2f)dest, (Vector2f)fleet.getLocation(), (Vector2f)dest);
                fleet.setMoveDestination(dest.x, dest.y);
            } else {
                Vector2f moveDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(fleet.getLocation(), fleet.getMoveDestination()));
                float dot = Vector2f.dot((Vector2f)windDir, (Vector2f)moveDir);
                if (fleet.wasSlowMoving()) {
                    dot = -1.0f;
                }
                if (dot < 0.0f) {
                    float accelBasedMult = fleet.getAcceleration() / baseFleetAccel;
                    if ((accelBasedMult *= accelBasedMult) > 1.0f) {
                        accelBasedMult = 1.0f;
                    }
                    if (accelBasedMult < 0.1f) {
                        accelBasedMult = 0.1f;
                    }
                    windSpeedReduction = -dot * fleet.getFleetData().getBurnLevel() * accelBasedMult;
                }
            }
            float burnBonus = fleet.getFleetData().getBurnLevel() - fleet.getFleetData().getMinBurnLevel();
            if (burnBonus < 0.0f) {
                burnBonus = 0.0f;
            }
            float maxSpeedWithWind = Misc.getSpeedForBurnLevel((float)this.params.burnLevel * intensity + burnBonus);
            if (windSpeedReduction > 0.0f) {
                maxSpeedWithWind = Misc.getSpeedForBurnLevel(Math.max((float)this.params.burnLevel * 0.5f * intensity, (float)this.params.burnLevel * intensity - windSpeedReduction));
            }
            if ((fleetSpeedAlongWind = Vector2f.dot((Vector2f)windDir, (Vector2f)fleet.getVelocity())) >= maxSpeedWithWind) {
                return;
            }
            velDir.scale(currFleetBurn);
            float fleetBurnAgainstWind = -1.0f * Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
            float windSpeed = Misc.getSpeedForBurnLevel(currWindBurn);
            Vector2f windVector = new Vector2f((ReadableVector2f)windDir);
            windVector.scale(windSpeed);
            Vector2f vel = fleet.getVelocity();
            Vector2f diff = Vector2f.sub((Vector2f)windVector, (Vector2f)vel, (Vector2f)new Vector2f());
            float max = diff.length();
            diff = Misc.normalise(diff);
            diff.scale(fleet.getAcceleration() * 3.0f * seconds);
            if (diff.length() > max) {
                diff.scale(max / diff.length());
            }
            float accelMult = 0.5f;
            if (fleetBurnAgainstWind > maxFleetBurnIntoWind) {
                accelMult += 0.75f + 0.25f * (fleetBurnAgainstWind - maxFleetBurnIntoWind);
            }
            windDir.scale(seconds * baseFleetAccel * accelMult);
            fleet.setVelocity(vel.x + windDir.x, vel.y + windDir.y);
            boolean withGlow = true;
            if (withGlow) {
                Color glowColor = this.params.windGlowColor;
                int alpha = glowColor.getAlpha();
                if (alpha < 75) {
                    glowColor = Misc.setAlpha(glowColor, 75);
                }
                p1 = this.getNoWobblePointAt(distAlong, yOff);
                p2 = this.getNoWobblePointAt(distAlong + 100.0f, yOff);
                if (p1 != null && p2 != null) {
                    windDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
                    String modId = "slipstream_" + this.entity.getId();
                    float durIn = 1.0f;
                    float durOut = 3.0f;
                    float sizeNormal = 5.0f + 10.0f * intensity;
                    for (FleetMemberViewAPI view : fleet.getViews()) {
                        view.getWindEffectDirX().shift(modId, windDir.x * sizeNormal, durIn, durOut, 1.0f);
                        view.getWindEffectDirY().shift(modId, windDir.y * sizeNormal, durIn, durOut, 1.0f);
                        view.getWindEffectColor().shift(modId, glowColor, durIn, durOut, 1.0f);
                    }
                }
            }
        }
    }

    public Vector2f getPointAt(float lengthAlongStream, float offset) {
        SlipstreamSegment curr = this.getSegmentForDist(lengthAlongStream);
        if (curr == null) {
            return null;
        }
        int index = curr.index;
        SlipstreamSegment next = null;
        SlipstreamSegment next2 = null;
        if (index >= this.segments.size() - 1) {
            return null;
        }
        if (index % 2 == 0) {
            next = this.segments.get(index + 1);
            if (index >= this.segments.size() - 2) {
                next2 = new SlipstreamSegment();
                next2.wobbledWidth = next.wobbledWidth;
                next2.normal = next.normal;
                next2.loc = new Vector2f((ReadableVector2f)next.dir);
                next2.loc.scale(next.lengthToPrev);
                Vector2f.add((Vector2f)next2.loc, (Vector2f)next.loc, (Vector2f)next2.loc);
                next2.lengthToPrev = next.lengthToPrev;
            } else {
                next2 = this.segments.get(index + 2);
            }
        }
        if (index % 2 != 0) {
            if (index >= this.segments.size() - 1) {
                return null;
            }
            curr = this.segments.get(index - 1);
            next = this.segments.get(index);
            next2 = this.segments.get(index + 1);
        }
        float lenForT = lengthAlongStream - curr.totalLength;
        float t = lenForT / (curr.lengthToNext + next2.lengthToPrev);
        Vector2f p0 = new Vector2f((ReadableVector2f)curr.loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)next.locB);
        Vector2f p2 = new Vector2f((ReadableVector2f)next2.loc);
        p0.x += curr.normal.x * curr.wobbledWidth * 0.5f * offset;
        p0.y += curr.normal.y * curr.wobbledWidth * 0.5f * offset;
        p2.x += next2.normal.x * next2.wobbledWidth * 0.5f * offset;
        p2.y += next2.normal.y * next2.wobbledWidth * 0.5f * offset;
        p1.x += next.normal.x * next.wobbledWidth * 0.5f * offset;
        p1.y += next.normal.y * next.wobbledWidth * 0.5f * offset;
        Vector2f p = Misc.bezier(p0, p1, p2, t);
        return p;
    }

    public Vector2f getNoWobblePointAt(float lengthAlongStream, float offset) {
        SlipstreamSegment curr = this.getSegmentForDist(lengthAlongStream);
        if (curr == null) {
            return null;
        }
        int index = curr.index;
        if (index >= this.segments.size() - 2) {
            return null;
        }
        SlipstreamSegment next = this.segments.get(index + 1);
        SlipstreamSegment next2 = this.segments.get(index + 2);
        if (index % 2 != 0) {
            curr = this.segments.get(index - 1);
            next = this.segments.get(index);
            next2 = this.segments.get(index + 1);
        }
        float lenForT = lengthAlongStream - curr.totalLength;
        float t = lenForT / (curr.lengthToNext + next.lengthToNext);
        Vector2f p0 = new Vector2f((ReadableVector2f)curr.loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)next.locB);
        Vector2f p2 = new Vector2f((ReadableVector2f)next2.loc);
        float edges = this.params.edgeWidth * 2.0f * 0.5f;
        p0.x += curr.normal.x * (curr.width - edges) * 0.5f * offset;
        p0.y += curr.normal.y * (curr.width - edges) * 0.5f * offset;
        p2.x += next2.normal.x * (next2.width - edges) * 0.5f * offset;
        p2.y += next2.normal.y * (next2.width - edges) * 0.5f * offset;
        p1.x += next.normal.x * (next.width - edges) * 0.5f * offset;
        p1.y += next.normal.y * (next.width - edges) * 0.5f * offset;
        Vector2f p = Misc.bezier(p0, p1, p2, t);
        return p;
    }

    public Vector2f getNormalAt(float lengthAlongStream) {
        Vector2f perp;
        float lenForT;
        float f;
        SlipstreamSegment curr = this.getSegmentForDist(lengthAlongStream);
        if (curr == null) {
            return null;
        }
        int index = curr.index;
        if (index >= this.segments.size() - 2) {
            return null;
        }
        SlipstreamSegment next = this.segments.get(index + 1);
        SlipstreamSegment next2 = this.segments.get(index + 2);
        if (index % 2 != 0) {
            curr = this.segments.get(index - 1);
            next = this.segments.get(index);
            next2 = this.segments.get(index + 1);
        }
        if ((f = (lenForT = lengthAlongStream - curr.totalLength) / curr.lengthToNext) < 1.0f) {
            perp = Misc.interpolateVector(curr.normal, next.normal, f);
        } else {
            f = (lenForT - curr.lengthToNext) / next.lengthToNext;
            perp = Misc.interpolateVector(next.normal, next2.normal, f);
        }
        return perp;
    }

    public List<SlipstreamSegment> getSegmentsNear(Vector2f loc, float range) {
        ArrayList<SlipstreamSegment> result = new ArrayList<SlipstreamSegment>();
        int boxIndex = 0;
        for (BoundingBox box : this.bounds) {
            if (box.pointNeedsDetailedCheck(loc, range)) {
                int min;
                int i = min = boxIndex * this.segmentsPerBox;
                while (i < min + this.segmentsPerBox && i < this.segments.size()) {
                    float r;
                    SlipstreamSegment curr = this.segments.get(i);
                    float distSq = Misc.getDistanceSq(curr.loc, loc);
                    if (distSq < (r = range + curr.width + Math.max(curr.lengthToPrev, curr.lengthToNext)) * r) {
                        result.add(curr);
                    }
                    ++i;
                }
            }
            ++boxIndex;
        }
        return result;
    }

    public static class SlipstreamParams2 {
        public String spriteKey1 = "slipstream";
        public String edgeKey = "slipstream_edge3";
        public Color spriteColor = new Color(0.3f, 0.5f, 1.0f, 1.0f);
        public Color windGlowColor = new Color(0.3f, 0.5f, 1.0f, 1.0f);
        public Color edgeColor = Color.white;
        public float edgeWidth = 256.0f;
        public float areaPerParticle = 2875.0f;
        public int maxParticles = 2000;
        public float minSpeed;
        public float maxSpeed;
        public int burnLevel = 30;
        public Color minColor;
        public Color maxColor;
        public float particleFadeInTime = 1.0f;
        public float minDur = 0.0f;
        public float maxDur = 4.0f;
        public float lineLengthFractionOfSpeed = 0.5f;
        public boolean slowDownInWiderSections = false;
        public float widthForMaxSpeed = 1.0f;
        public float widthForMaxSpeedMinMult = 0.5f;
        public float widthForMaxSpeedMaxMult = 1.5f;
    }

    public static class SlipstreamParticle {
        float speed;
        float dist;
        float yPos;
        Color color;
        float remaining;
        float elapsed;
    }

    public static class SlipstreamSegment {
        public Vector2f locB = new Vector2f();
        public Vector2f loc = new Vector2f();
        public Vector2f dir = new Vector2f();
        public float width;
        public transient float wobbledWidth;
        public transient int index = 0;
        public transient Vector2f normal = new Vector2f();
        public transient float tx = 0.0f;
        public transient float txe1 = 0.0f;
        public transient float txe2 = 0.0f;
        public transient float totalLength;
        public transient float lengthToPrev;
        public transient float lengthToNext;
        public MutatingVertexUtil wobble1;
        public MutatingVertexUtil wobble2;
        public FaderUtil fader = new FaderUtil(0.0f, 1.0f, 1.0f);
    }
}

