/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.impl.campaign.velfield.VelocityField;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TurbulenceCalc2 {
    public static void advance(TurbulenceParams params) {
        Vector2f v;
        int j;
        if (params.propagationAmount > 1.0f) {
            params.propagationAmount = 1.0f;
        }
        Vector2f[][] f = params.field.getField();
        float s = params.field.getCellSize();
        float effectWidth = params.effectWidth;
        float effectLength = params.effectLength;
        Vector2f[][] delta = new Vector2f[f.length][f[0].length];
        int i = 0;
        while (i < f.length) {
            j = 0;
            while (j < f[0].length) {
                delta[i][j] = new Vector2f();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < f.length) {
            j = 0;
            while (j < f[0].length) {
                float cx = (float)i * s;
                float cy = (float)j * s;
                v = f[i][j];
                Vector2f dir = Misc.normalise(new Vector2f((ReadableVector2f)v));
                Vector2f p1 = new Vector2f((ReadableVector2f)dir);
                p1.scale(-effectLength * 0.5f);
                p1.x += cx;
                p1.y += cy;
                Vector2f p2 = new Vector2f((ReadableVector2f)dir);
                p2.scale(effectLength * 0.5f);
                p2.x += cx;
                p2.y += cy;
                float minX = Math.min(p1.x - effectWidth * 0.5f, p2.x - effectWidth * 0.5f);
                float maxX = Math.max(p1.x + effectWidth * 0.5f, p2.x + effectWidth * 0.5f);
                float minY = Math.min(p1.y - effectLength * 0.5f, p2.y - effectLength * 0.5f);
                float maxY = Math.max(p1.y + effectLength * 0.5f, p2.y + effectLength * 0.5f);
                int cellX1 = (int)(minX / s);
                int cellY1 = (int)(minY / s);
                if (minX < 0.0f) {
                    cellX1 = (int)(-1.0f * Math.abs(minX) / s) - 1;
                }
                if (minY < 0.0f) {
                    cellY1 = (int)(-1.0f * Math.abs(minY) / s) - 1;
                }
                int cellX2 = (int)(maxX / s);
                int cellY2 = (int)(maxY / s);
                if (maxX < 0.0f) {
                    cellX2 = (int)(-1.0f * Math.abs(maxX) / s) - 1;
                }
                if (maxY < 0.0f) {
                    cellY2 = (int)(-1.0f * Math.abs(maxY) / s) - 1;
                }
                maxX += 1.0f;
                maxY += 1.0f;
                float velDir = Misc.getAngleInDegrees(dir);
                velDir = Misc.normalizeAngle(velDir);
                ArrayList<DeltaData> deltaData = new ArrayList<DeltaData>();
                int a = cellX1;
                while (a <= cellX2) {
                    int b = cellY1;
                    while (b <= cellY2) {
                        if (a != i || b != j) {
                            Vector2f p3 = new Vector2f((float)a * s, (float)b * s);
                            float u = (p3.x - p1.x) * (p2.x - p1.x) + (p3.y - p1.y) * (p2.y - p1.y);
                            float denom = Vector2f.sub((Vector2f)p2, (Vector2f)p1, (Vector2f)new Vector2f()).length();
                            if ((denom *= denom) != 0.0f && (u /= denom) >= 0.0f && u <= 1.0f) {
                                Vector2f intersect = new Vector2f();
                                intersect.x = p1.x + u * (p2.x - p1.x);
                                intersect.y = p1.y + u * (p2.y - p1.y);
                                float distFromLine = Vector2f.sub((Vector2f)intersect, (Vector2f)p3, (Vector2f)new Vector2f()).length();
                                float distAlongLine = Math.abs((u - 0.5f) * effectLength);
                                if (!(distFromLine > effectWidth * 0.5f) && !(distAlongLine > effectLength * 0.5f)) {
                                    float rateMult = 0.5f * (1.0f - distFromLine / (effectWidth * 0.5f)) + 0.5f * (1.0f - distAlongLine / (effectLength * 0.5f));
                                    float offsetMult = distFromLine / (effectWidth * 0.5f) * (0.5f + 0.5f * distAlongLine / (effectLength * 0.5f));
                                    float deltaAngleOffset = offsetMult * params.maxDispersionAngle;
                                    float offsetDir = 0.0f;
                                    float diff = Misc.normalizeAngle(Misc.getAngleInDegrees(p1, p3)) - velDir;
                                    if (diff < 0.0f) {
                                        diff += 360.0f;
                                    }
                                    offsetDir = diff == 0.0f || diff == 360.0f ? 0.0f : (diff > 180.0f ? -1.0f : 1.0f);
                                    Vector2f dv = Misc.getUnitVectorAtDegreeAngle(velDir + deltaAngleOffset * offsetDir);
                                    Vector2f d = TurbulenceCalc2.getCell(delta, a, b);
                                    Vector2f destVel = TurbulenceCalc2.getCell(f, a, b);
                                    DeltaData data = new DeltaData(d, destVel, dv, rateMult);
                                    deltaData.add(data);
                                }
                            }
                        }
                        ++b;
                    }
                    ++a;
                }
                float totalWeight = 0.0f;
                for (DeltaData data : deltaData) {
                    totalWeight += data.weight;
                }
                float speed = v.length();
                float energy = 0.5f * speed * speed;
                float energyToTransfer = energy * params.propagationAmount;
                if (totalWeight > 0.0f) {
                    for (DeltaData data : deltaData) {
                        float mult = data.weight / totalWeight;
                        float energyToAdd = energyToTransfer * mult;
                        float speedOther = data.velocity.length();
                        float speedOtherNew = (float)Math.sqrt(speedOther * speedOther + params.energyTransferMult * energyToAdd);
                        float speedAdd = speedOtherNew - speedOther;
                        data.delta.x += data.dir.x * speedAdd;
                        data.delta.y += data.dir.y * speedAdd;
                    }
                    float speedNew = (float)Math.sqrt(speed * speed - 2.0f * energyToTransfer);
                    float speedAdd = speedNew - speed;
                    Vector2f deltaForCurrCell = TurbulenceCalc2.getCell(delta, i, j);
                    deltaForCurrCell.x += dir.x * speedAdd;
                    deltaForCurrCell.y += dir.y * speedAdd;
                }
                ++j;
            }
            ++i;
        }
        float maxVel = params.maxVelocity;
        int i2 = 0;
        while (i2 < f.length) {
            int j2 = 0;
            while (j2 < f[0].length) {
                Vector2f.add((Vector2f)f[i2][j2], (Vector2f)delta[i2][j2], (Vector2f)f[i2][j2]);
                float len = f[i2][j2].length();
                if (len > maxVel) {
                    f[i2][j2].scale(maxVel / len);
                }
                ++j2;
            }
            ++i2;
        }
        float dampenFraction = params.dampenFactor;
        if (dampenFraction > 0.0f) {
            int i3 = 0;
            while (i3 < f.length) {
                int j3 = 0;
                while (j3 < f[0].length) {
                    v = f[i3][j3];
                    float speed = v.length();
                    float dampen = speed * params.propagationAmount * dampenFraction;
                    if (speed > 0.0f) {
                        v.scale((speed - dampen) / speed);
                    }
                    ++j3;
                }
                ++i3;
            }
        }
    }

    public static Vector2f getCell(Vector2f[][] data, int i, int j) {
        if (i < 0 || j < 0) {
            return new Vector2f();
        }
        if (i >= data.length || j >= data[0].length) {
            return new Vector2f();
        }
        return data[i][j];
    }

    public static void addCell(Vector2f[][] field, Vector2f[][] delta, int fromX, int fromY, int x, int y, Vector2f dir, float propagationMult) {
        Vector2f cell = TurbulenceCalc2.getCell(field, fromX, fromY);
        Vector2f d = TurbulenceCalc2.getCell(delta, x, y);
        Vector2f dFrom = TurbulenceCalc2.getCell(delta, fromX, fromY);
        float dot = Vector2f.dot((Vector2f)cell, (Vector2f)dir);
        d.x += dir.x * dot * propagationMult;
        d.y += dir.y * dot * propagationMult;
        dFrom.x -= dir.x * dot * propagationMult;
        dFrom.y -= dir.y * dot * propagationMult;
    }

    public static void addCell(Vector2f cell, Vector2f dir, Vector2f delta) {
        float dot = Vector2f.dot((Vector2f)cell, (Vector2f)dir);
        delta.x += dir.x * dot;
        delta.y += dir.y * dot;
    }

    public static class DeltaData {
        public Vector2f delta;
        public Vector2f velocity;
        public Vector2f dir;
        public float weight;

        public DeltaData(Vector2f delta, Vector2f velocity, Vector2f dir, float weight) {
            this.delta = delta;
            this.velocity = velocity;
            this.dir = dir;
            this.weight = weight;
        }
    }

    public static class TurbulenceParams {
        public VelocityField field;
        public float effectWidth;
        public float effectLength;
        public float propagationAmount;
        public float maxDispersionAngle = 120.0f;
        public float energyTransferMult = 5.0f;
        public float dampenFactor = 0.2f;
        public float maxVelocity = 1000.0f;
    }
}

