/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.velfield.TurbulenceCalc2;
import com.fs.starfarer.api.impl.campaign.velfield.VelocityField;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TurbulenceEntityPlugin
extends BaseCustomEntityPlugin {
    protected List<ParticleData> particles = new ArrayList<ParticleData>();
    protected List<ParticleData> darkParticles = new ArrayList<ParticleData>();
    protected VelocityField field;
    protected List<PointParticle> testParticles = new ArrayList<PointParticle>();
    protected int frame = 0;
    protected float distanceTravelled;

    public VelocityField getField() {
        return this.field;
    }

    public void setField(VelocityField field) {
        this.field = field;
    }

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    @Override
    public float getRenderRange() {
        float cells = Math.max(this.field.field.length, this.field.field[0].length);
        return cells * 1.5f * this.field.cellSize;
    }

    @Override
    public void advance(float amount) {
        Keyboard.isKeyDown((int)25);
        int i = 0;
        while (i < this.field.getField()[0].length) {
            int x = this.field.getField().length / 2;
            this.field.getField()[x][i].set(0.0f, 500.0f);
            ++i;
        }
        ++this.frame;
        TurbulenceCalc2.TurbulenceParams params = new TurbulenceCalc2.TurbulenceParams();
        params.field = this.field;
        params.effectWidth = 210.0f;
        params.effectLength = 410.0f;
        params.maxDispersionAngle = 120.0f;
        params.energyTransferMult = 5.0f;
        params.dampenFactor = 0.2f;
        params.maxVelocity = 1000.0f;
        params.maxDispersionAngle = 0.0f;
        params.maxVelocity = 1000.0f;
        params.energyTransferMult = 6.0f;
        params.propagationAmount = 6.0f * amount;
        TurbulenceCalc2.advance(params);
        float facing = this.entity.getFacing();
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float w = this.field.getCellSize() * (float)(this.field.getField().length - 1);
        float h = this.field.getCellSize() * (float)(this.field.getField()[0].length - 1);
        while (this.testParticles.size() < 500) {
            Vector2f loc = new Vector2f();
            loc.x = w * 0.4f + w * 0.2f * (float)Math.random();
            loc.y = h * (1.0f - (float)Math.random());
            loc = Misc.rotateAroundOrigin(loc, this.entity.getFacing());
            loc.x += x;
            loc.y += y;
            float size = 2.0f;
            float mass = 1.0E-4f;
            mass = (float)Math.random() * 10.0f;
            float dur = 0.0f + 4.0f * Misc.random.nextFloat();
            this.addTestParticle(loc, this.getRandomColor(), size, mass, dur);
        }
        Iterator<PointParticle> iter = this.testParticles.iterator();
        while (iter.hasNext()) {
            PointParticle p = iter.next();
            p.remaining -= amount;
            p.elapsed += amount;
            if (p.remaining <= 0.0f) {
                iter.remove();
                continue;
            }
            if (this.field.isInsideField(p.loc.x, p.loc.y, new Vector2f(x, y), facing)) {
                Vector2f vel = this.field.getVelocity(p.loc.x, p.loc.y, new Vector2f(x, y), facing);
                float accelAmount = 1.0f / p.mass;
                if (accelAmount > 1.0f) {
                    accelAmount = 1.0f;
                }
                Vector2f diff = Vector2f.sub((Vector2f)vel, (Vector2f)p.vel, (Vector2f)new Vector2f());
                p.vel.x += diff.x * (accelAmount *= 60.0f) * amount;
                p.vel.y += diff.y * accelAmount * amount;
            } else if (p.elapsed > 0.5f) {
                p.remaining = Math.min(p.remaining, 0.5f);
            }
            p.loc.x += p.vel.x * amount;
            p.loc.y += p.vel.y * amount;
        }
        ArrayList<ParticleData> remove = new ArrayList<ParticleData>();
        for (ParticleData p : this.particles) {
            p.advance(amount, this.field, x, y, facing);
            if (!(p.elapsed >= p.maxDur)) continue;
            remove.add(p);
        }
        this.particles.removeAll(remove);
        remove = new ArrayList();
        for (ParticleData p : this.darkParticles) {
            p.advance(amount, this.field, x, y, facing);
            if (!(p.elapsed >= p.maxDur)) continue;
            remove.add(p);
        }
        this.darkParticles.removeAll(remove);
        Vector2f vel = new Vector2f(0.0f, Misc.getSpeedForBurnLevel(30.0f));
        Vector2f dv = new Vector2f(vel.x * amount, vel.y * amount);
        this.distanceTravelled += dv.length();
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        PointParticle vel;
        float mx = Mouse.getX();
        float my = Mouse.getY();
        float wmx = Global.getSector().getViewport().convertScreenXToWorldX(mx);
        float wmy = Global.getSector().getViewport().convertScreenYToWorldY(my);
        this.entity.setFacing(0.0f);
        float facing = this.entity.getFacing();
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (Keyboard.isKeyDown((int)24)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glRotatef((float)facing, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPointSize((float)20.0f);
            GL11.glEnable((int)2832);
            GL11.glBegin((int)0);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.75f);
            int i = 0;
            while (i < this.field.field.length) {
                int j = 0;
                while (j < this.field.field[0].length) {
                    float cx = (float)i * this.field.cellSize;
                    float cy = (float)j * this.field.cellSize;
                    GL11.glVertex2f((float)cx, (float)cy);
                    ++j;
                }
                ++i;
            }
            GL11.glEnd();
            GL11.glLineWidth((float)1.0f);
            GL11.glEnable((int)2848);
            GL11.glDisable((int)3042);
            GL11.glBegin((int)1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            float scale = 1.0f;
            int i2 = 0;
            while (i2 < this.field.field.length) {
                int j = 0;
                while (j < this.field.field[0].length) {
                    Vector2f vel2 = this.field.field[i2][j];
                    float cx = (float)i2 * this.field.cellSize;
                    float cy = (float)j * this.field.cellSize;
                    GL11.glVertex2f((float)cx, (float)cy);
                    GL11.glVertex2f((float)(cx + vel2.x * scale), (float)(cy + vel2.y * scale));
                    ++j;
                }
                ++i2;
            }
            GL11.glEnd();
            GL11.glPopMatrix();
            GL11.glPointSize((float)6.0f);
            GL11.glEnable((int)2832);
            GL11.glBegin((int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex2f((float)wmx, (float)wmy);
            GL11.glEnd();
            GL11.glLineWidth((float)1.0f);
            GL11.glEnable((int)2848);
            GL11.glBegin((int)1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            vel = this.field.getVelocity(wmx, wmy, new Vector2f(x, y), facing);
            GL11.glVertex2f((float)wmx, (float)wmy);
            GL11.glVertex2f((float)(wmx + ((Vector2f)vel).x), (float)(wmy + ((Vector2f)vel).y));
            GL11.glEnd();
        }
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float zoom = Global.getSector().getViewport().getViewMult();
        GL11.glPointSize((float)(2.0f / zoom));
        GL11.glBegin((int)0);
        Iterator<PointParticle> iterator = this.testParticles.iterator();
        if (iterator.hasNext()) {
            vel = iterator.next();
        }
        GL11.glEnd();
        GL11.glLineWidth((float)3.5f);
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)2848);
        GL11.glBegin((int)1);
        for (PointParticle p : this.testParticles) {
            if (!viewport.isNearViewport(p.loc, 500.0f)) continue;
            float a = 1.0f;
            if (p.remaining <= 0.5f) {
                a = p.remaining / 0.5f;
            } else if (p.elapsed < 0.5f) {
                a = p.elapsed / 0.5f;
            }
            Vector2f prev = new Vector2f((ReadableVector2f)p.loc);
            float prevAlpha = 0.0f;
            float interval = 0.016666668f;
            float iter = 15.0f;
            int i = 0;
            while ((float)i < iter) {
                Vector2f vel3 = this.field.getVelocity(prev.x, prev.y, new Vector2f(x, y), facing);
                Vector2f loc = new Vector2f((ReadableVector2f)prev);
                loc.x -= vel3.x * interval;
                loc.y -= vel3.y * interval;
                float baseAlpha = 0.5f;
                float alpha = baseAlpha * a * (iter - (float)i) / iter;
                Misc.setColor(p.color, prevAlpha);
                GL11.glVertex2f((float)prev.x, (float)prev.y);
                Misc.setColor(p.color, alpha);
                GL11.glVertex2f((float)loc.x, (float)loc.y);
                prevAlpha = alpha;
                prev = loc;
                ++i;
            }
        }
        GL11.glEnd();
        this.renderTextureParticles(layer, viewport);
    }

    public void renderTextureParticles(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult;
        Vector2f loc;
        float size;
        float b = viewport.getAlphaMult();
        CampaignEngineLayers normalLayer = layer;
        CampaignEngineLayers darkLayer = layer;
        if (layer == normalLayer) {
            for (ParticleData p : this.particles) {
                size = p.baseSize * p.scale;
                loc = p.offset;
                alphaMult = 1.0f;
                p.sprite.setAngle(p.angle);
                p.sprite.setSize(size, size);
                p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
                p.sprite.setColor(p.color);
                p.sprite.renderAtCenter(loc.x, loc.y);
            }
        }
        if (layer == darkLayer) {
            GL14.glBlendEquation((int)32779);
            for (ParticleData p : this.darkParticles) {
                size = p.baseSize * p.scale;
                loc = p.offset;
                alphaMult = 1.0f;
                p.sprite.setAngle(p.angle);
                p.sprite.setSize(size, size);
                p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
                p.sprite.setColor(p.color);
                p.sprite.renderAtCenter(loc.x, loc.y);
            }
            GL14.glBlendEquation((int)32774);
        }
    }

    public void addTestParticle(Vector2f loc, Color color, float size, float mass, float dur) {
        PointParticle p = new PointParticle();
        p.loc.set((ReadableVector2f)loc);
        p.mass = mass;
        p.remaining = dur;
        p.size = size;
        p.color = color;
        this.testParticles.add(p);
    }

    public void addTexturedParticle(Vector2f loc, Color color, float mass, float size, float endSizeMult, float durIn, float durOut) {
        ParticleData p = new ParticleData(size, mass, durIn, durOut, endSizeMult, 30.0f, color, null);
        p.offset.set((ReadableVector2f)loc);
        this.particles.add(p);
    }

    public Color getRandomColor() {
        float r = 0.5f;
        float g = 0.3f + 0.3f * (float)Math.random();
        float b = 0.75f + 0.25f * (float)Math.random();
        float a = 0.85f + 0.15f * (float)Math.random();
        if (r < 0.0f) {
            r = 0.0f;
        }
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        if (a > 1.0f) {
            a = 1.0f;
        }
        a *= 0.33f;
        a = 1.0f;
        Color c = new Color(r, g, b, a);
        return c;
    }

    public static class ParticleData {
        public SpriteAPI sprite;
        public Vector2f offset = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public float scaleIncreaseRate = 1.0f;
        public float turnDir = 1.0f;
        public float angle = 1.0f;
        public float maxDur;
        public FaderUtil fader;
        public float elapsed = 0.0f;
        public float baseSize;
        public float mass;
        protected Color color;

        public ParticleData(float baseSize, float mass, float durIn, float durOut, float endSizeMult, float maxAngVel, Color color, String spriteSheetKey) {
            this.color = color;
            if (spriteSheetKey == null) {
                spriteSheetKey = "nebula_particles";
            }
            this.sprite = Global.getSettings().getSprite("misc", spriteSheetKey);
            float i = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            this.sprite.setTexWidth(0.25f);
            this.sprite.setTexHeight(0.25f);
            this.sprite.setTexX(i * 0.25f);
            this.sprite.setTexY(j * 0.25f);
            this.sprite.setAdditiveBlend();
            this.mass = mass;
            this.angle = (float)Math.random() * 360.0f;
            this.maxDur = durIn + durOut;
            this.scaleIncreaseRate = endSizeMult / this.maxDur;
            if (endSizeMult < 1.0f) {
                this.scaleIncreaseRate = -1.0f * endSizeMult;
            }
            this.scale = 1.0f;
            this.baseSize = baseSize;
            this.turnDir = Math.signum((float)Math.random() - 0.5f) * maxAngVel * (float)Math.random();
            this.fader = new FaderUtil(0.0f, durIn, durOut);
            this.fader.setBounceDown(true);
            this.fader.forceOut();
            this.fader.fadeIn();
        }

        public void advance(float amount, VelocityField field, float fieldX, float fieldY, float fieldFacing) {
            if (field.isInsideField(this.offset.x, this.offset.y, new Vector2f(fieldX, fieldY), fieldFacing)) {
                Vector2f fVel = field.getVelocity(this.offset.x, this.offset.y, new Vector2f(fieldX, fieldY), fieldFacing);
                float accelAmount = 1.0f / this.mass;
                if (accelAmount > 1.0f) {
                    accelAmount = 1.0f;
                }
                Vector2f diff = Vector2f.sub((Vector2f)fVel, (Vector2f)this.vel, (Vector2f)new Vector2f());
                this.vel.x += diff.x * (accelAmount *= 60.0f) * amount;
                this.vel.y += diff.y * accelAmount * amount;
            } else {
                this.fader.fadeOut();
            }
            this.scale += this.scaleIncreaseRate * amount;
            this.offset.x += this.vel.x * amount;
            this.offset.y += this.vel.y * amount;
            this.angle += this.turnDir * amount;
            this.elapsed += amount;
            this.fader.advance(amount);
        }
    }

    public static class PointParticle {
        float size = 6.0f;
        float mass = 1.0E-4f;
        Vector2f loc = new Vector2f();
        Vector2f vel = new Vector2f();
        Color color;
        float remaining;
        float elapsed;
    }
}

